/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.GenericFieldDescriptor;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;

public class TBFieldDescriptorFactory
extends AbstractElementVisitor
implements FieldDescriptorFactory {
    private static final Hashtable MAPPINGS = new Hashtable();
    private HashMap typeDescriptors;
    private Stack hierarchy = new Stack();
    private MetaTBFeld currentTBFeld;

    public TBFieldDescriptorFactory(MetaPlausibilisierung plausi) {
        this(((MetaCustomPlausibilisierung)plausi).rootThemenbereich());
    }

    public TBFieldDescriptorFactory(MetaThemenbereich tb) {
        this.typeDescriptors = new HashMap();
        this.hierarchy = new Stack();
        if (tb != null) {
            tb.accept(this);
        }
    }

    public FeldDeskriptorImpl getFieldDescriptor(String nameWithstructure) throws NoSuchFieldException {
        FeldDeskriptorImpl fieldDescriptor = null;
        if (nameWithstructure != null && nameWithstructure.length() > 0) {
            String[] paths = nameWithstructure.split("\\.");
            int i = 0;
            while (i < paths.length) {
                int[] indices;
                String name;
                int indexOf = paths[i].indexOf(35);
                if (indexOf > 0) {
                    name = paths[i].substring(0, indexOf);
                    indices = this.parseIndices(paths[i].substring(indexOf + 1));
                } else {
                    name = paths[i];
                    indices = null;
                }
                fieldDescriptor = this.getFieldDecriptor(name, indices, fieldDescriptor);
                ++i;
            }
        }
        return fieldDescriptor;
    }

    private String getHierarchy() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.hierarchy.size()) {
            buffer.append(this.hierarchy.get(i));
            buffer.append(".");
            ++i;
        }
        return buffer.toString();
    }

    private FeldDeskriptor getParentFieldDescriptor() {
        FeldDeskriptor parent;
        if (this.hierarchy.isEmpty()) {
            parent = null;
        } else {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.hierarchy.size()) {
                buffer.append(this.hierarchy.get(i));
                if (i < this.hierarchy.size() - 1) {
                    buffer.append(".");
                }
                ++i;
            }
            parent = (FeldDeskriptor)this.typeDescriptors.get(buffer.toString());
        }
        return parent;
    }

    private int[] parseIndices(String indicesAsString) {
        String[] indices = indicesAsString.split("#");
        int[] indicesAsInt = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            indicesAsInt[i] = Integer.parseInt(indices[i]);
            ++i;
        }
        return indicesAsInt;
    }

    private FeldDeskriptor getTypeDescriptor(String name, String structure) throws NoSuchFieldException {
        String key = structure != null && structure.length() > 0 ? String.valueOf(structure) + name : name;
        if (!this.typeDescriptors.containsKey(key)) {
            throw new NoSuchFieldException(name);
        }
        FeldDeskriptor typeDescriptor = (FeldDeskriptor)this.typeDescriptors.get(key);
        return typeDescriptor;
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich aTb) {
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)aTb;
        if (this.currentTBFeld == null) {
            this.visitElements(tb.getFelder());
            this.visitElements(tb.getVariablen());
            this.visitElements(tb.getInitialisierungswerte());
        } else {
            this.typeDescriptors.put(String.valueOf(this.getHierarchy()) + this.currentTBFeld.getName(), new FeldDeskriptorExt(MAPPINGS, this.currentTBFeld.getName(), this.getParentFieldDescriptor(), 7, ((MetaCustomTBFeld)this.currentTBFeld).dimensions(), TBFieldDescriptorFactory.getDisplayName((MetaCustomTBFeld)this.currentTBFeld)));
            this.enterSubNamespace(this.currentTBFeld.getName());
            this.visitElements(tb.getFelder());
            this.visitElements(tb.getVariablen());
            this.visitElements(tb.getInitialisierungswerte());
            this.leaveSubNamespace();
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.currentTBFeld = aFeld;
        if (aFeld.getKlasse() != null) {
            feld.getKlasse().accept(this);
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal merkmal) {
        int type;
        switch (merkmal.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                break;
            }
            case 6: {
                type = 8;
                break;
            }
            default: {
                type = 7;
            }
        }
        this.typeDescriptors.put(String.valueOf(this.getHierarchy()) + this.currentTBFeld.getName(), new FeldDeskriptorExt(MAPPINGS, this.currentTBFeld.getName(), this.getParentFieldDescriptor(), type, merkmal.getMaske(), ((MetaCustomTBFeld)this.currentTBFeld).dimensions(), TBFieldDescriptorFactory.getDisplayName((MetaCustomTBFeld)this.currentTBFeld)));
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        int type;
        switch (variable.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                break;
            }
            default: {
                type = 7;
            }
        }
        this.typeDescriptors.put(String.valueOf(this.getHierarchy()) + variable.getName(), new FeldDeskriptorExt(MAPPINGS, variable.getName(), this.getParentFieldDescriptor(), type, null, ((MetaCustomVariable)variable).dimensions(), "###PL-VARIABLE###"));
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        int type;
        switch (initwert.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                break;
            }
            default: {
                type = 7;
            }
        }
        this.typeDescriptors.put(String.valueOf(this.getHierarchy()) + initwert.getName(), new FeldDeskriptorExt(MAPPINGS, initwert.getName(), this.getParentFieldDescriptor(), type, null, ((MetaCustomInitwert)initwert).dimensions(), "###PL-VARIABLE###"));
    }

    public static String getDisplayName(MetaCustomTBFeld feld) {
        String displayName = feld.getBezeichnung();
        if ((displayName == null || displayName.length() == 0) && feld.getKlasse() instanceof MetaCustomMerkmal) {
            displayName = ((MetaCustomMerkmal)feld.getKlasse()).getBezeichnung();
        }
        if (displayName == null || displayName.length() == 0) {
            displayName = feld.getName();
        }
        return displayName;
    }

    private void enterSubNamespace(String namespace) {
        this.hierarchy.push(namespace);
    }

    private String leaveSubNamespace() {
        return (String)this.hierarchy.pop();
    }

    @Override
    public FeldDeskriptorImpl getFieldDecriptor(String name, int[] indices, FeldDeskriptorImpl parent) throws NoSuchFieldException {
        StringBuffer typeKey = new StringBuffer();
        FeldDeskriptorImpl aktParent = parent;
        if (aktParent != null) {
            Stack<FeldDeskriptorImpl> parents = new Stack<FeldDeskriptorImpl>();
            while (aktParent.getVorgaenger() != null) {
                parents.push(aktParent);
                aktParent = (FeldDeskriptorImpl)aktParent.getVorgaenger();
            }
            while (!parents.isEmpty()) {
                typeKey.append(aktParent.getFeldNameTB());
                typeKey.append('.');
                aktParent = (FeldDeskriptorImpl)parents.pop();
            }
            typeKey.append(aktParent.getFeldNameTB());
            typeKey.append('.');
        }
        return new GenericFieldDescriptor(this.getTypeDescriptor(name, typeKey.toString()), indices, parent);
    }
}

