/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.format;

import de.statspez.pleditor.generator.format.Segment;
import de.statspez.pleditor.generator.format.SegmentVisitor;

public class FormatSegment
implements Segment {
    public static final char BOLD = 'f';
    public static final char ITALIC = 'k';
    public static final char UNDERLINED = 'u';
    public static final char SUPER = 'h';
    public static final char SUB = 't';
    public static final char[] FORMATS = new char[]{'f', 'k', 'u', 'h', 't'};
    private final char type;
    private final Segment formatedSegment;

    public FormatSegment(char type, Segment formatedSegment) {
        boolean typeCorrect = false;
        int i = 0;
        while (i < FORMATS.length) {
            if (type == FORMATS[i]) {
                typeCorrect = true;
                break;
            }
            ++i;
        }
        if (!typeCorrect) {
            throw new IllegalArgumentException("Unbekannter Formattyp: " + type);
        }
        this.type = type;
        this.formatedSegment = formatedSegment;
    }

    public char getType() {
        return this.type;
    }

    public Segment getFormatedSegment() {
        return this.formatedSegment;
    }

    public String toString() {
        return "{" + this.type + "}" + this.formatedSegment + "{" + this.type + "}";
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean containsCode() {
        return this.formatedSegment.containsCode();
    }

    @Override
    public void accept(SegmentVisitor visitor) {
        visitor.visitFormatSegment(this);
    }
}

