/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.support.RootScope;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.SymbolAlreadyDefinedException;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import java.util.Hashtable;
import java.util.Map;

public class ScopeImpl
implements Scope {
    protected Scope superScope = null;
    public static final String SYMBOL_DESCRIPTOR_PROPERTY = "SymbolDescriptor";
    private Hashtable scopeTable = new Hashtable();

    public ScopeImpl(Scope sscope) {
        assert (sscope != null) : "Super-Scope ist null";
        this.superScope = sscope;
    }

    public ScopeImpl() {
        if (!(this instanceof RootScope)) {
            this.superScope = RootScope.instance();
        }
    }

    @Override
    public void define(MetaIdentifier identifier, String namespace, SymbolDescriptor descriptor) {
        if (this.isDefined(identifier, namespace)) {
            SymbolDescriptor definedDescriptor = this.symbolDescriptor(identifier, namespace);
            throw new SymbolAlreadyDefinedException(identifier, namespace, descriptor, definedDescriptor);
        }
        this.scopeTable.put(String.valueOf(namespace) + "." + identifier.value(), new Hashtable());
        this.setSymbolDescriptor(identifier, namespace, descriptor);
    }

    @Override
    public boolean isDefined(MetaIdentifier identifier, String namespace) {
        if (this.scopeTable.containsKey(String.valueOf(namespace) + "." + identifier.value())) {
            return true;
        }
        return this.superScope.isDefined(identifier, namespace);
    }

    @Override
    public void setSymbolDescriptor(MetaIdentifier identifier, String namespace, SymbolDescriptor descriptor) {
        this.setProperty(identifier, namespace, SYMBOL_DESCRIPTOR_PROPERTY, descriptor);
    }

    @Override
    public SymbolDescriptor symbolDescriptor(MetaIdentifier identifier, String namespace) {
        return (SymbolDescriptor)this.property(identifier, namespace, SYMBOL_DESCRIPTOR_PROPERTY);
    }

    @Override
    public void setProperty(MetaIdentifier identifier, String namespace, String key, Object value) {
        Hashtable properties = (Hashtable)this.scopeTable.get(String.valueOf(namespace) + "." + identifier.value());
        if (properties != null) {
            properties.put(key, value);
        } else {
            this.superScope.setProperty(identifier, namespace, key, value);
        }
    }

    @Override
    public Object property(MetaIdentifier identifier, String namespace, String key) {
        if (!this.isDefined(identifier, namespace)) {
            throw new IllegalArgumentException(String.valueOf(identifier.value()) + " ist in diesem Geltungsbereich " + "nicht definiert");
        }
        return this.propertyImpl(identifier, namespace, key);
    }

    @Override
    public Object property(MetaIdentifier identifier, String namespace, String key, Object defaultValue) {
        Object theValue = this.property(identifier, namespace, key);
        if (theValue == null) {
            theValue = defaultValue;
        }
        return theValue;
    }

    public void dump() {
        if (this.superScope instanceof ScopeImpl) {
            ((ScopeImpl)this.superScope).dump();
        }
        for (String sym : this.scopeTable.keySet()) {
            System.out.println(sym);
        }
    }

    public Hashtable dumpToHashtable() {
        Hashtable hashtable = new Hashtable();
        this.dumpTo(hashtable);
        return hashtable;
    }

    protected void dumpTo(Map map) {
        if (this.superScope instanceof ScopeImpl) {
            ((ScopeImpl)this.superScope).dumpTo(map);
        }
        map.putAll(this.scopeTable);
    }

    protected Object propertyImpl(MetaIdentifier identifier, String namespace, String key) {
        Object value = null;
        Hashtable properties = (Hashtable)this.scopeTable.get(String.valueOf(namespace) + "." + identifier.value());
        if (properties != null) {
            value = properties.get(key);
        }
        if (value == null && this.superScope instanceof ScopeImpl) {
            value = ((ScopeImpl)this.superScope).propertyImpl(identifier, namespace, key);
        }
        return value;
    }
}

