/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultContainer;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeNode;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreePanelOptions;
import de.statspez.pleditor.generator.codegen.diff.EdtDiffFacade;
import de.statspez.pleditor.generator.codegen.diff.ElementNameComparator;
import de.statspez.pleditor.generator.codegen.diff.ElementTypeComparator;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigDialog;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffUIConfigChangeListener;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffUIConfigDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DiffUITreePanel {
    private String context = null;
    private DiffConfig diffConfig = null;
    private DiffResultTree diffResultTree = null;
    private JPanel mainPanel = null;
    private JSplitPane splitPane = null;
    private JTextArea textArea = null;
    private JTree uiTree = null;
    private DiffUITreePanelOptions options = null;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file1 = new File("D:/testdaten/plablaufumgebung/test_edt_vergleich/Plausi_WarenumsatzMitKontextdaten.xml");
                File file2 = new File("D:/testdaten/plablaufumgebung/test_edt_vergleich/Plausi_WarenumsatzMitKontextdaten4.xml");
                DiffConfig config = new DiffConfig();
                config.setCheckId(true);
                config.EL_MERKMAL_ADDED = 2;
                config.EL_MERKMAL_REMOVED = 1;
                config.EL_FUNKTION_ADDED = 0;
                config.EL_FUNKTION_CHANGED = 0;
                config.EL_FUNKTION_REMOVED = 0;
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
                DiffConfigDialog configDialog = new DiffConfigDialog(frame, config);
                if (configDialog.start() == 1) {
                    DiffUITreePanelOptions options = new DiffUITreePanelOptions();
                    options.setHideNoError(true);
                    DiffResultContainer diffResult = EdtDiffFacade.diff(file1, file2, config);
                    DiffUITreePanel panel = new DiffUITreePanel(diffResult.getDiffResultTree(), diffResult.getDiffResultTree().getRootContext(), diffResult.getDiffConfig(), options);
                    frame.getContentPane().add(panel.getMainContainer());
                    frame.pack();
                } else {
                    frame.dispose();
                }
            }
        });
    }

    public DiffUITreePanel(DiffUITreePanelOptions options) {
        this.init(options);
    }

    public DiffUITreePanel(DiffResultTree diffResultTree) {
        this(diffResultTree, null);
    }

    public DiffUITreePanel(DiffResultTree diffResultTree, String context) {
        this(diffResultTree, null, null, null);
    }

    public DiffUITreePanel(DiffResultTree diffResultTree, String context, DiffConfig diffConfig, DiffUITreePanelOptions options) {
        this.diffConfig = diffConfig;
        this.init(options);
        this.setDiffResultTree(diffResultTree);
    }

    public final void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.uiTree.getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    public final void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.uiTree.expandPath(parent);
        } else {
            this.uiTree.collapsePath(parent);
        }
    }

    public final DiffConfig getDiffConfig() {
        return this.diffConfig;
    }

    public final DiffUITreePanelOptions getDiffUITreePanelOptions() {
        return this.options;
    }

    public final Container getMainContainer() {
        return this.mainPanel;
    }

    public final void setDiffConfig(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
        this.uiTree.setCellRenderer(new DiffUITreeCellRenderer(this.getDiffConfig()));
        if (this.uiTree.isVisible()) {
            this.uiTree.repaint();
        }
    }

    protected void hideNoDiff(boolean hide) {
        Enumeration<TreePath> enumeration = this.uiTree.getExpandedDescendants(new TreePath(this.uiTree.getModel().getRoot()));
        ((DiffUITreeNode)this.uiTree.getModel().getRoot()).hideNoDiff(hide, this.diffConfig);
        ((DefaultTreeModel)this.uiTree.getModel()).nodeStructureChanged((TreeNode)((DefaultTreeModel)this.uiTree.getModel()).getRoot());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath path = enumeration.nextElement();
                this.uiTree.expandPath(path);
            }
        }
    }

    protected void showText(DiffResultTreeNode resultNode) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = resultNode.getDiffResults().iterator();
        String ln = System.getProperty("line.separator");
        while (iterator.hasNext()) {
            DiffResult diffResult = (DiffResult)iterator.next();
            buffer.append(diffResult.getDiffDescription());
            if (!iterator.hasNext()) continue;
            buffer.append(ln);
        }
        this.textArea.setText(buffer.toString());
        this.textArea.setCaretPosition(0);
    }

    protected void sortTree(Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        Enumeration<TreePath> enumeration = this.uiTree.getExpandedDescendants(new TreePath(this.uiTree.getModel().getRoot()));
        if (enumeration != null) {
            ((DiffUITreeNode)this.uiTree.getModel().getRoot()).sortChildren(comparator);
            ((DefaultTreeModel)this.uiTree.getModel()).nodeStructureChanged((TreeNode)((DefaultTreeModel)this.uiTree.getModel()).getRoot());
            while (enumeration.hasMoreElements()) {
                TreePath path = enumeration.nextElement();
                this.uiTree.expandPath(path);
            }
        }
    }

    private void init(DiffUITreePanelOptions options) {
        if (options == null) {
            options = new DiffUITreePanelOptions();
        }
        this.options = options;
        this.mainPanel = new JPanel();
        JPanel textPanel = new JPanel();
        JPanel treePanel = new JPanel();
        this.uiTree = new JTree();
        this.textArea = new JTextArea();
        JScrollPane treeScroll = new JScrollPane(this.uiTree);
        JScrollPane textScroll = new JScrollPane(this.textArea);
        this.splitPane = new JSplitPane(1);
        ToolTipManager.sharedInstance().registerComponent(this.uiTree);
        this.uiTree.getSelectionModel().setSelectionMode(1);
        this.uiTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = ((JTree)e.getSource()).getSelectionPath();
                if (path != null) {
                    DiffUITreeNode uiNode = (DiffUITreeNode)path.getLastPathComponent();
                    DiffResultTreeNode resultNode = uiNode.getDiffResultTreeNode();
                    DiffUITreePanel.this.showText(resultNode);
                }
            }
        });
        treeScroll.setVerticalScrollBarPolicy(22);
        treeScroll.setHorizontalScrollBarPolicy(30);
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)treeScroll, "Center");
        this.textArea.setRows(3);
        textScroll.setVerticalScrollBarPolicy(22);
        textScroll.setHorizontalScrollBarPolicy(30);
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)textScroll, "Center");
        textPanel.setEnabled(false);
        this.splitPane.setLeftComponent(treePanel);
        this.splitPane.setRightComponent(textPanel);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        final JButton button = new JButton(options.getDialogTitle());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffUITreePanel.this.startConfigDialog(button.getText());
            }
        });
        toolBar.add(button);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.mainPanel.add((Component)toolBar, "North");
    }

    public void setDiffResultTree(DiffResultTree diffResultTree) {
        if (diffResultTree == null) {
            throw new NullPointerException();
        }
        this.context = this.context == null ? diffResultTree.getRootContext() : this.context;
        this.diffResultTree = diffResultTree;
        DiffResultTreeNode node = this.diffResultTree.getNode(this.context);
        this.uiTree.setModel(new DefaultTreeModel(new DiffUITreeNode(null, node)));
        this.uiTree.setCellRenderer(new DiffUITreeCellRenderer(this.getDiffConfig()));
        if (this.options.isNameSorting()) {
            this.sortTree(new ElementNameComparator());
        } else {
            this.sortTree(new ElementTypeComparator());
        }
        this.hideNoDiff(this.options.isHideNoError());
        this.expandAll(true);
    }

    public void setDividerLocation(double proportionalLocation) {
        this.splitPane.setDividerLocation(proportionalLocation);
    }

    public void setDividerLocation(int location) {
        this.splitPane.setDividerLocation(location);
    }

    private void startConfigDialog(String dialogTitle) {
        Window w = SwingUtilities.getWindowAncestor(this.mainPanel);
        DiffUIConfigDialog dlg = w instanceof JFrame ? new DiffUIConfigDialog((JFrame)w) : (w instanceof JDialog ? new DiffUIConfigDialog((JDialog)w) : new DiffUIConfigDialog());
        dlg.setInitialNameSorting(this.options.isNameSorting());
        dlg.setInitialHideNoError(this.options.isHideNoError());
        dlg.setDiffConfig(this.diffConfig);
        dlg.setTitle(dialogTitle);
        dlg.addDiffUIConfigListener(new DiffUIConfigChangeListener(){

            @Override
            public void hidingChanged(boolean hide) {
                DiffUITreePanel.this.options.setHideNoError(hide);
                DiffUITreePanel.this.hideNoDiff(hide);
            }

            @Override
            public void sortingChanged(boolean isNameSorting) {
                DiffUITreePanel.this.options.setNameSorting(isNameSorting);
                if (isNameSorting) {
                    DiffUITreePanel.this.sortTree(new ElementNameComparator());
                } else {
                    DiffUITreePanel.this.sortTree(new ElementTypeComparator());
                }
            }

            @Override
            public void diffConfigChanged(DiffConfig diffConfig) {
                DiffUITreePanel.this.hideNoDiff(true);
            }
        });
        dlg.start();
    }
}

