/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.KettleValueConverter;

class KettleRecordPopulator {
    private KettleValueConverter[] conv = null;

    KettleRecordPopulator() {
    }

    public void populate(BrighthouseRecord record, Object[] row, RowMetaInterface rowMeta) throws KettleException {
        if (this.conv == null) {
            if (record.size() != rowMeta.size()) {
                throw new KettleException("Number of columns passed to Infobright doesn't match the table definition!");
            }
            this.init(rowMeta);
        }
        for (int colidx = 0; colidx < record.size(); ++colidx) {
            Object value = row[colidx];
            try {
                record.setData(colidx, value, (ValueConverter)this.conv[colidx]);
                continue;
            }
            catch (ValueConverterException e) {
                Throwable cause = e.getCause();
                if (cause instanceof KettleException) {
                    throw (KettleException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        }
    }

    private void init(RowMetaInterface rowMeta) {
        int size = rowMeta.size();
        this.conv = new KettleValueConverter[size];
        for (int colidx = 0; colidx < size; ++colidx) {
            ValueMetaInterface meta = rowMeta.getValueMeta(colidx);
            this.conv[colidx] = new KettleValueConverter(meta);
        }
    }
}

