/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;

public class KettleDatabaseRepositoryJobAttribute
implements RepositoryAttributeInterface {
    private KettleDatabaseRepositoryConnectionDelegate connectionDelegate;
    private ObjectId jobObjectId;

    public KettleDatabaseRepositoryJobAttribute(KettleDatabaseRepositoryConnectionDelegate connectionDelegate, ObjectId jobObjectId) {
        this.connectionDelegate = connectionDelegate;
        this.jobObjectId = jobObjectId;
    }

    public boolean getAttributeBoolean(String code) throws KettleException {
        return this.connectionDelegate.getJobAttributeBoolean(this.jobObjectId, 0, code);
    }

    public long getAttributeInteger(String code) throws KettleException {
        return this.connectionDelegate.getJobAttributeInteger(this.jobObjectId, 0, code);
    }

    public String getAttributeString(String code) throws KettleException {
        return this.connectionDelegate.getJobAttributeString(this.jobObjectId, 0, code);
    }

    public void setAttribute(String code, String value) throws KettleException {
        this.connectionDelegate.insertJobAttribute(this.jobObjectId, 0L, code, 0L, value);
    }

    public void setAttribute(String code, boolean value) throws KettleException {
        this.connectionDelegate.insertJobAttribute(this.jobObjectId, 0L, code, 0L, value ? "Y" : "N");
    }

    public void setAttribute(String code, long value) throws KettleException {
        this.connectionDelegate.insertJobAttribute(this.jobObjectId, 0L, code, value, null);
    }
}

