/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleDependencyException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryExporter;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryBase;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryCreationHelper;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositorySecurityProvider;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryClusterSchemaDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConditionDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryDatabaseDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryDirectoryDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryJobDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryJobEntryDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryMetaStoreDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryNotePadDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryPartitionSchemaDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositorySlaveServerDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryStepDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryTransDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryUserDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryValueDelegate;
import org.pentaho.di.repository.kdr.delegates.metastore.KettleDatabaseRepositoryMetaStore;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;

public class KettleDatabaseRepository
extends KettleDatabaseRepositoryBase {
    public KettleDatabaseRepositoryTransDelegate transDelegate;
    public KettleDatabaseRepositoryJobDelegate jobDelegate;
    public KettleDatabaseRepositoryDatabaseDelegate databaseDelegate;
    public KettleDatabaseRepositorySlaveServerDelegate slaveServerDelegate;
    public KettleDatabaseRepositoryClusterSchemaDelegate clusterSchemaDelegate;
    public KettleDatabaseRepositoryPartitionSchemaDelegate partitionSchemaDelegate;
    public KettleDatabaseRepositoryDirectoryDelegate directoryDelegate;
    public KettleDatabaseRepositoryConnectionDelegate connectionDelegate;
    public KettleDatabaseRepositoryUserDelegate userDelegate;
    public KettleDatabaseRepositoryConditionDelegate conditionDelegate;
    public KettleDatabaseRepositoryValueDelegate valueDelegate;
    public KettleDatabaseRepositoryNotePadDelegate notePadDelegate;
    public KettleDatabaseRepositoryStepDelegate stepDelegate;
    public KettleDatabaseRepositoryJobEntryDelegate jobEntryDelegate;
    public KettleDatabaseRepositoryMetaStoreDelegate metaStoreDelegate;
    private KettleDatabaseRepositorySecurityProvider securityProvider;
    private Map<Class<? extends IRepositoryService>, IRepositoryService> serviceMap;
    private List<Class<? extends IRepositoryService>> serviceList;
    public KettleDatabaseRepositoryMetaStore metaStore = null;

    @Override
    public void init(RepositoryMeta repositoryMeta) {
        this.repositoryMeta = (KettleDatabaseRepositoryMeta)repositoryMeta;
        this.serviceList = new ArrayList<Class<? extends IRepositoryService>>();
        this.serviceMap = new HashMap<Class<? extends IRepositoryService>, IRepositoryService>();
        this.log = new LogChannel((Object)this);
        this.init();
    }

    private void init() {
        this.transDelegate = new KettleDatabaseRepositoryTransDelegate(this);
        this.jobDelegate = new KettleDatabaseRepositoryJobDelegate(this);
        this.databaseDelegate = new KettleDatabaseRepositoryDatabaseDelegate(this);
        this.slaveServerDelegate = new KettleDatabaseRepositorySlaveServerDelegate(this);
        this.clusterSchemaDelegate = new KettleDatabaseRepositoryClusterSchemaDelegate(this);
        this.partitionSchemaDelegate = new KettleDatabaseRepositoryPartitionSchemaDelegate(this);
        this.directoryDelegate = new KettleDatabaseRepositoryDirectoryDelegate(this);
        this.connectionDelegate = new KettleDatabaseRepositoryConnectionDelegate(this, this.repositoryMeta.getConnection());
        this.userDelegate = new KettleDatabaseRepositoryUserDelegate(this);
        this.conditionDelegate = new KettleDatabaseRepositoryConditionDelegate(this);
        this.valueDelegate = new KettleDatabaseRepositoryValueDelegate(this);
        this.notePadDelegate = new KettleDatabaseRepositoryNotePadDelegate(this);
        this.stepDelegate = new KettleDatabaseRepositoryStepDelegate(this);
        this.jobEntryDelegate = new KettleDatabaseRepositoryJobEntryDelegate(this);
        this.metaStoreDelegate = new KettleDatabaseRepositoryMetaStoreDelegate(this);
        this.creationHelper = new KettleDatabaseRepositoryCreationHelper(this);
    }

    public RepositoryMeta createRepositoryMeta() {
        return new KettleDatabaseRepositoryMeta();
    }

    @Override
    public void connect(String username, String password) throws KettleException {
        this.connect(username, password, false);
    }

    public void connect(String username, String password, boolean upgrade) throws KettleException {
        this.connectionDelegate.connect(upgrade, upgrade);
        try {
            IUser userinfo = this.userDelegate.loadUserInfo(new UserInfo(), username, password);
            this.securityProvider = new KettleDatabaseRepositorySecurityProvider(this, this.repositoryMeta, userinfo);
            this.registerRepositoryService(RepositorySecurityProvider.class, this.securityProvider);
            this.registerRepositoryService(RepositorySecurityManager.class, this.securityProvider);
            this.connectionDelegate.closeReadTransaction();
            this.metaStore = new KettleDatabaseRepositoryMetaStore(this);
        }
        catch (KettleDatabaseException e) {
            this.connectionDelegate.disconnect();
            throw e;
        }
    }

    private void registerRepositoryService(Class<? extends IRepositoryService> clazz, IRepositoryService repositoryService) {
        this.serviceMap.put(clazz, repositoryService);
        this.serviceList.add(clazz);
    }

    public synchronized void commit() throws KettleException {
        this.connectionDelegate.commit();
    }

    public synchronized void rollback() {
        this.connectionDelegate.rollback();
    }

    @Override
    public IUser getUserInfo() {
        if (this.securityProvider != null) {
            return this.securityProvider.getUserInfo();
        }
        return null;
    }

    public int getMajorVersion() {
        return this.connectionDelegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.connectionDelegate.getMinorVersion();
    }

    @Override
    public String getVersion() {
        return this.connectionDelegate.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransMeta loadTransformation(String transname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, boolean setInternalVariables, String versionName) throws KettleException {
        try {
            this.securityProvider.validateAction(RepositoryOperation.READ_TRANSFORMATION);
            TransMeta transMeta = new TransMeta();
            transMeta = this.transDelegate.loadTransformation(transMeta, transname, repdir, monitor, setInternalVariables);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationMetaLoaded.id, (Object)transMeta);
            TransMeta transMeta2 = transMeta;
            return transMeta2;
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedObjects readTransSharedObjects(TransMeta transMeta) throws KettleException {
        try {
            SharedObjects sharedObjects = this.transDelegate.readTransSharedObjects(transMeta);
            return sharedObjects;
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    @Override
    public ObjectId renameTransformation(ObjectId id_transformation, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        return this.renameTransformation(id_transformation, null, newDir, newName);
    }

    @Override
    public synchronized ObjectId renameTransformation(ObjectId id_transformation, String versionComment, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.MODIFY_TRANSFORMATION);
        this.transDelegate.renameTransformation(id_transformation, newDir, newName);
        if (!Const.isEmpty((String)versionComment)) {
            this.insertLogEntry(versionComment);
        }
        return id_transformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobMeta loadJob(String jobname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, String versionName) throws KettleException {
        try {
            this.securityProvider.validateAction(RepositoryOperation.READ_JOB);
            JobMeta jobMeta = this.jobDelegate.loadJobMeta(jobname, repdir, monitor);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobMetaLoaded.id, (Object)jobMeta);
            JobMeta jobMeta2 = jobMeta;
            return jobMeta2;
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedObjects readJobMetaSharedObjects(JobMeta jobMeta) throws KettleException {
        try {
            SharedObjects sharedObjects = this.jobDelegate.readSharedObjects(jobMeta);
            return sharedObjects;
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    @Override
    public ObjectId renameJob(ObjectId id_job, RepositoryDirectoryInterface dir, String newname) throws KettleException {
        return this.renameJob(id_job, null, dir, newname);
    }

    @Override
    public synchronized ObjectId renameJob(ObjectId id_job, String versionComment, RepositoryDirectoryInterface dir, String newname) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.MODIFY_TRANSFORMATION);
        this.jobDelegate.renameJob(id_job, dir, newname);
        if (!Const.isEmpty((String)versionComment)) {
            this.insertLogEntry(versionComment);
        }
        return id_job;
    }

    @Override
    public boolean exists(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        try {
            switch (objectType) {
                case JOB: {
                    this.securityProvider.validateAction(RepositoryOperation.READ_JOB);
                    boolean bl = this.jobDelegate.existsJobMeta(name, repositoryDirectory, objectType);
                    return bl;
                }
                case TRANSFORMATION: {
                    this.securityProvider.validateAction(RepositoryOperation.READ_TRANSFORMATION);
                    boolean bl = this.transDelegate.existsTransMeta(name, repositoryDirectory, objectType);
                    return bl;
                }
            }
            throw new KettleException("We can't verify the existance of repository element type [" + objectType + "]");
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    public void save(RepositoryElementInterface repositoryElement, String versionComment) throws KettleException {
        this.save(repositoryElement, versionComment, null);
    }

    @Override
    public void save(RepositoryElementInterface repositoryElement, String versionComment, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        this.save(repositoryElement, versionComment, monitor, null, false, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RepositoryElementInterface repositoryElement, String versionComment, ProgressMonitorListener monitor, ObjectId parentId, boolean used, boolean overwrite) throws KettleException {
        try {
            this.lockRepository();
            if (!Const.isEmpty((String)versionComment)) {
                this.insertLogEntry(versionComment);
            }
            switch (repositoryElement.getRepositoryElementType()) {
                case JOB: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_JOB);
                    this.jobDelegate.saveJob((JobMeta)repositoryElement, versionComment, monitor, overwrite);
                    break;
                }
                case TRANSFORMATION: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_TRANSFORMATION);
                    this.transDelegate.saveTransformation((TransMeta)repositoryElement, versionComment, monitor, overwrite);
                    break;
                }
                case DATABASE: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_DATABASE);
                    this.databaseDelegate.saveDatabaseMeta((DatabaseMeta)repositoryElement);
                    break;
                }
                case SLAVE_SERVER: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_SLAVE_SERVER);
                    this.slaveServerDelegate.saveSlaveServer((SlaveServer)repositoryElement, parentId, used, overwrite);
                    break;
                }
                case CLUSTER_SCHEMA: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_CLUSTER_SCHEMA);
                    this.clusterSchemaDelegate.saveClusterSchema((ClusterSchema)repositoryElement, versionComment, parentId, used, overwrite);
                    break;
                }
                case PARTITION_SCHEMA: {
                    this.securityProvider.validateAction(RepositoryOperation.MODIFY_PARTITION_SCHEMA);
                    this.partitionSchemaDelegate.savePartitionSchema((PartitionSchema)repositoryElement, parentId, used, overwrite);
                    break;
                }
                default: {
                    throw new KettleException("We can't save the element with type [" + repositoryElement.getRepositoryElementType() + "] in the repository");
                }
            }
            this.commit();
        }
        finally {
            this.unlockRepository();
        }
    }

    @Override
    public void save(RepositoryElementInterface repositoryElement, String versionComment, Calendar versionDate, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        this.save(repositoryElement, versionComment, monitor, null, false, overwrite);
    }

    public Condition loadCondition(ObjectId id_condition) throws KettleException {
        return this.conditionDelegate.loadCondition(id_condition);
    }

    public ObjectId saveCondition(Condition condition) throws KettleException {
        return this.saveCondition(condition, null);
    }

    public ObjectId saveCondition(Condition condition, ObjectId id_condition_parent) throws KettleException {
        return this.conditionDelegate.saveCondition(condition, id_condition_parent);
    }

    @Override
    public DatabaseMeta loadDatabaseMeta(ObjectId id_database, String versionName) throws KettleException {
        return this.databaseDelegate.loadDatabaseMeta(id_database);
    }

    @Override
    public void deleteDatabaseMeta(String databaseName) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.DELETE_DATABASE);
        this.databaseDelegate.deleteDatabaseMeta(databaseName);
        this.commit();
    }

    @Override
    public ClusterSchema loadClusterSchema(ObjectId idClusterSchema, List<SlaveServer> slaveServers, String versionLabel) throws KettleException {
        return this.clusterSchemaDelegate.loadClusterSchema(idClusterSchema, slaveServers);
    }

    @Override
    public SlaveServer loadSlaveServer(ObjectId id_slave_server, String versionName) throws KettleException {
        return this.slaveServerDelegate.loadSlaveServer(id_slave_server);
    }

    @Override
    public PartitionSchema loadPartitionSchema(ObjectId id_partition_schema, String versionName) throws KettleException {
        return this.partitionSchemaDelegate.loadPartitionSchema(id_partition_schema);
    }

    public ValueMetaAndData loadValueMetaAndData(ObjectId id_value) throws KettleException {
        return this.valueDelegate.loadValueMetaAndData(id_value);
    }

    public NotePadMeta loadNotePadMeta(ObjectId id_note) throws KettleException {
        return this.notePadDelegate.loadNotePadMeta(id_note);
    }

    public void saveNotePadMeta(NotePadMeta note, ObjectId id_transformation) throws KettleException {
        this.notePadDelegate.saveNotePadMeta(note, id_transformation);
    }

    @Override
    public RepositoryDirectoryInterface loadRepositoryDirectoryTree() throws KettleException {
        RepositoryDirectory root = new RepositoryDirectory();
        root.setObjectId((ObjectId)new LongObjectId(0L));
        return this.directoryDelegate.loadRepositoryDirectoryTree((RepositoryDirectoryInterface)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryDirectoryInterface loadRepositoryDirectoryTree(RepositoryDirectoryInterface root) throws KettleException {
        try {
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.directoryDelegate.loadRepositoryDirectoryTree(root);
            return repositoryDirectoryInterface;
        }
        finally {
            this.connectionDelegate.closeReadTransaction();
        }
    }

    @Override
    public RepositoryDirectoryInterface findDirectory(String directory) throws KettleException {
        return this.loadRepositoryDirectoryTree().findDirectory(directory);
    }

    @Override
    public RepositoryDirectoryInterface findDirectory(ObjectId directory) throws KettleException {
        return this.loadRepositoryDirectoryTree().findDirectory(directory);
    }

    @Override
    public void saveRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.CREATE_DIRECTORY);
        this.directoryDelegate.saveRepositoryDirectory(dir);
    }

    @Override
    public void deleteRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.DELETE_DIRECTORY);
        this.directoryDelegate.delRepositoryDirectory(dir, true);
        this.commit();
    }

    @Override
    public ObjectId renameRepositoryDirectory(ObjectId id, RepositoryDirectoryInterface newParentDir, String newName) throws KettleException {
        ObjectId result = null;
        this.securityProvider.validateAction(RepositoryOperation.RENAME_DIRECTORY);
        result = this.directoryDelegate.renameRepositoryDirectory(id, newParentDir, newName);
        this.commit();
        return result;
    }

    @Override
    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface parentDirectory, String directoryPath) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.CREATE_DIRECTORY);
        return this.directoryDelegate.createRepositoryDirectory(parentDirectory, directoryPath);
    }

    public synchronized ObjectId getRootDirectoryID() throws KettleException {
        RowMetaAndData result = this.connectionDelegate.getOneRow("SELECT " + this.quote("ID_DIRECTORY") + " FROM " + this.quoteTable("R_DIRECTORY") + " WHERE " + this.quote("ID_DIRECTORY_PARENT") + " = 0");
        if (result != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, -1L));
        }
        return null;
    }

    public synchronized int getNrSubDirectories(ObjectId id_directory) throws KettleException {
        return this.directoryDelegate.getNrSubDirectories(id_directory);
    }

    public synchronized ObjectId[] getSubDirectoryIDs(ObjectId id_directory) throws KettleException {
        return this.directoryDelegate.getSubDirectoryIDs(id_directory);
    }

    @Override
    public synchronized ObjectId insertLogEntry(String description) throws KettleException {
        ObjectId id = this.connectionDelegate.getNextLogID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_REPOSITORY_LOG", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("REP_VERSION", 2), (Object)this.getVersion());
        table.addValue((ValueMetaInterface)new ValueMeta("LOG_DATE", 3), (Object)new Date());
        table.addValue((ValueMetaInterface)new ValueMeta("LOG_USER", 2), (Object)(this.getUserInfo() != null ? this.getUserInfo().getLogin() : "admin"));
        table.addValue((ValueMetaInterface)new ValueMeta("OPERATION_DESC", 2), (Object)description);
        this.connectionDelegate.insertTableRow("R_REPOSITORY_LOG", table);
        return id;
    }

    public synchronized void insertTransNote(ObjectId id_transformation, ObjectId id_note) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NOTE", 5), (Object)id_note);
        this.connectionDelegate.insertTableRow("R_TRANS_NOTE", table);
    }

    public synchronized void insertJobNote(ObjectId id_job, ObjectId id_note) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_JOB", 5), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NOTE", 5), (Object)id_note);
        this.connectionDelegate.insertTableRow("R_JOB_NOTE", table);
    }

    @Override
    public synchronized void insertStepDatabase(ObjectId id_transformation, ObjectId id_step, ObjectId id_database) throws KettleException {
        RowMetaAndData check = this.getStepDatabase(id_step);
        if (check.getInteger(0) == null) {
            RowMetaAndData table = new RowMetaAndData();
            table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
            table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP", 5), (Object)id_step);
            table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5), (Object)id_database);
            this.connectionDelegate.insertTableRow("R_STEP_DATABASE", table);
        }
    }

    @Override
    public synchronized void insertJobEntryDatabase(ObjectId id_job, ObjectId id_jobentry, ObjectId id_database) throws KettleException {
        RowMetaAndData check = this.getJobEntryDatabase(id_jobentry);
        if (check.getInteger(0) == null) {
            RowMetaAndData table = new RowMetaAndData();
            table.addValue((ValueMetaInterface)new ValueMeta("ID_JOB", 5), (Object)id_job);
            table.addValue((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5), (Object)id_jobentry);
            table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5), (Object)id_database);
            this.connectionDelegate.insertTableRow("R_JOBENTRY_DATABASE", table);
        }
    }

    public synchronized ObjectId insertTransformationPartitionSchema(ObjectId id_transformation, ObjectId id_partition_schema) throws KettleException {
        ObjectId id = this.connectionDelegate.getNextTransformationPartitionSchemaID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANS_PARTITION_SCHEMA", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)id_partition_schema);
        this.connectionDelegate.insertTableRow("R_TRANS_PARTITION_SCHEMA", table);
        return id;
    }

    public synchronized ObjectId insertClusterSlave(ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        ObjectId id = this.connectionDelegate.getNextClusterSlaveID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_CLUSTER_SLAVE", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5), (Object)clusterSchema.getObjectId());
        table.addValue((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5), (Object)slaveServer.getObjectId());
        this.connectionDelegate.insertTableRow("R_CLUSTER_SLAVE", table);
        return id;
    }

    public synchronized ObjectId insertTransformationCluster(ObjectId id_transformation, ObjectId id_cluster) throws KettleException {
        ObjectId id = this.connectionDelegate.getNextTransformationClusterID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANS_CLUSTER", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5), (Object)id_cluster);
        this.connectionDelegate.insertTableRow("R_TRANS_CLUSTER", table);
        return id;
    }

    public synchronized ObjectId insertTransformationSlave(ObjectId id_transformation, ObjectId id_slave) throws KettleException {
        ObjectId id = this.connectionDelegate.getNextTransformationSlaveID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANS_SLAVE", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5), (Object)id_slave);
        this.connectionDelegate.insertTableRow("R_TRANS_SLAVE", table);
        return id;
    }

    public synchronized void insertTransStepCondition(ObjectId id_transformation, ObjectId id_step, ObjectId id_condition) throws KettleException {
        String tablename = "R_TRANS_STEP_CONDITION";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP", 5), (Object)id_step);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_CONDITION", 5), (Object)id_condition);
        this.connectionDelegate.insertTableRow(tablename, table);
    }

    @Override
    public synchronized String[] getTransformationNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.quoteTable("R_TRANSFORMATION") + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ORDER BY " + this.quote("NAME"), id_directory);
    }

    @Override
    public List<RepositoryElementMetaInterface> getJobObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return this.getRepositoryObjects(this.quoteTable("R_JOB"), RepositoryObjectType.JOB, id_directory);
    }

    @Override
    public List<RepositoryElementMetaInterface> getTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        List<RepositoryElementMetaInterface> objects = this.getRepositoryObjects(this.quoteTable("R_TRANSFORMATION"), RepositoryObjectType.TRANSFORMATION, id_directory);
        if (objects.size() > 0) {
            System.out.println(objects.get(0).getRepositoryDirectory().getPath());
        }
        return objects;
    }

    private synchronized List<RepositoryElementMetaInterface> getRepositoryObjects(String tableName, RepositoryObjectType objectType, ObjectId id_directory) throws KettleException {
        return this.connectionDelegate.getRepositoryObjects(tableName, objectType, id_directory);
    }

    @Override
    public synchronized String[] getJobNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.quoteTable("R_JOB") + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ORDER BY " + this.quote("NAME"), id_directory);
    }

    @Override
    public synchronized String[] getDirectoryNames(ObjectId id_directory) throws KettleException {
        return this.connectionDelegate.getStrings("SELECT " + this.quote("DIRECTORY_NAME") + " FROM " + this.quoteTable("R_DIRECTORY") + " WHERE " + this.quote("ID_DIRECTORY_PARENT") + " = ? ORDER BY " + this.quote("DIRECTORY_NAME"), id_directory);
    }

    public synchronized String[] getJobNames() throws KettleException {
        return this.connectionDelegate.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.quoteTable("R_JOB") + " ORDER BY " + this.quote("NAME"), new ObjectId[0]);
    }

    public ObjectId[] getSubConditionIDs(ObjectId id_condition) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_CONDITION") + " FROM " + this.quoteTable("R_CONDITION") + " WHERE " + this.quote("ID_CONDITION_PARENT") + " = ? ORDER BY " + this.quote("ID_CONDITION"), id_condition);
    }

    public ObjectId[] getTransNoteIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_NOTE") + " FROM " + this.quoteTable("R_TRANS_NOTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?", id_transformation);
    }

    public ObjectId[] getTransformationConditionIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_CONDITION") + " FROM " + this.quoteTable("R_TRANS_STEP_CONDITION") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public ObjectId[] getTransformationDatabaseIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_DATABASE") + " FROM " + this.quoteTable("R_STEP_DATABASE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?", id_transformation);
    }

    public ObjectId[] getJobNoteIDs(ObjectId id_job) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_NOTE") + " FROM " + this.quoteTable("R_JOB_NOTE") + " WHERE " + this.quote("ID_JOB") + " = ?", id_job);
    }

    @Override
    public ObjectId[] getDatabaseIDs(boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_DATABASE") + " FROM " + this.quoteTable("R_DATABASE") + " ORDER BY " + this.quote("ID_DATABASE"), new ObjectId[0]);
    }

    public ObjectId[] getDatabaseAttributeIDs(ObjectId id_database) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_DATABASE_ATTRIBUTE") + " FROM " + this.quoteTable("R_DATABASE_ATTRIBUTE") + " WHERE " + this.quote("ID_DATABASE") + " = ? ", id_database);
    }

    @Override
    public ObjectId[] getPartitionSchemaIDs(boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_PARTITION_SCHEMA") + " FROM " + this.quoteTable("R_PARTITION_SCHEMA") + " ORDER BY " + this.quote("NAME"), new ObjectId[0]);
    }

    public ObjectId[] getPartitionIDs(ObjectId id_partition_schema) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_PARTITION") + " FROM " + this.quoteTable("R_PARTITION") + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = ? ", id_partition_schema);
    }

    public ObjectId[] getTransformationPartitionSchemaIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_TRANS_PARTITION_SCHEMA") + " FROM " + this.quoteTable("R_TRANS_PARTITION_SCHEMA") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public ObjectId[] getTransformationClusterSchemaIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT ID_TRANS_CLUSTER FROM " + this.quoteTable("R_TRANS_CLUSTER") + " WHERE ID_TRANSFORMATION = ? ", id_transformation);
    }

    @Override
    public ObjectId[] getClusterIDs(boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_CLUSTER") + " FROM " + this.quoteTable("R_CLUSTER") + " ORDER BY " + this.quote("NAME"), new ObjectId[0]);
    }

    @Override
    public ObjectId[] getSlaveIDs(boolean includeDeleted) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_SLAVE") + " FROM " + this.quoteTable("R_SLAVE"), new ObjectId[0]);
    }

    public ObjectId[] getClusterSlaveIDs(ObjectId id_cluster_schema) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_SLAVE") + " FROM " + this.quoteTable("R_CLUSTER_SLAVE") + " WHERE " + this.quote("ID_CLUSTER") + " = ? ", id_cluster_schema);
    }

    @Override
    public synchronized String[] getDatabaseNames(boolean includeDeleted) throws KettleException {
        String nameField = this.quote("NAME");
        return this.connectionDelegate.getStrings("SELECT " + nameField + " FROM " + this.quoteTable("R_DATABASE") + " ORDER BY " + nameField, new ObjectId[0]);
    }

    @Override
    public synchronized String[] getPartitionSchemaNames(boolean includeDeleted) throws KettleException {
        String nameField = this.quote("NAME");
        return this.connectionDelegate.getStrings("SELECT " + nameField + " FROM " + this.quoteTable("R_PARTITION_SCHEMA") + " ORDER BY " + nameField, new ObjectId[0]);
    }

    @Override
    public synchronized String[] getSlaveNames(boolean includeDeleted) throws KettleException {
        String nameField = this.quote("NAME");
        return this.connectionDelegate.getStrings("SELECT " + nameField + " FROM " + this.quoteTable("R_SLAVE") + " ORDER BY " + nameField, new ObjectId[0]);
    }

    @Override
    public synchronized String[] getClusterNames(boolean includeDeleted) throws KettleException {
        String nameField = this.quote("NAME");
        return this.connectionDelegate.getStrings("SELECT " + nameField + " FROM " + this.quoteTable("R_CLUSTER") + " ORDER BY " + nameField, new ObjectId[0]);
    }

    public ObjectId[] getStepIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_STEP") + " FROM " + this.quoteTable("R_STEP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?", id_transformation);
    }

    @Override
    public synchronized String[] getTransformationsUsingDatabase(ObjectId id_database) throws KettleException {
        ObjectId[] transIds = this.connectionDelegate.getIDs("SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.quoteTable("R_STEP_DATABASE") + " WHERE " + this.quote("ID_DATABASE") + " = ?", id_database);
        return this.transDelegate.getTransformationsWithIDList(transIds);
    }

    @Override
    public synchronized String[] getJobsUsingDatabase(ObjectId id_database) throws KettleException {
        ObjectId[] jobIds = this.connectionDelegate.getIDs("SELECT DISTINCT " + this.quote("ID_JOB") + " FROM " + this.quoteTable("R_JOBENTRY_DATABASE") + " WHERE " + this.quote("ID_DATABASE") + " = ? ", id_database);
        return this.jobDelegate.getJobsWithIDList(jobIds);
    }

    public synchronized String[] getClustersUsingSlave(ObjectId id_slave) throws KettleException {
        return this.connectionDelegate.getStrings("SELECT DISTINCT " + this.quote("ID_CLUSTER") + " FROM " + this.quoteTable("R_CLUSTER_SLAVE") + " WHERE " + this.quote("ID_SLAVE") + " = ?", id_slave);
    }

    public synchronized String[] getTransformationsUsingSlave(ObjectId id_slave) throws KettleException {
        ObjectId[] transIds = this.connectionDelegate.getIDs("SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.quoteTable("R_TRANS_SLAVE") + " WHERE " + this.quote("ID_SLAVE") + " = ?", id_slave);
        return this.transDelegate.getTransformationsWithIDList(transIds);
    }

    public synchronized String[] getTransformationsUsingPartitionSchema(ObjectId id_partition_schema) throws KettleException {
        ObjectId[] transIds = this.connectionDelegate.getIDs("SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.quoteTable("R_TRANS_PARTITION_SCHEMA") + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = ?", id_partition_schema);
        return this.transDelegate.getTransformationsWithIDList(transIds);
    }

    public synchronized String[] getTransformationsUsingCluster(ObjectId id_cluster) throws KettleException {
        ObjectId[] transIds = this.connectionDelegate.getIDs("SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.quoteTable("R_TRANS_CLUSTER") + " WHERE " + this.quote("ID_CLUSTER") + " = ?", id_cluster);
        return this.transDelegate.getTransformationsWithIDList(transIds);
    }

    public ObjectId[] getJobHopIDs(ObjectId id_job) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_JOB_HOP") + " FROM " + this.quoteTable("R_JOB_HOP") + " WHERE " + this.quote("ID_JOB") + " = ?", id_job);
    }

    public ObjectId[] getTransDependencyIDs(ObjectId id_transformation) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_DEPENDENCY") + " FROM " + this.quoteTable("R_DEPENDENCY") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?", id_transformation);
    }

    public ObjectId[] getJobEntryIDs(ObjectId id_job) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_JOBENTRY") + " FROM " + this.quoteTable("R_JOBENTRY") + " WHERE " + this.quote("ID_JOB") + " = ?", id_job);
    }

    public ObjectId[] getJobEntryCopyIDs(ObjectId id_job) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_JOBENTRY_COPY") + " FROM " + this.quoteTable("R_JOBENTRY_COPY") + " WHERE " + this.quote("ID_JOB") + " = ?", id_job);
    }

    public ObjectId[] getJobEntryCopyIDs(ObjectId id_job, ObjectId id_jobentry) throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.quote("ID_JOBENTRY_COPY") + " FROM " + this.quoteTable("R_JOBENTRY_COPY") + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("ID_JOBENTRY") + " = ? ", id_job, id_jobentry);
    }

    private RowMetaAndData getStepDatabase(ObjectId id_step) throws KettleException {
        return this.connectionDelegate.getOneRow(this.quoteTable("R_STEP_DATABASE"), this.quote("ID_STEP"), id_step);
    }

    private RowMetaAndData getJobEntryDatabase(ObjectId id_jobentry) throws KettleException {
        return this.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY_DATABASE"), this.quote("ID_JOBENTRY"), id_jobentry);
    }

    public static final String byteArrayToString(byte[] val) throws IOException {
        String string;
        if (val == null) {
            string = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            BufferedOutputStream bos = new BufferedOutputStream(gzos);
            bos.write(val);
            bos.flush();
            bos.close();
            string = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
        }
        return string;
    }

    public synchronized void delSteps(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_STEP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void deleteCondition(ObjectId id_condition) throws KettleException {
        boolean ok = true;
        ObjectId[] ids = this.getSubConditionIDs(id_condition);
        if (ids.length > 0) {
            for (int i = 0; i < ids.length && ok; ++i) {
                this.deleteCondition(ids[i]);
            }
            this.deleteCondition(id_condition);
        } else {
            this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_CONDITION") + " WHERE " + this.quote("ID_CONDITION") + " = ? ", id_condition);
        }
    }

    public synchronized void delStepConditions(ObjectId id_transformation) throws KettleException {
        ObjectId[] ids = this.getTransformationConditionIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            this.deleteCondition(ids[i]);
        }
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_STEP_CONDITION") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delStepDatabases(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_STEP_DATABASE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delJobEntryDatabases(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOBENTRY_DATABASE") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delJobEntries(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOBENTRY") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delJobEntryCopies(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOBENTRY_COPY") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delDependencies(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_DEPENDENCY") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delStepAttributes(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_STEP_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delTransAttributes(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delJobAttributes(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOB_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delPartitionSchemas(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_PARTITION_SCHEMA") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delPartitions(ObjectId id_partition_schema) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_PARTITION") + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = ? ", id_partition_schema);
    }

    public synchronized void delClusterSlaves(ObjectId id_cluster) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_CLUSTER_SLAVE") + " WHERE " + this.quote("ID_CLUSTER") + " =  ? ", id_cluster);
    }

    public synchronized void delTransformationClusters(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_CLUSTER") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delTransformationSlaves(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_SLAVE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delJobEntryAttributes(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOBENTRY_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delTransHops(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_HOP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " =  ? ", id_transformation);
    }

    public synchronized void delJobHops(ObjectId id_job) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOB_HOP") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delTransNotes(ObjectId id_transformation) throws KettleException {
        ObjectId[] ids = this.getTransNoteIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_NOTE") + " WHERE " + this.quote("ID_NOTE") + " = ? ", ids[i]);
        }
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_NOTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delJobNotes(ObjectId id_job) throws KettleException {
        ObjectId[] ids = this.getJobNoteIDs(id_job);
        for (int i = 0; i < ids.length; ++i) {
            this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_NOTE") + " WHERE " + this.quote("ID_NOTE") + " = ? ", ids[i]);
        }
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOB_NOTE") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delTrans(ObjectId id_transformation) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.DELETE_TRANSFORMATION);
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANSFORMATION") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delJob(ObjectId id_job) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.DELETE_TRANSFORMATION);
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_JOB") + " WHERE " + this.quote("ID_JOB") + " = ? ", id_job);
    }

    public synchronized void delTransStepCondition(ObjectId id_transformation) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_STEP_CONDITION") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    public synchronized void delValue(ObjectId id_value) throws KettleException {
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_VALUE") + " WHERE " + this.quote("ID_VALUE") + " = ? ", id_value);
    }

    @Override
    public synchronized void deleteSlave(ObjectId id_slave) throws KettleException {
        this.securityProvider.validateAction(RepositoryOperation.DELETE_SLAVE_SERVER);
        String[] transList = this.getTransformationsUsingSlave(id_slave);
        String[] clustList = this.getClustersUsingSlave(id_slave);
        if (transList.length != 0 || clustList.length != 0) {
            int i;
            StringBuffer message = new StringBuffer();
            if (transList.length > 0) {
                message.append("Slave used by the following transformations:").append(Const.CR);
                for (i = 0; i < transList.length; ++i) {
                    message.append("  ").append(transList[i]).append(Const.CR);
                }
                message.append(Const.CR);
            }
            if (clustList.length > 0) {
                message.append("Slave used by the following cluster schemas:").append(Const.CR);
                for (i = 0; i < clustList.length; ++i) {
                    message.append("  ").append(clustList[i]).append(Const.CR);
                }
            }
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This slave server is still in use by one or more transformations (" + transList.length + ") or cluster schemas (" + clustList.length + ") :", (Throwable)e);
        }
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_SLAVE") + " WHERE " + this.quote("ID_SLAVE") + " = ? ", id_slave);
        this.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_TRANS_SLAVE") + " WHERE " + this.quote("ID_SLAVE") + " = ? ", id_slave);
        this.commit();
    }

    @Override
    public synchronized void deletePartitionSchema(ObjectId id_partition_schema) throws KettleException {
        this.partitionSchemaDelegate.delPartitionSchema(id_partition_schema);
        this.commit();
    }

    @Override
    public synchronized void deleteClusterSchema(ObjectId id_cluster) throws KettleException {
        this.clusterSchemaDelegate.delClusterSchema(id_cluster);
        this.commit();
    }

    @Override
    public synchronized void deleteTransformation(ObjectId id_transformation) throws KettleException {
        this.delTransNotes(id_transformation);
        this.delStepAttributes(id_transformation);
        this.delSteps(id_transformation);
        this.delStepConditions(id_transformation);
        this.delStepDatabases(id_transformation);
        this.delTransHops(id_transformation);
        this.delDependencies(id_transformation);
        this.delTransAttributes(id_transformation);
        this.delPartitionSchemas(id_transformation);
        this.delTransformationClusters(id_transformation);
        this.delTransformationSlaves(id_transformation);
        this.delTrans(id_transformation);
        this.commit();
    }

    @Override
    public synchronized void deleteJob(ObjectId id_job) throws KettleException {
        this.delJobNotes(id_job);
        this.delJobAttributes(id_job);
        this.delJobEntryAttributes(id_job);
        this.delJobEntryDatabases(id_job);
        this.delJobEntries(id_job);
        this.delJobEntryCopies(id_job);
        this.delJobHops(id_job);
        this.delJob(id_job);
        this.commit();
    }

    public boolean dropRepositorySchema() throws KettleException {
        this.connectionDelegate.closeStepAttributeInsertPreparedStatement();
        this.connectionDelegate.closeLookupJobEntryAttribute();
        for (int i = 0; i < repositoryTableNames.length; ++i) {
            try {
                this.execStatement("DROP TABLE " + this.quoteTable(repositoryTableNames[i]));
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed("dropped table " + repositoryTableNames[i]);
                continue;
            }
            catch (KettleException dbe) {
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed("Unable to drop table: " + repositoryTableNames[i]);
            }
        }
        this.log.logBasic("Dropped all " + repositoryTableNames.length + " repository tables.");
        this.commit();
        return true;
    }

    public void updateStepTypes() throws KettleException {
        this.creationHelper.updateStepTypes(new ArrayList<String>(), false, false);
    }

    public void updateDatabaseTypes() throws KettleException {
        this.creationHelper.updateDatabaseTypes(new ArrayList<String>(), false, false);
    }

    public void updateJobEntryTypes() throws KettleException {
        this.creationHelper.updateJobEntryTypes(new ArrayList<String>(), false, false);
    }

    public synchronized String toString() {
        if (this.repositoryMeta == null) {
            return this.getClass().getName();
        }
        return this.repositoryMeta.getName();
    }

    @Override
    public void clearSharedObjectCache() {
    }

    public Database getDatabase() {
        return this.connectionDelegate.getDatabase();
    }

    public void setDatabase(Database database) {
        this.connectionDelegate.setDatabase(database);
        this.connectionDelegate.setDatabaseMeta(database.getDatabaseMeta());
    }

    public synchronized void lockRepository() throws KettleException {
        this.connectionDelegate.lockRepository();
    }

    public synchronized void unlockRepository() throws KettleException {
        this.connectionDelegate.unlockRepository();
    }

    public List<DatabaseMeta> getDatabases() throws KettleException {
        ArrayList<DatabaseMeta> list = new ArrayList<DatabaseMeta>();
        ObjectId[] databaseIDs = this.getDatabaseIDs(false);
        for (int i = 0; i < databaseIDs.length; ++i) {
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(databaseIDs[i], null);
            list.add(databaseMeta);
        }
        return list;
    }

    @Override
    public List<SlaveServer> getSlaveServers() throws KettleException {
        ArrayList<SlaveServer> list = new ArrayList<SlaveServer>();
        ObjectId[] slaveIDs = this.getSlaveIDs(false);
        for (int i = 0; i < slaveIDs.length; ++i) {
            SlaveServer slaveServer = this.loadSlaveServer(slaveIDs[i], null);
            list.add(slaveServer);
        }
        return list;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.connectionDelegate.getDatabaseMeta();
    }

    @Override
    public List<DatabaseMeta> readDatabases() throws KettleException {
        ArrayList<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
        ObjectId[] ids = this.getDatabaseIDs(false);
        for (int i = 0; i < ids.length; ++i) {
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(ids[i], null);
            databases.add(databaseMeta);
        }
        return databases;
    }

    public boolean isUseBatchProcessing() {
        return this.connectionDelegate.isUseBatchProcessing();
    }

    public void setImportBaseDirectory(RepositoryDirectory importBaseDirectory) {
        this.importBaseDirectory = importBaseDirectory;
    }

    public RepositoryDirectory getImportBaseDirectory() {
        return this.importBaseDirectory;
    }

    public void createRepositorySchema(ProgressMonitorListener monitor, boolean upgrade, List<String> statements, boolean dryRun) throws KettleException {
        this.creationHelper.createRepositorySchema(monitor, upgrade, statements, dryRun);
    }

    @Override
    public synchronized int countNrStepAttributes(ObjectId id_step, String code) throws KettleException {
        return this.connectionDelegate.countNrStepAttributes(id_step, code);
    }

    @Override
    public synchronized int countNrJobEntryAttributes(ObjectId id_jobentry, String code) throws KettleException {
        return this.connectionDelegate.countNrJobEntryAttributes(id_jobentry, code);
    }

    @Override
    public synchronized void disconnect() {
        this.metaStore = null;
        this.connectionDelegate.disconnect();
    }

    @Override
    public long getJobEntryAttributeInteger(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return this.connectionDelegate.getJobEntryAttributeInteger(id_jobentry, nr, code);
    }

    @Override
    public String getJobEntryAttributeString(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return this.connectionDelegate.getJobEntryAttributeString(id_jobentry, nr, code);
    }

    @Override
    public boolean getJobEntryAttributeBoolean(ObjectId id_jobentry, int nr, String code, boolean def) throws KettleException {
        return this.connectionDelegate.getJobEntryAttributeBoolean(id_jobentry, nr, code, def);
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, String value) throws KettleException {
        this.connectionDelegate.saveJobEntryAttribute(id_job, id_jobentry, (long)nr, code, value);
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, boolean value) throws KettleException {
        this.connectionDelegate.saveJobEntryAttribute(id_job, id_jobentry, (long)nr, code, value);
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, long value) throws KettleException {
        this.connectionDelegate.saveJobEntryAttribute(id_job, id_jobentry, (long)nr, code, value);
    }

    @Override
    public boolean getStepAttributeBoolean(ObjectId id_step, int nr, String code, boolean def) throws KettleException {
        return this.connectionDelegate.getStepAttributeBoolean(id_step, nr, code, def);
    }

    @Override
    public long getStepAttributeInteger(ObjectId id_step, int nr, String code) throws KettleException {
        return this.connectionDelegate.getStepAttributeInteger(id_step, nr, code);
    }

    @Override
    public String getStepAttributeString(ObjectId id_step, int nr, String code) throws KettleException {
        return this.connectionDelegate.getStepAttributeString(id_step, nr, code);
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, String value) throws KettleException {
        this.connectionDelegate.saveStepAttribute(id_transformation, id_step, (long)nr, code, value);
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, boolean value) throws KettleException {
        this.connectionDelegate.saveStepAttribute(id_transformation, id_step, (long)nr, code, value);
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, long value) throws KettleException {
        this.connectionDelegate.saveStepAttribute(id_transformation, id_step, (long)nr, code, value);
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, double value) throws KettleException {
        this.connectionDelegate.saveStepAttribute(id_transformation, id_step, (long)nr, code, value);
    }

    public ObjectId findStepAttributeID(ObjectId id_step, int nr, String code) throws KettleException {
        return this.connectionDelegate.findStepAttributeID(id_step, nr, code);
    }

    public void execStatement(String sql) throws KettleException {
        this.connectionDelegate.getDatabase().execStatement(sql);
    }

    public void loadJobEntry(JobEntryBase jobEntryBase, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        this.jobEntryDelegate.loadJobEntryBase(jobEntryBase, id_jobentry, databases, slaveServers);
    }

    @Override
    public ObjectId getClusterID(String name) throws KettleException {
        return this.clusterSchemaDelegate.getClusterID(name);
    }

    @Override
    public ObjectId getDatabaseID(String name) throws KettleException {
        return this.databaseDelegate.getDatabaseID(name);
    }

    @Override
    public ObjectId getJobId(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return this.jobDelegate.getJobID(name, repositoryDirectory.getObjectId());
    }

    @Override
    public ObjectId getPartitionSchemaID(String name) throws KettleException {
        return this.partitionSchemaDelegate.getPartitionSchemaID(name);
    }

    @Override
    public ObjectId getSlaveID(String name) throws KettleException {
        return this.slaveServerDelegate.getSlaveID(name);
    }

    @Override
    public ObjectId getTransformationID(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return this.transDelegate.getTransformationID(name, repositoryDirectory.getObjectId());
    }

    public ObjectId insertJobEntry(ObjectId id_job, JobEntryBase jobEntryBase) throws KettleException {
        return this.jobEntryDelegate.insertJobEntry(id_job, jobEntryBase);
    }

    @Override
    public DatabaseMeta loadDatabaseMetaFromStepAttribute(ObjectId idStep, String code, List<DatabaseMeta> databases) throws KettleException {
        long id_database = this.getStepAttributeInteger(idStep, code);
        if (id_database <= 0L) {
            return null;
        }
        return DatabaseMeta.findDatabase(databases, (ObjectId)new LongObjectId(id_database));
    }

    @Override
    public void saveDatabaseMetaStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, DatabaseMeta database) throws KettleException {
        ObjectId id = null;
        if (database != null) {
            id = database.getObjectId();
            Long id_database = id == null ? Long.valueOf(-1L) : new LongObjectId(id).longValue();
            this.saveStepAttribute(id_transformation, id_step, code, id_database);
        }
    }

    @Override
    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId id_jobentry, String nameCode, int nr, String idCode, List<DatabaseMeta> databases) throws KettleException {
        long id_database = this.getJobEntryAttributeInteger(id_jobentry, nr, idCode);
        if (id_database <= 0L) {
            String name = this.getJobEntryAttributeString(id_jobentry, nr, nameCode);
            if (name == null) {
                return null;
            }
            return DatabaseMeta.findDatabase(databases, (String)name);
        }
        return DatabaseMeta.findDatabase(databases, (ObjectId)new LongObjectId(id_database));
    }

    @Override
    public void saveDatabaseMetaJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String nameCode, String idCode, DatabaseMeta database) throws KettleException {
        ObjectId id = null;
        if (database != null) {
            id = database.getObjectId();
            Long id_database = id == null ? Long.valueOf(-1L) : new LongObjectId(id).longValue();
            this.saveJobEntryAttribute(id_job, id_jobentry, nr, idCode, id_database);
            this.saveJobEntryAttribute(id_job, id_jobentry, nr, nameCode, id_database);
            this.insertJobEntryDatabase(id_job, id_jobentry, id);
        }
    }

    @Override
    public Condition loadConditionFromStepAttribute(ObjectId id_step, String code) throws KettleException {
        long id_condition = this.getStepAttributeInteger(id_step, code);
        if (id_condition > 0L) {
            return this.loadCondition((ObjectId)new LongObjectId(id_condition));
        }
        return null;
    }

    @Override
    public void saveConditionStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, Condition condition) throws KettleException {
        ObjectId id = null;
        if (condition != null) {
            id = this.saveCondition(condition);
            Long id_condition = id == null ? Long.valueOf(-1L) : new LongObjectId(id).longValue();
            this.saveStepAttribute(id_transformation, id_step, code, id_condition);
            this.insertTransStepCondition(id_transformation, id_step, condition.getObjectId());
        }
    }

    @Override
    public KettleDatabaseRepositorySecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    public KettleDatabaseRepositorySecurityProvider getSecurityManager() {
        return this.securityProvider;
    }

    @Override
    public void undeleteObject(RepositoryElementMetaInterface element) throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepositoryElementMetaInterface> getJobAndTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        ArrayList<RepositoryElementMetaInterface> objs = new ArrayList<RepositoryElementMetaInterface>();
        objs.addAll(this.getJobObjects(id_directory, includeDeleted));
        objs.addAll(this.getTransformationObjects(id_directory, includeDeleted));
        return objs;
    }

    @Override
    public IRepositoryService getService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.serviceMap.get(clazz);
    }

    @Override
    public List<Class<? extends IRepositoryService>> getServiceInterfaces() throws KettleException {
        return this.serviceList;
    }

    @Override
    public boolean hasService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.serviceMap.containsKey(clazz);
    }

    public RepositoryDirectory getDefaultSaveDirectory(RepositoryElementInterface repositoryElement) throws KettleException {
        return this.getUserHomeDirectory();
    }

    public RepositoryDirectory getUserHomeDirectory() throws KettleException {
        RepositoryDirectory root = new RepositoryDirectory();
        root.setObjectId((ObjectId)new LongObjectId(0L));
        this.directoryDelegate.loadRepositoryDirectory(root, root.getObjectId());
        return root;
    }

    @Override
    public RepositoryObject getObjectInformation(ObjectId objectId, RepositoryObjectType objectType) throws KettleException {
        try {
            long dirId;
            Date modifiedDate;
            String modifiedUser;
            String description;
            String name;
            switch (objectType) {
                case TRANSFORMATION: {
                    RowMetaAndData row = this.transDelegate.getTransformation(objectId);
                    name = row.getString("NAME", null);
                    description = row.getString("DESCRIPTION", null);
                    modifiedUser = row.getString("MODIFIED_USER", "-");
                    modifiedDate = row.getDate("MODIFIED_DATE", null);
                    dirId = row.getInteger("ID_DIRECTORY", 0L);
                    break;
                }
                case JOB: {
                    RowMetaAndData row = this.jobDelegate.getJob(objectId);
                    name = row.getString("NAME", null);
                    description = row.getString("DESCRIPTION", null);
                    modifiedUser = row.getString("MODIFIED_USER", "-");
                    modifiedDate = row.getDate("MODIFIED_DATE", null);
                    dirId = row.getInteger("ID_DIRECTORY", 0L);
                    break;
                }
                default: {
                    throw new KettleException("Object type " + objectType.getTypeDescription() + " was specified.  Only information from transformations and jobs can be retrieved at this time.");
                }
            }
            boolean isDeleted = name == null;
            RepositoryDirectoryInterface directory = this.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(dirId));
            return new RepositoryObject(objectId, name, directory, modifiedUser, modifiedDate, objectType, description, isDeleted);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get object information for object with id=" + objectId, (Throwable)e);
        }
    }

    @Override
    public JobMeta loadJob(ObjectId idJob, String versionLabel) throws KettleException {
        RepositoryObject jobInfo = this.getObjectInformation(idJob, RepositoryObjectType.JOB);
        return this.loadJob(jobInfo.getName(), jobInfo.getRepositoryDirectory(), null, versionLabel);
    }

    @Override
    public TransMeta loadTransformation(ObjectId idTransformation, String versionLabel) throws KettleException {
        RepositoryObject jobInfo = this.getObjectInformation(idTransformation, RepositoryObjectType.TRANSFORMATION);
        return this.loadTransformation(jobInfo.getName(), jobInfo.getRepositoryDirectory(), null, true, versionLabel);
    }

    @Override
    public String getConnectMessage() {
        return null;
    }

    @Override
    public IRepositoryExporter getExporter() {
        return new RepositoryExporter(this);
    }

    @Override
    public IRepositoryImporter getImporter() {
        return new RepositoryImporter(this);
    }

    @Override
    public KettleDatabaseRepositoryMetaStore getMetaStore() {
        return this.metaStore;
    }
}

