/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.annotations.ImportRulePlugin;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=ImportRuleInterface.class)
@PluginAnnotationType(value=ImportRulePlugin.class)
public class ImportRulePluginType
extends BasePluginType
implements PluginTypeInterface {
    private static ImportRulePluginType pluginType;

    private ImportRulePluginType() {
        super(ImportRulePlugin.class, "IMPORT_RULE", "Import rule");
        this.populateFolders("rules");
    }

    public static ImportRulePluginType getInstance() {
        if (pluginType == null) {
            pluginType = new ImportRulePluginType();
        }
        return pluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String kettleImportRulesXmlFile = "kettle-import-rules.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(kettleImportRulesXmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + kettleImportRulesXmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native import rules definition file: kettle-import-rules.xml");
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node stepsNode = XMLHandler.getSubNode((Node)document, (String)"rules");
            List stepNodes = XMLHandler.getNodes((Node)stepsNode, (String)"rule");
            for (Node stepNode : stepNodes) {
                this.registerPluginFromXmlResource(stepNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle steps XML config file: " + kettleImportRulesXmlFile, (Throwable)e);
        }
    }

    protected void registerAnnotations() throws KettlePluginException {
    }

    protected void registerXmlPlugins() throws KettlePluginException {
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((ImportRulePlugin)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((ImportRulePlugin)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((ImportRulePlugin)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((ImportRulePlugin)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((ImportRulePlugin)annotation).classLoaderGroup();
    }
}

