/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.hadoopsnappy;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.pentaho.di.core.compress.CompressionInputStream;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.hadoopsnappy.HadoopSnappyCompressionProvider;

public class HadoopSnappyCompressionInputStream
extends CompressionInputStream {
    public HadoopSnappyCompressionInputStream(InputStream in, CompressionProvider provider) throws IOException {
        super(HadoopSnappyCompressionInputStream.getDelegate(in), provider);
    }

    protected static InputStream getDelegate(InputStream in) throws IOException {
        try {
            return HadoopSnappyCompressionInputStream.getSnappyInputStream(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object nextEntry() throws IOException {
        return null;
    }

    public static InputStream getSnappyInputStream(InputStream in) throws Exception {
        return HadoopSnappyCompressionInputStream.getSnappyInputStream(262144, in);
    }

    public static InputStream getSnappyInputStream(int bufferSize, InputStream in) throws Exception {
        if (!HadoopSnappyCompressionProvider.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        Object snappyShim = HadoopSnappyCompressionProvider.getActiveSnappyShim();
        Method getSnappyInputStream = snappyShim.getClass().getMethod("getSnappyInputStream", Integer.TYPE, InputStream.class);
        return (InputStream)getSnappyInputStream.invoke(snappyShim, bufferSize, in);
    }
}

