/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.UDTSQLData;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLData;
import java.sql.SQLException;

class IfxUDT
extends IfxBaseType {
    private SQLData udtClass;

    IfxUDT() {
        this.setIfxType(44);
    }

    IfxUDT(byte[] b) throws SQLException {
        this.setIfxType(44);
        this.fromBytes(b);
    }

    IfxUDT(InputStream x, int length) throws SQLException {
        this.setIfxType(44);
        this.fromInputStream(x, length);
    }

    @Override
    public void fromObject(Object data) throws SQLException {
        if (data == null) {
            this.nullify();
            this.udtClass = null;
        } else {
            String ename;
            if (!(data instanceof SQLData)) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.udtClass = (SQLData)data;
            if (!this.conn.isDirect()) {
                this.outputStream.reset();
                this.udtClass.writeSQL(this.outputStream);
            }
            if ((ename = this.udtClass.getSQLTypeName()) != null) {
                this.setExtendedTypeName(ename);
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toObject(false);
    }

    @Override
    public Object toObject(boolean fromComplexType) throws SQLException {
        if (this.isNull) {
            return null;
        }
        if (!fromComplexType && this.conn.isDirect() && this.udtClass != null) {
            return this.udtClass;
        }
        if (this.typeMap == null && (this.typeMap = this.conn.getTypeMap()) == null) {
            throw IfxErrMsg.getSQLException(-79769);
        }
        Class cls = (Class)this.typeMap.getOrDefault("*", this.typeMap.get(this.extendedName));
        if (cls == null) {
            throw IfxErrMsg.getSQLException(-79769);
        }
        try {
            this.udtClass = (SQLData)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716);
        }
        if (this.inputStream == null && this.outputStream.length() > 0) {
            this.inputStream = new IfxUDTInput(this.conn, this.outputStream.toByteArray(), 0, this.outputStream.length());
        }
        this.udtClass.readSQL(this.inputStream, this.extendedName);
        if (this.udtClass instanceof UDTSQLData) {
            return ((UDTSQLData)this.udtClass).getSQLDataObject();
        }
        return this.udtClass;
    }

    @Override
    public void fromBytes(byte[] b) throws SQLException {
        this.outputStream.reset();
        this.outputStream.writeBytes(b, b.length);
        this.inputStream = new IfxUDTInput(this.conn, b, 0, b.length);
        this.unnullify();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return this.inputStream.toByteArray();
    }

    @Override
    public void fromInputStream(InputStream x, int length) throws SQLException {
        byte[] b = new byte[length];
        int offset = 0;
        try {
            int readLen;
            do {
                readLen = x.read(b, offset, length);
                offset += readLen;
            } while ((length -= readLen) > 0);
            this.outputStream.reset();
            this.outputStream.writeBytes(b, length);
            this.inputStream = new IfxUDTInput(this.conn, b, 0, length);
            this.unnullify();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return new ByteArrayInputStream(this.inputStream.toByteArray());
    }

    @Override
    public void clear() {
        this.udtClass = null;
        this.nullify();
    }

    @Override
    public String toString() {
        try {
            return this.toObject().toString();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get string value for UDT [" + this.extendedName + "]", e);
        }
    }
}

