/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DateUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;

public class Sichtgruppe
extends NamedIdObjectList {
    private static final long serialVersionUID = 1L;
    private AbstractSicht selectedSicht;
    private String stand;
    private String art;
    private boolean isMultiSelection;
    private String name;

    public Sichtgruppe(String name) {
        this.name = name;
    }

    public String getArt() {
        return this.art;
    }

    @Override
    public String toString() {
        return "Sichtengruppe Art:" + this.art + " - " + this.getIdsApostropheString();
    }

    public AbstractSicht getSelectedSicht() {
        if (this.stand == null) {
            throw new IllegalStateException("Es muss ein Stand gesetzt werden, bevor eine Sicht gelesen werden kann");
        }
        return this.selectedSicht;
    }

    public void setSelectedSicht(AbstractSicht sicht) {
        this.selectedSicht = sicht;
    }

    public Collection getSichtenlist() {
        LinkedList result = new LinkedList();
        result.addAll(this);
        return result;
    }

    public void setStand(String gew\u00fcnschterStand) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        if (gew\u00fcnschterStand == null) {
            throw new IllegalArgumentException("Man kann den Stand nicht auf null setzen (" + this.name + ")");
        }
        if (gew\u00fcnschterStand.trim().startsWith("today")) {
            gew\u00fcnschterStand = DateUtils.getTodayString();
        }
        if (this.selectedSicht == null) {
            this.selectedSicht = (AbstractSicht)this.get(0);
        }
        this.selectedSicht.setStand(gew\u00fcnschterStand);
        this.stand = gew\u00fcnschterStand;
    }

    public String getStand() {
        return this.stand;
    }

    @Override
    public void clear() {
        super.clear();
        this.selectedSicht = null;
        this.stand = null;
    }

    public void clearSelections() {
        for (AbstractSicht aSicht : this) {
            aSicht.clearSelection();
        }
    }

    @Override
    public boolean add(Object o) {
        if (!(o instanceof AbstractSicht)) {
            throw new IllegalArgumentException("Kann nur Sichten zu Sichtengruppe hinzuf\u00fcgen");
        }
        AbstractSicht sicht = (AbstractSicht)o;
        this.art = sicht.getArt();
        if (this.selectedSicht == null) {
            this.selectedSicht = sicht;
        }
        return super.add(sicht);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("nicht mehr");
    }

    public boolean isStandButtonWanted() {
        boolean result = false;
        for (AbstractSicht eineSicht : this) {
            if (!eineSicht.isStandbuttonWanted()) continue;
            result = true;
        }
        return result;
    }

    public void setSelectedSicht(Integer sichttid) {
        if (!this.containsItemWithId(sichttid)) {
            StringBuffer msg = new StringBuffer("Es wurde versucht eine Sicht mit der id " + sichttid + " auszuw\u00e4hlen, die nicht in der Sichtgruppe enthalten ist. [");
            for (AbstractSicht eineSicht : this) {
                msg.append(String.valueOf(eineSicht.getName()) + "(tid:" + eineSicht.getId() + ")  ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        this.setSelectedSicht((AbstractSicht)this.getById(sichttid));
    }

    public void makeSureSelectedSichtIsOK() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        if (this.stand == null) {
            throw new IllegalStateException("Stand der Sichtgruppe darf nicht null sein");
        }
        this.selectedSicht.setStand(this.stand);
    }

    public StringBuffer toXml(boolean isOldOrganigrammArt) {
        StringBuffer result = new StringBuffer();
        result.append("<sichten anzahl=\"" + this.size() + "\">\n");
        AbstractSicht letzteSicht = this.getSelectedSicht();
        String selected = "";
        for (AbstractSicht eineSicht : this) {
            selected = eineSicht == letzteSicht ? "true" : "false";
            result.append("  <sicht name_intern=\"" + eineSicht.getName_intern() + "\" tid=\"" + eineSicht.getId() + "\" ");
            if (isOldOrganigrammArt || eineSicht.isStandbuttonWanted()) {
                result.append("stand=\"" + this.getStand() + "\"");
            }
            result.append(" selected=\"" + selected + "\">" + eineSicht.toString() + "</sicht>\n");
        }
        result.append("</sichten>\n");
        return result;
    }

    public boolean isMultiSelection() {
        return this.isMultiSelection;
    }

    public void setMultiSelection(boolean isMulti) {
        this.isMultiSelection = isMulti;
        for (AbstractSicht aSicht : this) {
            aSicht.setMultiSelection(isMulti);
        }
    }

    public StringBuffer getJSONInfo() {
        StringBuffer result = new StringBuffer();
        result.append("sichten:{count:" + this.size() + ",stand:\"" + this.getStand() + "\",isMultiSelection:" + (this.isMultiSelection() ? "true" : "false"));
        result.append(",selected:" + this.getSelectedSicht().getJSONInfo() + ",");
        result.append("other:[");
        for (AbstractSicht sicht : this) {
            if (sicht == this.getSelectedSicht()) continue;
            result.append(String.valueOf(sicht.getJSONInfo()) + ",");
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.setLength(result.length() - 1);
        }
        result.append("]}");
        return result;
    }
}

