/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.IdObject;
import de.memtext.baseobjects.IdObjectI;
import de.memtext.baseobjects.NamedIdObjectI;
import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.coll.IdObjectCollection;
import de.memtext.baseobjects.coll.IdObjectList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentCollection;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentSet;
import de.memtext.db.DB;
import de.memtext.db.ProcedureSql;
import de.memtext.rights.Allowable;
import de.memtext.rights.Rights;
import de.memtext.rights.RightsKeyEntry;
import de.memtext.time.EphemeralI;
import de.memtext.time.Period;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeBuilder;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.memtext.util.TreeUtils;
import de.superx.common.DBServletException;
import de.superx.common.RightsApplicator;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.Sichten;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.awt.Color;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractSicht
extends SelectableItemTree
implements NamedIdObjectI,
EphemeralI,
Allowable,
TemplateHashModel,
TemplateMethodModel {
    private static boolean isNewTreeBuildWanted = true;
    protected static ImageIcon leaf = null;
    private boolean isFirstInGroup = false;
    protected Sichten sichten;
    private Integer attribut3;
    private boolean isSubelementsinForEach = true;
    private boolean isDynamic = false;
    private boolean isTreeCfgRead = false;
    private HashMap childrensMap = new HashMap();
    private static final long serialVersionUID = 1L;
    private Object id;
    private String name;
    protected String mandantenID = "default";
    public NamedIdObjectWithParentCollection selectableItemCollection = new NamedIdObjectWithParentSet();
    protected int label;
    protected String art;
    protected String name_intern;
    protected String beschreibung;
    protected String quelle;
    protected String stand;
    protected boolean isStandbuttonWanted;
    protected boolean isPerfectlyRegular;
    protected boolean hasCachedVersion;
    protected boolean isAllowed = false;
    protected Period validityPeriod = new Period(Date.valueOf("1900-01-01"), Date.valueOf("3000-01-01"));
    protected Integer systeminfoid;
    protected SxUser user;
    protected String treeCfgTable;
    protected String altHierId;
    protected String treeCfgId;
    protected AbstractSicht hauptSicht;
    protected NamedIdObjectWithParentList altHierItems = new NamedIdObjectWithParentList();
    protected IdObjectCollection closedTreeNodes = new IdObjectList();
    protected Integer type;
    protected Integer xmlMaxEntries;
    protected Rights rights = new Rights(true, true);

    public AbstractSicht(Sichten sichten, Object id, String name) {
        this.sichten = sichten;
        this.setId(id);
        this.setName(name);
        this.configTree();
    }

    protected AbstractSicht(Sichten sichten, Object id, String name, DefaultTreeModel model) {
        this.sichten = sichten;
        this.setId(id);
        this.setName(name);
        this.setModel(model);
        this.configTree();
    }

    public SxUser getUser() {
        return this.user;
    }

    public int getLabel() {
        return this.label;
    }

    private void readRights() throws SQLException, DBServletException, TemplateException, IOException {
        if (this.getArt().indexOf("Kostenstellen-Sicht") > -1 && this.getType() == 10) {
            this.rights.setAdmin(this.user.isAdmin());
            this.rights.setHasAllRights(this.user.isAdmin());
            if (!this.user.isAdmin()) {
                this.rights.clear();
                StringBuffer sql = new StringBuffer("select ch110_institut,hierarchie from user_institution where userid=" + this.user.getId() + " and (gueltig_seit<=<<Stand>> or gueltig_seit is null) and (gueltig_bis>=<<Stand>> or gueltig_seit is null)");
                this.littleGenerateSql(sql);
                SxResultSet result = this.readFromDb(sql.toString());
                StringBuffer msg = new StringBuffer(String.valueOf(this.user.getName()) + " (" + this.user.getId() + ") erh\u00e4lt Rechte f\u00fcr Sicht " + this.getName_intern() + " (" + this.getId() + ")");
                for (SxResultRow row : result) {
                    if (row.get(0).toString().trim().equals("0")) {
                        this.rights.setHasAllRights(true);
                    }
                    boolean subordinates = true;
                    if (row.get(1) != null && row.get(1).toString().equals("0")) {
                        subordinates = true;
                    }
                    this.rights.addAllowed(new RightsKeyEntry(row.get(0), subordinates));
                    msg.append(row.get(0) + " ");
                }
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, msg.toString());
            }
        }
    }

    public String getBeschreibung() {
        return this.beschreibung;
    }

    @Override
    public java.util.Date getValidSince() {
        return this.validityPeriod.getFrom();
    }

    @Override
    public java.util.Date getValidTill() {
        return this.validityPeriod.getTill();
    }

    @Override
    public boolean isValidAt(java.util.Date date) {
        return this.validityPeriod.isInPeriod(date);
    }

    @Override
    public void setValidSince(java.util.Date date) {
        this.validityPeriod.setFrom(date);
    }

    @Override
    public void setValidTill(java.util.Date date) {
        this.validityPeriod.setTill(date);
    }

    public String getName_intern() {
        return this.name_intern;
    }

    public void setBeschreibung(String string) {
        this.beschreibung = string;
    }

    public void setLabel(int i2) {
        this.label = i2;
    }

    public void setName_intern(String string) {
        this.name_intern = string;
    }

    public String getQuelle() {
        return this.quelle;
    }

    public void setQuelle(String q) {
        this.quelle = q;
        if (AbstractSicht.getStrippedSQL(q).indexOf("<<") > -1) {
            this.isDynamic = true;
        }
    }

    public static String getStrippedSQL(String sql) {
        int startpos = 0;
        if (sql.trim().toUpperCase().startsWith("<<SQL>>")) {
            startpos = 7;
        }
        return sql.substring(startpos);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isStandbuttonWanted() {
        return this.isStandbuttonWanted;
    }

    public String getStand() {
        return this.stand;
    }

    public void setStandbuttonWanted(boolean b2) {
        this.isStandbuttonWanted = b2;
    }

    public void setStand(String gewuenschterStand) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        if (gewuenschterStand == null) {
            throw new IllegalArgumentException("Der Stand kann nicht auf null gesetzt werden f\u00fcr Sicht " + this.getId());
        }
        if (!DateUtils.isValidDate(gewuenschterStand)) {
            throw new IllegalArgumentException("Konnte neuen Stand f\u00fcr Sicht " + this.getName_intern() + " (" + this.getId() + ") nicht setzen.  " + gewuenschterStand + " ist kein g\u00fcltiges dd.mm.yyyy-Datum");
        }
        if (this.stand == null || !gewuenschterStand.equals(this.stand)) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, String.valueOf(DateUtils.getNowString()) + " Start aktualisieren Sicht:  " + this.getName_intern() + " (" + this.getId() + ") f\u00fcr Stand " + this.stand);
            this.stand = gewuenschterStand;
            this.update();
        }
    }

    public boolean isAltHier() {
        return this.hauptSicht != null;
    }

    public boolean isCachedVersionInPool() {
        return false;
    }

    protected void update() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        this.readRights();
        if (this.getTreeCfgTable() != null && !this.isTreeCfgRead) {
            this.readTreeCfg();
        }
        if (this.isAltHier()) {
            this.updateAltHier();
        } else if (!this.isCachedVersionInPool()) {
            this.updateRegular();
        }
        SelectableItemNode root = (SelectableItemNode)this.getModel().getRoot();
        root.removeAllChildren();
        if (!this.isCachedVersionInPool() && this.selectableItemCollection.size() == 0) {
            this.setNoSelectionPossible();
        } else {
            if (this.isAltHier()) {
                try {
                    TreeBuilder.addNodesToRootFromMap(root, "", this.childrensMap, null);
                }
                catch (NoMainEntryException noMainEntryException) {
                }
                catch (KeyParentEqualException e2) {
                    e2.printStackTrace();
                }
                try {
                    if (root.getChildCount() == 0) {
                        TreeBuilder.addNodesToRootFromMap(root, null, this.childrensMap, null);
                    }
                }
                catch (NoMainEntryException e3) {
                    e3.printStackTrace();
                }
                catch (KeyParentEqualException e4) {
                    e4.printStackTrace();
                }
            } else if (isNewTreeBuildWanted) {
                if (this.isCachedVersionInPool()) {
                    this.addCachedNodes(root);
                } else {
                    this.childrensMap.clear();
                    for (SelectableItem item : this.selectableItemCollection) {
                        SelectableItemNode n;
                        TreeBuilder.add(this.childrensMap, n, (n = new SelectableItemNode(item)).getParentKey() == null ? "" : n.getParentKey());
                    }
                    TreeBuilder.addNodesToRootFromMap(root, "", this.childrensMap, null);
                }
            } else {
                this.insertnodes("", root);
                if (root.getChildCount() == 0) {
                    this.insertnodes(null, root);
                }
            }
            this.childrensMap.clear();
            Level lev = Logger.getLogger("superx_" + this.mandantenID).getLevel();
            if (lev != null && lev.intValue() <= Level.FINE.intValue()) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach urspr\u00fcngl. Aufbau:\n" + TreeUtils.countDescendents(root) + " Eintr\u00e4ge ");
            }
            if (EqualsUtil.areEqual(lev, Level.FINEST)) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINEST, "Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach urspr\u00fcngl. Aufbau:\n" + TreeUtils.toString(root));
            }
            if (this.isAltHier()) {
                RightsApplicator.apply(this, this.hauptSicht.rights);
            } else {
                RightsApplicator.apply(this, this.rights);
            }
            if (lev != null && lev.intValue() <= Level.FINE.intValue()) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach Rechteanwendung:\n" + TreeUtils.countDescendents(root) + " Eintr\u00e4ge ");
            }
            if (EqualsUtil.areEqual(lev, Level.FINEST)) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINEST, "Tree Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach Rechteanwendung:\n" + TreeUtils.toString(root));
            }
            if (root.getChildCount() == 0) {
                this.setNoSelectionPossible();
            }
            ((DefaultTreeModel)this.getModel()).reload();
            this.applyTreeCfg();
        }
        this.updateSubordinateKeyLists(root);
        this.refreshGui();
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, "Aktualisieren der Sicht:  " + this.getName_intern() + " (" + this.getId() + ") f\u00fcr Stand " + this.stand + " beendet");
        try {
            if (DateUtils.formatGerman(DateUtils.parse(this.stand)).equals(DateUtils.getTodayString())) {
                if (this.sichten.containsItemWithId(this.getId())) {
                    this.sichten.remove(this.sichten.getById(this.getId()));
                }
                this.sichten.add(this);
            }
        }
        catch (ParseException e5) {
            e5.printStackTrace();
        }
    }

    public void addCachedNodes(SelectableItemNode root) {
        throw new UnsupportedOperationException("hier nicht definiert");
    }

    private void updateRegular() throws SQLException, DBServletException, TemplateException, IOException {
        String sql = "";
        boolean isOrganigramm = false;
        if (this.getArt().equals("Organigramm-Sicht")) {
            isOrganigramm = true;
        }
        sql = this.prepareGeneralReadingSql();
        SxResultSet rohform = this.readFromDb(sql);
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, " Datenbank lieferte f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") " + rohform.size() + " Eintr\u00e4ge " + DateUtils.getNowString());
        this.selectableItemCollection.clear();
        if (rohform.size() > 0) {
            try {
                this.selectableItemCollection.addAll(SelectableItem.toSelectableItemCollection(rohform, isOrganigramm));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new SQLException("Sicht " + this.getName() + "(" + this.getId() + ") konnte nicht aufgebaut werden.\n" + e2);
            }
            if (EqualsUtil.areEqual(Logger.getLogger("superx_" + this.mandantenID).getLevel(), Level.FINEST)) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINEST, this.selectableItemCollection.toString());
            }
        }
    }

    private void updateAltHier() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        SelectableItem copiedElement2;
        this.hauptSicht.setStand(this.stand);
        if (this.altHierItems.isEmpty()) {
            this.readAltHierItems();
        }
        this.selectableItemCollection.clear();
        this.childrensMap.clear();
        int sortnr = 1;
        for (NamedIdObjectWithParent altHierItem : this.altHierItems) {
            SelectableItem hauptItem = null;
            try {
                hauptItem = (SelectableItem)this.hauptSicht.getSelectableItemCollection().getById(altHierItem.getId());
                copiedElement2 = (SelectableItem)hauptItem.clone();
                copiedElement2.setParentKey(altHierItem.getParentKey());
                copiedElement2.setSortNr(sortnr++);
                this.selectableItemCollection.add(copiedElement2);
                TreeBuilder.add(this.childrensMap, new SelectableItemNode(copiedElement2), copiedElement2.getParentKey());
            }
            catch (IllegalArgumentException copiedElement2) {
                // empty catch block
            }
        }
        if (!this.selectableItemCollection.containsItemWithId("") && this.selectableItemCollection.containsItemWithId(null) && this.hauptSicht.getSelectableItemCollection().containsItemWithParent("")) {
            NamedIdObjectWithParentCollection c2 = this.hauptSicht.getSelectableItemCollection().getByParent("");
            for (SelectableItem item : c2) {
                copiedElement2 = (SelectableItem)item.clone();
                copiedElement2.setSortNr(sortnr++);
                this.selectableItemCollection.add(copiedElement2);
                TreeBuilder.add(this.childrensMap, copiedElement2, copiedElement2.getParentKey());
            }
        }
    }

    public void updateKlappstatus() {
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            node.setClosedInTree(this.isCollapsed(new TreePath(node.getPath())));
        }
    }

    private void applyTreeCfg() {
        if (this.isAltHier()) {
            TreeUtils.expandAll(this);
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
            block0: while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.setClosedInAltHier(false);
                for (IdObject closedItem : this.closedTreeNodes) {
                    if (!EqualsUtil.areEqual(node.getId(), closedItem.getId())) continue;
                    node.setClosedInAltHier(false);
                    TreePath tp = new TreePath(node.getPath());
                    this.collapsePath(tp);
                    continue block0;
                }
            }
        } else {
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.setClosedInAltHier(false);
            }
        }
    }

    protected void setNoSelectionPossible() {
        ((SelectableItemNode)this.getModel().getRoot()).removeAllChildren();
        ((SelectableItemNode)this.getModel().getRoot()).add(new SelectableItemNode(new SelectableItem("keine Auswahl m\u00f6glich", "Keine Auswahl m\u00f6glich")));
        ((DefaultTreeModel)this.getModel()).reload();
    }

    private void updateSubordinateKeyLists(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeNode node = en.nextElement();
            if (!(node instanceof SelectableItemNode)) continue;
            ((SelectableItemNode)node).updateSubordinateKeyList();
        }
    }

    private void littleGenerateSql(StringBuffer sql) {
        StringUtils.replace(sql, "<<UserID>>", "" + this.user.getId());
        String art = this.getArt();
        if (art.endsWith("-Sicht")) {
            art = art.substring(0, art.length() - 6);
        }
        if (this.getSqlDialect().equals("Postgres")) {
            StringUtils.replace(sql, "<<" + art + "-Stand>>", "date_val('" + this.getStand() + "')");
            StringUtils.replace(sql, "<<Stand>>", "date_val('" + this.getStand() + "')");
        } else {
            StringUtils.replace(sql, "<<Stand>>", "date('" + this.getStand() + "')");
            StringUtils.replace(sql, "<<" + art + "-Stand>>", "date('" + this.getStand() + "')");
        }
        StringUtils.replace(sql, "<<Sicht>>", "'" + this.getId().toString() + "'");
    }

    private String prepareGeneralReadingSql() {
        StringBuffer result = new StringBuffer(this.getQuelle());
        if (result.length() > 7 && result.substring(0, 7).equals("<<SQL>>")) {
            result = new StringBuffer(result.substring(7));
        }
        this.littleGenerateSql(result);
        if (result.toString().startsWith("sp_")) {
            if (this.getSqlDialect().equals("Postgres")) {
                result.insert(0, "select ");
            } else {
                result.insert(0, "execute procedure ");
            }
        }
        return result.toString();
    }

    protected String prepareOrgaReadingSql() {
        ProcedureSql procSql = new ProcedureSql(this.getSqlDialect().equals("Postgres") ? DB.POSTGRES : DB.INFORMIX);
        procSql.setName(this.getQuelle());
        procSql.addParam(this.user.getId());
        procSql.addDateParam(this.getStand());
        procSql.addParam(this.getId());
        procSql.setFinalSelect("select name,key_apnr,parent,lehre,erlaubt from tmp_organigramm; drop table tmp_organigramm;");
        return procSql.getFinishedCall();
    }

    protected abstract String getSqlDialect();

    protected abstract SxResultSet readFromDb(String var1) throws SQLException, DBServletException, TemplateException, IOException;

    private void insertnodes(String theParent, DefaultMutableTreeNode aktNode) {
        Collection result = new TreeSet();
        result = this.mySelect(theParent);
        for (SelectableItem einEintrag : result) {
            SelectableItemNode neuNode = new SelectableItemNode(einEintrag);
            aktNode.add(neuNode);
            String eintrag_key = (String)einEintrag.getId();
            if (eintrag_key != null & theParent == null) {
                this.insertnodes((String)einEintrag.getId(), neuNode);
            }
            if (eintrag_key == null & theParent == null) {
                System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName());
            }
            if (eintrag_key == null || theParent == null) continue;
            if (!theParent.equals(eintrag_key)) {
                if (eintrag_key.trim().equals("")) {
                    throw new IllegalArgumentException("Ung\u00fcltiger Schl\u00fcssel Leerstring bei Sicht " + this.getId());
                }
                this.insertnodes((String)einEintrag.getId(), neuNode);
                continue;
            }
            System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName() + " key_apnr:" + einEintrag.getId());
        }
    }

    private Collection mySelect(String pruefparent) {
        TreeSet<SelectableItem> result = new TreeSet<SelectableItem>();
        for (SelectableItem einEintrag : this.selectableItemCollection) {
            String eintrag_parent = (String)einEintrag.getParentKey();
            if (eintrag_parent == null && pruefparent == null) {
                result.add(einEintrag);
            }
            if (eintrag_parent == null || pruefparent == null || !eintrag_parent.equals(pruefparent)) continue;
            result.add(einEintrag);
        }
        return result;
    }

    public String getArt() {
        return this.art;
    }

    public void setArt(String string) {
        this.art = string;
    }

    public boolean isPerfectlyRegular() {
        return this.isPerfectlyRegular;
    }

    public void setPerfectlyRegular(boolean b2) {
        this.isPerfectlyRegular = b2;
    }

    public void setUser(SxUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User objekt darf nicht null sein");
        }
        this.user = user;
        this.rights.setAdmin(user.isAdmin());
    }

    Integer getSysteminfoid() {
        return this.systeminfoid;
    }

    void setSysteminfoid(Integer systeminfoid) {
        this.systeminfoid = systeminfoid;
    }

    String getTreeCfgId() {
        return this.treeCfgId;
    }

    public void setTreeCfgId(String treeviewid) {
        this.treeCfgId = treeviewid;
    }

    String getTreeCfgTable() {
        return this.treeCfgTable;
    }

    public void setTreeCfgTable(String treeCfgTable) {
        this.treeCfgTable = treeCfgTable;
    }

    String getAltHierId() {
        return this.altHierId;
    }

    public void setAltHierId(String alt_hier_id) {
        this.altHierId = alt_hier_id;
    }

    public NamedIdObjectWithParentCollection getSelectableItemCollection() {
        return this.selectableItemCollection;
    }

    public void setHauptSicht(AbstractSicht hauptSicht) {
        this.hauptSicht = hauptSicht;
    }

    public void readAltHierItems() throws SQLException, DBServletException, KeyParentEqualException, TemplateException, IOException {
        String sql = "select key,parent from " + this.getQuelle() + " where hierarchie_id='" + this.getAltHierId() + "' order by key";
        SxResultSet rohform = this.readFromDb(sql);
        this.altHierItems.clear();
        for (SxResultRow einEintrag : rohform) {
            NamedIdObjectWithParent item = new NamedIdObjectWithParent();
            item.setId(einEintrag.get(0));
            try {
                item.setParentKey(einEintrag.get(1));
            }
            catch (KeyParentEqualException e2) {
                e2.printStackTrace();
                throw new RuntimeException("Konne Sicht " + this.getName() + " (" + this.getId() + ") nicht aufbauen." + e2);
            }
            this.altHierItems.add(item);
        }
    }

    public String getAllNeededKeysList() {
        String result = "";
        if (this.getSelectionCount() == 0) {
            result = TreeUtils.getSubordinateKeyList((DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot(), true, true);
        } else {
            int i2 = 0;
            while (i2 < this.getSelectionCount()) {
                SelectableItemNode selNode = (SelectableItemNode)this.getSelectionPaths()[i2].getLastPathComponent();
                if (i2 > 0) {
                    result = String.valueOf(result) + ",\n";
                }
                result = String.valueOf(result) + TreeUtils.getSubordinateKeyList(selNode, true, true);
                ++i2;
            }
        }
        return "(" + result + ")";
    }

    public Object exec(List l2) throws TemplateModelException {
        if (l2 == null || l2.size() < 2) {
            throw new TemplateModelException("Syntax: getSubkeys,Schl\u00fcssel - mindestens 2 Elemente n\u00f6tig");
        }
        if (!l2.get(0).toString().equalsIgnoreCase("getSubkeys")) {
            throw new IllegalArgumentException("nur getSubkeys,Schl\u00fcssel implementiert");
        }
        String key = l2.get(1).toString();
        if (!this.containsItemWithId(key)) {
            throw new IllegalArgumentException("In der Sicht " + this.getName() + " ist kein Schl\u00fcssel " + key + " enhalten");
        }
        SelectableItemNode node = this.getById(key);
        return "(" + TreeUtils.getSubordinateKeyList(node, true, true) + ")";
    }

    public String getOwnAndParentsKeyList() {
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        if (this.getSelectionCount() > 0) {
            startNode = (SelectableItemNode)this.getSelectionPath().getLastPathComponent();
        }
        return TreeUtils.getOwnAndParentsKeyList(startNode, false, true).replaceAll(",'xxxxxx-xxxxxx@'", "");
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return String.valueOf(this.isAltHier() ? "Alt.Hier:" : "") + this.name + " Anzahl Eintr\u00e4ge:" + ((DefaultMutableTreeNode)this.getModel().getRoot()).getChildCount();
    }

    protected void refreshGui() {
        SelectableItemNode root = (SelectableItemNode)this.getModel().getRoot();
        if (!this.isAltHier() && root.getChildCount() > 0) {
            DefaultMutableTreeNode ebene1 = (DefaultMutableTreeNode)root.getChildAt(0);
            this.expandPath(new TreePath(ebene1.getPath()));
        }
        this.setRootVisible(false);
        this.validate();
    }

    private void configTree() {
        this.setRootVisible(false);
        if (leaf == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                leaf = new ImageIcon(cl.getResource("images/leaf.gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setBorderSelectionColor(Color.darkGray);
        if (leaf != null) {
            renderer.setLeafIcon(leaf);
        }
        this.setCellRenderer(renderer);
        this.setSelectionModel(new SxSelectionModel());
        this.getSelectionModel().setSelectionMode(1);
        this.refreshGui();
    }

    protected void setMultiSelection(boolean isMulti) {
        if (isMulti) {
            this.getSelectionModel().setSelectionMode(4);
        } else {
            this.getSelectionModel().setSelectionMode(1);
        }
    }

    protected void reset() {
        this.setNoSelectionPossible();
    }

    private void readTreeCfg() throws SQLException, DBServletException, TemplateException, IOException {
        this.closedTreeNodes.clear();
        String sql = "select node_id from " + this.getTreeCfgTable() + " where tree_id='" + this.getTreeCfgId() + "'";
        SxResultSet rohform = this.readFromDb(sql);
        for (SxResultRow einEintrag : rohform) {
            IdObject item = new IdObject();
            item.setId(einEintrag.get(0));
            this.closedTreeNodes.add(item);
        }
        this.isTreeCfgRead = true;
    }

    @Override
    public Collection getElements(int enumType) {
        LinkedList<SelectableItemNode> result = new LinkedList<SelectableItemNode>();
        SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
        int i2 = 0;
        while (i2 < Math.max(1, this.getSelectionCount())) {
            if (this.getSelectionCount() > 0) {
                startNode = (SelectableItemNode)this.getSelectionPaths()[i2].getLastPathComponent();
            }
            Enumeration<TreeNode> en = null;
            if (enumType < 1 || enumType > 3) {
                throw new IllegalArgumentException("Ung\u00fcltiger Enumtype");
            }
            if (enumType == 1) {
                en = startNode.preorderEnumeration();
            }
            if (enumType == 2) {
                en = startNode.breadthFirstEnumeration();
            }
            if (enumType == 3) {
                en = startNode.depthFirstEnumeration();
            }
            if (this.isSubelementsinForEach()) {
                while (en.hasMoreElements()) {
                    SelectableItemNode node = (SelectableItemNode)en.nextElement();
                    if (node.isHidden() || node.isRoot()) continue;
                    result.add(node);
                }
            } else if (!(startNode.isHidden() || startNode.isRoot() || this.isAltHier() && !this.isVisible(new TreePath(startNode.getPath())))) {
                result.add(startNode);
            }
            ++i2;
        }
        return result;
    }

    public boolean isExpanded(SelectableItemNode n) {
        return this.isCollapsed(new TreePath(n.getPath()));
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key == null) {
            return null;
        }
        SimpleScalar result = null;
        if (key.equalsIgnoreCase("sichtart")) {
            result = new SimpleScalar(this.getArt());
        }
        if (key.equalsIgnoreCase("sichtname_intern")) {
            result = new SimpleScalar(this.getName_intern());
        }
        if (key.equalsIgnoreCase("sichtname")) {
            result = new SimpleScalar(this.getName());
        }
        if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("key")) {
            result = this.getId() == null ? new SimpleScalar(null) : new SimpleScalar(this.getId().toString());
        }
        if (key.equalsIgnoreCase("allNeededKeys") || key.equalsIgnoreCase("allNeededKeysList")) {
            result = new SimpleScalar(this.getAllNeededKeysList());
        }
        if (key.equalsIgnoreCase("keysToRoot")) {
            result = new SimpleScalar(this.getOwnAndParentsKeyList());
        }
        if (key.equalsIgnoreCase("elements")) {
            result = new SimpleSequence(this.getElements(1));
        }
        if (key.equalsIgnoreCase("elementsMinEbene")) {
            result = new SimpleNumber(this.getElementsMinEbene(1));
        }
        if (key.equalsIgnoreCase("elementsMaxEbene")) {
            result = new SimpleNumber(this.getElementsMaxEbene(1));
        }
        if (key.equalsIgnoreCase("breadthFirstElements")) {
            result = new SimpleSequence(this.getElements(2));
        }
        if (key.equalsIgnoreCase("depthFirstElements")) {
            result = new SimpleSequence(this.getElements(3));
        }
        if (key.equalsIgnoreCase("selectedElementsOnly")) {
            LinkedList<Object> list = new LinkedList<Object>();
            int i2 = 0;
            while (i2 < this.getSelectionCount()) {
                list.add(this.getSelectionPaths()[i2].getLastPathComponent());
                ++i2;
            }
            result = new SimpleSequence(list);
        }
        if (key.equalsIgnoreCase("hasValue")) {
            result = this.getSelectionCount() == 0 ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
        if (key.equalsIgnoreCase("selectionCount")) {
            result = new SimpleNumber((Number)new Integer(this.getSelectionCount()));
        }
        return result;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    @Override
    public void setAllowed(boolean isAllowed) {
        this.isAllowed = isAllowed;
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    public void setMandantenID(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    public static void main(String[] args) {
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getXmlMaxEntries() {
        return this.xmlMaxEntries;
    }

    public void setXmlMaxEntries(Integer xmlMaxEntries) {
        this.xmlMaxEntries = xmlMaxEntries;
    }

    protected void finishClone(AbstractSicht cl) throws CloneNotSupportedException {
        cl.sichten = this.sichten;
        cl.mandantenID = this.mandantenID;
        cl.label = this.label;
        cl.art = this.art;
        cl.name_intern = this.name_intern;
        cl.beschreibung = this.beschreibung;
        cl.quelle = this.quelle;
        cl.stand = this.stand;
        cl.isStandbuttonWanted = this.isStandbuttonWanted;
        cl.isPerfectlyRegular = this.isPerfectlyRegular;
        cl.hasCachedVersion = this.hasCachedVersion;
        cl.isAllowed = this.isAllowed;
        cl.systeminfoid = this.systeminfoid;
        cl.treeCfgId = this.treeCfgId;
        cl.treeCfgTable = this.treeCfgTable;
        cl.selectableItemCollection.clear();
        for (IdObjectI item : this.selectableItemCollection) {
            cl.selectableItemCollection.add(((SelectableItem)item).clone());
        }
        cl.altHierItems.clear();
        for (IdObjectI item : this.altHierItems) {
            cl.altHierItems.add(((NamedIdObjectWithParent)item).clone());
        }
        cl.closedTreeNodes.clear();
        for (IdObjectI item : this.closedTreeNodes) {
            cl.closedTreeNodes.add(((IdObject)item).clone());
        }
        cl.validityPeriod = (Period)this.validityPeriod.clone();
        cl.user = this.user;
        cl.altHierId = this.altHierId;
        if (this.hauptSicht != null) {
            cl.hauptSicht = (AbstractSicht)this.hauptSicht.clone();
        }
        cl.type = this.type;
        cl.xmlMaxEntries = this.xmlMaxEntries;
        cl.attribut3 = this.attribut3;
        cl.rights = (Rights)this.rights.clone();
        cl.applyTreeCfg();
    }

    public String getJSONInfo() {
        return "{name:\"" + StringUtils.jsonAdapt(this.getName(), true) + "\",name_intern:\"" + StringUtils.jsonAdapt(this.getName_intern(), true) + "\",stand:" + (this.isStandbuttonWanted() ? "true" : "false") + "}";
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof AbstractSicht) {
            result = this.getId().equals(((AbstractSicht)o).getId());
        }
        return result;
    }

    public boolean isSubelementsinForEach() {
        return this.isSubelementsinForEach;
    }

    public void setSubelementsinForEach(boolean isSubelementsinForEach) {
        this.isSubelementsinForEach = isSubelementsinForEach;
    }

    public boolean isFirstInGroup() {
        return this.isFirstInGroup;
    }

    public void setFirstInGroup(boolean isFristInGroup) {
        this.isFirstInGroup = isFristInGroup;
    }

    public Integer getAttribut3() {
        return this.attribut3;
    }

    public void setAttribut3(Integer attribut3) {
        this.attribut3 = attribut3;
    }

    public int getElementsMinEbene(int type) {
        Collection c2 = this.getElements(type);
        int minEbene = 99999;
        for (DefaultMutableTreeNode n : c2) {
            if (n.getLevel() >= minEbene) continue;
            minEbene = n.getLevel();
        }
        return minEbene;
    }

    public int getElementsMaxEbene(int type) {
        Collection c2 = this.getElements(type);
        int maxEbene = -1;
        for (DefaultMutableTreeNode n : c2) {
            if (n.getLevel() <= maxEbene) continue;
            maxEbene = n.getLevel();
        }
        return maxEbene;
    }

    private class SxSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;

        private SxSelectionModel() {
        }

        @Override
        protected boolean canPathsBeAdded(TreePath[] paths) {
            boolean result = true;
            int i2 = 0;
            while (i2 < paths.length) {
                if (paths[i2].getLastPathComponent() instanceof SelectableItemNode && !((SelectableItemNode)paths[i2].getLastPathComponent()).isSelectable()) {
                    result = false;
                    break;
                }
                ++i2;
            }
            return result;
        }

        @Override
        public void addSelectionPath(TreePath path) {
            TreePath[] tp = new TreePath[]{path};
            if (this.canPathsBeAdded(tp)) {
                super.addSelectionPath(path);
            }
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            if (this.canPathsBeAdded(paths)) {
                super.addSelectionPaths(paths);
            }
        }

        @Override
        public void setSelectionPath(TreePath path) {
            TreePath[] tp = new TreePath[]{path};
            if (this.canPathsBeAdded(tp)) {
                super.setSelectionPath(path);
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if (this.canPathsBeAdded(paths)) {
                super.setSelectionPaths(paths);
            }
        }
    }
}

