/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.dlg;

import de.memtext.dlg.DialogWithExit;
import de.memtext.dlg.OkCancelPanel;
import de.memtext.util.ComponentUtils;
import de.memtext.widgets.HorizontalBox;
import de.memtext.widgets.VerticalBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public abstract class OkCancelDlg
extends DialogWithExit {
    private OkCancelPanel pOkCancel;
    private HorizontalBox boxAboverOkCancel = new HorizontalBox();
    protected boolean wasOkSelected;
    protected boolean wasCancelSelected;

    public OkCancelDlg(Frame owner, String title, boolean isModal) {
        super(owner, title, isModal);
        this.initOkCancelDlg();
    }

    public OkCancelDlg(Frame frame, String title) throws HeadlessException {
        super(frame, title, true);
        this.initOkCancelDlg();
    }

    public OkCancelDlg(Dialog arg0) throws HeadlessException {
        super(arg0, true);
        this.initOkCancelDlg();
    }

    public OkCancelDlg(Dialog arg0, String arg1) throws HeadlessException {
        super(arg0, arg1, true);
        this.initOkCancelDlg();
    }

    private void initOkCancelDlg() {
        VerticalBox pSouth = new VerticalBox();
        this.pOkCancel = new OkCancelPanel();
        pSouth.add(this.boxAboverOkCancel);
        pSouth.add(this.pOkCancel);
        this.getContentPane().add((Component)pSouth, "South");
        this.pOkCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("OK")) {
                    OkCancelDlg.this.wasOkSelected = true;
                    OkCancelDlg.this.wasCancelSelected = false;
                    OkCancelDlg.this.performOk();
                }
                if (cmd.equals("Cancel")) {
                    OkCancelDlg.this.wasOkSelected = false;
                    OkCancelDlg.this.wasCancelSelected = true;
                    OkCancelDlg.this.performCancel();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.pOkCancel.getBtnOk());
    }

    public void addAboveOK(JComponent comp) {
        this.boxAboverOkCancel.add(comp);
    }

    public boolean wasOkSelected() {
        return this.wasOkSelected;
    }

    public boolean wasCancelSelected() {
        return this.wasCancelSelected;
    }

    protected abstract void performOk();

    protected abstract void performCancel();

    public void addBeforeOK(JComponent comp) {
        int pos = ComponentUtils.getPositionOnComponent(this.pOkCancel.getBtnOk(), this.pOkCancel);
        this.pOkCancel.add((Component)comp, pos);
    }

    public void addAfterOK(JComponent comp) {
        int pos = ComponentUtils.getPositionOnComponent(this.pOkCancel.getBtnOk(), this.pOkCancel);
        this.pOkCancel.add((Component)comp, pos + 1);
    }

    public void addAfterCancel(JComponent comp) {
        int pos = ComponentUtils.getPositionOnComponent(this.pOkCancel.getBtnCancel(), this.pOkCancel);
        this.pOkCancel.add((Component)comp, pos + 1);
    }

    public void setOkVisible(boolean b2) {
        this.pOkCancel.setOkVisible(b2);
    }

    public void setCancelVisible(boolean b2) {
        this.pOkCancel.setCancelVisible(b2);
    }

    public boolean requestFocusForOK() {
        return this.pOkCancel.getBtnOk().requestFocusInWindow();
    }

    public void setOkBold(boolean b2) {
        this.pOkCancel.setOkBold(b2);
    }

    public void setOkDefaultButton() {
        this.getRootPane().setDefaultButton(this.pOkCancel.getBtnOk());
    }

    public static void main(String[] args) {
        OkCancelDlg dlg = new OkCancelDlg((Frame)new JFrame(), "test"){

            @Override
            protected void performOk() {
            }

            @Override
            protected void performCancel() {
            }
        };
        dlg.setCenter(new JLabel("cnter"));
        dlg.pack();
        dlg.show();
    }
}

