/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.CSMspwd;
import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.BufferedOutputStream;
import java.io.IOException;

public class CSMBufferedOutputStream
extends BufferedOutputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final short BLOCK_SIZE = 8;
    static final short SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataOutputStream IfxOs = null;
    private byte[] buffer;
    private int bufferDataLen;
    private String ClientLocale = null;
    private Trace traceObj;

    public CSMBufferedOutputStream(IfxDataOutputStream ifxDataOutputStream, CSMspwd cSMspwd) {
        super(ifxDataOutputStream);
        this.CSMspwd = cSMspwd;
        this.IfxOs = ifxDataOutputStream;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    public CSMBufferedOutputStream(IfxDataOutputStream ifxDataOutputStream, int n, CSMspwd cSMspwd) {
        super(ifxDataOutputStream, n);
        this.CSMspwd = cSMspwd;
        this.IfxOs = ifxDataOutputStream;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    public final void flush() throws IOException {
        if (this.bufferDataLen > 0) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
        }
        this.IfxOs.flush();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= 4098) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
            this.encryptWrite(byArray, n, n2);
        } else {
            int n3 = this.bufferDataLen + n2;
            if (n3 > 4098) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferDataLen);
                System.arraycopy(byArray, n, byArray2, this.bufferDataLen, n2);
                this.encryptWrite(byArray2, 0, n3);
                this.bufferDataLen = 0;
            } else {
                System.arraycopy(byArray, n, this.buffer, this.bufferDataLen, n2);
                if (n3 == 4098) {
                    this.encryptWrite(this.buffer, 0, n3);
                    this.bufferDataLen = 0;
                } else {
                    this.bufferDataLen = n3;
                }
            }
        }
    }

    private void encryptWrite(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        int n3;
        this.IfxOs.writeShort((short)3);
        int n4 = n2 % 8;
        if (n4 > 0) {
            n3 = n2 + (8 - n4);
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            for (int i2 = n2; i2 < n3; ++i2) {
                byArray2[i2] = 0;
            }
        } else {
            n3 = n2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        byte[] byArray3 = new byte[n3];
        try {
            this.CSMspwd.processOutMessage(byArray2, byArray3);
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
        short s = (short)(n3 + 2);
        this.IfxOs.writeShort(s);
        this.IfxOs.writeShort(n2);
        this.IfxOs.write(byArray3, 0, n3);
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

