/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.CryptUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.ServletHelper;
import de.superx.common.DBServletException;
import de.superx.common.SxUser;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.util.SqlStringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SuperXmlPwChanger
extends HttpServlet {
    private static String alternativeRedirectUrl;
    private static String encodeAlgorithm;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletUtils.setPath(this.getServletConfig().getServletContext().getRealPath("/xml"));
        alternativeRedirectUrl = config.getInitParameter("alt_redirect_url");
        encodeAlgorithm = config.getInitParameter("encodeAlgorithm");
        if (encodeAlgorithm == null || encodeAlgorithm.equals("")) {
            encodeAlgorithm = "SHA512";
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletUtils.setPath(this.getServletConfig().getServletContext().getRealPath("/xml"));
        PwChanger pw = new PwChanger(request, response);
        pw.run(true);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        PrintWriter output = response.getWriter();
        if (session == null || session.getAttribute("user") == null) {
            output.write(SuperXManager.htmlPageHead("Erfolg") + "<h3 class=\"title\">Passwort\u00e4nderung f\u00fcr angemeldete Benutzer</h3></body></html>");
        } else {
            response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            output.write(SuperXManager.htmlPageHead("Passwort \u00e4ndern"));
            output.write(UserInitializer.getPwChangeHtml("<h3 class=\"title\">Passwort &auml;ndern</h3>"));
            output.write(SuperXManager.pageEnd);
        }
        output.flush();
        output.close();
    }

    public String getServletInfo() {
        return "<i>SuperXmlPwChanger</i>";
    }

    public static String getEncyptionInfo() {
        return encodeAlgorithm;
    }

    private class PwChanger
    extends SuperXServletHelper {
        private String passwort;
        private Connection con;
        private SxUser user;

        public PwChanger(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
        }

        @Override
        protected void perform() throws KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
            boolean isShowLoginWantend = EqualsUtil.areEqual(ServletHelper.getParameter(this.request, "showlogin"), "true");
            String add = "";
            if (isShowLoginWantend) {
                add = "<input type=\"hidden\" name=\"showlogin\" value=\"true\">";
            }
            String altesPasswort = ServletHelper.getParameter(this.request, "altes_passwort");
            this.passwort = ServletHelper.getParameter(this.request, "passwort");
            String passwort2 = ServletHelper.getParameter(this.request, "passwort2");
            HttpSession ses = this.request.getSession();
            this.user = (SxUser)ses.getAttribute("user");
            String currentSha = this.user.getCurrentSha();
            if (altesPasswort == null || altesPasswort.equals("") || this.passwort == null || this.passwort.equals("")) {
                this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Bitte Passwort eingeben</font>"));
            } else {
                this.con = SxPools.get(this.getMandantenID()).getConnection();
                try {
                    boolean isAltesPasswortOk = this.checkOldPw(altesPasswort);
                    if (isAltesPasswortOk) {
                        if (!EqualsUtil.areEqual(this.passwort, passwort2)) {
                            this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Die eingegeben Passw&ouml;rter stimmten nicht &uuml;berein</font>"));
                        } else if (this.user.isPWUsedBefore(this.passwort) || CryptUtils.encodeSHA(this.passwort).equals(currentSha) || CryptUtils.encodeSHA(this.passwort + CryptUtils.geheimnis1).equals(currentSha) || CryptUtils.encodeSHA512(this.passwort).equals(currentSha)) {
                            this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Sie m&uuml;ssen ein neues Passwort eingeben (kein bereits fr&uuml;her benutztes)</font>"));
                        } else {
                            String faults = SxPools.get(this.getMandantenID()).getNewPWChecker().checkForFaults(this.user.getName(), this.passwort);
                            if (faults != null) {
                                this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>" + faults + "</font>"));
                            } else {
                                this.user.rememberOldSHA(currentSha);
                                this.dbUpdate();
                                this.request.getSession().setAttribute("passwordchange", (Object)"false");
                                String add2 = "";
                                String session_alt_re = (String)this.request.getSession().getAttribute("alt_redirect_url");
                                if (alternativeRedirectUrl != null || session_alt_re != null) {
                                    add2 = EqualsUtil.areEqual(session_alt_re, "none") ? "Rufen Sie die Startseite auf" : add2 + "<p><a href=\"" + (alternativeRedirectUrl != null ? alternativeRedirectUrl : session_alt_re) + "\">zur Startseite</a></p>";
                                } else if (isShowLoginWantend) {
                                    add2 = "<p>Sie k&ouml;nnen Sich jetzt <a href=\"/superx/servlet/de.superx.servlet.SuperXmlAnmeldung?showlogin=true&MandantenID=" + this.getMandantenID() + "\">neu anmelden</a>";
                                    SuperXServletHelper.removeCookie(this.request, this.response);
                                    this.request.getSession().invalidate();
                                }
                                this.sendBackHtml(SuperXManager.htmlPageHead("Erfolg") + "<h3>Passwort&auml;nderung erfolgreich</h3>" + add2 + "</body></html>");
                            }
                        }
                    }
                    this.con.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.con != null) {
                        SxPools.invalidate(this.getMandantenID(), this.con);
                    }
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, "SQL-Fehler: " + e.toString());
                    throw new DBServletException(e.getMessage());
                }
            }
        }

        private boolean checkOldPw(String altesPasswort) throws SQLException, IOException {
            boolean isOk = false;
            String msg = null;
            PreparedStatement pst = this.con.prepareStatement("select passwd_sha, akt_versuch,max_versuch from userinfo where tid = ?");
            pst.setInt(1, new Integer(this.user.getId().toString()));
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                int max_versuch;
                int akt_versuch;
                String oldsha = rs.getString(1);
                if (oldsha != null) {
                    oldsha = oldsha.trim();
                }
                if ((akt_versuch = rs.getInt(2)) >= (max_versuch = rs.getInt(3))) {
                    msg = "Maximale Loginversuche &uuml;berschritten";
                    continue;
                }
                if (CryptUtils.encodeSHA(altesPasswort).equals(oldsha) || CryptUtils.encodeSHA(altesPasswort + CryptUtils.geheimnis1).equals(oldsha) || CryptUtils.encodeSHA512(altesPasswort).equals(oldsha)) {
                    isOk = true;
                    continue;
                }
                UserInitializer.versuchszahlErh\u00f6hen(this.user.getName().toString(), this.con);
                msg = "Bisheriges Passwort falsch";
            }
            rs.close();
            pst.close();
            if (msg != null) {
                this.sendBackHtml(UserInitializer.getPwChangeHtml("<font color=red>" + msg + "</font>"));
            }
            return isOk;
        }

        private void dbUpdate() throws Exception {
            int rowcount;
            Statement stm = this.con.createStatement();
            String newSha = "";
            if (encodeAlgorithm.equals("SHA512")) {
                newSha = CryptUtils.encodeSHA512(this.passwort);
            }
            if (encodeAlgorithm.equals("SHA_SALTED")) {
                newSha = CryptUtils.encodeSHA512(this.passwort + CryptUtils.geheimnis1);
            }
            if (encodeAlgorithm.equals("SHA")) {
                newSha = CryptUtils.encodeSHA(this.passwort);
            }
            if ((rowcount = stm.executeUpdate("update userinfo set passwd_sha='" + newSha + "',kennwort='' where tid=" + this.user.getId() + ";")) != 1) {
                throw new DBServletException("Passwort\u00e4nderung fehlgeschlagen, statt einem Eintrag wurden " + rowcount + " ge\u00e4ndert.");
            }
            stm.execute(this.user.getUser_PW_Command(SxPools.get(this.getMandantenID()).getPasswortG\u00fcltigkeit()));
            stm.close();
            this.user.setCurrentSha(newSha);
        }
    }
}

