/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebserviceClientBewegungsdatenByFistl
extends AbstractWebserviceClient {
    private Collection<String> finanzstellen = new LinkedList<String>();
    private boolean isDBConnectionPossible = true;
    private Document configDocument;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private String hsnr;
    private String xmlConfig;
    private String datentyp;
    private String url;
    private String soap;
    private String outfilename;
    private boolean columnNamesWritten = false;
    private boolean columnNamesHdWritten = false;
    private File tmpFile;
    private File outFile;
    private File outFileHd;
    private String jahr;
    private PrintWriter fw;
    private PrintWriter fwhd;
    private BufferedWriter bfw;
    private BufferedWriter bfwhd;
    private String dbpropfile;
    private static final Logger log = Logger.getLogger("wc");

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientBewegungsdatenByFistl Version 0.9.3");
        WebserviceClientBewegungsdatenByFistl tc = new WebserviceClientBewegungsdatenByFistl();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            XMLUtils.getExceptionHandler().setWithGui(false);
            XMLUtils.getExceptionHandler().setExitWanted(true);
            LogUtils.initRawFileDateTime("wc", "WebserviceClient.log", 100000, 1, true, false);
            log.setLevel(Level.FINEST);
            log.getHandlers()[0].setLevel(Level.FINEST);
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-xmlconfig,-hsnr,-jahr,-out,-datentyp,-dbproperties");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.readFinanzstellen();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            log.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailurl");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailsoap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.datentyp + "\nSOAP Aufruf:\n" + this.soap);
        log.fine(this.datentyp + "\nSOAP Aufruf:\n" + this.soap);
        this.initOutFile();
        String msg = "";
        Iterator<String> it = this.finanzstellen.iterator();
        int i = 0;
        while (it.hasNext()) {
            String fistl = it.next();
            String tmpsoap = this.soap.replace("XXFISTLXX", fistl);
            if (++i % 10 == 0) {
                System.out.print(i + " ");
            }
            this.tmpFile = this.createSoapFile(tmpsoap, this.url);
            String nodeName = "EX_" + this.datentyp.toUpperCase();
            if (this.isReplyOk()) {
                String data;
                String columnNames = this.getColumnNames(nodeName).toString();
                if (!this.columnNamesWritten && !columnNames.equals("")) {
                    this.bfw.write(columnNames);
                    this.columnNamesWritten = true;
                }
                if (!(data = this.getData(nodeName).toString()).equals("")) {
                    this.bfw.write(data);
                }
                this.bfw.flush();
                if (this.datentyp.equals("fmifiit")) {
                    columnNames = this.getColumnNames("EX_FMIFIHD").toString();
                    if (!this.columnNamesHdWritten && !columnNames.equals("")) {
                        this.bfwhd.write(columnNames);
                        this.columnNamesHdWritten = true;
                    }
                    if (!(data = this.getData("EX_FMIFIHD").toString()).equals("")) {
                        this.bfwhd.write(data);
                    }
                    this.bfwhd.flush();
                }
                if (!this.isDeleteTmpXmlFileWanted) continue;
                this.tmpFile.delete();
                continue;
            }
            msg = "Error: Aufruf von Webservice f\u00fcr Bewegungsdaten " + this.datentyp + " (" + this.xmlConfig + ") fehlgeschlagen";
            System.out.println(msg);
            System.out.println(StringUtils.readFile(this.tmpFile));
            log.severe(msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
        this.closeFile();
    }

    private void readConfig() {
        this.xmlConfig = GetOpts.getValue("-xmlconfig");
        this.outfilename = GetOpts.getValue("-out");
        this.hsnr = GetOpts.getValue("-hsnr");
        this.jahr = GetOpts.getValue("-jahr");
        this.datentyp = GetOpts.getValue("-datentyp");
        this.dbpropfile = GetOpts.getValue("-dbproperties");
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        log.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent("-nodelete")) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        log.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        log.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void initOutFile() throws Exception {
        this.outFile = new File(this.outfilename);
        if (this.outFile.exists()) {
            this.outFile.delete();
        }
        this.fw = new PrintWriter(this.outFile);
        this.bfw = new BufferedWriter(this.fw);
        if (this.datentyp.equals("fmifiit")) {
            String hdfilename = StringUtils.replace(this.outfilename, ".", "hd.");
            this.outFileHd = new File(hdfilename);
            String msg = "Erzeuge zusaetzliche Header_Datei " + hdfilename;
            log.log(Level.INFO, msg);
            System.out.println(msg);
            this.fwhd = new PrintWriter(this.outFileHd);
            this.bfwhd = new BufferedWriter(this.fwhd);
        }
    }

    private void closeFile() throws Exception {
        this.bfw.close();
        this.fw.close();
        if (this.datentyp.equals("fmifiit")) {
            this.bfwhd.close();
            this.fwhd.close();
        }
        if (this.isDeleteTmpXmlFileWanted && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    private boolean isReplyOk() throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        boolean checkReturn = false;
        String result = "";
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    if (!parser.getLocalName().equals("RETURN")) break;
                    checkReturn = true;
                    break;
                }
                case 4: {
                    if (!checkReturn || parser.isWhiteSpace()) break;
                    result = parser.getText();
                    checkReturn = false;
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        return result.equals("I");
    }

    private StringBuilder getData(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        String datumspattern = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
        StringBuilder result = new StringBuilder();
        boolean getData = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (!name.equals(topnode)) break;
                    getData = true;
                    break;
                }
                case 4: {
                    if (!getData || parser.isWhiteSpace()) break;
                    String data = parser.getText();
                    data = data.matches("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)") ? data.replaceAll("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)", "$3.$2.$1") : WebserviceClientBewegungsdatenByFistl.purge(data);
                    result.append(data);
                    break;
                }
                case 2: {
                    if (parser.getLocalName().equals(topnode)) {
                        getData = false;
                        break;
                    }
                    if (getData && parser.getLocalName().equals("item")) {
                        result.append("\n");
                        break;
                    }
                    if (!getData) break;
                    result.append("^");
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        return result;
    }

    private String getColumnNames(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        String prefix = topnode.replaceAll("EX_", "");
        StringBuilder result = new StringBuilder();
        boolean getNames = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (parser.getLocalName().equals(topnode)) {
                        getNames = true;
                        break;
                    }
                    if (!getNames || name.equals("item")) break;
                    result.append(prefix + "_" + parser.getLocalName() + "^");
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals(topnode) && !parser.getLocalName().equals("item")) break;
                    getNames = false;
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        if (result.length() > 0) {
            result.append("\n");
        }
        return result.toString().toLowerCase();
    }

    private void readFinanzstellen() throws Exception {
        if (this.isDBConnectionPossible) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.dbpropfile);
            Connection con = myConnection.getConnection();
            Statement stm = con.createStatement();
            ResultSet rs = stm.executeQuery("select distinct fmfctr_fictr from gxstage_sap_sc11 -- where csks_kostl in ('8056100000','8056410000','8056121002')");
            while (rs.next()) {
                String instnr = rs.getString(1);
                this.finanzstellen.add(instnr);
            }
            rs.close();
            stm.close();
            con.close();
        }
        String msg = this.finanzstellen.size() + " Finanzstellen gefunden";
        log.log(Level.INFO, msg);
        System.out.println(msg);
    }
}

