/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.FilenamesFilter;
import de.memtext.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static int getHowOld(File f) {
        long now = new Date().getTime();
        return (int)((now - f.lastModified()) / 60000L);
    }

    public static String getFileNameWithoutSuffix(String filename) {
        int index = filename.indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException(filename + " doesn't contain .");
        }
        filename = filename.substring(0, index);
        return filename;
    }

    public static String addToEndOfFileName(String filename, String suffix) {
        int index = filename.indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException(filename + " doesn't contain .");
        }
        filename = filename.substring(0, index) + suffix + filename.substring(index, filename.length());
        return filename;
    }

    public static File[] getFileList(File dir, String beginning, String endings) {
        FilenamesFilter filt = new FilenamesFilter(null, endings, beginning);
        filt.setAllDirsAccepted(false);
        return dir.listFiles(filt);
    }

    public static void copyFile(String source, String target) throws IOException {
        FileUtils.copyFile(new File(source), new File(target));
    }

    public static void copyFile(File source, File target) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(target);
            in = new BufferedInputStream(is);
            out = new BufferedOutputStream(os);
            int buffer_size = 32768;
            byte[] buffer = new byte[buffer_size];
            int len = in.read(buffer, 0, buffer_size);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer, 0, buffer_size);
            }
            in.close();
            is.close();
            out.close();
            os.close();
        }
        catch (FileNotFoundException fe) {
            throw new FileNotFoundException("Die Datei " + source + " konnte nicht gefunden werden!");
        }
        catch (IOException e) {
            throw new IOException("Couldn't copy file " + e.toString());
        }
    }

    public static void createZipFile(String pathToZipUp, String pathToSaveTo) {
        FileUtils.createZipFile(pathToZipUp, "", pathToSaveTo);
    }

    public static void createZipFile(String pathToZipUp, String relPath, String pathToSaveTo) {
        try {
            FileOutputStream fos = new FileOutputStream(pathToSaveTo);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(8);
            if (!relPath.equals("") && pathToZipUp.lastIndexOf("\\") + 1 != pathToZipUp.length()) {
                pathToZipUp = pathToZipUp + "\\";
            }
            System.out.println(pathToZipUp + relPath);
            File f = new File(pathToZipUp + relPath);
            String[] files = f.list();
            if (pathToZipUp.lastIndexOf("\\") + 1 != pathToZipUp.length()) {
                pathToZipUp = pathToZipUp + "\\";
            }
            for (int y = 0; y < files.length; ++y) {
                File aFile;
                String fullpath = pathToZipUp;
                if (!relPath.equals("")) {
                    fullpath = fullpath + relPath + "\\";
                }
                if ((aFile = new File(fullpath = fullpath + files[y])).isDirectory()) {
                    relPath = relPath.equals("") ? files[y] : relPath + "\\" + files[y];
                    FileUtils.createZipFile(fullpath, relPath, pathToSaveTo);
                    continue;
                }
                byte[] temp = new byte[files[y].length()];
                try {
                    int n;
                    FileInputStream fis = new FileInputStream(aFile);
                    CRC32 crc32 = new CRC32();
                    while ((n = fis.read(temp)) > -1) {
                        crc32.update(temp, 0, n);
                    }
                    fis.close();
                    String shortName = files[y].substring(fullpath.length());
                    ZipEntry ze = new ZipEntry(shortName);
                    ze.setSize(aFile.length());
                    ze.setTime(aFile.lastModified());
                    ze.setCrc(crc32.getValue());
                    zos.putNextEntry(ze);
                    fis = new FileInputStream(aFile);
                    while ((n = fis.read(temp)) > -1) {
                        zos.write(temp, 0, n);
                    }
                    fis.close();
                    zos.closeEntry();
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] a) {
        List<File> l = FileUtils.getFileList("/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf", "mo*.xsl,g*.xsl");
        Iterator<File> it = l.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static void download(URL url, File targetFile) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(targetFile);
        BufferedInputStream bufferedInStream = new BufferedInputStream(inStream);
        BufferedOutputStream bufferedOutStream = new BufferedOutputStream(os);
        int buffer_size = 32768;
        byte[] buffer = new byte[buffer_size];
        int len = inStream.read(buffer, 0, buffer_size);
        while (len != -1) {
            bufferedOutStream.write(buffer, 0, len);
            len = bufferedInStream.read(buffer, 0, buffer_size);
        }
        bufferedInStream.close();
        inStream.close();
        bufferedOutStream.close();
        os.close();
    }

    public static String removeProblemChars(String name) {
        String result = name.replace('\\', '-');
        result = result.replace('/', '-');
        result = StringUtils.replace(result, " - ", "-");
        result = StringUtils.replace(result, " -", "-");
        result = StringUtils.replace(result, "- ", "-");
        result = result.replace(' ', '_');
        result = result.replace('*', '_');
        result = result.replace('?', '_');
        result = result.replace(',', '_');
        return result;
    }

    public static List<File> getFileList(String dir, String regex) {
        LinkedList<File> resultFiles = new LinkedList<File>();
        File fDir = new File(dir);
        File[] files = fDir.listFiles();
        StringTokenizer st = new StringTokenizer(regex, ",");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            pattern = pattern.replace(".", "\\.");
            pattern = pattern.replace("?", ".?").replace("*", ".*");
            for (File file : files) {
                if (!file.getName().matches(pattern)) continue;
                resultFiles.add(file);
            }
        }
        return resultFiles;
    }

    public static String getFileContentsWithEncoding(String filePath, String encoding) throws FileNotFoundException, IOException {
        File f = new File(filePath);
        String fileContents = "";
        if (encoding == null || encoding.trim().equals("")) {
            encoding = System.getProperty("file.encoding");
        }
        FileInputStream fis = new FileInputStream(f);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        StringWriter out = new StringWriter();
        String text = in.readLine();
        while (text != null) {
            out.write(text);
            out.write(System.getProperty("line.separator"));
            text = in.readLine();
        }
        if (out != null) {
            fileContents = out.toString();
        }
        return fileContents;
    }

    /*
     * Exception decompiling
     */
    public static String tail(File myFile, int nLines) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

