/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.trace;

import de.werum.sis.trace.Logger;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FileLogger
extends Logger {
    private static FileLogger myFileLogger = null;
    private Writer logfile;
    private String filename;

    private FileLogger(boolean debug, int errorThreshold, String filename) {
        super(debug, errorThreshold);
        this.filename = filename;
        try {
            this.logfile = new FileWriter(filename, true);
        }
        catch (IOException ex) {
            System.out.println("Konnte File" + filename + "nicht oeffnen.");
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
        try {
            this.logfile = new FileWriter(filename, true);
        }
        catch (IOException ex) {
            System.out.println("Konnte neues File" + filename + "nicht oeffnen/anlegen.");
        }
    }

    public void print(int errorLevel, String sMsg) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.now();
            StringBuffer sB = new StringBuffer(this.m_iEbene * 2);
            for (int i = 0; i < this.m_iEbene; ++i) {
                sB.append("  ");
            }
            try {
                this.logfile.write(this.m_sbZeit.toString() + sB.toString() + sMsg + "\n");
                this.logfile.flush();
            }
            catch (IOException ex) {
                System.out.println("Konnte File" + this.filename + "nicht oeffnen.");
            }
            Object var3_3 = null;
        }
    }

    public void print(String sMsg) {
        if (this.debug) {
            this.now();
            StringBuffer sB = new StringBuffer(this.m_iEbene * 2);
            for (int i = 0; i < this.m_iEbene; ++i) {
                sB.append("  ");
            }
            try {
                this.logfile.write(this.m_sbZeit.toString() + sB.toString() + sMsg + "\n");
                this.logfile.flush();
            }
            catch (IOException ex) {
                System.out.println("Konnte File" + this.filename + "nicht oeffnen.");
            }
            Object var2_2 = null;
        }
    }

    public void enter(String klasse, String methode) {
        if (this.debug) {
            this.m_listFuncs.add(klasse + ", " + methode);
            this.print("-> " + this.m_iEbene + ": " + this.m_listFuncs.get(this.m_iEbene).toString());
            ++this.m_iEbene;
        }
    }

    public void enter(int errorLevel, String klasse, String methode) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.enter(klasse, methode);
        }
    }

    public void leave() {
        if (this.debug) {
            --this.m_iEbene;
            this.print("<- " + this.m_iEbene + ": " + this.m_listFuncs.remove(this.m_iEbene).toString());
        }
    }

    public void leave(int errorLevel) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.leave();
        }
    }

    public static FileLogger getInstance(boolean debug, int errorThreshold, String filename) {
        if (myFileLogger == null) {
            myFileLogger = new FileLogger(debug, errorThreshold, filename);
        }
        return myFileLogger;
    }
}

