/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.meta.generator;

import de.werum.sis.meta.generator.FieldDescription;
import de.werum.sis.meta.generator.ObjectDescription;
import de.werum.sis.meta.generator.XMLParser;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class JavaClassGenerator {
    private String buildPath;
    private String packageName;

    public JavaClassGenerator(String buildPath, String packageName) {
        this.buildPath = buildPath;
        this.packageName = packageName;
    }

    public void generate(XMLParser parser) throws Exception {
        Iterator iter = parser.getObjects();
        while (iter.hasNext()) {
            ObjectDescription object = (ObjectDescription)iter.next();
            if (!object.getGenerateMetaClass()) continue;
            System.out.println("Bearbeite Objekt " + object.getName() + "...");
            this.generateMetaObject(object);
        }
        System.out.println("Generierung erfolgreich!");
    }

    private void generateMetaObject(ObjectDescription object) throws Exception {
        String className = "Meta" + object.getName();
        System.out.println("\tGeneriere Klasse " + className + ".java");
        PrintStream out = new PrintStream(new FileOutputStream(this.buildPath + System.getProperty("file.separator") + className + ".java"));
        this.generateClassHeader(out, className);
        this.generateClassImport(out, object);
        this.generateClassHeader(out, object, className);
        this.generateAttributes(out, object);
        this.generateClassConstructor(out, object, className);
        this.generateAccessors(out, object);
        this.generateClassFooter(out);
        out.close();
    }

    private void generateClassHeader(PrintStream out, String className) {
        GregorianCalendar cal = new GregorianCalendar();
        String date = cal.get(5) + "." + (cal.get(2) + 1) + "." + cal.get(1);
        out.println("/*");
        out.println(" * $RCSFile: " + className + ".java,v $");
        out.println(" *");
        out.println(" * automatically generated on " + date);
        out.println(" *");
        out.println(" * DO NOT EDIT THIS FILE!");
        out.println(" *");
        out.println(" * $Revision: $");
        out.println(" *");
        out.println(" * $Date: $");
        out.println(" *");
        out.println(" * Copyright:");
        out.println(" * Werum Software & Systems AG");
        out.println(" * Wulf-Werum-Strasse 3");
        out.println(" * D-21337 Lueneburg");
        out.println(" *");
        out.println(" * $Log: " + className + ".java,v $");
        out.println(" */");
        out.println("package " + this.packageName + ";");
        out.println();
    }

    private void generateClassImport(PrintStream out, ObjectDescription object) {
        Iterator imports = object.getImports();
        String importValue = null;
        if (object.hasList()) {
            out.println("import java.util.Iterator;");
            out.println("import java.util.Vector;");
        }
        while (imports.hasNext()) {
            importValue = imports.next().toString();
            if (importValue.length() == 0) continue;
            out.print("import ");
            out.print(importValue);
            out.println(";");
        }
        if (object.getSuperClass() == null || object.getSuperClass().length() == 0) {
            out.println("import de.werum.sis.meta.MetaElement;");
        }
        out.println();
    }

    private void generateClassHeader(PrintStream out, ObjectDescription object, String className) {
        String[] commentLines;
        String objectComment = object.getComment();
        if (objectComment != null && objectComment.length() > 0 && (commentLines = objectComment.split("\n")) != null && commentLines.length > 0) {
            out.println("/**");
            for (int i = 0; i < commentLines.length; ++i) {
                out.println(" * " + commentLines[i].trim());
            }
            out.println(" */");
        }
        String parentClass = object.getSuperClass();
        out.print("public ");
        if (object.isAbstractClass()) {
            out.print("abstract ");
        }
        out.print("class " + className);
        out.print(" extends ");
        if (parentClass != null) {
            out.print("Meta");
            out.print(parentClass);
        } else {
            out.print("MetaElement");
        }
        out.println();
        out.println("{");
    }

    private void generateClassFooter(PrintStream out) {
        out.print("}");
    }

    private void generateAttributes(PrintStream out, ObjectDescription object) {
        Iterator fields = object.getFields();
        while (fields.hasNext()) {
            String[] commentLines;
            FieldDescription field = (FieldDescription)fields.next();
            String fieldName = this.getFieldName(field);
            String fieldType = this.getFieldType(field);
            fieldType = fieldType.replaceAll("!", "");
            String fieldComment = field.getComment();
            if (fieldComment != null && fieldComment.length() > 0 && (commentLines = fieldComment.split("\n")) != null && commentLines.length > 0) {
                out.println("   /**");
                for (int i = 0; i < commentLines.length; ++i) {
                    out.println("    * " + commentLines[i].trim());
                }
                out.println("    */");
            }
            out.print("   private " + fieldType + " " + fieldName);
            out.println(";");
            out.println();
        }
    }

    private void generateClassConstructor(PrintStream out, ObjectDescription object, String className) {
        Iterator fields = object.getFields();
        out.println("   /**");
        out.println("    * Konstruktor");
        out.println("    */");
        out.println("    public " + className + "()");
        out.println("    {");
        while (fields.hasNext()) {
            FieldDescription field = (FieldDescription)fields.next();
            String fieldName = this.getFieldName(field);
            String fieldType = this.getFieldType(field);
            String fieldDefault = field.getDefaultValue();
            out.print("   \t\tthis." + fieldName + " = ");
            if (field.isList()) {
                out.println("new " + fieldType + "();");
                continue;
            }
            if (fieldDefault != null && fieldDefault.length() > 0) {
                if (fieldType.equals("String")) {
                    out.println("\"" + fieldDefault + "\";");
                    continue;
                }
                out.println(fieldDefault + ";");
                continue;
            }
            if (field.isNumeric()) {
                out.println("0;");
                continue;
            }
            if (field.isBooleanType()) {
                out.println("false;");
                continue;
            }
            out.println("null;");
        }
        out.println("    }");
        out.println();
    }

    private void generateAccessors(PrintStream out, ObjectDescription object) {
        Iterator fields = object.getFields();
        while (fields.hasNext()) {
            FieldDescription aField = (FieldDescription)fields.next();
            if (aField.isList()) {
                this.generateListAccessors(out, aField);
            } else {
                this.generateSimpleAccessors(out, aField);
            }
            if (!fields.hasNext()) continue;
            out.println();
        }
    }

    private void generateSimpleAccessors(PrintStream out, FieldDescription aField) {
        String fieldName = this.getFieldName(aField);
        String fieldType = this.getFieldType(aField);
        fieldType = fieldType.replaceAll("!", "");
        String fieldNameOwu = this.replaceUmlauts(aField.getName());
        out.println("   /**");
        out.println("    * Liefert den Wert des Feldes " + fieldNameOwu + " zur&uuml;ck.");
        out.println("    */");
        if (aField.isBooleanType()) {
            out.println("   public " + fieldType + " is" + fieldNameOwu + "()");
        } else {
            out.println("   public " + fieldType + " get" + fieldNameOwu + "()");
        }
        out.println("   {");
        out.println("      return this." + fieldName + ";");
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * Setzt den Wert des Feldes " + fieldNameOwu + ".");
        out.println("    */");
        out.println("   public void set" + fieldNameOwu + "(" + fieldType + " " + fieldName + ")");
        out.println("   {");
        out.println("      this." + fieldName + " = " + fieldName + ";");
        out.println("   }");
    }

    private void generateListAccessors(PrintStream out, FieldDescription aField) {
        String fieldName = this.getFieldName(aField);
        String fieldNameOwu = this.replaceUmlauts(aField.getName());
        out.println("   /**");
        out.println("    * Liefert einen Iterator ueber die Elemente von " + fieldNameOwu);
        out.println("    * zur&uuml;ck. Der Type der Elemente, die vom Iterator geliefert werden");
        out.println("    * ist " + aField.getListType() + ".");
        out.println("    */");
        out.println("   public Iterator get" + fieldNameOwu + "()");
        out.println("   {");
        out.println("      return this." + fieldName + ".iterator();");
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * Liefert die Anzahl der in " + fieldNameOwu + " enthaltenen");
        out.println("    * Elemente zur&uuml;ck.");
        out.println("    */");
        out.println("   public int sizeOf" + fieldNameOwu + "()");
        out.println("   {");
        out.println("      return this." + fieldName + ".size();");
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * Liefert Element aus " + fieldNameOwu);
        out.println("    */");
        out.print("   public " + aField.getListType());
        out.println(" getFrom" + fieldNameOwu + "(int position)");
        out.println("   {");
        if (aField.getWrapperClass() != null) {
            out.print("      return ((" + aField.getWrapperClass() + ")this." + fieldName);
            out.print(".elementAt(position)).");
            if ("Integer".equals(aField.getWrapperClass())) {
                out.print("int");
            } else if ("Float".equals(aField.getWrapperClass())) {
                out.print("float");
            } else if ("Double".equals(aField.getWrapperClass())) {
                out.print("double");
            } else if ("Boolean".equals(aField.getWrapperClass())) {
                out.print("boolean");
            } else if ("Character".equals(aField.getWrapperClass())) {
                out.print("char");
            } else if ("Short".equals(aField.getWrapperClass())) {
                out.print("short");
            }
            out.println("Value();");
        } else {
            out.print("      return (" + aField.getListType() + ")this." + fieldName);
            out.println(".elementAt(position);");
        }
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * F&uuml;gt zu " + fieldNameOwu + " ein neues Element am Ende hinzu.");
        out.println("    */");
        out.print("   public void addTo" + fieldNameOwu);
        out.println("(" + aField.getListType() + " anElement)");
        out.println("   {");
        if (aField.getWrapperClass() != null) {
            out.println("      this." + fieldName + ".add(new " + aField.getWrapperClass() + "(anElement));");
        } else {
            out.println("      this." + fieldName + ".add(anElement);");
        }
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * Entfernt ein Element aus " + fieldNameOwu + ".");
        out.println("    */");
        out.println("   public void removeFrom" + fieldNameOwu + "(int position)");
        out.println("   {");
        out.println("      this." + fieldName + ".remove(position);");
        out.println("   }");
    }

    private String getFieldType(FieldDescription field) {
        String fieldType = new String("");
        fieldType = field.isList() ? "Vector" : field.getType();
        return fieldType;
    }

    private String getFieldName(FieldDescription field) {
        String name = field.getName();
        if ((name = this.replaceUmlauts(name)).length() > 0) {
            String first = name.substring(0, 1).toLowerCase();
            name = first + name.substring(1);
        }
        return name;
    }

    private String replaceUmlauts(String str) {
        str = str.replaceAll("\u00e4", "ae");
        str = str.replaceAll("\u00c4", "Ae");
        str = str.replaceAll("\u00f6", "oe");
        str = str.replaceAll("\u00d6", "Oe");
        str = str.replaceAll("\u00fc", "ue");
        str = str.replaceAll("\u00dc", "Ue");
        str = str.replaceAll("\u00df", "ss");
        str = str.trim();
        return str;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.err.println("Aufruf muss mit drei Parametern erfolgen:");
            System.err.println("1. Parameter: Verzeichnis, in dem die XML-Objektbeschreibungen liegen");
            System.err.println("2. Parameter: Ziel-Verzeichnis fuer die generierten Java-Dateien");
            System.err.println("3. Parameter: Package der generierten Klassen");
            System.err.println("4 - X. Parameter: Namen der zu generierenden Klassen");
            System.exit(1);
        }
        String inputDir = args[0];
        String outputDir = args[1];
        String pckage = args[2];
        XMLParser parser = new XMLParser();
        try {
            if (args.length > 3) {
                for (int i = 3; i < args.length; ++i) {
                    if (!parser.parseFile(inputDir + "/" + args[i])) continue;
                    JavaClassGenerator generator = new JavaClassGenerator(outputDir, pckage);
                    generator.generate(parser);
                }
            } else if (parser.parseDirectory(inputDir)) {
                JavaClassGenerator generator = new JavaClassGenerator(outputDir, pckage);
                generator.generate(parser);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

