/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CryptKeyPair;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.trace.ConsoleLogger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class CipherPacker {
    protected static final byte[] PBE_HYBRID_CHECK_STR_BYTES;
    protected static final byte[] PBE_CHECK_STR_BYTES;
    protected static final int DEFAULT_CIPHER_PACKER_USER_ID = 402;
    protected static final Integer DEFAULT_CIPHER_PACKER_USER_ID_OBJ;
    protected static final int PACK_TYPE_ID_PBE_HYBRID_PRIVATE = 40;
    protected static final int PACK_TYPE_ID_PBE_HYBRID_PUBLIC = 41;
    protected static final int PACK_TYPE_ID_HYBRID_PRIVATE = 50;
    protected static final int PACK_TYPE_ID_HYBRID_PUBLIC = 51;
    protected static final int PACK_TYPE_ID_PBE = 60;
    private ConsoleLogger lg = ConsoleLogger.getInstance();
    private CryptProperties properties;

    public CipherPacker(CryptProperties properties) {
        this.properties = properties;
    }

    public void packCipher(OutputStream outputStream, Cipher cipher, Key key, boolean clear) throws GeneralSecurityException, IOException {
        if (clear && cipher.getAlgorithm().startsWith(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()))) {
            this.lg.print(7, "3DES-Schluessel - Klartext.");
            ObjectOutputStream o_os = new ObjectOutputStream(outputStream);
            o_os.writeInt(this.properties.getEncryptPackagingUserId());
            o_os.writeInt(0);
            byte[] key_array = key.getEncoded();
            int keyLength = key_array.length;
            o_os.writeInt(keyLength);
            o_os.write(key_array);
            byte[] iv_array = cipher.getIV();
            if (iv_array != null) {
                int ivLength = iv_array.length;
                o_os.writeInt(ivLength);
                o_os.write(iv_array);
            } else {
                o_os.writeInt(0);
            }
            o_os.flush();
        } else if (cipher.getAlgorithm().startsWith(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()))) {
            this.lg.print(7, "3DES-Schluessel - verschluesseln.");
            CryptKeyPair keyPair = null;
            Cipher rsaCipher = null;
            String keyRef = null;
            boolean rsaOk = true;
            try {
                keyPair = new CryptKeyPair(this.properties, null, true, false);
                rsaCipher = keyPair.publicCipher(true);
                keyRef = keyPair.getKeyRef();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                rsaOk = false;
            }
            if (rsaOk) {
                ObjectOutputStream o_os = new ObjectOutputStream(outputStream);
                o_os.writeInt(this.properties.getEncryptPackagingUserId());
                o_os.writeInt(1);
                byte[] enc_key_array = rsaCipher.doFinal(key.getEncoded());
                int keyLength = enc_key_array.length;
                o_os.writeInt(keyLength);
                o_os.write(enc_key_array);
                byte[] enc_iv_array = rsaCipher.doFinal(cipher.getIV());
                int ivLength = enc_iv_array.length;
                o_os.writeInt(ivLength);
                o_os.write(enc_iv_array);
                this.lg.print(5, "Schluesselreferenz: " + keyRef);
                o_os.writeUTF(keyRef);
                o_os.flush();
            } else {
                this.lg.print(0, "3DES-Schluessel im Klartext verpacken.");
                this.packCipher(outputStream, cipher, key, true);
            }
        } else if (this.properties.getAsymetricAlgorithm(this.properties.getEncryptPackagingUserId()).equals(cipher.getAlgorithm())) {
            this.lg.print(7, "RSA-Schluessel - Klartext.");
            this.packKey(outputStream, key);
        }
    }

    public void packCipher(OutputStream _os, Cipher cipher, Key key, boolean clear, boolean benutzePrivateKey, String _keyRef, boolean _useKennungPasswort, String _kennung, String _passwort) throws GeneralSecurityException, IOException {
        this.packCipher(_os, cipher, key, clear, benutzePrivateKey, _keyRef, _useKennungPasswort, _kennung, _passwort, true);
    }

    public void packCipherDesPw(OutputStream _os, Cipher cipher, Key key, String _kennung, String _passwort) throws GeneralSecurityException, IOException {
        if (_kennung == null || _passwort == null || _kennung.length() == 0 || _passwort.length() == 0) {
            System.err.println("CipherPacker: Beim Einpacken des sym. Schluessels soll eine Kennung und ein Passwort verwendet werden. Es wurde aber entweder keine Kennung oder kein Passwort uebergeben!");
            this.packCipher(_os, cipher, key, true);
        } else if (cipher.getAlgorithm().startsWith(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()))) {
            byte[] accountBytesIv = (_passwort + _kennung + "_sis_4456_wer_hae_fz4e589d").getBytes();
            byte[][] ivs_to_write = this.getAccountCryptedIv(cipher.getIV(), accountBytesIv);
            byte[] accountBytesKey = (_passwort + _kennung + "_sis_7634_wer_hae_9rf0eu5o").getBytes();
            byte[][] key_and_iv_to_write = this.getAccountCryptedIv(key.getEncoded(), accountBytesKey);
            if (ivs_to_write != null && key_and_iv_to_write != null) {
                ObjectOutputStream o_os = new ObjectOutputStream(_os);
                o_os.writeInt(this.properties.getEncryptPackagingUserId());
                o_os.writeInt(29);
                o_os.writeInt(key_and_iv_to_write[0].length);
                o_os.write(key_and_iv_to_write[0]);
                o_os.writeInt(key_and_iv_to_write[1].length);
                o_os.write(key_and_iv_to_write[1]);
                o_os.writeInt(ivs_to_write[0].length);
                o_os.write(ivs_to_write[0]);
                o_os.writeInt(ivs_to_write[1].length);
                o_os.write(ivs_to_write[1]);
                o_os.flush();
            } else {
                this.packCipher(_os, cipher, key, true);
            }
        } else {
            this.packCipher(_os, cipher, key, true);
        }
    }

    public void packCipher(OutputStream _os, Cipher cipher, Key key, boolean clear, boolean benutzePrivateKey, String _keyRef, boolean _useKennungPasswort, String _kennung, String _passwort, boolean _useKennungPasswortAsSymKey) throws GeneralSecurityException, IOException {
        if (_useKennungPasswort && (_kennung == null || _passwort == null || _kennung.length() == 0 || _passwort.length() == 0)) {
            throw new GeneralSecurityException("CipherPacker: Beim Einpacken des sym. Schluessels soll eine Kennung und ein Passwort verwendet werden. Es wurde aber entweder keine Kennung oder kein Passwort uebergeben!");
        }
        if (!clear && cipher.getAlgorithm().startsWith(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()))) {
            CryptKeyPair keyPair = null;
            Cipher rsaCipher = null;
            String keyRef = null;
            boolean rsaOk = true;
            try {
                keyPair = new CryptKeyPair(this.properties, _keyRef, !benutzePrivateKey, benutzePrivateKey);
                rsaCipher = benutzePrivateKey ? keyPair.privateCipher(true) : keyPair.publicCipher(true);
                keyRef = keyPair.getKeyRef();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                rsaOk = false;
            }
            if (rsaOk) {
                ObjectOutputStream o_os = new ObjectOutputStream(_os);
                o_os.writeInt(this.properties.getEncryptPackagingUserId());
                Object ivs_to_write = new byte[2][];
                int cryptKennung = 0;
                if (_useKennungPasswort) {
                    byte[][] ivs_to_write_SymKey;
                    byte[] accountBytes = (_passwort + _kennung + "_sis_2643_wer_hae_342yq32r").getBytes();
                    boolean doUserPasswordXOR = true;
                    if (_useKennungPasswortAsSymKey && (ivs_to_write_SymKey = this.getAccountCryptedIv(cipher.getIV(), accountBytes)) != null) {
                        ivs_to_write = ivs_to_write_SymKey;
                        doUserPasswordXOR = false;
                        cryptKennung = benutzePrivateKey ? 20 : 21;
                    }
                    if (doUserPasswordXOR) {
                        ivs_to_write[0] = this.getAccountEncodedIv(rsaCipher.doFinal(cipher.getIV()), accountBytes);
                        ivs_to_write[1] = null;
                        cryptKennung = benutzePrivateKey ? 10 : 11;
                    }
                } else {
                    ivs_to_write[0] = rsaCipher.doFinal(cipher.getIV());
                    ivs_to_write[1] = null;
                    cryptKennung = benutzePrivateKey ? 4 : 5;
                }
                o_os.writeInt(cryptKennung);
                byte[] enc_key_array = rsaCipher.doFinal(key.getEncoded());
                int keyLength = enc_key_array.length;
                o_os.writeInt(keyLength);
                o_os.write(enc_key_array);
                o_os.writeInt(ivs_to_write[0].length);
                o_os.write(ivs_to_write[0]);
                if (cryptKennung == 20 || cryptKennung == 21) {
                    o_os.writeInt(ivs_to_write[1].length);
                    o_os.write(ivs_to_write[1]);
                }
                o_os.writeUTF(keyRef);
                o_os.flush();
            } else {
                System.err.print("CipherPackerIntern Warnung: 3DES-Schluessel wird im Klartext verpackt. KeyRef: " + _keyRef);
                this.packCipher(_os, cipher, key, true);
            }
        } else {
            this.packCipher(_os, cipher, key, clear);
        }
    }

    public void packCipher(OutputStream _os, Cipher cipher, Key key, boolean clear, boolean benutzePrivateKey, String _keyRef, boolean _symSchluesselEinpacken, boolean _useKennungPassword, String _kennung, String _password) throws GeneralSecurityException, IOException {
        if (_symSchluesselEinpacken) {
            this.packCipher(_os, cipher, key, clear, benutzePrivateKey, _keyRef, _useKennungPassword, _kennung, _password);
        } else if (cipher.getAlgorithm().startsWith(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()))) {
            this.lg.print(7, "3DES-Schluesselerkennungszeichen.");
            ObjectOutputStream o_os = new ObjectOutputStream(_os);
            o_os.writeInt(this.properties.getEncryptPackagingUserId());
            o_os.writeInt(0);
            o_os.flush();
        }
    }

    public void packKey(OutputStream outputStream, Key key) throws GeneralSecurityException, IOException {
        ObjectOutputStream o_os = new ObjectOutputStream(outputStream);
        if (key instanceof PublicKey) {
            o_os.writeInt(this.properties.getEncryptPackagingUserId());
            o_os.writeInt(2);
        } else if (key instanceof PrivateKey) {
            o_os.writeInt(this.properties.getEncryptPackagingUserId());
            o_os.writeInt(3);
        } else {
            throw new GeneralSecurityException("CipherPacker: packKey packt nur RSA-Schluessel");
        }
        byte[] key_array = key.getEncoded();
        int keyLength = key_array.length;
        o_os.writeInt(keyLength);
        o_os.write(key_array);
        o_os.flush();
    }

    public static void packKey(OutputStream outputStream, byte[] key_array, boolean privateKey) throws IOException {
        ObjectOutputStream o_os = new ObjectOutputStream(outputStream);
        if (privateKey) {
            o_os.writeInt(402);
            o_os.writeInt(3);
        } else {
            o_os.writeInt(402);
            o_os.writeInt(2);
        }
        int keyLength = key_array.length;
        o_os.writeInt(keyLength);
        o_os.write(key_array);
        o_os.flush();
    }

    private byte[] getAccountEncodedIv(byte[] _encryptedIv, byte[] _accountBytes) {
        int index;
        byte[] result = new byte[_encryptedIv.length];
        for (index = 0; index < _encryptedIv.length && index < _accountBytes.length; ++index) {
            result[index] = (byte)(_encryptedIv[index] ^ _accountBytes[index]);
        }
        if (index < _encryptedIv.length) {
            for (int i = index; i < _encryptedIv.length; ++i) {
                result[i] = _encryptedIv[i];
            }
        }
        return result;
    }

    public byte[][] getAccountCryptedIv(byte[] _encryptedIv, byte[] _accountBytes) {
        Object result = null;
        try {
            Cipher symetric_cipher = Cipher.getInstance(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getSymetricOpMode(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getSymetricPadding(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            SecretKeySpec keySpec = new SecretKeySpec(_accountBytes, this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()));
            SecretKey triple_des_key = keyFactory.generateSecret(keySpec);
            SecureRandom secRand = this.properties.getSecureRandom();
            if (secRand != null) {
                symetric_cipher.init(1, (Key)triple_des_key, secRand);
            } else {
                symetric_cipher.init(1, triple_des_key);
            }
            result = new byte[2][];
            result[0] = symetric_cipher.doFinal(_encryptedIv);
            result[1] = symetric_cipher.getIV();
        }
        catch (Exception ex) {
            this.lg.print(1, "Account-Verschluesselung nicht moeglich: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public void packCipherHybrid(OutputStream out, Key symmetricKey, Cipher symmetricCipher, boolean usePrivateKey, String keyRef) throws IOException, GeneralSecurityException {
        int i;
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        if (symmetricKey == null) {
            throw new IllegalArgumentException("symmetricKey ist erforderlich.");
        }
        if (symmetricCipher == null) {
            throw new IllegalArgumentException("symmetricCipher ist erforderlich.");
        }
        CryptKeyPair keyPair = new CryptKeyPair(this.properties, keyRef, !usePrivateKey, usePrivateKey);
        if ((keyRef = keyPair.getKeyRef()) == null) {
            throw new IllegalStateException("keyRef == null");
        }
        Cipher hybridCipher = usePrivateKey ? keyPair.privateCipher(true) : keyPair.publicCipher(true);
        if (hybridCipher == null) {
            throw new IllegalStateException("hybridCipher == null");
        }
        ObjectOutputStream o_os = new ObjectOutputStream(out);
        o_os.writeInt(this.properties.getEncryptPackagingUserId());
        int algIndicator = usePrivateKey ? 50 : 51;
        o_os.writeInt(algIndicator);
        byte[] symmetricCipherIv = symmetricCipher.getIV();
        byte[] symmetricKeyBytes = symmetricKey.getEncoded();
        byte[] ivAndSymmetricKeyBytes = new byte[symmetricCipherIv.length + symmetricKeyBytes.length];
        int len = symmetricCipherIv.length;
        for (i = 0; i < len; ++i) {
            ivAndSymmetricKeyBytes[i] = symmetricCipherIv[i];
        }
        len = symmetricKeyBytes.length;
        for (i = 0; i < len; ++i) {
            ivAndSymmetricKeyBytes[i + symmetricCipherIv.length] = symmetricKeyBytes[i];
        }
        byte[] encryptedIvAndSymmetricKey = hybridCipher.doFinal(ivAndSymmetricKeyBytes);
        o_os.writeInt(symmetricCipherIv.length);
        o_os.writeInt(encryptedIvAndSymmetricKey.length);
        o_os.write(encryptedIvAndSymmetricKey);
        o_os.writeUTF(keyRef);
        o_os.flush();
    }

    public void packCipherPBEHybrid(OutputStream out, Cipher symmetricCipher, byte[] symmetricCipherIv, byte[] pbeSalt, boolean usePrivateKey, String keyRef) throws GeneralSecurityException, IOException {
        int i;
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        if (symmetricCipher == null) {
            throw new IllegalArgumentException("symmetricCipher ist erforderlich.");
        }
        if (symmetricCipherIv == null) {
            throw new IllegalArgumentException("symmetricCipherIv ist erforderlich.");
        }
        if (pbeSalt == null) {
            throw new IllegalArgumentException("pbeSalt ist erforderlich.");
        }
        CryptKeyPair keyPair = new CryptKeyPair(this.properties, keyRef, !usePrivateKey, usePrivateKey);
        if ((keyRef = keyPair.getKeyRef()) == null) {
            throw new IllegalStateException("keyRef == null");
        }
        Cipher hybridCipher = usePrivateKey ? keyPair.privateCipher(true) : keyPair.publicCipher(true);
        if (hybridCipher == null) {
            throw new IllegalStateException("hybridCipher == null");
        }
        ObjectOutputStream o_os = new ObjectOutputStream(out);
        o_os.writeInt(this.properties.getEncryptPackagingUserId());
        int algIndicator = usePrivateKey ? 40 : 41;
        o_os.writeInt(algIndicator);
        byte[] ivAndSalt = new byte[symmetricCipherIv.length + pbeSalt.length];
        int len = symmetricCipherIv.length;
        for (i = 0; i < len; ++i) {
            ivAndSalt[i] = symmetricCipherIv[i];
        }
        len = pbeSalt.length;
        for (i = 0; i < len; ++i) {
            ivAndSalt[i + symmetricCipherIv.length] = pbeSalt[i];
        }
        byte[] encryptedIvAndSalt = hybridCipher.doFinal(ivAndSalt);
        o_os.writeInt(symmetricCipherIv.length);
        o_os.writeInt(encryptedIvAndSalt.length);
        o_os.write(encryptedIvAndSalt);
        byte[] checkStrEncrypted = symmetricCipher.doFinal(PBE_HYBRID_CHECK_STR_BYTES);
        o_os.writeInt(checkStrEncrypted.length);
        o_os.write(checkStrEncrypted);
        o_os.writeUTF(keyRef);
        o_os.flush();
    }

    public void packCipherPBE(OutputStream out, Cipher symmetricCipher, byte[] symmetricCipherIv, byte[] pbeSalt) throws IOException, GeneralSecurityException {
        int i;
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        if (symmetricCipher == null) {
            throw new IllegalArgumentException("symmetricCipher ist erforderlich.");
        }
        if (symmetricCipherIv == null) {
            throw new IllegalArgumentException("symmetricCipherIv ist erforderlich.");
        }
        if (pbeSalt == null) {
            throw new IllegalArgumentException("pbeSalt ist erforderlich.");
        }
        ObjectOutputStream o_os = new ObjectOutputStream(out);
        o_os.writeInt(this.properties.getEncryptPackagingUserId());
        o_os.writeInt(60);
        byte[] ivAndSalt = new byte[symmetricCipherIv.length + pbeSalt.length];
        int len = symmetricCipherIv.length;
        for (i = 0; i < len; ++i) {
            ivAndSalt[i] = symmetricCipherIv[i];
        }
        len = pbeSalt.length;
        for (i = 0; i < len; ++i) {
            ivAndSalt[i + symmetricCipherIv.length] = pbeSalt[i];
        }
        o_os.writeInt(symmetricCipherIv.length);
        o_os.writeInt(ivAndSalt.length);
        o_os.write(ivAndSalt);
        byte[] checkStrEncrypted = symmetricCipher.doFinal(PBE_CHECK_STR_BYTES);
        o_os.writeInt(checkStrEncrypted.length);
        o_os.write(checkStrEncrypted);
        o_os.flush();
    }

    static {
        try {
            PBE_HYBRID_CHECK_STR_BYTES = "check".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        PBE_CHECK_STR_BYTES = PBE_HYBRID_CHECK_STR_BYTES;
        DEFAULT_CIPHER_PACKER_USER_ID_OBJ = new Integer(402);
    }
}

