/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.SimpleTypeParser;
import de.statspez.sdf.generator.parser.ValueSpaceParser;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SDFMerkmalParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private SimpleTypeParser simpleTypeParser;
    private ValueSpaceParser valueSpaceParser;
    private MetaCustomSDFMerkmal merkmal;

    public SDFMerkmalParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.simpleTypeParser = new SimpleTypeParser(this, resolver);
        this.parserChain.addParser((SubParser)this.simpleTypeParser);
        this.valueSpaceParser = new ValueSpaceParser(this, resolver);
        this.parserChain.addParser((SubParser)this.valueSpaceParser);
        this.merkmal = null;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Fuer das Merkmal ist kein Name definiert!");
            }
            this.merkmal.setName(SDFTags.dekodiereXMLName(name));
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("description".equalsIgnoreCase(localName)) {
            this.merkmal.setBeschreibung(ParserUtil.removeWhitespaces(chars));
        } else if ("annotation".equalsIgnoreCase(localName)) {
            this.merkmal.setKommentar(ParserUtil.removeWhitespaces(chars));
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("variable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.merkmal = new MetaCustomSDFMerkmal();
            this.simpleTypeParser.setMerkmal(this.merkmal);
            this.valueSpaceParser.setMerkmal(this.merkmal);
            this.enable();
        } else if ("description".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            try {
                this.merkmal.setSpecification(Helper.metaStructureFor((String)ParserUtil.createSpecification(this.merkmal)));
            }
            catch (Exception e) {
                throw new MetaParseException("SDF-Merkmal <" + this.merkmal.getName() + ">, Fehler in der Spezifikation.", e);
            }
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.merkmal;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser instanceof ValueSpaceParser) {
            this.merkmal.setReferringClassificationName(((ValueSpaceParser)aParser).getClassificationReferece());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

