/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.parser.IncludeMetadataGroupParser;
import de.statspez.sdf.generator.parser.IncludeMetadataItemParser;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetadataGroupParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private IncludeMetadataItemParser includeMetadataItemParser;
    private IncludeMetadataGroupParser includeMetadataGroupParser;
    private MetaSDFMetaMerkmalsgruppe merkmalsgruppe;

    public MetadataGroupParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.includeMetadataItemParser = new IncludeMetadataItemParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeMetadataItemParser);
        this.includeMetadataGroupParser = new IncludeMetadataGroupParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeMetadataGroupParser);
        this.merkmalsgruppe = null;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("metadataGroup".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Fuer die Meta-Merkmalsgruppe ist kein Name definiert!");
            }
            this.merkmalsgruppe.setName(SDFTags.dekodiereXMLName(name));
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("annotation".equalsIgnoreCase(localName)) {
            this.merkmalsgruppe.setKommentar(ParserUtil.removeWhitespaces(chars));
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("metadataGroup".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("metadataGroup".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.merkmalsgruppe = new MetaSDFMetaMerkmalsgruppe();
            this.enable();
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if ("description".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else {
                throw MetaParseException.unknownTagException((String)localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("metadataGroup".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !this.parserChain.endElement(namespaceURI, localName, qName)) {
            if ("description".equalsIgnoreCase(localName)) {
                this.merkmalsgruppe.setBeschreibung(this.superParser().charData().toString().trim());
            } else {
                throw MetaParseException.unknownClosingTagException((String)localName);
            }
        }
    }

    public MetaElementInterface object() {
        return this.merkmalsgruppe;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        this.merkmalsgruppe.addToSDFMetaFeldReferenzen((MetaSDFMetaFeldReferenz)aParser.object());
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

