/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAufruf;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.parser.LocalReference;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InvokeParser
extends SubParser {
    private MetaCustomSDFTemplateAufruf aufruf = null;
    private MetaSDFDokumenterzeuger dokumenterzeuger = null;

    public InvokeParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public void setDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
        this.dokumenterzeuger = dokumenterzeuger;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) {
        if ("invoke".equalsIgnoreCase(localName)) {
            String[] structuresArray;
            String forEach;
            String template = atts.getValue("template");
            if (template != null) {
                template = SDFTags.dekodiereXMLName(template);
                this.aufruf.setTemplateId(template);
                this.resolver().registerForResolve((Reference)new LocalReference(this.aufruf, "TEMPLATE_BY_ID", template, this.dokumenterzeuger));
            }
            String structures = null;
            String forAttr = atts.getValue("for");
            if (forAttr != null) {
                structures = SDFTags.dekodiereXMLName(forAttr);
                this.aufruf.setIteration(false);
            }
            if ((forEach = atts.getValue("for-each")) != null) {
                structures = SDFTags.dekodiereXMLName(forEach);
                this.aufruf.setIteration(true);
            }
            if (structures != null && (structuresArray = ParserUtil.getSpaceSeparatedTokens(structures)) != null) {
                this.aufruf.setTemplateStrukturen(structuresArray);
                if (template == null) {
                    int i = 0;
                    while (i < structuresArray.length) {
                        this.resolver().registerForResolve((Reference)new LocalReference(this.aufruf, "TEMPLATE_BY_STRUCTURE", structuresArray[i], this.dokumenterzeuger));
                        ++i;
                    }
                }
            }
            this.aufruf.setVorbedingung(TypesParser.parseApplyType(atts.getValue("apply-type")));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("invoke".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"invoke".equalsIgnoreCase(localName)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        this.aufruf = new MetaCustomSDFTemplateAufruf();
        this.enable();
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!"invoke".equalsIgnoreCase(localName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
        this.disableAndNotify();
    }

    public MetaElementInterface object() {
        return this.aufruf;
    }
}

