/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.dto;

import org.saiku.olap.dto.AbstractSaikuObject;

public class SaikuCube
extends AbstractSaikuObject {
    private String connectionName;
    private String catalogName;
    private String schemaName;
    private String caption;
    private boolean visible;

    public SaikuCube() {
    }

    public SaikuCube(String connectionName, String uniqueCubeName, String name, String caption, String catalog, String schema) {
        this(connectionName, uniqueCubeName, name, caption, catalog, schema, true);
    }

    public SaikuCube(String connectionName, String uniqueCubeName, String name, String caption, String catalog, String schema, boolean visible) {
        super(uniqueCubeName, name);
        this.connectionName = connectionName;
        this.catalogName = catalog;
        this.schemaName = schema;
        this.caption = caption;
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getUniqueName() {
        String uniqueName = "[" + this.connectionName + "].[" + this.catalogName + "]";
        uniqueName = uniqueName + ".[" + this.schemaName + "].[" + this.getName() + "]";
        return uniqueName;
    }

    public String getCubeName() {
        String name = super.getUniqueName();
        if (name != null && !name.startsWith("[")) {
            name = "[" + name + "]";
        }
        return name;
    }

    public String getName() {
        return super.getName();
    }

    public String getCaption() {
        return this.caption;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

