/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.interpreter.ErrorStatementException;
import de.statspez.pleditor.generator.interpreter.GenericFieldDescriptor;
import de.statspez.pleditor.generator.interpreter.IdentifierResolver;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ValueResolver;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatement;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.runtime.BooleanValue;
import de.statspez.pleditor.generator.runtime.BreakStatementException;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.FunctionLib;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.ReturnStatementException;
import de.statspez.pleditor.generator.runtime.SupportLib;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.ExtendedSatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class ProgramInterpreter
extends AbstractElementVisitor {
    private InterpreterContext context = null;
    private ValueResolver valueResolver = null;
    private IdentifierResolver identifierResolver = null;

    public Value executeInnerProgram(MetaProgram program, InterpreterContext currentContext) {
        this.init(currentContext);
        return this.execute(program);
    }

    public Value execute(MetaProgram program, InterpreterContext currentContext) {
        this.init(currentContext);
        this.context.enterProgram(null, null);
        Value returnValue = this.execute(program);
        this.context.leaveScope();
        return returnValue;
    }

    public Value execute(ProgramDescriptor programDescriptor, FeldDeskriptorImpl structure, InterpreterContext currentContext) {
        Value returnValue;
        this.init(currentContext);
        this.context.enterProgram(structure, programDescriptor);
        try {
            returnValue = this.execute(programDescriptor.getProgram());
        }
        catch (ErrorStatementException e) {
            this.context.notePlausiError(e.getErrorNumber(), null);
            returnValue = BooleanValue.TRUE;
        }
        this.context.leaveScope();
        return returnValue;
    }

    protected Value execute(MetaFunctionCall functionCall, InterpreterContext currentContext) {
        this.init(currentContext);
        this.identifierResolver.resolve(functionCall.function(), true);
        String name = this.identifierResolver.getName();
        FeldDeskriptorImpl structure = this.identifierResolver.getFieldDescriptor();
        try {
            Value returnValue;
            int i;
            ProgramDescriptor programDescriptor = this.context.getProgramFactory().getFunction(name, structure);
            if (programDescriptor == null) {
                throw new RuntimeException("Die Funktion " + name + " ist in diesem Kontext nicht definiert.");
            }
            int numOfParameters = 0;
            if (programDescriptor.getParameters() != null) {
                numOfParameters = programDescriptor.getParameters().length;
            }
            if (numOfParameters != functionCall.numberOfParameters()) {
                throw new RuntimeException("Die Anzahl der Parameter beim Aufruf der Funktion " + name + " stimmt nicht mit der definierten Anzahl der Parameter \u00fcberein.");
            }
            this.context = currentContext;
            this.valueResolver = new ValueResolver(currentContext);
            this.identifierResolver = new IdentifierResolver(currentContext);
            Value[] values = null;
            if (functionCall.numberOfParameters() > 0) {
                values = new Value[functionCall.numberOfParameters()];
                i = 0;
                while (i < functionCall.numberOfParameters()) {
                    values[i] = this.valueResolver.resolve(functionCall.parameterAt(i));
                    ++i;
                }
            }
            this.context.enterProgram(structure, programDescriptor);
            if (functionCall.numberOfParameters() > 0) {
                i = 0;
                while (i < functionCall.numberOfParameters()) {
                    this.context.setVariableValue(programDescriptor.getParameters()[i], values[i]);
                    ++i;
                }
            }
            try {
                returnValue = this.execute(programDescriptor.getProgram());
            }
            finally {
                this.context.leaveScope();
            }
            return returnValue;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected void execute(MetaAblaufStatement ablaufStatement, InterpreterContext currentContext) {
        this.init(currentContext);
        this.identifierResolver.resolve(ablaufStatement.function(), true);
        String name = this.identifierResolver.getName();
        FeldDeskriptorImpl structure = this.identifierResolver.getFieldDescriptor();
        try {
            int i;
            ProgramDescriptor programDescriptor = this.context.getProgramFactory().getFlow(name, structure);
            if (programDescriptor == null) {
                throw new RuntimeException("Der Ablauf " + name + " ist in diesem Kontext nicht definiert.");
            }
            int numOfParameters = 0;
            if (programDescriptor.getParameters() != null) {
                numOfParameters = programDescriptor.getParameters().length;
            }
            if (numOfParameters != ablaufStatement.numberOfParameters()) {
                throw new RuntimeException("Die Anzahl der Parameter beim Aufruf des Ablaufs " + name + " stimmt nicht mit der Anzahl der Initialisierungswerte \u00fcberein.");
            }
            this.context = currentContext;
            this.valueResolver = new ValueResolver(currentContext);
            this.identifierResolver = new IdentifierResolver(currentContext);
            Value[] values = null;
            if (ablaufStatement.numberOfParameters() > 0) {
                values = new Value[ablaufStatement.numberOfParameters()];
                i = 0;
                while (i < ablaufStatement.numberOfParameters()) {
                    values[i] = this.valueResolver.resolve(ablaufStatement.parameterAt(i));
                    ++i;
                }
            }
            this.context.enterProgram(structure, programDescriptor);
            if (ablaufStatement.numberOfParameters() > 0) {
                i = 0;
                while (i < ablaufStatement.numberOfParameters()) {
                    FeldDeskriptorImpl fieldDescriptor = this.context.getFieldDescriptorFactory().getFieldDecriptor(programDescriptor.getParameters()[i], null, this.context.getCurrentStructure());
                    fieldDescriptor.setValueWith(this.context.getSatz(), values[i]);
                    ++i;
                }
            }
            try {
                this.execute(programDescriptor.getProgram());
            }
            finally {
                this.context.leaveScope();
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected Value execute(MetaCheckFeldStatement checkFeldStatement, InterpreterContext currentContext) {
        this.init(currentContext);
        this.identifierResolver.resolve(checkFeldStatement.field(), false);
        FeldDeskriptorImpl field = this.identifierResolver.getFieldDescriptor();
        int[] dimension = ((FeldDeskriptorExt)field.getFeldDeskriptor()).getDimension();
        int[] indices = this.identifierResolver.getIndices();
        ArrayList<MetaValueAccess> fields = new ArrayList<MetaValueAccess>();
        if (dimension == null || dimension.length == 0 || indices != null && indices.length == dimension.length) {
            fields.add(checkFeldStatement.field());
        } else {
            this.resolveFieldsForCheck(fields, checkFeldStatement, dimension, indices);
        }
        ValueResolver checkFieldValueResolver = new ValueResolver(currentContext, this.context.getPlausiKontext().getMerkmalsPruefungWertAbfrageStrategie() == 2);
        ArrayList<Value> values = new ArrayList<Value>(fields.size());
        int i = 0;
        while (i < fields.size()) {
            values.add(checkFieldValueResolver.resolve((MetaElement)fields.get(i)));
            ++i;
        }
        String name = this.identifierResolver.getName();
        FeldDeskriptorImpl structure = (FeldDeskriptorImpl)field.getVorgaenger();
        try {
            ProgramDescriptor programDescriptor = this.context.getProgramFactory().getFieldCheck(name, structure);
            if (programDescriptor == null) {
                throw new RuntimeException("Das Feld " + name + " ist in diesem Kontext nicht definiert.");
            }
            this.context = currentContext;
            this.valueResolver = new ValueResolver(currentContext);
            this.identifierResolver = new IdentifierResolver(currentContext);
            this.context.enterProgram(structure, programDescriptor);
            Value returnValue = NilValue.instance();
            int i2 = 0;
            while (i2 < values.size()) {
                this.context.setVariableValue("feld", (Value)values.get(i2));
                try {
                    this.execute(programDescriptor.getProgram());
                    returnValue = BooleanValue.FALSE;
                }
                catch (ErrorStatementException e) {
                    this.context.notePlausiError(field, e.getErrorNumber(), null);
                    returnValue = BooleanValue.TRUE;
                }
                catch (Throwable e) {
                    this.context.notePlausiError(field, 0, e);
                    returnValue = BooleanValue.TRUE;
                }
                ++i2;
            }
            this.context.leaveScope();
            return returnValue;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected Value execute(MetaPruefeStatement pruefeStatement, InterpreterContext currentContext) {
        this.init(currentContext);
        this.identifierResolver.resolve(pruefeStatement.function(), true);
        String name = this.identifierResolver.getName();
        FeldDeskriptorImpl structure = this.identifierResolver.getFieldDescriptor();
        try {
            BooleanValue returnValue;
            ProgramDescriptor programDescriptor = this.context.getProgramFactory().getCheck(name, structure);
            if (programDescriptor == null) {
                throw new RuntimeException("Die Pr\u00fcfung " + name + " ist in diesem Kontext nicht definiert.");
            }
            this.context = currentContext;
            this.valueResolver = new ValueResolver(currentContext);
            this.identifierResolver = new IdentifierResolver(currentContext);
            this.context.enterProgram(structure, programDescriptor);
            try {
                this.execute(programDescriptor.getProgram());
                returnValue = BooleanValue.FALSE;
            }
            catch (ErrorStatementException e) {
                this.context.notePlausiError(e.getErrorNumber(), null);
                returnValue = BooleanValue.TRUE;
            }
            catch (Throwable e) {
                this.context.notePlausiError(0, e);
                returnValue = BooleanValue.TRUE;
            }
            this.context.leaveScope();
            return returnValue;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(InterpreterContext currentContext) {
        this.context = currentContext;
        this.valueResolver = new ValueResolver(currentContext);
        this.identifierResolver = new IdentifierResolver(currentContext);
    }

    private Value execute(MetaProgram program) {
        Value returnValue;
        if (program.containsHierarchicalFunction()) {
            program = CodegenUtil.convertProgramWithHierarchicalCode(program);
        }
        try {
            program.accept(this);
            returnValue = NilValue.instance();
        }
        catch (ReturnStatementException e) {
            returnValue = e.getReturnValue();
        }
        return returnValue;
    }

    private MetaValueAccess createValueAccessWithIndices(MetaValueAccess valueAccess, Vector indices) {
        MetaValueAccess valueAccessWithIndices;
        if (indices != null && !indices.isEmpty()) {
            MetaArrayAccess adaptedField;
            MetaValueAccess field;
            MetaValueAccess structure;
            if (valueAccess instanceof MetaStructureAccess) {
                MetaStructureAccess structureAccess = (MetaStructureAccess)valueAccess;
                structure = structureAccess.structureAccess();
                field = structureAccess.selectedElement();
            } else {
                structure = null;
                field = valueAccess;
            }
            if (field instanceof MetaFieldAccess) {
                MetaFieldAccess fieldAccess = (MetaFieldAccess)field;
                adaptedField = new MetaArrayAccess(fieldAccess.accessedField(), indices);
            } else {
                MetaArrayAccess arrayAccess = (MetaArrayAccess)field;
                adaptedField = new MetaArrayAccess(arrayAccess.accessedArray(), indices);
            }
            valueAccessWithIndices = structure != null ? new MetaStructureAccess(structure, adaptedField) : adaptedField;
        } else {
            valueAccessWithIndices = valueAccess;
        }
        return valueAccessWithIndices;
    }

    private int resolveSizeOf(MetaValueAccess field, Vector indices) {
        MetaSizeOfOperator sizeOf = new MetaSizeOfOperator(new MetaFactor(this.createValueAccessWithIndices(field, indices)));
        NumberValue resolve = (NumberValue)this.valueResolver.resolve(sizeOf);
        return new Long(resolve.asLong()).intValue();
    }

    private void resolveFieldsForCheck(List fields, MetaCheckFeldStatement checkFeldStatement, int[] dimensions, int[] indices) {
        int size;
        int numOfDimension = 0;
        if (indices != null) {
            numOfDimension = indices.length;
        }
        if ((size = dimensions[numOfDimension]) < 0) {
            Vector<MetaFactor> currentIndicesVector = new Vector<MetaFactor>();
            if (indices != null) {
                int i = 0;
                while (i < indices.length) {
                    currentIndicesVector.add(new MetaFactor(new MetaNumber(String.valueOf(indices[i]))));
                    ++i;
                }
            }
            size = this.resolveSizeOf(checkFeldStatement.field(), currentIndicesVector);
        }
        int i = 0;
        while (i < size) {
            int[] currentIndices = new int[numOfDimension + 1];
            if (numOfDimension > 0) {
                int j = 0;
                while (j < indices.length) {
                    currentIndices[j] = indices[j];
                    ++j;
                }
            }
            currentIndices[currentIndices.length - 1] = i;
            if (currentIndices.length == dimensions.length) {
                Vector<MetaFactor> currentIndicesVector = new Vector<MetaFactor>();
                currentIndicesVector.add(new MetaFactor(new MetaNumber("" + (i + 1))));
                fields.add(this.createValueAccessWithIndices(checkFeldStatement.field(), currentIndicesVector));
            } else {
                this.resolveFieldsForCheck(fields, checkFeldStatement, dimensions, currentIndices);
            }
            ++i;
        }
    }

    @Override
    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    @Override
    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator iter = aSequence.statements();
        while (iter != null && iter.hasNext()) {
            MetaStatement statement = (MetaStatement)iter.next();
            this.context.setCurrentLine(statement.startLine());
            statement.accept(this);
        }
    }

    @Override
    public void visitErrorStatement(MetaErrorStatement aStatement) {
        throw new ErrorStatementException(aStatement.errorNumber());
    }

    @Override
    public void visitReturnStatement(MetaReturnStatement aStatement) {
        throw new ReturnStatementException(this.valueResolver.resolve(aStatement.returnValue()));
    }

    @Override
    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator iter = aDeclaration.identifiers();
        while (iter != null && iter.hasNext()) {
            MetaIdentifier variable = (MetaIdentifier)iter.next();
            this.context.declareVariable(variable.value());
        }
    }

    @Override
    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.identifierResolver.resolve(anAssignment.leftValue());
        Value value = this.valueResolver.resolve(anAssignment.rightValue());
        if (this.identifierResolver.isVariable()) {
            this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), value);
        } else {
            this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), value);
        }
    }

    @Override
    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        PlausiRuntimeIterator valueIter = SupportLib.iteratorFor(this.valueResolver.resolve(anAssignment.rightValue()), this.context);
        Iterator varIter = anAssignment.leftValues();
        while (varIter != null && varIter.hasNext()) {
            this.identifierResolver.resolve((MetaElement)varIter.next());
            if (valueIter == null || !valueIter.hasNext()) continue;
            Value value = (Value)valueIter.next();
            if (this.identifierResolver.isVariable()) {
                this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), value);
                continue;
            }
            this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), value);
        }
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        if (this.valueResolver.resolve(aStatement.condition()).asBoolean()) {
            if (aStatement.ifTrue() != null) {
                this.context.enterBlock();
                try {
                    aStatement.ifTrue().accept(this);
                }
                finally {
                    this.context.leaveScope();
                }
            }
        } else if (aStatement.ifFalse() != null) {
            this.context.enterBlock();
            try {
                aStatement.ifFalse().accept(this);
            }
            finally {
                this.context.leaveScope();
            }
        }
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        FeldDeskriptorImpl fieldDescriptor;
        int[] indices;
        String name;
        this.identifierResolver.resolve(aStatement.startAssignment().leftValue());
        boolean variable = this.identifierResolver.isVariable();
        if (variable) {
            name = this.identifierResolver.getName();
            indices = this.identifierResolver.getIndices();
            fieldDescriptor = null;
        } else {
            name = null;
            indices = null;
            fieldDescriptor = this.identifierResolver.getFieldDescriptor();
        }
        long step = 1L;
        if (aStatement.stepExpression() != null) {
            step = this.valueResolver.resolve(aStatement.stepExpression()).asLong();
        }
        aStatement.startAssignment().accept(this);
        try {
            while (!this.valueResolver.resolve(aStatement.endCondition()).asBoolean()) {
                if (aStatement.loopBody() != null) {
                    this.context.enterBlock();
                    try {
                        aStatement.loopBody().accept(this);
                    }
                    finally {
                        this.context.leaveScope();
                    }
                }
                if (variable) {
                    this.context.incrementVariableValue(name, indices, step);
                    continue;
                }
                Value value = fieldDescriptor.getValueFrom(this.context.getSatz());
                fieldDescriptor.setValueWith(this.context.getSatz(), this.context.valueFactory().valueFor(value.asDouble() + (double)step));
            }
        }
        catch (BreakStatementException breakStatementException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.context.enterBlock();
        try {
            Iterator iter = aStatement.variables();
            while (iter != null && iter.hasNext()) {
                MetaIdentifier variable = (MetaIdentifier)iter.next();
                try {
                    this.identifierResolver.resolve(new MetaFieldAccess(variable));
                }
                catch (Exception e) {
                    this.context.declareVariable(variable.value());
                }
            }
            PlausiRuntimeIterator values = SupportLib.iteratorFor(this.valueResolver.resolve(aStatement.value()), this.context);
            try {
                block18: {
                    block17: {
                        if (!true) break block17;
                        if (values == null) return;
                        if (!values.hasNext()) break block18;
                    }
                    do {
                        iter = aStatement.variables();
                        while (iter != null && iter.hasNext()) {
                            Value value = (Value)values.next();
                            MetaIdentifier variable = (MetaIdentifier)iter.next();
                            this.identifierResolver.resolve(new MetaFieldAccess(variable));
                            if (this.identifierResolver.isVariable()) {
                                this.context.setVariableValue(variable.value(), value);
                                continue;
                            }
                            this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), value);
                        }
                        if (aStatement.loopBody() != null) {
                            this.context.enterBlock();
                            try {
                                aStatement.loopBody().accept(this);
                            }
                            finally {
                                this.context.leaveScope();
                            }
                        }
                        if (values == null) return;
                    } while (values.hasNext());
                }
                return;
            }
            catch (BreakStatementException breakStatementException) {
                return;
            }
        }
        finally {
            this.context.leaveScope();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        try {
            while (true) {
                if (!this.valueResolver.resolve(aStatement.condition()).asBoolean()) {
                    return;
                }
                if (aStatement.loopBody() == null) continue;
                this.context.enterBlock();
                aStatement.loopBody().accept(this);
                continue;
                break;
            }
            finally {
                this.context.leaveScope();
            }
        }
        catch (BreakStatementException breakStatementException) {
            // empty catch block
        }
    }

    @Override
    public void visitBreakStatement(MetaBreakStatement aStatement) {
        throw new BreakStatementException();
    }

    @Override
    public void visitFunctionCall(MetaFunctionCall aStatement) {
        this.valueResolver.resolve(aStatement);
    }

    @Override
    public void visitPrintStatement(MetaPrintStatement aStatement) {
        if (aStatement.leftValue() != null) {
            this.identifierResolver.resolve(aStatement.leftValue());
            Iterator iter = aStatement.toPrint();
            while (iter != null && iter.hasNext()) {
                Value oldValue;
                if (this.identifierResolver.isVariable()) {
                    oldValue = this.context.getVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices());
                    this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), FunctionLib.KONKATENIEREN(this.context, oldValue, this.valueResolver.resolve((MetaElement)iter.next())));
                    continue;
                }
                oldValue = this.identifierResolver.getFieldDescriptor().getValueFrom(this.context.getSatz());
                this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), FunctionLib.KONKATENIEREN(this.context, oldValue, this.valueResolver.resolve((MetaElement)iter.next())));
            }
        } else {
            Iterator iter = aStatement.toPrint();
            while (iter != null && iter.hasNext()) {
                this.context.getConsole().print(this.valueResolver.resolve((MetaElement)iter.next()));
            }
            this.context.getConsole().println();
        }
    }

    @Override
    public void visitAblaufStatement(MetaAblaufStatement statement) {
        new ProgramInterpreter().execute(statement, this.context);
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement statement) {
        this.valueResolver.resolve(statement);
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement statement) {
        this.valueResolver.resolve(statement);
    }

    @Override
    public void visitSetStatement(MetaSetStatement aSetStatemnt) {
        block13: {
            this.identifierResolver.resolve(aSetStatemnt.getFactor());
            if (this.identifierResolver.isVariable()) {
                throw new RuntimeException();
            }
            try {
                int numOfIndices;
                SatzInterface satz = this.context.getSatz();
                FeldDeskriptorImpl fieldDescriptor = this.identifierResolver.getFieldDescriptor();
                Stack<FeldDeskriptorInterface> hierachy = new Stack<FeldDeskriptorInterface>();
                FeldDeskriptorInterface current = fieldDescriptor.getVorgaenger();
                while (current != null) {
                    hierachy.push(current);
                    current = current.getVorgaenger();
                }
                SatzInterface subSatz = satz;
                while (!hierachy.empty()) {
                    current = (FeldDeskriptorInterface)hierachy.pop();
                    subSatz = subSatz.getSubSatz(current);
                }
                if (subSatz instanceof ExtendedSatzInterface) {
                    if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
                        ((ExtendedSatzInterface)subSatz).appendSatz(fieldDescriptor);
                    } else if (aSetStatemnt.getType() == MetaSetStatement.DELETE) {
                        ((ExtendedSatzInterface)subSatz).removeSatz(fieldDescriptor);
                    }
                    break block13;
                }
                int[] indices = fieldDescriptor.getIndizes();
                int n = numOfIndices = indices != null ? indices.length : 0;
                if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
                    int[] newIndices = new int[numOfIndices + 1];
                    int lastIndex = 0;
                    if (numOfIndices > 0) {
                        System.arraycopy(indices, 0, newIndices, 0, numOfIndices);
                        lastIndex = numOfIndices - 1;
                    }
                    newIndices[lastIndex] = subSatz.getLaenge(fieldDescriptor, indices);
                    GenericFieldDescriptor newDescriptor = new GenericFieldDescriptor(fieldDescriptor.getFeldDeskriptor(), newIndices, (FeldDeskriptorImpl)fieldDescriptor.getVorgaenger());
                    subSatz.getSubSatz(newDescriptor);
                    break block13;
                }
                if (aSetStatemnt.getType() != MetaSetStatement.DELETE) break block13;
                if (numOfIndices > 0) {
                    subSatz.setLeerWert(fieldDescriptor);
                    break block13;
                }
                throw new RuntimeException("Kein Index vorhanden.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

