/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.PruefungIterator;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import java.io.Writer;
import java.util.HashSet;

public class PlausiFehlerFactoryGenerator
extends JavaCodeGenerator {
    private static final String FEHLER_FACTORY_METHOD = "createPlausiFehler";
    private static final String KEY_VAR = "key";
    private CodegenContext context;
    private int numOfErrors;
    private String currentFilename;
    private Writer currentWriter;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.numOfErrors = 0;
        this.currentFilename = null;
        this.currentWriter = null;
        this.defineMethod("protected", "PlausiFehler", FEHLER_FACTORY_METHOD, "String key");
        PruefungIterator pruefungIt = new PruefungIterator(this.context.getPlausi());
        pruefungIt.eachPruefung(new PruefungIterator.CodeBlock(){
            private HashSet definedKeys = new HashSet();

            @Override
            public void doForPruefung(MetaCustomPruefung pruefung, MetaCustomThemenbereich tb) {
                PlausiFehlerFactoryGenerator.this.generateForPruefung(pruefung, tb, this.definedKeys);
            }
        });
        this.setErrorContext(this.context.getMessageContext());
        this.visitElements(this.context.getPlausi().getMerkmale());
        this.indentNewLine();
        this.out.print("throw new IllegalArgumentException(\"Ungueltiger ");
        this.out.print("Pruefschluessel \" + ");
        this.out.print(KEY_VAR);
        this.out.print(");");
        this.closeCurrentSegment();
    }

    private void startNewSegmentIfNecessary() {
        if (this.numOfErrors >= this.context.getMaxElementsInSegment(3)) {
            this.numOfErrors = 1;
            String className = this.context.getNextPlausiSegmentClassName();
            this.currentFilename = String.valueOf(className) + ".java";
            this.indentNewLine();
            this.out.print("return ");
            this.out.print(className);
            this.out.print(".");
            this.out.print(FEHLER_FACTORY_METHOD);
            this.out.print("(");
            this.out.print(KEY_VAR);
            this.out.print(");");
            this.closeCurrentSegment();
            this.currentWriter = this.context.createWriter(this.currentFilename);
            this.setOutput(this.currentWriter);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
            this.out.print("PlausiFehler");
            this.out.print(";");
            this.indentNewLine();
            this.defineClass(className, "public", null);
            this.defineMethod("public static", "PlausiFehler", FEHLER_FACTORY_METHOD, "String key");
        } else {
            ++this.numOfErrors;
        }
    }

    private void closeCurrentSegment() {
        if (this.withinSegment()) {
            this.endMethodDefinition();
            this.endClassDefinition();
            this.context.destroyWriter(this.currentFilename, this.currentWriter);
        } else {
            this.endMethodDefinition();
        }
    }

    private boolean withinSegment() {
        return this.currentFilename != null && this.currentWriter != null;
    }

    private void generateForPruefung(MetaCustomPruefung pruefung, MetaCustomThemenbereich tb, HashSet definedKeys) {
        this.startNewSegmentIfNecessary();
        this.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
        if (definedKeys.contains(pruefung.getPruefschluessel())) {
            this.error(pruefung, "Der Pruefschluessel " + pruefung.getPruefschluessel() + " wird in dieser Plausibilisierung bereits" + " verwendet");
        } else {
            definedKeys.add(pruefung.getPruefschluessel());
        }
        this.indentNewLine();
        this.out.print("if (\"");
        this.out.print(pruefung.getPruefschluessel());
        this.out.print("\".equals(");
        this.out.print(KEY_VAR);
        this.out.print("))");
        this.openBlock();
        this.createPlausiFehlerErzeugung(pruefung.getPruefschluessel(), this.context.getTextResource().getFehlertextKurz(pruefung), this.context.getTextResource().getFehlertextLang(pruefung), this.context.getTextResource().getKorrekturhinweis(pruefung), pruefung.getThemenbereich().getName(), pruefung.getFehlergewicht(), pruefung.getPruefungsart(), pruefung.hauptbezugsfeldIndex(), (short)0, null, 0L, null, null);
        this.indentNewLine();
        this.out.print("return fehler;");
        this.closeBlock();
    }

    private void createPlausiFehlerErzeugung(String schluessel, String fehlerKurz, String kommentar, String korrekturhinweis, String referenzTB, short gewicht, short art, int[] referenzFeldIndizes, short merkmalstyp, String maske, long wertlaenge, String wertebereich, String merkmalsbezeichnung) {
        this.indentNewLine();
        this.out.print("PlausiFehler");
        this.out.print(" fehler = new ");
        this.out.print("PlausiFehler");
        this.out.print("();");
        this.indentNewLine();
        this.out.print("fehler.setFehlerSchluessel(\"");
        this.out.print(schluessel);
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlertextKurz(\"");
        this.out.print(StringHelper.getEscapedStringValue(fehlerKurz));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlertextLang(\"");
        this.out.print(StringHelper.getEscapedStringValue(kommentar));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlerKorrekturhinweis(\"");
        this.out.print(StringHelper.getEscapedStringValue(korrekturhinweis));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlerGewicht(");
        this.out.print(gewicht);
        this.out.print(");");
        this.indentNewLine();
        this.out.print("fehler.setReferenzTB(\"");
        this.out.print(referenzTB);
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlerArt(");
        this.out.print(art);
        this.out.print(");");
        if (referenzFeldIndizes != null && referenzFeldIndizes.length > 0) {
            this.out.print("fehler.setReferenzFeldIndizes(new int[]{");
            int i = 0;
            while (i < referenzFeldIndizes.length) {
                int index;
                if (i > 0) {
                    this.out.print(",");
                }
                if ((index = referenzFeldIndizes[i]) > 0) {
                    --index;
                }
                this.out.print(index);
                ++i;
            }
            this.out.print("});");
        }
        if (merkmalstyp > 0) {
            this.indentNewLine();
            this.out.print("fehler.setMerkmalstyp(");
            this.out.print(Settings.rtTypForILTypeConstant(merkmalstyp));
            this.out.print(");");
        }
        if (maske != null && maske.length() > 0) {
            this.indentNewLine();
            this.out.print("fehler.setMaske(\"");
            this.out.print(StringHelper.getEscapedStringValue(maske));
            this.out.print("\");");
        }
        if (wertlaenge > 0L) {
            this.indentNewLine();
            this.out.print("fehler.setWertlaenge(");
            this.out.print(wertlaenge);
            this.out.print(");");
        }
        if (wertebereich != null && wertebereich.length() > 0) {
            this.indentNewLine();
            this.out.print("fehler.setWertebereich(\"");
            this.out.print(StringHelper.getEscapedStringValue(wertebereich));
            this.out.print("\");");
        }
        if (merkmalsbezeichnung != null && merkmalsbezeichnung.length() > 0) {
            this.indentNewLine();
            this.out.print("fehler.setMerkmalsbezeichnung(\"");
            this.out.print(StringHelper.getEscapedStringValue(merkmalsbezeichnung));
            this.out.print("\");");
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal anObject) {
        this.startNewSegmentIfNecessary();
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
        this.indentNewLine();
        this.out.print("if (\"");
        this.out.print(merkmal.getName());
        this.out.print("\".equals(");
        this.out.print(KEY_VAR);
        this.out.print("))");
        this.openBlock();
        this.createPlausiFehlerErzeugung(merkmal.getName(), this.context.getTextResource().getFehlertextKurz(merkmal), this.context.getTextResource().getFehlertextLang(merkmal), this.context.getTextResource().getKorrekturhinweis(merkmal), "Merkmalpruefung", (short)9, (short)1, null, merkmal.getTyp(), merkmal.getMaske(), merkmal.getLaenge(), CodegenUtil.getValueSpaceAsString(merkmal), CodegenUtil.getDisplayName(this.context.getTextResource(), merkmal));
        this.indentNewLine();
        this.out.print("return fehler;");
        this.closeBlock();
    }
}

