/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Calendar;
import mondrian.util.DateSchedule;
import mondrian.util.ScheduleUtil;

class MonthlyByWeekDateSchedule
implements DateSchedule {
    int period;
    int beginMonth;
    int daysOfWeekBitmap;
    int weeksOfMonthBitmap;

    MonthlyByWeekDateSchedule(Calendar begin, int period, int daysOfWeekBitmap, int weeksOfMonthBitmap) {
        this.period = period;
        ScheduleUtil.assertTrue(period > 0, "period must be positive");
        this.beginMonth = begin == null ? 0 : MonthlyByWeekDateSchedule.monthOrdinal(begin);
        this.daysOfWeekBitmap = daysOfWeekBitmap;
        ScheduleUtil.assertTrue((daysOfWeekBitmap & 0xFE) != 0, "weekly schedule must have at least one day set");
        ScheduleUtil.assertTrue((daysOfWeekBitmap & 0xFE) == daysOfWeekBitmap, "weekly schedule has bad bits set: " + daysOfWeekBitmap);
        this.weeksOfMonthBitmap = weeksOfMonthBitmap;
        ScheduleUtil.assertTrue((weeksOfMonthBitmap & 0x3F) != 0, "weeks of month schedule must have at least one week set");
        ScheduleUtil.assertTrue((weeksOfMonthBitmap & 0x3F) == weeksOfMonthBitmap, "week of month schedule has bad bits set: " + weeksOfMonthBitmap);
    }

    @Override
    public Calendar nextOccurrence(Calendar earliest, boolean strict) {
        earliest = (Calendar)earliest.clone();
        if (strict) {
            earliest.add(5, 1);
        }
        int i = 365 + this.period;
        while (i-- > 0) {
            int month = MonthlyByWeekDateSchedule.monthOrdinal(earliest);
            if ((month - this.beginMonth) % this.period != 0) {
                earliest.set(5, 1);
                earliest.add(2, 1);
                continue;
            }
            int dayOfWeek = earliest.get(7);
            if ((this.daysOfWeekBitmap & 1 << dayOfWeek) != 0) {
                int dayOfMonth = earliest.get(5);
                int weekOfMonth = (dayOfMonth + 6) / 7;
                if ((this.weeksOfMonthBitmap & 1 << weekOfMonth) != 0) {
                    return earliest;
                }
                if ((this.weeksOfMonthBitmap & 1) != 0) {
                    earliest.add(4, 1);
                    boolean isLast = earliest.get(5) <= 7;
                    earliest.add(4, -1);
                    if (isLast) {
                        return earliest;
                    }
                }
            }
            earliest.add(5, 1);
        }
        throw ScheduleUtil.newInternal("monthy-by-week date schedule is cyclic");
    }

    private static int monthOrdinal(Calendar earliest) {
        return earliest.get(1) * 12 + earliest.get(2);
    }
}

