/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class HiveDialect
extends JdbcDialectImpl {
    private static final int MAX_COLUMN_NAME_LENGTH = 128;
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(HiveDialect.class, Dialect.DatabaseProduct.HIVE){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return super.acceptsConnection(connection) && !JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.IMPALA, connection);
        }
    };

    public HiveDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        return null;
    }

    @Override
    protected Set<List<Integer>> deduceSupportedResultSetStyles(DatabaseMetaData databaseMetaData) {
        return Collections.emptySet();
    }

    @Override
    protected boolean deduceReadOnly(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.isReadOnly();
        }
        catch (SQLException e) {
            return true;
        }
    }

    @Override
    protected int deduceMaxColumnNameLength(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            return 128;
        }
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return true;
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return true;
    }

    @Override
    public boolean allowsOrderByAlias() {
        return true;
    }

    @Override
    public boolean requiresGroupByAlias() {
        return false;
    }

    @Override
    public boolean requiresUnionOrderByExprToBeInSelectClause() {
        return false;
    }

    @Override
    public boolean requiresUnionOrderByOrdinal() {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return "select * from (" + this.generateInlineGeneric(columnNames, columnTypes, valueList, " from dual", false) + ") x limit " + valueList.size();
    }

    @Override
    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        Util.singleQuoteString(value, buf);
    }

    @Override
    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (collateNullsLast) {
            if (ascending) {
                return "ISNULL(" + expr + ") ASC, " + expr + " ASC";
            }
            return expr + " DESC";
        }
        if (ascending) {
            return expr + " ASC";
        }
        return "ISNULL(" + expr + ") DESC, " + expr + " DESC";
    }

    @Override
    public boolean allowsAs() {
        return false;
    }

    @Override
    public boolean allowsJoinOn() {
        return false;
    }
}

