/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.recorder.MessageRecorder;
import mondrian.rolap.aggmatcher.Recognizer;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMElementParser;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XMLAttrVector;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;

public class DefaultDef {
    public static String[] _elements = new String[]{"AggRules", "Base", "CaseMatcher", "NameMatcher", "FactCountMatch", "ForeignKeyMatch", "TableMatch", "Mapper", "Regex", "RegexMapper", "Ref", "LevelMapRef", "MeasureMapRef", "IgnoreMapRef", "FactCountMatchRef", "ForeignKeyMatchRef", "TableMatchRef", "LevelMap", "MeasureMap", "IgnoreMap", "AggRule"};

    public static Class getXMLDefClass() {
        return DefaultDef.class;
    }

    public static class AggRule
    extends Base {
        public String tag;
        public String countColumn;
        public IgnoreMap ignoreMap;
        public IgnoreMapRef ignoreMapRef;
        public FactCountMatch factCountMatch;
        public FactCountMatchRef factCountMatchRef;
        public ForeignKeyMatch foreignKeyMatch;
        public ForeignKeyMatchRef foreignKeyMatchRef;
        public TableMatch tableMatch;
        public TableMatchRef tableMatchRef;
        public LevelMap levelMap;
        public LevelMapRef levelMapRef;
        public MeasureMap measureMap;
        public MeasureMapRef measureMapRef;

        public AggRule() {
        }

        public AggRule(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.tag = (String)_parser.getAttribute("tag", "String", null, null, true);
                this.countColumn = (String)_parser.getAttribute("countColumn", "String", "fact_count", null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                this.ignoreMap = (IgnoreMap)_parser.getElement(IgnoreMap.class, false);
                this.ignoreMapRef = (IgnoreMapRef)_parser.getElement(IgnoreMapRef.class, false);
                this.factCountMatch = (FactCountMatch)_parser.getElement(FactCountMatch.class, false);
                this.factCountMatchRef = (FactCountMatchRef)_parser.getElement(FactCountMatchRef.class, false);
                this.foreignKeyMatch = (ForeignKeyMatch)_parser.getElement(ForeignKeyMatch.class, false);
                this.foreignKeyMatchRef = (ForeignKeyMatchRef)_parser.getElement(ForeignKeyMatchRef.class, false);
                this.tableMatch = (TableMatch)_parser.getElement(TableMatch.class, false);
                this.tableMatchRef = (TableMatchRef)_parser.getElement(TableMatchRef.class, false);
                this.levelMap = (LevelMap)_parser.getElement(LevelMap.class, false);
                this.levelMapRef = (LevelMapRef)_parser.getElement(LevelMapRef.class, false);
                this.measureMap = (MeasureMap)_parser.getElement(MeasureMap.class, false);
                this.measureMapRef = (MeasureMapRef)_parser.getElement(MeasureMapRef.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "AggRule";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggRule.displayAttribute((PrintWriter)_out, (String)"tag", (Object)this.tag, (int)(_indent + 1));
            AggRule.displayAttribute((PrintWriter)_out, (String)"countColumn", (Object)this.countColumn, (int)(_indent + 1));
            AggRule.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"ignoreMap", (ElementDef)this.ignoreMap, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"ignoreMapRef", (ElementDef)this.ignoreMapRef, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"factCountMatch", (ElementDef)this.factCountMatch, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"factCountMatchRef", (ElementDef)this.factCountMatchRef, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"foreignKeyMatch", (ElementDef)this.foreignKeyMatch, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"foreignKeyMatchRef", (ElementDef)this.foreignKeyMatchRef, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"tableMatch", (ElementDef)this.tableMatch, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"tableMatchRef", (ElementDef)this.tableMatchRef, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"levelMap", (ElementDef)this.levelMap, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"levelMapRef", (ElementDef)this.levelMapRef, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"measureMap", (ElementDef)this.measureMap, (int)(_indent + 1));
            AggRule.displayElement((PrintWriter)_out, (String)"measureMapRef", (ElementDef)this.measureMapRef, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggRule", new XMLAttrVector().add("tag", (Object)this.tag).add("countColumn", (Object)this.countColumn).add("enabled", (Object)this.enabled));
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.ignoreMap);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.ignoreMapRef);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.factCountMatch);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.factCountMatchRef);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.foreignKeyMatch);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.foreignKeyMatchRef);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.tableMatch);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.tableMatchRef);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.levelMap);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.levelMapRef);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.measureMap);
            AggRule.displayXMLElement((XMLOutput)_out, (ElementDef)this.measureMapRef);
            _out.endTag("AggRule");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggRule _cother = (AggRule)_other;
            boolean _diff = AggRule.displayAttributeDiff((String)"tag", (Object)this.tag, (Object)_cother.tag, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayAttributeDiff((String)"countColumn", (Object)this.countColumn, (Object)_cother.countColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"ignoreMap", (NodeDef)this.ignoreMap, (NodeDef)_cother.ignoreMap, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"ignoreMapRef", (NodeDef)this.ignoreMapRef, (NodeDef)_cother.ignoreMapRef, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"factCountMatch", (NodeDef)this.factCountMatch, (NodeDef)_cother.factCountMatch, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"factCountMatchRef", (NodeDef)this.factCountMatchRef, (NodeDef)_cother.factCountMatchRef, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"foreignKeyMatch", (NodeDef)this.foreignKeyMatch, (NodeDef)_cother.foreignKeyMatch, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"foreignKeyMatchRef", (NodeDef)this.foreignKeyMatchRef, (NodeDef)_cother.foreignKeyMatchRef, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"tableMatch", (NodeDef)this.tableMatch, (NodeDef)_cother.tableMatch, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"tableMatchRef", (NodeDef)this.tableMatchRef, (NodeDef)_cother.tableMatchRef, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"levelMap", (NodeDef)this.levelMap, (NodeDef)_cother.levelMap, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"levelMapRef", (NodeDef)this.levelMapRef, (NodeDef)_cother.levelMapRef, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"measureMap", (NodeDef)this.measureMap, (NodeDef)_cother.measureMap, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRule.displayElementDiff((String)"measureMapRef", (NodeDef)this.measureMapRef, (NodeDef)_cother.measureMapRef, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        private boolean isOk(Base base) {
            return base != null && base.isEnabled();
        }

        private boolean isRef(AggRules rules, MessageRecorder msgRecorder, Base base, Base baseRef, String baseName) {
            if (!this.isOk(base)) {
                if (this.isOk(baseRef)) {
                    baseRef.validate(rules, msgRecorder);
                    return true;
                }
                String msg = "Neither base " + baseName + " or baseref " + baseName + "Ref is ok";
                msgRecorder.reportError(msg);
                return false;
            }
            if (this.isOk(baseRef)) {
                String msg = "Both base " + base.getName() + " and baseref " + baseRef.getName() + " are ok";
                msgRecorder.reportError(msg);
                return false;
            }
            base.validate(rules, msgRecorder);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (this.ignoreMap != null) {
                    this.ignoreMap.validate(rules, msgRecorder);
                } else if (this.ignoreMapRef != null) {
                    this.ignoreMapRef.validate(rules, msgRecorder);
                    this.ignoreMap = rules.lookupIgnoreMap(this.ignoreMapRef.getRefId());
                }
                if (this.isRef(rules, msgRecorder, this.factCountMatch, this.factCountMatchRef, "FactCountMatch")) {
                    this.factCountMatch = rules.lookupFactCountMatch(this.factCountMatchRef.getRefId());
                }
                if (this.isRef(rules, msgRecorder, this.foreignKeyMatch, this.foreignKeyMatchRef, "ForeignKeyMatch")) {
                    this.foreignKeyMatch = rules.lookupForeignKeyMatch(this.foreignKeyMatchRef.getRefId());
                }
                if (this.isRef(rules, msgRecorder, this.tableMatch, this.tableMatchRef, "TableMatch")) {
                    this.tableMatch = rules.lookupTableMatch(this.tableMatchRef.getRefId());
                }
                if (this.isRef(rules, msgRecorder, this.levelMap, this.levelMapRef, "LevelMap")) {
                    this.levelMap = rules.lookupLevelMap(this.levelMapRef.getRefId());
                }
                if (this.isRef(rules, msgRecorder, this.measureMap, this.measureMapRef, "MeasureMap")) {
                    this.measureMap = rules.lookupMeasureMap(this.measureMapRef.getRefId());
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public String getCountColumn() {
            return this.countColumn;
        }

        public FactCountMatch getFactCountMatch() {
            return this.factCountMatch;
        }

        public ForeignKeyMatch getForeignKeyMatch() {
            return this.foreignKeyMatch;
        }

        public TableMatch getTableMatch() {
            return this.tableMatch;
        }

        public LevelMap getLevelMap() {
            return this.levelMap;
        }

        public MeasureMap getMeasureMap() {
            return this.measureMap;
        }

        public IgnoreMap getIgnoreMap() {
            return this.ignoreMap;
        }
    }

    public static class IgnoreMap
    extends RegexMapper {
        private static final String[] TEMPLATE_NAMES = new String[0];

        public IgnoreMap() {
        }

        public IgnoreMap(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                NodeDef[] _tempArray = _parser.getArray(Regex.class, 0, 0);
                this.regexs = new Regex[_tempArray.length];
                for (int _i = 0; _i < this.regexs.length; ++_i) {
                    this.regexs[_i] = (Regex)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "IgnoreMap";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            IgnoreMap.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            IgnoreMap.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            IgnoreMap.displayElementArray((PrintWriter)_out, (String)"regexs", (NodeDef[])this.regexs, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("IgnoreMap", new XMLAttrVector().add("id", (Object)this.id).add("enabled", (Object)this.enabled));
            IgnoreMap.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.regexs);
            _out.endTag("IgnoreMap");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            IgnoreMap _cother = (IgnoreMap)_other;
            boolean _diff = IgnoreMap.displayElementArrayDiff((String)"regexs", (NodeDef[])this.regexs, (NodeDef[])_cother.regexs, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        protected String[] getTemplateNames() {
            return TEMPLATE_NAMES;
        }

        protected Recognizer.Matcher getMatcher() {
            return this.getMatcher(new String[0]);
        }
    }

    public static class MeasureMap
    extends RegexMapper {
        private static final String[] TEMPLATE_NAMES = new String[]{"measure_name", "measure_column_name", "aggregate_name"};

        public MeasureMap() {
        }

        public MeasureMap(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                NodeDef[] _tempArray = _parser.getArray(Regex.class, 0, 0);
                this.regexs = new Regex[_tempArray.length];
                for (int _i = 0; _i < this.regexs.length; ++_i) {
                    this.regexs[_i] = (Regex)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "MeasureMap";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureMap.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            MeasureMap.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            MeasureMap.displayElementArray((PrintWriter)_out, (String)"regexs", (NodeDef[])this.regexs, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureMap", new XMLAttrVector().add("id", (Object)this.id).add("enabled", (Object)this.enabled));
            MeasureMap.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.regexs);
            _out.endTag("MeasureMap");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureMap _cother = (MeasureMap)_other;
            boolean _diff = MeasureMap.displayElementArrayDiff((String)"regexs", (NodeDef[])this.regexs, (NodeDef[])_cother.regexs, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        protected String[] getTemplateNames() {
            return TEMPLATE_NAMES;
        }

        protected Recognizer.Matcher getMatcher(String measureName, String measuerColumnName, String aggregateName) {
            return this.getMatcher(new String[]{measureName, measuerColumnName, aggregateName});
        }
    }

    public static class LevelMap
    extends RegexMapper {
        private static final String[] TEMPLATE_NAMES = new String[]{"usage_prefix", "hierarchy_name", "level_name", "level_column_name"};

        public LevelMap() {
        }

        public LevelMap(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                NodeDef[] _tempArray = _parser.getArray(Regex.class, 0, 0);
                this.regexs = new Regex[_tempArray.length];
                for (int _i = 0; _i < this.regexs.length; ++_i) {
                    this.regexs[_i] = (Regex)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "LevelMap";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            LevelMap.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            LevelMap.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            LevelMap.displayElementArray((PrintWriter)_out, (String)"regexs", (NodeDef[])this.regexs, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("LevelMap", new XMLAttrVector().add("id", (Object)this.id).add("enabled", (Object)this.enabled));
            LevelMap.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.regexs);
            _out.endTag("LevelMap");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            LevelMap _cother = (LevelMap)_other;
            boolean _diff = LevelMap.displayElementArrayDiff((String)"regexs", (NodeDef[])this.regexs, (NodeDef[])_cother.regexs, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        protected String[] getTemplateNames() {
            return TEMPLATE_NAMES;
        }

        protected Recognizer.Matcher getMatcher(String usagePrefix, String hierarchyName, String levelName, String levelColumnName) {
            return this.getMatcher(new String[]{usagePrefix, hierarchyName, levelName, levelColumnName});
        }
    }

    public static class TableMatchRef
    extends Ref {
        public TableMatchRef() {
        }

        public TableMatchRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "TableMatchRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            TableMatchRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            TableMatchRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("TableMatchRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("TableMatchRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            TableMatchRef _cother = (TableMatchRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasTableMatch(this.getRefId())) {
                    String msg = "No TableMatch has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static class ForeignKeyMatchRef
    extends Ref {
        public ForeignKeyMatchRef() {
        }

        public ForeignKeyMatchRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "ForeignKeyMatchRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ForeignKeyMatchRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            ForeignKeyMatchRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ForeignKeyMatchRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("ForeignKeyMatchRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ForeignKeyMatchRef _cother = (ForeignKeyMatchRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasForeignKeyMatch(this.getRefId())) {
                    String msg = "No ForeignKeyMatch has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static class FactCountMatchRef
    extends Ref {
        public FactCountMatchRef() {
        }

        public FactCountMatchRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "FactCountMatchRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            FactCountMatchRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            FactCountMatchRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("FactCountMatchRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("FactCountMatchRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            FactCountMatchRef _cother = (FactCountMatchRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasFactCountMatch(this.getRefId())) {
                    String msg = "No FactCountMatch has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static class IgnoreMapRef
    extends Ref {
        public IgnoreMapRef() {
        }

        public IgnoreMapRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "IgnoreMapRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            IgnoreMapRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            IgnoreMapRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("IgnoreMapRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("IgnoreMapRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            IgnoreMapRef _cother = (IgnoreMapRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasIgnoreMap(this.getRefId())) {
                    String msg = "No IgnoreMap has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static class MeasureMapRef
    extends Ref {
        public MeasureMapRef() {
        }

        public MeasureMapRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "MeasureMapRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureMapRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            MeasureMapRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureMapRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("MeasureMapRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureMapRef _cother = (MeasureMapRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasMeasureMap(this.getRefId())) {
                    String msg = "No MeasureMap has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static class LevelMapRef
    extends Ref {
        public LevelMapRef() {
        }

        public LevelMapRef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "LevelMapRef";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            LevelMapRef.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            LevelMapRef.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("LevelMapRef", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("LevelMapRef");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            LevelMapRef _cother = (LevelMapRef)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (!rules.hasLevelMap(this.getRefId())) {
                    String msg = "No LevelMap has id equal to refid \"" + this.getRefId() + "\"";
                    msgRecorder.reportError(msg);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }
    }

    public static abstract class Ref
    extends Base {
        public String refId;

        public Ref() {
        }

        public Ref(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.refId = (String)_parser.getAttribute("refId", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Ref";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Ref.displayAttribute((PrintWriter)_out, (String)"refId", (Object)this.refId, (int)(_indent + 1));
            Ref.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Ref", new XMLAttrVector().add("refId", (Object)this.refId).add("enabled", (Object)this.enabled));
            _out.endTag("Ref");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Ref _cother = (Ref)_other;
            boolean _diff = Ref.displayAttributeDiff((String)"refId", (Object)this.refId, (Object)_cother.refId, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        protected String getTag() {
            return this.getRefId();
        }

        public String getRefId() {
            return this.refId;
        }
    }

    public static abstract class RegexMapper
    extends Base {
        public String id;
        public Regex[] regexs;

        public RegexMapper() {
        }

        public RegexMapper(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                NodeDef[] _tempArray = _parser.getArray(Regex.class, 0, 0);
                this.regexs = new Regex[_tempArray.length];
                for (int _i = 0; _i < this.regexs.length; ++_i) {
                    this.regexs[_i] = (Regex)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "RegexMapper";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            RegexMapper.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            RegexMapper.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            RegexMapper.displayElementArray((PrintWriter)_out, (String)"regexs", (NodeDef[])this.regexs, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("RegexMapper", new XMLAttrVector().add("id", (Object)this.id).add("enabled", (Object)this.enabled));
            RegexMapper.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.regexs);
            _out.endTag("RegexMapper");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            RegexMapper _cother = (RegexMapper)_other;
            boolean _diff = RegexMapper.displayAttributeDiff((String)"id", (Object)this.id, (Object)_cother.id, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && RegexMapper.displayElementArrayDiff((String)"regexs", (NodeDef[])this.regexs, (NodeDef[])_cother.regexs, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        protected String getTag() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                String[] templateNames = this.getTemplateNames();
                for (int i = 0; i < this.regexs.length; ++i) {
                    Regex regex = this.regexs[i];
                    regex.validate(rules, templateNames, msgRecorder);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        protected abstract String[] getTemplateNames();

        protected Recognizer.Matcher getMatcher(String[] names) {
            final Pattern[] patterns = new Pattern[this.regexs.length];
            for (int i = 0; i < this.regexs.length; ++i) {
                Regex regex = this.regexs[i];
                patterns[i] = regex.getPattern(names);
            }
            return new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    for (int i = 0; i < patterns.length; ++i) {
                        Pattern pattern = patterns[i];
                        if (pattern == null || !pattern.matcher(name).matches()) continue;
                        if (AggRules.getLogger().isDebugEnabled()) {
                            this.debug(name, pattern);
                        }
                        return true;
                    }
                    return false;
                }

                private void debug(String name, Pattern p) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append("DefaultDef.RegexMapper");
                    bf.append(".Matcher.matches:");
                    bf.append(" name \"");
                    bf.append(name);
                    bf.append("\" matches regex \"");
                    bf.append(p.pattern());
                    bf.append("\"");
                    if ((p.flags() & 2) != 0) {
                        bf.append(" case_insensitive");
                    }
                    String msg = bf.toString();
                    AggRules.getLogger().debug((Object)msg);
                }
            };
        }
    }

    public static class Regex
    extends CaseMatcher {
        public String space;
        public String dot;
        public String cdata;
        protected static final int BAD_ID = -1;
        protected String[] templateParts;
        protected int[] templateNamePos;
        private static final int MAX_SIZE = 50;

        public Regex() {
        }

        public Regex(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.space = (String)_parser.getAttribute("space", "String", "_", null, false);
                this.dot = (String)_parser.getAttribute("dot", "String", "_", null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Regex";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Regex.displayAttribute((PrintWriter)_out, (String)"space", (Object)this.space, (int)(_indent + 1));
            Regex.displayAttribute((PrintWriter)_out, (String)"dot", (Object)this.dot, (int)(_indent + 1));
            Regex.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            Regex.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            Regex.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            Regex.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Regex", new XMLAttrVector().add("space", (Object)this.space).add("dot", (Object)this.dot).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.cdata(this.cdata);
            _out.endTag("Regex");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Regex _cother = (Regex)_other;
            boolean _diff = Regex.displayAttributeDiff((String)"space", (Object)this.space, (Object)_cother.space, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Regex.displayAttributeDiff((String)"dot", (Object)this.dot, (Object)_cother.dot, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Regex.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getSpace() {
            return this.space;
        }

        public String getDot() {
            return this.dot;
        }

        public String getTemplate() {
            return this.cdata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(AggRules rules, String[] templateNames, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                super.validate(rules, msgRecorder);
                String[] ss = new String[51];
                int[] poss = new int[50];
                String template = this.getTemplate();
                int end = 0;
                int previousEnd = 0;
                int start = template.indexOf("${", end);
                if (templateNames.length == 0) {
                    if (start == -1) {
                        this.templateParts = new String[1];
                        this.templateParts[0] = template;
                        this.templateNamePos = new int[0];
                    } else {
                        String msg = "Bad template \"" + template + "\", no ${} entries but there are " + "template names";
                        msgRecorder.reportError(msg);
                    }
                    return;
                }
                for (int count = 0; count < 50; ++count) {
                    String msg;
                    if (start == -1) {
                        if (count == 0) {
                            msg = "Bad template \"" + template + "\", no ${} entries";
                            msgRecorder.reportError(msg);
                            return;
                        }
                        this.templateNamePos = new int[count];
                        System.arraycopy(poss, 0, this.templateNamePos, 0, count);
                        ss[count++] = template.substring(end, template.length());
                        this.templateParts = new String[count];
                        System.arraycopy(ss, 0, this.templateParts, 0, count);
                        return;
                    }
                    previousEnd = end;
                    end = template.indexOf(125, start);
                    if (end == -1) {
                        msg = "Bad template \"" + template + "\", it had a \"${\", but no '}'";
                        msgRecorder.reportError(msg);
                        return;
                    }
                    String name = template.substring(start + 2, end);
                    int pos = this.convertNameToID(name, templateNames, msgRecorder);
                    if (pos == -1) {
                        return;
                    }
                    poss[count] = pos;
                    ss[count] = template.substring(previousEnd, start);
                    start = template.indexOf("${", end);
                    ++end;
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        private int convertNameToID(String name, String[] templateNames, MessageRecorder msgRecorder) {
            if (name == null) {
                String msg = "Template name is null";
                msgRecorder.reportError(msg);
                return -1;
            }
            for (int i = 0; i < templateNames.length; ++i) {
                if (!templateNames[i].equals(name)) continue;
                return i;
            }
            String msg = "Bad template name \"" + name + "\"";
            msgRecorder.reportError(msg);
            return -1;
        }

        public String getRegex(String[] names) {
            String space = this.getSpace();
            String dot = this.getDot();
            StringBuilder buf = new StringBuilder();
            buf.append(this.templateParts[0]);
            for (int i = 0; i < this.templateNamePos.length; ++i) {
                String n = names[this.templateNamePos[i]];
                if (n == null) {
                    return null;
                }
                if (space != null) {
                    n = n.replaceAll(" ", space);
                }
                if (dot != null) {
                    n = n.replaceAll("\\.", dot);
                }
                buf.append(n);
                buf.append(this.templateParts[i + 1]);
            }
            String regex = buf.toString();
            if (AggRules.getLogger().isDebugEnabled()) {
                StringBuilder bf = new StringBuilder(64);
                bf.append(this.getName());
                bf.append(".getRegex:");
                bf.append(" for names ");
                for (int i = 0; i < names.length; ++i) {
                    bf.append('\"');
                    bf.append(names[i]);
                    bf.append('\"');
                    if (i + 1 >= names.length) continue;
                    bf.append(", ");
                }
                bf.append(" regex is \"");
                bf.append(regex);
                bf.append('\"');
                String msg = bf.toString();
                AggRules.getLogger().debug((Object)msg);
            }
            return regex;
        }

        protected Pattern getPattern(String[] names) {
            String charcase = this.getCharCase();
            if (charcase.equals("ignore")) {
                String regex = this.getRegex(names);
                if (regex == null) {
                    return null;
                }
                Pattern pattern = Pattern.compile(regex, 2);
                return pattern;
            }
            if (charcase.equals("exact")) {
                String regex = this.getRegex(names);
                if (regex == null) {
                    return null;
                }
                Pattern pattern = Pattern.compile(regex);
                return pattern;
            }
            if (charcase.equals("upper")) {
                String[] ucNames = new String[names.length];
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    ucNames[i] = name == null ? null : name.toUpperCase();
                }
                String regex = this.getRegex(ucNames);
                if (regex == null) {
                    return null;
                }
                Pattern pattern = Pattern.compile(regex);
                return pattern;
            }
            String[] lcNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                lcNames[i] = name == null ? null : name.toLowerCase();
            }
            String regex = this.getRegex(lcNames);
            if (regex == null) {
                return null;
            }
            Pattern pattern = Pattern.compile(regex);
            return pattern;
        }
    }

    public static abstract class Mapper
    extends CaseMatcher {
        public String template;
        public String space;
        public String dot;
        protected static final int BAD_ID = -1;
        protected String[] templateParts;
        protected int[] templateNamePos;
        private static final int MAX_SIZE = 50;

        public Mapper() {
        }

        public Mapper(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.template = (String)_parser.getAttribute("template", "String", null, null, true);
                this.space = (String)_parser.getAttribute("space", "String", "_", null, false);
                this.dot = (String)_parser.getAttribute("dot", "String", "_", null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Mapper";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Mapper.displayAttribute((PrintWriter)_out, (String)"template", (Object)this.template, (int)(_indent + 1));
            Mapper.displayAttribute((PrintWriter)_out, (String)"space", (Object)this.space, (int)(_indent + 1));
            Mapper.displayAttribute((PrintWriter)_out, (String)"dot", (Object)this.dot, (int)(_indent + 1));
            Mapper.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            Mapper.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            Mapper.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Mapper", new XMLAttrVector().add("template", (Object)this.template).add("space", (Object)this.space).add("dot", (Object)this.dot).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("Mapper");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Mapper _cother = (Mapper)_other;
            boolean _diff = Mapper.displayAttributeDiff((String)"template", (Object)this.template, (Object)_cother.template, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Mapper.displayAttributeDiff((String)"space", (Object)this.space, (Object)_cother.space, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Mapper.displayAttributeDiff((String)"dot", (Object)this.dot, (Object)_cother.dot, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getSpace() {
            return this.space;
        }

        public String getDot() {
            return this.dot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                super.validate(rules, msgRecorder);
                String[] ss = new String[51];
                int[] poss = new int[50];
                String template = this.getTemplate();
                int end = 0;
                int previousEnd = 0;
                int start = template.indexOf("${", end);
                for (int count = 0; count < 50; ++count) {
                    String msg;
                    if (start == -1) {
                        if (count == 0) {
                            msg = "Bad template \"" + template + "\", no ${} entries";
                            msgRecorder.reportError(msg);
                            return;
                        }
                        this.templateNamePos = new int[count];
                        System.arraycopy(poss, 0, this.templateNamePos, 0, count);
                        ss[count++] = template.substring(end, template.length());
                        this.templateParts = new String[count];
                        System.arraycopy(ss, 0, this.templateParts, 0, count);
                        return;
                    }
                    previousEnd = end;
                    end = template.indexOf(125, start);
                    if (end == -1) {
                        msg = "Bad template \"" + template + "\", it had a \"${\", but no '}'";
                        msgRecorder.reportError(msg);
                        return;
                    }
                    String name = template.substring(start + 2, end);
                    int pos = this.convertNameToID(name, msgRecorder);
                    if (pos == -1) {
                        return;
                    }
                    poss[count] = pos;
                    ss[count] = template.substring(previousEnd, start);
                    start = template.indexOf("${", end);
                    ++end;
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        protected abstract String[] getTemplateNames();

        private int convertNameToID(String name, MessageRecorder msgRecorder) {
            if (name == null) {
                String msg = "Template name is null";
                msgRecorder.reportError(msg);
                return -1;
            }
            String[] names = this.getTemplateNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(name)) continue;
                return i;
            }
            String msg = "Bad template name \"" + name + "\"";
            msgRecorder.reportError(msg);
            return -1;
        }

        public String getRegex(String[] names) {
            String space = this.getSpace();
            String dot = this.getDot();
            StringBuilder buf = new StringBuilder();
            buf.append(this.templateParts[0]);
            for (int i = 0; i < this.templateNamePos.length; ++i) {
                String n = names[this.templateNamePos[i]];
                if (space != null) {
                    n = n.replaceAll(" ", space);
                }
                if (dot != null) {
                    n = n.replaceAll("\\.", dot);
                }
                buf.append(n);
                buf.append(this.templateParts[i + 1]);
            }
            String regex = buf.toString();
            if (AggRules.getLogger().isDebugEnabled()) {
                StringBuilder bf = new StringBuilder(64);
                bf.append(this.getName());
                bf.append(".getRegex:");
                bf.append(" for names ");
                for (int i = 0; i < names.length; ++i) {
                    bf.append('\"');
                    bf.append(names[i]);
                    bf.append('\"');
                    if (i + 1 >= names.length) continue;
                    bf.append(", ");
                }
                bf.append(" regex is \"");
                bf.append(regex);
                bf.append('\"');
                String msg = bf.toString();
                AggRules.getLogger().debug((Object)msg);
            }
            return regex;
        }

        protected Recognizer.Matcher getMatcher(String[] names) {
            String regex;
            String charcase = this.getCharCase();
            int flag = 0;
            if (charcase.equals("ignore")) {
                regex = this.getRegex(names);
                flag = 2;
            } else if (charcase.equals("exact")) {
                regex = this.getRegex(names);
            } else if (charcase.equals("upper")) {
                String[] ucNames = new String[names.length];
                for (int i = 0; i < names.length; ++i) {
                    ucNames[i] = names[i].toUpperCase();
                }
                regex = this.getRegex(ucNames);
            } else {
                String[] lcNames = new String[names.length];
                for (int i = 0; i < names.length; ++i) {
                    lcNames[i] = names[i].toLowerCase();
                }
                regex = this.getRegex(lcNames);
            }
            final Pattern pattern = Pattern.compile(regex, flag);
            return new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    boolean b = pattern.matcher(name).matches();
                    if (AggRules.getLogger().isDebugEnabled()) {
                        this.debug(name);
                    }
                    return b;
                }

                private void debug(String name) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append(Mapper.this.getName());
                    bf.append(".Matcher.matches:");
                    bf.append(" name \"");
                    bf.append(name);
                    bf.append("\" pattern \"");
                    bf.append(pattern.pattern());
                    bf.append("\"");
                    if ((pattern.flags() & 2) != 0) {
                        bf.append(" case_insensitive");
                    }
                    String msg = bf.toString();
                    AggRules.getLogger().debug((Object)msg);
                }
            };
        }
    }

    public static class TableMatch
    extends NameMatcher {
        public TableMatch() {
        }

        public TableMatch(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
                this.posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
                this.basename = (String)_parser.getAttribute("basename", "String", null, null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "TableMatch";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            TableMatch.displayAttribute((PrintWriter)_out, (String)"pretemplate", (Object)this.pretemplate, (int)(_indent + 1));
            TableMatch.displayAttribute((PrintWriter)_out, (String)"posttemplate", (Object)this.posttemplate, (int)(_indent + 1));
            TableMatch.displayAttribute((PrintWriter)_out, (String)"basename", (Object)this.basename, (int)(_indent + 1));
            TableMatch.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            TableMatch.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            TableMatch.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("TableMatch", new XMLAttrVector().add("pretemplate", (Object)this.pretemplate).add("posttemplate", (Object)this.posttemplate).add("basename", (Object)this.basename).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("TableMatch");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            TableMatch _cother = (TableMatch)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                if (this.pretemplate == null && this.posttemplate == null) {
                    String msg = "Must have at least one template non-null";
                    msgRecorder.reportError(msg);
                }
                super.validate(rules, msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public Recognizer.Matcher getMatcher(String name) {
            return super.getMatcher(name);
        }
    }

    public static class ForeignKeyMatch
    extends NameMatcher {
        public ForeignKeyMatch() {
        }

        public ForeignKeyMatch(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
                this.posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
                this.basename = (String)_parser.getAttribute("basename", "String", null, null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "ForeignKeyMatch";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"pretemplate", (Object)this.pretemplate, (int)(_indent + 1));
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"posttemplate", (Object)this.posttemplate, (int)(_indent + 1));
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"basename", (Object)this.basename, (int)(_indent + 1));
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            ForeignKeyMatch.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ForeignKeyMatch", new XMLAttrVector().add("pretemplate", (Object)this.pretemplate).add("posttemplate", (Object)this.posttemplate).add("basename", (Object)this.basename).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("ForeignKeyMatch");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ForeignKeyMatch _cother = (ForeignKeyMatch)_other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                super.validate(rules, msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public Recognizer.Matcher getMatcher(String foreignKeyName) {
            return super.getMatcher(foreignKeyName);
        }
    }

    public static class FactCountMatch
    extends NameMatcher {
        public String factCountName;

        public FactCountMatch() {
        }

        public FactCountMatch(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.factCountName = (String)_parser.getAttribute("factCountName", "String", "fact_count", null, true);
                this.pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
                this.posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
                this.basename = (String)_parser.getAttribute("basename", "String", null, null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "FactCountMatch";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"factCountName", (Object)this.factCountName, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"pretemplate", (Object)this.pretemplate, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"posttemplate", (Object)this.posttemplate, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"basename", (Object)this.basename, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            FactCountMatch.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("FactCountMatch", new XMLAttrVector().add("factCountName", (Object)this.factCountName).add("pretemplate", (Object)this.pretemplate).add("posttemplate", (Object)this.posttemplate).add("basename", (Object)this.basename).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("FactCountMatch");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            FactCountMatch _cother = (FactCountMatch)_other;
            boolean _diff = FactCountMatch.displayAttributeDiff((String)"factCountName", (Object)this.factCountName, (Object)_cother.factCountName, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                super.validate(rules, msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public Recognizer.Matcher getMatcher() {
            return super.getMatcher(this.factCountName);
        }
    }

    public static abstract class NameMatcher
    extends CaseMatcher {
        public String pretemplate;
        public String posttemplate;
        public String basename;
        Pattern baseNamePattern = null;

        public NameMatcher() {
        }

        public NameMatcher(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
                this.posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
                this.basename = (String)_parser.getAttribute("basename", "String", null, null, false);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "NameMatcher";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"pretemplate", (Object)this.pretemplate, (int)(_indent + 1));
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"posttemplate", (Object)this.posttemplate, (int)(_indent + 1));
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"basename", (Object)this.basename, (int)(_indent + 1));
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            NameMatcher.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NameMatcher", new XMLAttrVector().add("pretemplate", (Object)this.pretemplate).add("posttemplate", (Object)this.posttemplate).add("basename", (Object)this.basename).add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("NameMatcher");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NameMatcher _cother = (NameMatcher)_other;
            boolean _diff = NameMatcher.displayAttributeDiff((String)"pretemplate", (Object)this.pretemplate, (Object)_cother.pretemplate, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NameMatcher.displayAttributeDiff((String)"posttemplate", (Object)this.posttemplate, (Object)_cother.posttemplate, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NameMatcher.displayAttributeDiff((String)"basename", (Object)this.basename, (Object)_cother.basename, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                super.validate(rules, msgRecorder);
                if (this.basename != null) {
                    this.baseNamePattern = Pattern.compile(this.basename);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public String getRegex(String name) {
            StringBuilder buf = new StringBuilder();
            if (this.pretemplate != null) {
                buf.append(this.pretemplate);
            }
            if (name != null) {
                String n = name;
                if (this.baseNamePattern != null) {
                    Matcher matcher = this.baseNamePattern.matcher(name);
                    if (matcher.matches() && matcher.groupCount() > 0) {
                        n = matcher.group(1);
                    } else {
                        if (AggRules.getLogger().isDebugEnabled()) {
                            StringBuilder bf = new StringBuilder(64);
                            bf.append(this.getName());
                            bf.append(".getRegex: for name \"");
                            bf.append(name);
                            bf.append("\" regex is null because basename \"");
                            bf.append(this.basename);
                            bf.append("\" is not matched.");
                            String msg = bf.toString();
                            AggRules.getLogger().debug((Object)msg);
                        }
                        return null;
                    }
                }
                buf.append(n);
            }
            if (this.posttemplate != null) {
                buf.append(this.posttemplate);
            }
            String regex = buf.toString();
            if (AggRules.getLogger().isDebugEnabled()) {
                StringBuilder bf = new StringBuilder(64);
                bf.append(this.getName());
                bf.append(".getRegex: for name \"");
                bf.append(name);
                bf.append("\" regex is \"");
                bf.append(regex);
                bf.append('\"');
                String msg = bf.toString();
                AggRules.getLogger().debug((Object)msg);
            }
            return regex;
        }

        protected Recognizer.Matcher getMatcher(String name) {
            String regex;
            String charcase = this.getCharCase();
            int flag = 0;
            if (charcase.equals("ignore")) {
                regex = this.getRegex(name);
                flag = 2;
            } else {
                regex = charcase.equals("exact") ? this.getRegex(name) : (charcase.equals("upper") ? this.getRegex(name.toUpperCase()) : this.getRegex(name.toLowerCase()));
            }
            if (regex == null) {
                return new Recognizer.Matcher(){

                    @Override
                    public boolean matches(String name) {
                        return false;
                    }
                };
            }
            final Pattern pattern = Pattern.compile(regex, flag);
            return new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    boolean b = pattern.matcher(name).matches();
                    if (AggRules.getLogger().isDebugEnabled()) {
                        this.debug(name);
                    }
                    return b;
                }

                private void debug(String name) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append(NameMatcher.this.getName());
                    bf.append(".Matcher.matches:");
                    bf.append(" name \"");
                    bf.append(name);
                    bf.append("\" pattern \"");
                    bf.append(pattern.pattern());
                    bf.append("\"");
                    if ((pattern.flags() & 2) != 0) {
                        bf.append(" case_insensitive");
                    }
                    String msg = bf.toString();
                    AggRules.getLogger().debug((Object)msg);
                }
            };
        }
    }

    public static abstract class CaseMatcher
    extends Base {
        public String id;
        public static final String[] _charcase_values = new String[]{"ignore", "exact", "upper", "lower"};
        public String charcase;

        public CaseMatcher() {
        }

        public CaseMatcher(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.id = (String)_parser.getAttribute("id", "String", null, null, true);
                this.charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "CaseMatcher";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CaseMatcher.displayAttribute((PrintWriter)_out, (String)"id", (Object)this.id, (int)(_indent + 1));
            CaseMatcher.displayAttribute((PrintWriter)_out, (String)"charcase", (Object)this.charcase, (int)(_indent + 1));
            CaseMatcher.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CaseMatcher", new XMLAttrVector().add("id", (Object)this.id).add("charcase", (Object)this.charcase).add("enabled", (Object)this.enabled));
            _out.endTag("CaseMatcher");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CaseMatcher _cother = (CaseMatcher)_other;
            boolean _diff = CaseMatcher.displayAttributeDiff((String)"id", (Object)this.id, (Object)_cother.id, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CaseMatcher.displayAttributeDiff((String)"charcase", (Object)this.charcase, (Object)_cother.charcase, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public void validate(AggRules rules, MessageRecorder msgRecorder) {
        }

        @Override
        protected String getTag() {
            return this.getId();
        }

        public String getId() {
            return this.id;
        }

        public String getCharCase() {
            return this.charcase;
        }
    }

    public static abstract class Base
    extends ElementDef {
        public Boolean enabled;

        public Base() {
        }

        public Base(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Base";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Base.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Base", new XMLAttrVector().add("enabled", (Object)this.enabled));
            _out.endTag("Base");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Base _cother = (Base)_other;
            boolean _diff = Base.displayAttributeDiff((String)"enabled", (Object)this.enabled, (Object)_cother.enabled, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        protected abstract String getTag();

        public abstract void validate(AggRules var1, MessageRecorder var2);
    }

    public static class AggRules
    extends ElementDef {
        public String tag;
        public TableMatch[] tableMatches;
        public FactCountMatch[] factCountMatches;
        public ForeignKeyMatch[] foreignKeyMatches;
        public LevelMap[] levelMaps;
        public MeasureMap[] measureMaps;
        public IgnoreMap[] ignoreMaps;
        public AggRule[] aggRules;
        private static final Logger LOGGER = Logger.getLogger(DefaultDef.class);

        public AggRules() {
        }

        public AggRules(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", DefaultDef.class);
                this.tag = (String)_parser.getAttribute("tag", "String", null, null, true);
                NodeDef[] _tempArray = _parser.getArray(TableMatch.class, 0, 0);
                this.tableMatches = new TableMatch[_tempArray.length];
                for (_i = 0; _i < this.tableMatches.length; ++_i) {
                    this.tableMatches[_i] = (TableMatch)_tempArray[_i];
                }
                _tempArray = _parser.getArray(FactCountMatch.class, 0, 0);
                this.factCountMatches = new FactCountMatch[_tempArray.length];
                for (_i = 0; _i < this.factCountMatches.length; ++_i) {
                    this.factCountMatches[_i] = (FactCountMatch)_tempArray[_i];
                }
                _tempArray = _parser.getArray(ForeignKeyMatch.class, 0, 0);
                this.foreignKeyMatches = new ForeignKeyMatch[_tempArray.length];
                for (_i = 0; _i < this.foreignKeyMatches.length; ++_i) {
                    this.foreignKeyMatches[_i] = (ForeignKeyMatch)_tempArray[_i];
                }
                _tempArray = _parser.getArray(LevelMap.class, 0, 0);
                this.levelMaps = new LevelMap[_tempArray.length];
                for (_i = 0; _i < this.levelMaps.length; ++_i) {
                    this.levelMaps[_i] = (LevelMap)_tempArray[_i];
                }
                _tempArray = _parser.getArray(MeasureMap.class, 0, 0);
                this.measureMaps = new MeasureMap[_tempArray.length];
                for (_i = 0; _i < this.measureMaps.length; ++_i) {
                    this.measureMaps[_i] = (MeasureMap)_tempArray[_i];
                }
                _tempArray = _parser.getArray(IgnoreMap.class, 0, 0);
                this.ignoreMaps = new IgnoreMap[_tempArray.length];
                for (_i = 0; _i < this.ignoreMaps.length; ++_i) {
                    this.ignoreMaps[_i] = (IgnoreMap)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggRule.class, 1, 0);
                this.aggRules = new AggRule[_tempArray.length];
                for (_i = 0; _i < this.aggRules.length; ++_i) {
                    this.aggRules[_i] = (AggRule)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggRules";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggRules.displayAttribute((PrintWriter)_out, (String)"tag", (Object)this.tag, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"tableMatches", (NodeDef[])this.tableMatches, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"factCountMatches", (NodeDef[])this.factCountMatches, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"foreignKeyMatches", (NodeDef[])this.foreignKeyMatches, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"levelMaps", (NodeDef[])this.levelMaps, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"measureMaps", (NodeDef[])this.measureMaps, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"ignoreMaps", (NodeDef[])this.ignoreMaps, (int)(_indent + 1));
            AggRules.displayElementArray((PrintWriter)_out, (String)"aggRules", (NodeDef[])this.aggRules, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggRules", new XMLAttrVector().add("tag", (Object)this.tag));
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.tableMatches);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.factCountMatches);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.foreignKeyMatches);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levelMaps);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measureMaps);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.ignoreMaps);
            AggRules.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.aggRules);
            _out.endTag("AggRules");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggRules _cother = (AggRules)_other;
            boolean _diff = AggRules.displayAttributeDiff((String)"tag", (Object)this.tag, (Object)_cother.tag, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"tableMatches", (NodeDef[])this.tableMatches, (NodeDef[])_cother.tableMatches, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"factCountMatches", (NodeDef[])this.factCountMatches, (NodeDef[])_cother.factCountMatches, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"foreignKeyMatches", (NodeDef[])this.foreignKeyMatches, (NodeDef[])_cother.foreignKeyMatches, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"levelMaps", (NodeDef[])this.levelMaps, (NodeDef[])_cother.levelMaps, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"measureMaps", (NodeDef[])this.measureMaps, (NodeDef[])_cother.measureMaps, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"ignoreMaps", (NodeDef[])this.ignoreMaps, (NodeDef[])_cother.ignoreMaps, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggRules.displayElementArrayDiff((String)"aggRules", (NodeDef[])this.aggRules, (NodeDef[])_cother.aggRules, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        protected static Logger getLogger() {
            return LOGGER;
        }

        public String getTag() {
            return this.tag;
        }

        public AggRule getAggRule(String tag) {
            for (int i = 0; i < this.aggRules.length; ++i) {
                AggRule aggRule = this.aggRules[i];
                if (!aggRule.isEnabled() || !aggRule.getTag().equals(tag)) continue;
                return aggRule;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                this.validate(this.factCountMatches, msgRecorder);
                this.validate(this.tableMatches, msgRecorder);
                this.validate(this.levelMaps, msgRecorder);
                this.validate(this.measureMaps, msgRecorder);
                this.validate(this.ignoreMaps, msgRecorder);
                this.validate(this.aggRules, msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        private void validate(Base[] bases, MessageRecorder msgRecorder) {
            for (int i = 0; i < bases.length; ++i) {
                Base base = bases[i];
                if (!base.isEnabled()) continue;
                base.validate(this, msgRecorder);
            }
        }

        public boolean hasIgnoreMap(String id) {
            return this.lookupIgnoreMap(id) != null;
        }

        public IgnoreMap lookupIgnoreMap(String id) {
            return (IgnoreMap)this.lookupBase(id, this.ignoreMaps);
        }

        public boolean hasFactCountMatch(String id) {
            return this.lookupFactCountMatch(id) != null;
        }

        public FactCountMatch lookupFactCountMatch(String id) {
            return (FactCountMatch)this.lookupBase(id, this.factCountMatches);
        }

        public boolean hasForeignKeyMatch(String id) {
            return this.lookupForeignKeyMatch(id) != null;
        }

        public ForeignKeyMatch lookupForeignKeyMatch(String id) {
            return (ForeignKeyMatch)this.lookupBase(id, this.foreignKeyMatches);
        }

        public boolean hasTableMatch(String id) {
            return this.lookupTableMatch(id) != null;
        }

        public TableMatch lookupTableMatch(String id) {
            return (TableMatch)this.lookupBase(id, this.tableMatches);
        }

        public boolean hasLevelMap(String id) {
            return this.lookupLevelMap(id) != null;
        }

        public LevelMap lookupLevelMap(String id) {
            return (LevelMap)this.lookupBase(id, this.levelMaps);
        }

        public boolean hasMeasureMap(String id) {
            return this.lookupMeasureMap(id) != null;
        }

        public MeasureMap lookupMeasureMap(String id) {
            return (MeasureMap)this.lookupBase(id, this.measureMaps);
        }

        public boolean hasAggRule(String id) {
            return this.lookupAggRule(id) != null;
        }

        public AggRule lookupAggRule(String id) {
            return (AggRule)this.lookupBase(id, this.aggRules);
        }

        private Base lookupBase(String tag, Base[] bases) {
            for (int i = 0; i < bases.length; ++i) {
                Base base = bases[i];
                if (!base.isEnabled() || !base.getTag().equals(tag)) continue;
                return base;
            }
            return null;
        }

        public IgnoreMap[] getIgnoreMaps() {
            return this.ignoreMaps;
        }

        public FactCountMatch[] getFactCountMatches() {
            return this.factCountMatches;
        }

        public ForeignKeyMatch[] getForeignKeyMatches() {
            return this.foreignKeyMatches;
        }

        public TableMatch[] getTableMatches() {
            return this.tableMatches;
        }

        public LevelMap[] getLevelMaps() {
            return this.levelMaps;
        }

        public MeasureMap[] getMeasureMaps() {
            return this.measureMaps;
        }

        public AggRule[] getAggRules() {
            return this.aggRules;
        }
    }
}

