/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.List;
import mondrian.calc.TupleList;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.Position;

public class RolapAxis
implements Axis {
    private final TupleList list;

    public RolapAxis(TupleList list) {
        this.list = list;
    }

    public TupleList getTupleList() {
        return this.list;
    }

    @Override
    public List<Position> getPositions() {
        return new PositionList(this.list);
    }

    public static String toString(Axis axis) {
        List<Position> pl = axis.getPositions();
        return RolapAxis.toString(pl);
    }

    public static String toString(List<Position> pl) {
        StringBuilder buf = new StringBuilder();
        for (Position p : pl) {
            buf.append('{');
            boolean firstTime = true;
            for (Member m : p) {
                if (!firstTime) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
                firstTime = false;
            }
            buf.append('}');
            buf.append('\n');
        }
        return buf.toString();
    }

    private static class PositionImpl
    extends AbstractList<Member>
    implements Position {
        private final TupleList tupleList;
        private final int offset;

        PositionImpl(TupleList tupleList, int offset) {
            this.tupleList = tupleList;
            this.offset = offset;
        }

        @Override
        public Member get(int index) {
            return this.tupleList.get(index, this.offset);
        }

        @Override
        public int size() {
            return this.tupleList.getArity();
        }
    }

    private static class PositionList
    extends AbstractList<Position> {
        private final TupleList list;

        PositionList(TupleList list) {
            this.list = list;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Position get(int index) {
            return new PositionImpl(this.list, index);
        }
    }
}

