/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class TupleType
implements Type {
    public final Type[] elementTypes;
    private final String digest;

    public TupleType(Type[] elementTypes) {
        assert (elementTypes != null);
        this.elementTypes = (Type[])elementTypes.clone();
        StringBuilder buf = new StringBuilder();
        buf.append("TupleType<");
        int k = 0;
        for (Type elementType : elementTypes) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(elementType);
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public String toString() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleType) {
            TupleType that = (TupleType)obj;
            return Arrays.equals(this.elementTypes, that.elementTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    @Override
    public boolean usesDimension(Dimension dimension, boolean definitely) {
        for (Type elementType : this.elementTypes) {
            if (!elementType.usesDimension(dimension, definitely)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        for (Type elementType : this.elementTypes) {
            if (!elementType.usesHierarchy(hierarchy, definitely)) continue;
            return true;
        }
        return false;
    }

    public List<Hierarchy> getHierarchies() {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(this.elementTypes.length);
        for (Type elementType : this.elementTypes) {
            hierarchies.add(elementType.getHierarchy());
        }
        return hierarchies;
    }

    @Override
    public int getArity() {
        return this.elementTypes.length;
    }

    @Override
    public Dimension getDimension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Level getLevel() {
        throw new UnsupportedOperationException();
    }

    public Type getValueType() {
        for (Type elementType : this.elementTypes) {
            MemberType memberType;
            Dimension dimension;
            if (!(elementType instanceof MemberType) || (dimension = (memberType = (MemberType)elementType).getDimension()) == null || !dimension.isMeasures()) continue;
            return memberType.getValueType();
        }
        return new ScalarType();
    }

    @Override
    public Type computeCommonType(Type type, int[] conversionCount) {
        if (type instanceof ScalarType) {
            return this.getValueType().computeCommonType(type, conversionCount);
        }
        if (type instanceof MemberType) {
            return this.commonTupleType(new TupleType(new Type[]{type}), conversionCount);
        }
        if (!(type instanceof TupleType)) {
            return null;
        }
        return this.commonTupleType(type, conversionCount);
    }

    @Override
    public boolean isInstance(Object value) {
        if (!(value instanceof Object[])) {
            return false;
        }
        Object[] objects = (Object[])value;
        if (objects.length != this.elementTypes.length) {
            return false;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (this.elementTypes[i].isInstance(objects[i])) continue;
            return false;
        }
        return true;
    }

    private Type commonTupleType(Type type, int[] conversionCount) {
        TupleType that = (TupleType)type;
        if (this.elementTypes.length < that.elementTypes.length) {
            return this.createCommonTupleType(that, conversionCount);
        }
        return that.createCommonTupleType(this, conversionCount);
    }

    private Type createCommonTupleType(TupleType that, int[] conversionCount) {
        int i;
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        for (i = 0; i < this.elementTypes.length; ++i) {
            Type commonType = this.elementTypes[i].computeCommonType(that.elementTypes[i], conversionCount);
            elementTypes.add(commonType);
            if (commonType != null) continue;
            return null;
        }
        if (elementTypes.size() < that.elementTypes.length) {
            for (i = elementTypes.size(); i < that.elementTypes.length; ++i) {
                elementTypes.add(new ScalarType());
            }
        }
        return new TupleType(elementTypes.toArray(new Type[elementTypes.size()]));
    }

    public static void checkHierarchies(MemberType[] memberTypes) {
        for (int i = 0; i < memberTypes.length; ++i) {
            MemberType memberType = memberTypes[i];
            for (int j = 0; j < i; ++j) {
                MemberType member1 = memberTypes[j];
                Hierarchy hierarchy = memberType.getHierarchy();
                Hierarchy hierarchy1 = member1.getHierarchy();
                if (hierarchy == null || hierarchy != hierarchy1) continue;
                throw MondrianResource.instance().DupHierarchiesInTuple.ex(hierarchy.getUniqueName());
            }
        }
    }
}

