/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.calc.ParameterSlot;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Literal;
import mondrian.olap.Parameter;
import mondrian.olap.Util;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ParameterImpl
implements Parameter,
ParameterCompilable {
    private final String name;
    private String description;
    private Exp defaultExp;
    private Type type;
    private ParameterSlot slot = new ParameterSlot(){
        Object value;
        boolean assigned;

        @Override
        public Object getCachedDefaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Calc getDefaultValueCalc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Parameter getParameter() {
            return ParameterImpl.this;
        }

        @Override
        public Object getParameterValue() {
            return this.value;
        }

        @Override
        public boolean isParameterSet() {
            return this.assigned;
        }

        @Override
        public void unsetParameterValue() {
            this.assigned = false;
            this.value = null;
        }

        @Override
        public void setCachedDefaultValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setParameterValue(Object value, boolean assigned) {
            this.assigned = true;
            this.value = value;
            assert (!(value instanceof List) || value instanceof TupleList);
            assert (!(value instanceof MemberExpr));
            assert (!(value instanceof Literal));
        }
    };

    public ParameterImpl(String name, Exp defaultExp, String description, Type type) {
        this.name = name;
        this.defaultExp = defaultExp;
        this.description = description;
        this.type = type;
        assert (defaultExp != null);
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType);
    }

    @Override
    public Parameter.Scope getScope() {
        return Parameter.Scope.Statement;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Exp getDefaultExp() {
        return this.defaultExp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        if (this.slot == null) {
            return null;
        }
        Object value = this.slot.getParameterValue();
        return ParameterImpl.convertBack(value);
    }

    @Override
    public void setValue(Object value) {
        this.slot.setParameterValue(this.convert(value), true);
    }

    @Override
    public boolean isSet() {
        return this.slot != null && this.slot.isParameterSet();
    }

    @Override
    public void unsetValue() {
        this.slot.unsetParameterValue();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParameterImpl)) {
            return false;
        }
        ParameterImpl that = (ParameterImpl)other;
        return that.getName().equals(this.getName()) && that.defaultExp.equals(this.defaultExp);
    }

    public int hashCode() {
        return Util.hash(this.getName().hashCode(), this.defaultExp.hashCode());
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(Type type) {
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType || type instanceof SetType && ((SetType)type).getElementType() instanceof MemberType) : type;
        this.type = type;
    }

    public void setDefaultExp(Exp defaultExp) {
        assert (defaultExp != null);
        this.defaultExp = defaultExp;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        ParameterSlot slot = compiler.registerParameter(this);
        if (this.slot != null && this.slot.isParameterSet()) {
            slot.setParameterValue(this.slot.getParameterValue(), true);
        }
        this.slot = slot;
        if (this.type instanceof SetType) {
            return new MemberListParameterCalc(slot);
        }
        return new ParameterCalc(slot);
    }

    protected Object convert(Object value) {
        if (value instanceof List && !(value instanceof TupleList)) {
            List list = (List)value;
            return TupleCollections.asTupleList(list);
        }
        if (value instanceof MemberExpr) {
            return ((MemberExpr)value).getMember();
        }
        if (value instanceof Literal) {
            return ((Literal)value).getValue();
        }
        return value;
    }

    public static Object convertBack(Object value) {
        if (value instanceof TupleList) {
            TupleList tupleList = (TupleList)value;
            if (tupleList.getArity() == 1) {
                return tupleList.slice(0);
            }
            return TupleCollections.asMemberArrayList(tupleList);
        }
        return value;
    }

    private static class MemberListParameterCalc
    extends AbstractListCalc {
        private final ParameterSlot slot;

        public MemberListParameterCalc(ParameterSlot slot) {
            super(new DummyExp(slot.getParameter().getType()), new Calc[0]);
            this.slot = slot;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            TupleList value = (TupleList)evaluator.getParameterValue(this.slot);
            if (!this.slot.isParameterSet()) {
                this.slot.setParameterValue(value, false);
            }
            return value;
        }
    }

    private static class ParameterCalc
    extends GenericCalc {
        private final ParameterSlot slot;

        public ParameterCalc(ParameterSlot slot) {
            super(new DummyExp(slot.getParameter().getType()), new Calc[0]);
            this.slot = slot;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            Object value = evaluator.getParameterValue(this.slot);
            if (!this.slot.isParameterSet()) {
                this.slot.setParameterValue(value, false);
            }
            return value;
        }
    }
}

