/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;

public class AnyNumberSequence
extends AnySequence
implements NumberSequence {
    private static final Number ZERO = new BigDecimal("0");

    public AnyNumberSequence(FormulaContext context) {
        super(context);
    }

    public AnyNumberSequence(LValue n, FormulaContext context) {
        super(n, context);
    }

    public AnyNumberSequence(ArrayCallback array, FormulaContext context) {
        super(array, context);
    }

    public AnyNumberSequence(AnySequence anySequence) {
        super(anySequence);
    }

    @Override
    protected boolean isValidNext(LValue o) throws EvaluationException {
        if (o == null) {
            return false;
        }
        Type type = o.getValueType();
        if (type.isFlagSet(16)) {
            return true;
        }
        if (type.isFlagSet(32)) {
            return true;
        }
        if (type.isFlagSet(2)) {
            return true;
        }
        return type.isFlagSet(1);
    }

    @Override
    public Number nextNumber() throws EvaluationException {
        Object value = super.next();
        if (value instanceof Number) {
            return (Number)value;
        }
        return ZERO;
    }
}

