/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.synchronizeaftermerge;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMerge;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMergeData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SynchronizeAfterMergeMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SynchronizeAfterMergeMeta.class;
    private String schemaName;
    private String tableName;
    private DatabaseMeta databaseMeta;
    private String[] keyStream;
    private String[] keyLookup;
    private String[] keyCondition;
    private String[] keyStream2;
    private String[] updateLookup;
    private String[] updateStream;
    private Boolean[] update;
    private int commitSize;
    private boolean tablenameInField;
    private String tablenameField;
    private String operationOrderField;
    private boolean useBatchUpdate;
    private boolean performLookup;
    private String OrderInsert;
    private String OrderUpdate;
    private String OrderDelete;

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setPerformLookup(boolean performLookup) {
        this.performLookup = performLookup;
    }

    public boolean isPerformLookup() {
        return this.performLookup;
    }

    public boolean istablenameInField() {
        return this.tablenameInField;
    }

    public void settablenameInField(boolean tablenamefield) {
        this.tablenameInField = tablenamefield;
    }

    public String gettablenameField() {
        return this.tablenameField;
    }

    public String getOperationOrderField() {
        return this.operationOrderField;
    }

    public String getOrderInsert() {
        return this.OrderInsert;
    }

    public String getOrderUpdate() {
        return this.OrderUpdate;
    }

    public String getOrderDelete() {
        return this.OrderDelete;
    }

    public void setOrderInsert(String insert) {
        this.OrderInsert = insert;
    }

    public void setOrderUpdate(String update) {
        this.OrderUpdate = update;
    }

    public void setOrderDelete(String delete) {
        this.OrderDelete = delete;
    }

    public void setOperationOrderField(String operationOrderField) {
        this.operationOrderField = operationOrderField;
    }

    public void settablenameField(String tablenamefield) {
        this.tablenameField = tablenamefield;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        SynchronizeAfterMergeMeta retval = (SynchronizeAfterMergeMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.keyStream[i] = this.keyStream[i];
            retval.keyLookup[i] = this.keyLookup[i];
            retval.keyCondition[i] = this.keyCondition[i];
            retval.keyStream2[i] = this.keyStream2[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
            retval.update[i] = this.update[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)csize, (int)0);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"table");
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_batch"));
            this.performLookup = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"perform_lookup"));
            this.tablenameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"tablename_in_field"));
            this.tablenameField = XMLHandler.getTagValue((Node)stepnode, (String)"tablename_field");
            this.operationOrderField = XMLHandler.getTagValue((Node)stepnode, (String)"operation_order_field");
            this.OrderInsert = XMLHandler.getTagValue((Node)stepnode, (String)"order_insert");
            this.OrderUpdate = XMLHandler.getTagValue((Node)stepnode, (String)"order_update");
            this.OrderDelete = XMLHandler.getTagValue((Node)stepnode, (String)"order_delete");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                String updateValue;
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XMLHandler.getTagValue((Node)vnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.tablenameInField = false;
        this.tablenameField = null;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = 100;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.DefaultTableName", (String[])new String[0]);
        this.operationOrderField = null;
        this.OrderInsert = null;
        this.OrderUpdate = null;
        this.OrderDelete = null;
        this.performLookup = false;
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ColumnName.NewName", (String[])new String[0]) + i;
            this.update[i] = Boolean.TRUE;
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(200);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"tablename_in_field", (boolean)this.tablenameInField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"tablename_field", (String)this.tablenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_batch", (boolean)this.useBatchUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"perform_lookup", (boolean)this.performLookup));
        retval.append("    ").append(XMLHandler.addTagValue((String)"operation_order_field", (String)this.operationOrderField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"order_insert", (String)this.OrderInsert));
        retval.append("    ").append(XMLHandler.addTagValue((String)"order_update", (String)this.OrderUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"order_delete", (String)this.OrderDelete));
        retval.append("    <lookup>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"update", (boolean)this.update[i]));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.tablenameInField = rep.getStepAttributeBoolean(id_step, "tablename_in_field");
            this.tablenameField = rep.getStepAttributeString(id_step, "tablename_field");
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "use_batch");
            this.performLookup = rep.getStepAttributeBoolean(id_step, "perform_lookup");
            this.operationOrderField = rep.getStepAttributeString(id_step, "operation_order_field");
            this.OrderInsert = rep.getStepAttributeString(id_step, "order_insert");
            this.OrderUpdate = rep.getStepAttributeString(id_step, "order_update");
            this.OrderDelete = rep.getStepAttributeString(id_step, "order_delete");
            int nrkeys = rep.countNrStepAttributes(id_step, "key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
                this.update[i] = rep.getStepAttributeBoolean(id_step, i, "value_update", true);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_in_field", this.tablenameInField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_field", this.tablenameField);
            rep.saveStepAttribute(id_transformation, id_step, "operation_order_field", this.operationOrderField);
            rep.saveStepAttribute(id_transformation, id_step, "order_insert", this.OrderInsert);
            rep.saveStepAttribute(id_transformation, id_step, "order_update", this.OrderUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "order_delete", this.OrderDelete);
            rep.saveStepAttribute(id_transformation, id_step, "use_batch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "perform_lookup", this.performLookup);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_rename", this.updateStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_update", this.update[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        error_message = "";
        if (this.databaseMeta != null) {
            db = new Database(SynchronizeAfterMergeMeta.loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                db.connect();
                if (!Const.isEmpty((String)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                    r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found != false ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found != false ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        v = prev.searchValueMeta(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = error_found != false ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        lufield = this.updateStream[i];
                        v = prev.searchValueMeta(lufield);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + lufield + Const.CR;
                    }
                    if (error_found) {
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    } else {
                        cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    errorMsgDiffField = "";
                    errorDiffLenField = false;
                    errorMsgDiffLenField = "";
                    errorDiffField = false;
                    r = db.getTableFields(this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName));
                    if (r == null) ** GOTO lbl147
                    for (i = 0; i < this.updateStream.length; ++i) {
                        lufieldstream = this.updateStream[i];
                        lufieldtable = this.updateLookup[i];
                        vs = prev.searchValueMeta(lufieldstream);
                        vt = r.searchValueMeta(lufieldtable);
                        if (vs == null || vt == null) continue;
                        if (!vs.getTypeDesc().equalsIgnoreCase(vt.getTypeDesc())) {
                            errorMsgDiffField = errorMsgDiffField + Const.CR + "The input field [" + vs.getName() + "] ( Type=" + vs.getTypeDesc() + ") is not the same as the type in the target table (Type=" + vt.getTypeDesc() + ")" + Const.CR;
                            errorDiffField = true;
                            continue;
                        }
                        if (vt.getLength() >= vs.getLength() && vs.getLength() != -1 || vt.getLength() == -1) continue;
                        errorMsgDiffLenField = errorMsgDiffLenField + Const.CR + "The input field [" + vs.getName() + "] " + "(" + vs.getTypeDesc() + ")" + " has a length (" + vs.getLength() + ")" + " that is higher than that in the target table (" + vt.getLength() + ")." + Const.CR;
                        errorDiffLenField = true;
                    }
                    if (errorDiffField) {
                        errorMsgDiffField = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.FieldsTypeDifferent", (String[])new String[0]) + Const.CR + errorMsgDiffField;
                        cr = new CheckResult(4, errorMsgDiffField, (CheckResultSourceInterface)stepMeta);
                    }
                    if (errorDiffLenField) {
                        errorMsgDiffLenField = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.FieldsLenDifferent", (String[])new String[0]) + Const.CR + errorMsgDiffLenField;
                        cr = new CheckResult(3, errorMsgDiffLenField, (CheckResultSourceInterface)stepMeta);
                    }
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
lbl147:
        // 5 sources

        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block18: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    ValueMetaInterface v;
                    int i;
                    RowMeta tableFields = new RowMeta();
                    if (this.keyLookup != null) {
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            v = prev.searchValueMeta(this.keyStream[i]);
                            if (v == null) {
                                throw new KettleStepException("Unable to find field [" + this.keyStream[i] + "] in the input rows");
                            }
                            ValueMetaInterface tableField = v.clone();
                            tableField.setName(this.keyLookup[i]);
                            tableFields.addValueMeta(tableField);
                        }
                    }
                    for (i = 0; i < this.updateLookup.length; ++i) {
                        v = prev.searchValueMeta(this.updateStream[i]);
                        if (v != null) {
                            ValueMetaInterface vk = tableFields.searchValueMeta(this.updateStream[i]);
                            if (vk != null) continue;
                            ValueMetaInterface tableField = v.clone();
                            tableField.setName(this.updateLookup[i]);
                            tableFields.addValueMeta(tableField);
                            continue;
                        }
                        throw new KettleStepException("Unable to find field [" + this.updateStream[i] + "] in the input rows");
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                            String cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i2 = 0; i2 < this.keyLookup.length; ++i2) {
                                    idx_fields[i2] = this.keyLookup[i2];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.schemaName, this.tableName, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(schemaTable, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block18;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            DatabaseImpact ii;
            ValueMetaInterface v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SynchronizeAfterMerge(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SynchronizeAfterMergeData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

