/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.socketreader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.socketreader.SocketReader;
import org.pentaho.di.trans.steps.socketreader.SocketReaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SocketReaderMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SocketReaderMeta.class;
    private String hostname;
    private String port;
    private String bufferSize;
    private boolean compressed;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("     " + XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        xml.append("     " + XMLHandler.addTagValue((String)"port", (String)this.port));
        xml.append("     " + XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        xml.append("     " + XMLHandler.addTagValue((String)"compressed", (boolean)this.compressed));
        return xml.toString();
    }

    private void readData(Node stepnode) {
        this.hostname = XMLHandler.getTagValue((Node)stepnode, (String)"hostname");
        this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
        this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
        this.compressed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"compressed"));
    }

    @Override
    public void setDefault() {
        this.bufferSize = "3000";
        this.compressed = true;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.hostname = rep.getStepAttributeString(id_step, "hostname");
        this.port = rep.getStepAttributeString(id_step, "port");
        this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
        this.compressed = rep.getStepAttributeBoolean(id_step, "compressed");
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "hostname", this.hostname);
        rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
        rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
        rep.saveStepAttribute(id_transformation, id_step, "compressed", this.compressed);
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SocketReaderMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SocketReaderMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SocketReaderMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SocketReaderMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SocketReader(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SocketReaderData();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }
}

