/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ExportFeedback;
import org.pentaho.di.repository.IRepositoryExporterFeedback;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.metastore.api.IMetaStore;

public class RepositoryExporter
implements IRepositoryExporterFeedback {
    private static Class<?> PKG = RepositoryExporter.class;
    private Repository repository;
    private LogChannelInterface log;
    private ImportRules importRules;
    private boolean hasRules = false;
    private List<ExportFeedback> feedbackList = new ArrayList<ExportFeedback>();
    private boolean rulesViolation = false;

    public RepositoryExporter(Repository repository) {
        this.log = repository.getLog();
        this.repository = repository;
        this.importRules = new ImportRules();
    }

    @Override
    public boolean isRulesViolation() {
        return this.rulesViolation;
    }

    @Override
    public void setImportRulesToValidate(ImportRules importRules) {
        this.importRules = importRules;
        this.hasRules = importRules != null && !importRules.getRules().isEmpty();
    }

    @Override
    public List<ExportFeedback> exportAllObjectsWithFeedback(ProgressMonitorListener monitorOuter, String xmlFilename, RepositoryDirectoryInterface root, String exportType) throws KettleException {
        return this.exportAllObjectsInternal(monitorOuter, xmlFilename, root, exportType, true);
    }

    @Override
    public void exportAllObjects(ProgressMonitorListener monitorOuter, String xmlFilename, RepositoryDirectoryInterface root, String exportType) throws KettleException {
        this.exportAllObjectsInternal(monitorOuter, xmlFilename, root, exportType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<ExportFeedback> exportAllObjectsInternal(ProgressMonitorListener monitorOuter, String xmlFilename, RepositoryDirectoryInterface root, String exportType, boolean feedback) throws KettleException {
        this.feedbackList.clear();
        ProgressMonitorDecorator monitor = monitorOuter == null ? new ProgressMonitorDecorator((ProgressMonitorListener)new ProgressNullMonitorListener()) : new ProgressMonitorDecorator(monitorOuter);
        monitor.beginTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.BeginTask", (String[])new String[0]), 104);
        FileObject output = KettleVFS.getFileObject((String)xmlFilename);
        ExportFeedback feed = new ExportFeedback();
        feed.setItemName(BaseMessages.getString(PKG, (String)"Repository.Exporter.Feedback.CreateExportFile", (String[])new String[]{xmlFilename}));
        feed.setSimpleString(true);
        this.feedbackList.add(feed);
        ExportWriter writer = null;
        try {
            writer = new ExportWriter(output);
            monitor.worked(4);
            monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.ConnectToRepository", (String[])new String[0]));
            root = null == root ? this.repository.loadRepositoryDirectoryTree() : root;
            ExportType type = ExportType.valueOf(exportType.toUpperCase());
            switch (type) {
                case ALL: {
                    this.exportTransformations(monitor, root, writer, feedback);
                    monitor.worked(50);
                    this.exportJobs(monitor, root, writer, feedback);
                    monitor.worked(50);
                    break;
                }
                case TRANS: {
                    this.exportTransformations(monitor, root, writer, feedback);
                    monitor.worked(100);
                    break;
                }
                case JOBS: {
                    this.exportJobs(monitor, root, writer, feedback);
                    monitor.worked(100);
                    break;
                }
                default: {
                    throw new KettleException("Unsupported export type: " + (Object)((Object)type));
                }
            }
            monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.SavingResultFile", (String[])new String[0]));
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Exception.CloseExportFile", (String[])new String[]{xmlFilename}));
            }
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Exception.CloseExportFile", (String[])new String[]{xmlFilename}));
        }
        if (monitor != null) {
            monitor.done();
        }
        return this.feedbackList;
    }

    private void exportJobs(ProgressMonitorDecorator monitor, RepositoryDirectoryInterface dirTree, ExportWriter writer, boolean feedback) throws KettleException {
        try {
            monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.StartJobsExport", (String[])new String[0]));
            writer.openJob();
            ObjectId[] dirids = dirTree.getDirectoryIDs();
            this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.DirectoryGoing", (Object[])new Object[]{dirids.length, dirTree.getPath()}));
            for (int d = 0; d < dirids.length; ++d) {
                if (monitor.isCanceled()) {
                    this.cancelMonitorAction(writer);
                    break;
                }
                RepositoryDirectoryInterface repdir = dirTree.findDirectory(dirids[d]);
                String[] jobs = this.repository.getJobNames(dirids[d], false);
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.FindJobs", (Object[])new Object[]{jobs.length, repdir.getName()}));
                String dirPath = repdir.getPath();
                for (int i = 0; i < jobs.length && !monitor.isCanceled(); ++i) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.ExportingJob", (String[])new String[]{jobs[i]}));
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.LoadingJob", (String[])new String[]{dirPath, jobs[i]}));
                    JobMeta jobMeta = this.repository.loadJob(jobs[i], repdir, null, null);
                    jobMeta.setRepository(this.repository);
                    this.convertFromFileRepository(jobMeta);
                    List<ImportValidationFeedback> errors = this.validateObject(jobMeta, feedback);
                    if (errors.isEmpty()) {
                        writer.writeJob(jobMeta.getXML() + Const.CR);
                    } else {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.JobRuleViolation", (Object[])new Object[]{jobs[i], repdir}));
                        this.rulesViolation = true;
                        monitor.registerRuleViolation();
                        writer.registerRuleViolation();
                    }
                    if (!feedback) continue;
                    ExportFeedback fb = new ExportFeedback();
                    fb.setType(ExportFeedback.Type.JOB);
                    fb.setItemName(jobMeta.getName());
                    fb.setItemPath(dirPath);
                    ExportFeedback.Status status = errors.isEmpty() ? ExportFeedback.Status.EXPORTED : ExportFeedback.Status.REJECTED;
                    fb.setStatus(status);
                    fb.setResult(errors);
                    this.feedbackList.add(fb);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository jobs", (Throwable)e);
        }
        finally {
            writer.closeJob();
        }
    }

    private void cancelMonitorAction(ExportWriter writer) throws IOException {
        writer.registerRuleViolation();
        if (this.feedbackList != null) {
            this.feedbackList.clear();
        }
    }

    private List<ImportValidationFeedback> validateObject(Object subject, boolean boolFeedback) throws KettleException {
        if (!this.hasRules) {
            return Collections.emptyList();
        }
        if (!boolFeedback) {
            RepositoryImporter.validateImportedElement(this.importRules, subject);
        }
        List<ImportValidationFeedback> feedback = this.importRules.verifyRules(subject);
        ArrayList<ImportValidationFeedback> errors = new ArrayList<ImportValidationFeedback>(feedback.size());
        for (ImportValidationFeedback res : feedback) {
            if (!res.isError()) continue;
            errors.add(res);
        }
        return errors;
    }

    private void convertFromFileRepository(JobMeta jobMeta) {
        if (this.repository instanceof KettleFileRepository) {
            KettleFileRepository fileRep = (KettleFileRepository)this.repository;
            String jobMetaFilename = fileRep.calcFilename(jobMeta.getObjectId());
            jobMeta.setFilename(jobMetaFilename);
            for (JobEntryCopy copy : jobMeta.getJobCopies()) {
                JobEntryJob jobEntryJob;
                FileObject fileObject;
                AbstractMeta meta;
                JobEntryTrans trans;
                JobEntryInterface entry = copy.getEntry();
                if (entry instanceof JobEntryTrans && (trans = (JobEntryTrans)entry).getSpecificationMethod() == ObjectLocationSpecificationMethod.FILENAME) {
                    try {
                        meta = trans.getTransMeta(this.repository, this.repository.getMetaStore(), jobMeta);
                        fileObject = KettleVFS.getFileObject((String)meta.getFilename());
                        trans.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                        trans.setFileName(null);
                        trans.setTransname(meta.getName());
                        trans.setDirectory(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                    }
                    catch (Exception e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.UnableToLoadJobTrans", (String[])new String[]{trans.getName()}), (Throwable)e);
                    }
                }
                if (!(entry instanceof JobEntryJob) || (jobEntryJob = (JobEntryJob)entry).getSpecificationMethod() != ObjectLocationSpecificationMethod.FILENAME) continue;
                try {
                    meta = jobEntryJob.getJobMeta(this.repository, this.repository.getMetaStore(), jobMeta);
                    fileObject = KettleVFS.getFileObject((String)meta.getFilename());
                    jobEntryJob.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                    jobEntryJob.setFileName(null);
                    jobEntryJob.setJobName(meta.getName());
                    jobEntryJob.setDirectory(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.UnableToLoadJobJob", (String[])new String[]{jobEntryJob.getName()}), (Throwable)e);
                }
            }
        }
    }

    private void convertFromFileRepository(TransMeta transMeta) {
        if (this.repository instanceof KettleFileRepository) {
            KettleFileRepository fileRep = (KettleFileRepository)this.repository;
            String transMetaFilename = fileRep.calcFilename(transMeta.getObjectId());
            transMeta.setFilename(transMetaFilename);
            for (StepMeta stepMeta : transMeta.getSteps()) {
                MappingMeta mappingMeta;
                if (!stepMeta.isMapping() || (mappingMeta = (MappingMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() != ObjectLocationSpecificationMethod.FILENAME) continue;
                try {
                    TransMeta meta = MappingMeta.loadMappingMeta(mappingMeta, fileRep, (IMetaStore)fileRep.metaStore, transMeta);
                    FileObject fileObject = KettleVFS.getFileObject((String)meta.getFilename());
                    mappingMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                    mappingMeta.setFileName(null);
                    mappingMeta.setTransName(meta.getName());
                    mappingMeta.setDirectoryPath(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.UnableToLoadTransInMap", (String[])new String[]{mappingMeta.getName()}), (Throwable)e);
                }
            }
        }
    }

    private String calcRepositoryDirectory(KettleFileRepository fileRep, FileObject fileObject) throws FileSystemException {
        String baseDirectory;
        String path = fileObject.getParent().getName().getPath();
        if (path.startsWith(baseDirectory = fileRep.getRepositoryMeta().getBaseDirectory())) {
            return path.substring(baseDirectory.length());
        }
        return path;
    }

    private void exportTransformations(ProgressMonitorDecorator monitor, RepositoryDirectoryInterface dirTree, ExportWriter writer, boolean feedback) throws KettleException {
        try {
            writer.openTrans();
            monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.StartTransExport", (String[])new String[0]));
            ObjectId[] dirids = dirTree.getDirectoryIDs();
            this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.DirectoryGoing", (Object[])new Object[]{dirids.length, dirTree.getPath()}));
            for (int d = 0; d < dirids.length; ++d) {
                if (monitor.isCanceled()) {
                    this.cancelMonitorAction(writer);
                    break;
                }
                RepositoryDirectoryInterface repdir = dirTree.findDirectory(dirids[d]);
                String[] trans = this.repository.getTransformationNames(dirids[d], false);
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.FindTrans", (Object[])new Object[]{trans.length, repdir.getName()}));
                String dirPath = repdir.getPath();
                for (int i = 0; i < trans.length && !monitor.isCanceled(); ++i) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.LoadingTransformation", (String[])new String[]{dirPath, trans[i]}));
                    monitor.subTask(BaseMessages.getString(PKG, (String)"Repository.Exporter.Monitor.ExportTransformation", (String[])new String[]{trans[i]}));
                    TransMeta transMeta = this.repository.loadTransformation(trans[i], repdir, null, true, null);
                    transMeta.setRepository(this.repository);
                    this.convertFromFileRepository(transMeta);
                    List<ImportValidationFeedback> errors = this.validateObject(transMeta, feedback);
                    if (errors.isEmpty()) {
                        writer.writeTrans(transMeta.getXML() + Const.CR);
                    } else {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Repository.Exporter.Log.TransRuleViolation", (Object[])new Object[]{trans[i], repdir}));
                        this.rulesViolation = true;
                        monitor.registerRuleViolation();
                        writer.registerRuleViolation();
                    }
                    if (!feedback) continue;
                    ExportFeedback fb = new ExportFeedback();
                    fb.setType(ExportFeedback.Type.TRANSFORMATION);
                    fb.setItemName(transMeta.getName());
                    fb.setItemPath(dirPath);
                    ExportFeedback.Status status = errors.isEmpty() ? ExportFeedback.Status.EXPORTED : ExportFeedback.Status.REJECTED;
                    fb.setStatus(status);
                    fb.setResult(errors);
                    this.feedbackList.add(fb);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository transformations", (Throwable)e);
        }
        finally {
            writer.closeTrans();
        }
    }

    public static enum ExportType {
        ALL,
        TRANS,
        JOBS;

    }

    private class ProgressMonitorDecorator
    implements ProgressMonitorListener {
        private ProgressMonitorListener monitor;
        private boolean violation = false;
        private int vn = 0;

        ProgressMonitorDecorator(ProgressMonitorListener monitor) {
            this.monitor = monitor;
        }

        public void beginTask(String message, int nrWorks) {
            this.monitor.beginTask(message, nrWorks);
        }

        public void done() {
            this.monitor.done();
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public void subTask(String message) {
            if (!this.violation) {
                this.monitor.subTask(message);
            } else {
                this.monitor.subTask(BaseMessages.getString((Class)PKG, (String)"Repository.Exporter.Monitor.ExportRulesViolated", (Object[])new Object[]{this.vn}));
            }
        }

        public void registerRuleViolation() {
            ++this.vn;
            this.violation = true;
        }

        public void worked(int nrWorks) {
            this.monitor.worked(nrWorks);
        }

        public void setTaskName(String taskName) {
            this.monitor.setTaskName(taskName);
        }
    }

    private class ExportStFileWriter
    implements IExportWriter {
        private FileObject writeTo;
        private OutputStream os;
        private OutputStreamWriter out;
        private boolean start = false;
        private boolean trans = false;
        private boolean jobs = false;

        ExportStFileWriter(FileObject writeTo) throws KettleException {
            this.writeTo = writeTo;
            this.write();
        }

        private void write() throws KettleException {
            if (!this.start) {
                this.prepareToWrite();
                this.writeXmlRoot();
                this.start = true;
            }
        }

        @Override
        public void openTrans() throws KettleException {
            try {
                if (!this.trans) {
                    this.out.write(XmlElements.TRANS_START.getTag());
                    this.trans = true;
                }
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
        }

        @Override
        public void writeTrans(String str) throws KettleException {
            try {
                this.out.write(str);
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
        }

        @Override
        public void closeTrans() throws KettleException {
            if (this.trans) {
                try {
                    this.out.write(XmlElements.TRANS_END.getTag());
                }
                catch (IOException e) {
                    throw new KettleException((Throwable)e);
                }
            }
        }

        @Override
        public void openJob() throws KettleException {
            try {
                if (!this.jobs) {
                    this.out.write(XmlElements.JOBS_START.getTag());
                    this.jobs = true;
                }
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
        }

        @Override
        public void writeJob(String str) throws KettleException {
            try {
                this.out.write(str);
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
        }

        @Override
        public void closeJob() throws KettleException {
            if (this.jobs) {
                try {
                    this.out.write(XmlElements.JOBS_END.getTag());
                }
                catch (IOException e) {
                    throw new KettleException((Throwable)e);
                }
            }
        }

        private void prepareToWrite() throws KettleException {
            try {
                this.os = this.writeTo.getContent().getOutputStream();
                this.out = new OutputStreamWriter(this.os, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleException((Throwable)e);
            }
            catch (FileSystemException e) {
                throw new KettleException((Throwable)e);
            }
        }

        private void writeXmlRoot() throws KettleException {
            try {
                this.out.write(XMLHandler.getXMLHeader());
                this.out.write(XmlElements.REPO_START.getTag());
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.start && this.out != null) {
                this.out.write(XmlElements.REPO_END.getTag());
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class NullStFileWriter
    implements IExportWriter {
        NullStFileWriter() {
        }

        @Override
        public void writeJob(String str) throws KettleException {
        }

        @Override
        public void writeTrans(String str) throws KettleException {
        }

        @Override
        public void closeJob() throws KettleException {
        }

        @Override
        public void closeTrans() throws KettleException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void openJob() throws KettleException {
        }

        @Override
        public void openTrans() throws KettleException {
        }
    }

    static enum XmlElements {
        REPO_START("<repository>" + Const.CR + Const.CR),
        REPO_END("</repository>" + Const.CR + Const.CR),
        JOBS_START("<jobs>" + Const.CR),
        JOBS_END("</jobs>" + Const.CR),
        TRANS_START("<transformations>" + Const.CR),
        TRANS_END("</transformations>" + Const.CR);

        private String tag;

        private XmlElements(String tag) {
            this.tag = tag;
        }

        String getTag() {
            return this.tag;
        }
    }

    static interface IExportWriter {
        public void writeJob(String var1) throws KettleException;

        public void writeTrans(String var1) throws KettleException;

        public void openJob() throws KettleException;

        public void closeJob() throws KettleException;

        public void openTrans() throws KettleException;

        public void closeTrans() throws KettleException;

        public void close() throws IOException;
    }

    private class ExportWriter
    implements IExportWriter {
        private IExportWriter delegate;
        private FileObject writeTo;
        private boolean fileDeleted = false;

        ExportWriter(FileObject writeTo) throws KettleException {
            this.writeTo = writeTo;
            this.delegate = new ExportStFileWriter(writeTo);
        }

        void registerRuleViolation() throws IOException {
            this.delegate.close();
            if (!this.fileDeleted) {
                this.fileDeleted = this.writeTo.delete();
            }
            if (!this.fileDeleted) {
                RepositoryExporter.this.log.logDebug(BaseMessages.getString((Class)PKG, (String)"Repository.Exporter.Log.UnableToDeleteFile", (String[])new String[0]));
            }
            this.delegate = new NullStFileWriter();
        }

        @Override
        public void writeJob(String str) throws KettleException {
            this.delegate.writeJob(str);
        }

        @Override
        public void writeTrans(String str) throws KettleException {
            this.delegate.writeTrans(str);
        }

        @Override
        public void closeJob() throws KettleException {
            this.delegate.closeJob();
        }

        @Override
        public void closeTrans() throws KettleException {
            this.delegate.closeTrans();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void openJob() throws KettleException {
            this.delegate.openJob();
        }

        @Override
        public void openTrans() throws KettleException {
            this.delegate.openTrans();
        }
    }
}

