/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.FileDoesNotExistValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryZipFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryZipFile.class;
    private String zipFilename = null;
    public int compressionRate = 1;
    public int ifZipFileExists = 2;
    public int afterZip = 0;
    private String wildCard = null;
    private String excludeWildCard = null;
    private String sourceDirectory = null;
    private String movetoDirectory = null;
    private boolean addFileToResult = false;
    private boolean isFromPrevious = false;
    private boolean createParentFolder = false;
    private boolean addDate = false;
    private boolean addTime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat = null;
    private boolean createMoveToDirectory = false;
    private boolean includingSubFolders = true;
    private String storedSourcePathDepth = "1";

    public JobEntryZipFile(String n) {
        super(n, "");
    }

    public JobEntryZipFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryZipFile je = (JobEntryZipFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compressionrate", (int)this.compressionRate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifzipfileexists", (int)this.ifZipFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildCard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.excludeWildCard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourcedirectory", (String)this.sourceDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetoDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterzip", (int)this.afterZip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addFileToResult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isfromprevious", (boolean)this.isFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createParentFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createMoveToDirectory", (boolean)this.createMoveToDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includingSubFolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"stored_source_path_depth", (String)this.storedSourcePathDepth));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.zipFilename = XMLHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.compressionRate = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"compressionrate"), (int)-1);
            this.ifZipFileExists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"ifzipfileexists"), (int)-1);
            this.afterZip = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"afterzip"), (int)-1);
            this.wildCard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.excludeWildCard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.sourceDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sourcedirectory");
            this.movetoDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addFileToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.createParentFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createparentfolder"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.specifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.dateTimeFormat = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createMoveToDirectory"));
            this.includingSubFolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.storedSourcePathDepth = XMLHandler.getTagValue((Node)entrynode, (String)"stored_source_path_depth");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableLoadJobEntryXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zipfilename");
            this.compressionRate = (int)rep.getJobEntryAttributeInteger(id_jobentry, "compressionrate");
            this.ifZipFileExists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "ifzipfileexists");
            this.afterZip = (int)rep.getJobEntryAttributeInteger(id_jobentry, "afterzip");
            this.wildCard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.excludeWildCard = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.sourceDirectory = rep.getJobEntryAttributeString(id_jobentry, "sourcedirectory");
            this.movetoDirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.addFileToResult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.isFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "isfromprevious");
            this.createParentFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createparentfolder");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "addtime");
            this.specifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.dateTimeFormat = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.createMoveToDirectory = rep.getJobEntryAttributeBoolean(id_jobentry, "createMoveToDirectory");
            this.includingSubFolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.storedSourcePathDepth = rep.getJobEntryAttributeString(id_jobentry, "stored_source_path_depth");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableLoadJobEntryRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "zipfilename", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compressionrate", this.compressionRate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifzipfileexists", this.ifZipFileExists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "afterzip", this.afterZip);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildCard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardexclude", this.excludeWildCard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sourcedirectory", this.sourceDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetodirectory", this.movetoDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfiletoresult", this.addFileToResult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isfromprevious", this.isFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createparentfolder", this.createParentFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addtime", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddate", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.specifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.dateTimeFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createMoveToDirectory", this.createMoveToDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includingSubFolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "stored_source_path_depth", this.storedSourcePathDepth);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableSaveJobEntryRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean result = false;
        try {
            parentfolder = KettleVFS.getFileObject((String)filename, (VariableSpace)this).getParent();
            if (!parentfolder.exists()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.CanNotFindFolder", (String[])new String[]{"" + parentfolder.getName()}));
                }
                parentfolder.createFolder();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.FolderCreated", (String[])new String[]{"" + parentfolder.getName()}));
                }
            } else if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.FolderExists", (String[])new String[]{"" + parentfolder.getName()}));
            }
            result = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryZipFile.CanNotCreateFolder", (String[])new String[]{"" + parentfolder.getName()}), e);
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRowFile(Job parentJob, Result result, String realZipfilename, String realWildcard, String realWildcardExclude, String realSourceDirectoryOrFile, String realMovetodirectory, boolean createparentfolder) {
        boolean Fileexists = false;
        File tempFile = null;
        File fileZip = null;
        boolean resultat = false;
        boolean renameOk = false;
        boolean orginExist = false;
        FileObject originFile = null;
        ZipInputStream zin = null;
        byte[] buffer = null;
        OutputStream dest = null;
        FilterOutputStream buff = null;
        ZipOutputStream out = null;
        ZipEntry entry = null;
        String localSourceFilename = realSourceDirectoryOrFile;
        try {
            originFile = KettleVFS.getFileObject((String)realSourceDirectoryOrFile, (VariableSpace)this);
            localSourceFilename = KettleVFS.getFilename((FileObject)originFile);
            orginExist = originFile.exists();
        }
        catch (Exception e) {
        }
        finally {
            if (originFile != null) {
                try {
                    originFile.close();
                }
                catch (IOException ex) {
                    this.logError("Error closing file '" + originFile.toString() + "'", ex);
                }
            }
        }
        String localrealZipfilename = realZipfilename;
        if (realZipfilename != null && orginExist) {
            FileObject fileObject = null;
            try {
                int i;
                Pattern patternexclude;
                Pattern pattern;
                fileObject = KettleVFS.getFileObject((String)localrealZipfilename, (VariableSpace)this);
                localrealZipfilename = KettleVFS.getFilename((FileObject)fileObject);
                if (fileObject.exists()) {
                    Fileexists = true;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileExists1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileExists2.Label", (String[])new String[0]));
                    }
                }
                if (createparentfolder) {
                    this.createParentFolder(localrealZipfilename);
                }
                if (this.ifZipFileExists == 3 && Fileexists) {
                    resultat = false;
                }
                if (this.ifZipFileExists == 2 && Fileexists) {
                    if (this.addFileToResult) {
                        ResultFile resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                    resultat = true;
                }
                if (this.afterZip == 2 && realMovetodirectory == null) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
                }
                FileObject[] fileList = null;
                FileObject sourceFileOrFolder = KettleVFS.getFileObject((String)localSourceFilename);
                boolean isSourceDirectory = sourceFileOrFolder.getType().equals((Object)FileType.FOLDER);
                if (isSourceDirectory) {
                    pattern = !Const.isEmpty((String)realWildcard) ? Pattern.compile(realWildcard) : null;
                    patternexclude = !Const.isEmpty((String)realWildcardExclude) ? Pattern.compile(realWildcardExclude) : null;
                    fileList = this.includingSubFolders ? sourceFileOrFolder.findFiles(new FileSelector(){

                        public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                            return true;
                        }

                        public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                            boolean include;
                            if (fileInfo.getFile().getType().equals((Object)FileType.FILE)) {
                                String name;
                                include = true;
                                if (pattern != null) {
                                    name = fileInfo.getFile().getName().getPath();
                                    include = pattern.matcher(name).matches();
                                }
                                if (include && patternexclude != null) {
                                    name = fileInfo.getFile().getName().getPath();
                                    include = !pattern.matcher(name).matches();
                                }
                            } else {
                                include = false;
                            }
                            return include;
                        }
                    }) : sourceFileOrFolder.getChildren();
                } else {
                    pattern = null;
                    patternexclude = null;
                    fileList = new FileObject[]{sourceFileOrFolder};
                }
                if (fileList.length == 0) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.FolderIsEmpty", (String[])new String[]{localSourceFilename}));
                }
                if (!this.checkContainsFile(localSourceFilename, fileList, isSourceDirectory)) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.NoFilesInFolder", (String[])new String[]{localSourceFilename}));
                }
                if (this.ifZipFileExists == 0 && Fileexists) {
                    if (localrealZipfilename.toLowerCase().endsWith(".zip")) {
                        localrealZipfilename = localrealZipfilename.substring(0, localrealZipfilename.length() - 4);
                    }
                    localrealZipfilename = localrealZipfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + ".zip";
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileNameChange1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileNameChange1.Label", (String[])new String[0]));
                    }
                } else if (this.ifZipFileExists == 1 && Fileexists) {
                    fileZip = this.getFile(localrealZipfilename);
                    tempFile = File.createTempFile(fileZip.getName(), null);
                    tempFile.delete();
                    renameOk = fileZip.renameTo(tempFile);
                    if (!renameOk) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Rename_Temp1.Label", (String[])new String[0]) + fileZip.getAbsolutePath() + BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Rename_Temp2.Label", (String[])new String[0]) + tempFile.getAbsolutePath() + BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Rename_Temp3.Label", (String[])new String[0]));
                    }
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileAppend1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Zip_FileAppend2.Label", (String[])new String[0]));
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobZipFiles.Files_Found1.Label", (String[])new String[0]) + fileList.length + BaseMessages.getString(PKG, (String)"JobZipFiles.Files_Found2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Files_Found3.Label", (String[])new String[0]));
                }
                buffer = new byte[18024];
                dest = KettleVFS.getOutputStream((String)localrealZipfilename, (boolean)false);
                buff = new BufferedOutputStream(dest);
                out = new ZipOutputStream(buff);
                HashSet<String> fileSet = new HashSet<String>();
                if (renameOk) {
                    zin = new ZipInputStream(new FileInputStream(tempFile));
                    entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (!fileSet.contains(name)) {
                            int len;
                            out.putNextEntry(new ZipEntry(name));
                            while ((len = zin.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                            fileSet.add(name);
                        }
                        entry = zin.getNextEntry();
                    }
                    zin.close();
                }
                out.setMethod(8);
                if (this.compressionRate == 0) {
                    out.setLevel(0);
                } else if (this.compressionRate == 1) {
                    out.setLevel(-1);
                }
                if (this.compressionRate == 2) {
                    out.setLevel(9);
                }
                if (this.compressionRate == 3) {
                    out.setLevel(1);
                }
                FileObject[] zippedFiles = new FileObject[fileList.length];
                int fileNum = 0;
                for (i = 0; i < fileList.length && !parentJob.isStopped(); ++i) {
                    int len;
                    String relativeName;
                    FileObject file;
                    boolean isTargetDirectory;
                    boolean getIt = true;
                    boolean getItexclude = false;
                    if (isSourceDirectory) {
                        String filename = this.includingSubFolders ? fileList[i].getName().getPath() : fileList[i].getName().getBaseName();
                        if (pattern != null) {
                            Matcher matcher = pattern.matcher(filename);
                            getIt = matcher.matches();
                        }
                        if (patternexclude != null) {
                            Matcher matcherexclude = patternexclude.matcher(filename);
                            getItexclude = matcherexclude.matches();
                        }
                    }
                    String targetFilename = KettleVFS.getFilename((FileObject)fileList[i]);
                    if (sourceFileOrFolder.getType().equals((Object)FileType.FILE)) {
                        targetFilename = localSourceFilename;
                    }
                    boolean bl = isTargetDirectory = (file = KettleVFS.getFileObject((String)targetFilename)).exists() && file.getType().equals((Object)FileType.FOLDER);
                    if (!getIt || getItexclude || isTargetDirectory || fileSet.contains(targetFilename)) continue;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.Add_FilesToZip1.Label", (String[])new String[0]) + fileList[i] + BaseMessages.getString(PKG, (String)"JobZipFiles.Add_FilesToZip2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Add_FilesToZip3.Label", (String[])new String[0]));
                    }
                    InputStream in = KettleVFS.getInputStream((FileObject)file);
                    String fullName = fileList[i].getName().getPath();
                    String basePath = sourceFileOrFolder.getName().getPath();
                    if (isSourceDirectory) {
                        relativeName = fullName.startsWith(basePath) ? fullName.substring(basePath.length() + 1) : fullName;
                    } else if (this.isFromPrevious) {
                        int depth = this.determineDepth(this.environmentSubstitute(this.storedSourcePathDepth));
                        relativeName = this.determineZipfilenameForDepth(fullName, depth);
                    } else {
                        relativeName = fileList[i].getName().getBaseName();
                    }
                    out.putNextEntry(new ZipEntry(relativeName));
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    out.closeEntry();
                    in.close();
                    zippedFiles[fileNum] = fileList[i];
                    ++fileNum;
                }
                out.close();
                buff.close();
                dest.close();
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.TotalZippedFiles", (String[])new String[]{"" + zippedFiles.length}));
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (this.afterZip == 1 || this.afterZip == 2) {
                    for (i = 0; i < zippedFiles.length; ++i) {
                        if (zippedFiles[i] == null) continue;
                        FileObject fileObjectd = zippedFiles[i];
                        if (!isSourceDirectory) {
                            fileObjectd = KettleVFS.getFileObject((String)localSourceFilename);
                        }
                        if (this.afterZip == 1) {
                            boolean deleted = fileObjectd.delete();
                            if (!deleted) {
                                resultat = false;
                                this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Delete_File1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Delete_File2.Label", (String[])new String[0]));
                            }
                            if (!this.log.isDebug()) continue;
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.File_Deleted1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(PKG, (String)"JobZipFiles.File_Deleted2.Label", (String[])new String[0]));
                            continue;
                        }
                        if (this.afterZip != 2) continue;
                        FileObject fileObjectm = null;
                        try {
                            fileObjectm = KettleVFS.getFileObject((String)(realMovetodirectory + Const.FILE_SEPARATOR + fileObjectd.getName().getBaseName()));
                            fileObjectd.moveTo(fileObjectm);
                        }
                        catch (IOException e) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Move_File1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_Move_File2.Label", (String[])new String[0]) + e.getMessage());
                            resultat = false;
                        }
                        finally {
                            block100: {
                                try {
                                    if (fileObjectm != null) {
                                        fileObjectm.close();
                                    }
                                }
                                catch (Exception e) {
                                    if (fileObjectm == null) break block100;
                                    this.logError("Error closing file '" + fileObjectm.toString() + "'", e);
                                }
                            }
                        }
                        if (!this.log.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobZipFiles.File_Moved1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(PKG, (String)"JobZipFiles.File_Moved2.Label", (String[])new String[0]));
                    }
                }
                if (this.addFileToResult) {
                    ResultFile resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                }
                resultat = true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_CreateZipFile1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(PKG, (String)"JobZipFiles.Cant_CreateZipFile2.Label", (String[])new String[0]), e);
                resultat = false;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException ex) {
                        this.logError("Error closing file '" + fileObject.toString() + "'", ex);
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (buff != null) {
                        buff.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (zin != null) {
                        zin.close();
                    }
                    if (entry != null) {
                        entry = null;
                    }
                }
                catch (IOException ex) {
                    this.logError("Error closing zip file entry for file '" + originFile.toString() + "'", ex);
                }
            }
        } else {
            resultat = true;
            if (localrealZipfilename == null) {
                this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.No_ZipFile_Defined.Label", (String[])new String[0]));
            }
            if (!orginExist) {
                this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.No_FolderCible_Defined.Label", (String[])new String[]{localSourceFilename}));
            }
        }
        return resultat;
    }

    private int determineDepth(String depthString) throws KettleException {
        DecimalFormat df = new DecimalFormat("0");
        ParsePosition pp = new ParsePosition(0);
        df.setParseIntegerOnly(true);
        try {
            Number n = df.parse(depthString, pp);
            if (n == null) {
                return 1;
            }
            if (pp.getErrorIndex() == 0) {
                throw new KettleException("Unable to convert stored depth '" + depthString + "' to depth at position " + pp.getErrorIndex());
            }
            return n.intValue();
        }
        catch (Exception e) {
            throw new KettleException("Unable to convert stored depth '" + depthString + "' to depth", (Throwable)e);
        }
    }

    private String determineZipfilenameForDepth(String filename, int depth) throws KettleException {
        try {
            if (Const.isEmpty((String)filename)) {
                return null;
            }
            if (depth == 0) {
                return filename;
            }
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            FileObject folder = fileObject.getParent();
            String baseName = fileObject.getName().getBaseName();
            if (depth == 1) {
                return baseName;
            }
            StringBuilder path = new StringBuilder(baseName);
            for (int d = 1; d < depth && folder != null; folder = folder.getParent(), ++d) {
                path.insert(0, '/');
                path.insert(0, folder.getName().getBaseName());
            }
            return path.toString();
        }
        catch (Exception e) {
            throw new KettleException("Unable to get zip filename '" + filename + "' to depth " + depth, (Throwable)e);
        }
    }

    private File getFile(String filename) {
        try {
            String uri = KettleVFS.getFileObject((String)this.environmentSubstitute(filename)).getName().getPath();
            return new File(uri);
        }
        catch (KettleFileException ex) {
            this.logError("Error in Fetching URI for File: " + filename, ex);
            return new File(filename);
        }
    }

    private boolean checkContainsFile(String realSourceDirectoryOrFile, FileObject[] filelist, boolean isDirectory) throws FileSystemException {
        boolean retval = false;
        for (int i = 0; i < filelist.length; ++i) {
            FileObject file = filelist[i];
            if (!file.exists() || !file.getType().equals((Object)FileType.FILE)) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        String realZipfilename = null;
        String realWildcard = null;
        String realWildcardExclude = null;
        String realTargetdirectory = null;
        String realMovetodirectory = this.environmentSubstitute(this.movetoDirectory);
        boolean SanityControlOK = true;
        if (this.afterZip == 2) {
            if (Const.isEmpty((String)realMovetodirectory)) {
                SanityControlOK = false;
                this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
            } else {
                FileObject moveToDirectory = null;
                try {
                    moveToDirectory = KettleVFS.getFileObject((String)realMovetodirectory, (VariableSpace)this);
                    if (moveToDirectory.exists()) {
                        if (moveToDirectory.getType() == FileType.FOLDER) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.MoveToFolderExist", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            SanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.MoveToFolderNotFolder", (String[])new String[]{realMovetodirectory}));
                        }
                    } else {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                        if (this.createMoveToDirectory) {
                            moveToDirectory.createFolder();
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.MoveToFolderCreaterd", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            SanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                    }
                }
                catch (Exception e) {
                    SanityControlOK = false;
                    this.logError(BaseMessages.getString(PKG, (String)"JobZipFiles.ErrorGettingMoveToFolder.Label", (String[])new String[]{realMovetodirectory}), e);
                }
                finally {
                    if (moveToDirectory != null) {
                        realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                        try {
                            moveToDirectory.close();
                            moveToDirectory = null;
                        }
                        catch (Exception e) {
                            this.logError("Error moving to directory", e);
                            result.setResult(false);
                            result.setNrErrors(1L);
                        }
                    }
                }
            }
        }
        if (!SanityControlOK) {
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        if (this.isFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobZipFiles.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.isFromPrevious && rows != null) {
            try {
                for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                    realTargetdirectory = resultRow.getString(0, null);
                    if (!Const.isEmpty((String)realTargetdirectory)) {
                        if (!Const.isEmpty((String)resultRow.getString(1, null))) {
                            realWildcard = resultRow.getString(1, null);
                        }
                        if (!Const.isEmpty((String)resultRow.getString(2, null))) {
                            realWildcardExclude = resultRow.getString(2, null);
                        }
                        if (!Const.isEmpty((String)(realZipfilename = resultRow.getString(3, null)))) {
                            if (this.processRowFile(this.parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createParentFolder)) continue;
                            result.setResult(false);
                            return result;
                        }
                        this.logError("destination zip filename is empty! Ignoring row...");
                        continue;
                    }
                    this.logError("Target directory is empty! Ignoring row...");
                }
            }
            catch (Exception e) {
                this.logError("Erreur during process!", e);
                result.setResult(false);
                result.setNrErrors(1L);
            }
        } else if (!this.isFromPrevious) {
            if (!Const.isEmpty((String)this.sourceDirectory)) {
                realZipfilename = this.getFullFilename(this.environmentSubstitute(this.zipFilename), this.addDate, this.addTime, this.specifyFormat, this.dateTimeFormat);
                realWildcard = this.environmentSubstitute(this.wildCard);
                realWildcardExclude = this.environmentSubstitute(this.excludeWildCard);
                realTargetdirectory = this.environmentSubstitute(this.sourceDirectory);
                result.setResult(this.processRowFile(this.parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createParentFolder));
            } else {
                this.logError("Source folder/file is empty! Ignoring row...");
            }
        }
        return result;
    }

    public String getFullFilename(String filename, boolean add_date, boolean add_time, boolean specify_format, String datetime_folder) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        String realfilename = this.environmentSubstitute(filename);
        int lenstring = realfilename.length();
        int lastindexOfDot = realfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = realfilename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (specify_format && !Const.isEmpty((String)datetime_folder)) {
            daf.applyPattern(datetime_folder);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (add_date) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (add_time) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + realfilename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildCard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.excludeWildCard = wildcardexclude;
    }

    public void setSourceDirectory(String sourcedirectory) {
        this.sourceDirectory = sourcedirectory;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetoDirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getMoveToDirectory() {
        return this.movetoDirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public String getWildcard() {
        return this.wildCard;
    }

    public String getWildcardExclude() {
        return this.excludeWildCard;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addFileToResult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    public void setcreateparentfolder(boolean createparentfolder) {
        this.createParentFolder = createparentfolder;
    }

    public void setDateInFilename(boolean adddate) {
        this.addDate = adddate;
    }

    public boolean isDateInFilename() {
        return this.addDate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addTime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addTime;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.specifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.dateTimeFormat = date_time_format;
    }

    public boolean getcreateparentfolder() {
        return this.createParentFolder;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isFromPrevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isFromPrevious;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx1, this.getVariables());
        AndValidator.putValidators(ctx1, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        if (3 == this.ifZipFileExists) {
            FileDoesNotExistValidator.putFailIfExists(ctx1, true);
        }
        JobEntryValidatorUtils.andValidator().validate(this, "zipFilename", remarks, ctx1);
        if (2 == this.afterZip) {
            JobEntryValidatorUtils.andValidator().validate(this, "moveToDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "sourceDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    public boolean isIncludingSubFolders() {
        return this.includingSubFolders;
    }

    public void setIncludingSubFolders(boolean includesSubFolders) {
        this.includingSubFolders = includesSubFolders;
    }

    public String getStoredSourcePathDepth() {
        return this.storedSourcePathDepth;
    }

    public void setStoredSourcePathDepth(String storedSourcePathDepth) {
        this.storedSourcePathDepth = storedSourcePathDepth;
    }
}

