/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mssqlbulkload;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryMssqlBulkLoad
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryMssqlBulkLoad.class;
    private String schemaname = null;
    private String tablename = null;
    private String filename = null;
    private String datafiletype = "char";
    private String fieldterminator = null;
    private String lineterminated = null;
    private String codepage = "OEM";
    private String specificcodepage = null;
    private int startfile = 0;
    private int endfile = 0;
    private String orderby = null;
    private boolean addfiletoresult = false;
    private String formatfilename = null;
    private boolean firetriggers = false;
    private boolean checkconstraints = false;
    private boolean keepnulls = false;
    private boolean tablock = false;
    private String errorfilename = null;
    private boolean adddatetime = false;
    private String orderdirection = "Asc";
    private int maxerrors = 0;
    private int batchsize = 0;
    private int rowsperbatch = 0;
    private boolean keepidentity = false;
    private boolean truncate = false;
    private DatabaseMeta connection = null;

    public JobEntryMssqlBulkLoad(String n) {
        super(n, "");
    }

    public JobEntryMssqlBulkLoad() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryMssqlBulkLoad je = (JobEntryMssqlBulkLoad)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"datafiletype", (String)this.datafiletype));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fieldterminator", (String)this.fieldterminator));
        retval.append("      ").append(XMLHandler.addTagValue((String)"lineterminated", (String)this.lineterminated));
        retval.append("      ").append(XMLHandler.addTagValue((String)"codepage", (String)this.codepage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"specificcodepage", (String)this.specificcodepage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"formatfilename", (String)this.formatfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"firetriggers", (boolean)this.firetriggers));
        retval.append("      ").append(XMLHandler.addTagValue((String)"checkconstraints", (boolean)this.checkconstraints));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keepnulls", (boolean)this.keepnulls));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keepidentity", (boolean)this.keepidentity));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablock", (boolean)this.tablock));
        retval.append("      ").append(XMLHandler.addTagValue((String)"startfile", (int)this.startfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"endfile", (int)this.endfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"orderby", (String)this.orderby));
        retval.append("      ").append(XMLHandler.addTagValue((String)"orderdirection", (String)this.orderdirection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxerrors", (int)this.maxerrors));
        retval.append("      ").append(XMLHandler.addTagValue((String)"batchsize", (int)this.batchsize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rowsperbatch", (int)this.rowsperbatch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"errorfilename", (String)this.errorfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddatetime", (boolean)this.adddatetime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"truncate", (boolean)this.truncate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.datafiletype = XMLHandler.getTagValue((Node)entrynode, (String)"datafiletype");
            this.fieldterminator = XMLHandler.getTagValue((Node)entrynode, (String)"fieldterminator");
            this.lineterminated = XMLHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.codepage = XMLHandler.getTagValue((Node)entrynode, (String)"codepage");
            this.specificcodepage = XMLHandler.getTagValue((Node)entrynode, (String)"specificcodepage");
            this.formatfilename = XMLHandler.getTagValue((Node)entrynode, (String)"formatfilename");
            this.firetriggers = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"firetriggers"));
            this.checkconstraints = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"checkconstraints"));
            this.keepnulls = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"keepnulls"));
            this.keepidentity = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"keepidentity"));
            this.tablock = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"tablock"));
            this.startfile = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"startfile"), (int)0);
            this.endfile = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"endfile"), (int)0);
            this.orderby = XMLHandler.getTagValue((Node)entrynode, (String)"orderby");
            this.orderdirection = XMLHandler.getTagValue((Node)entrynode, (String)"orderdirection");
            this.errorfilename = XMLHandler.getTagValue((Node)entrynode, (String)"errorfilename");
            this.maxerrors = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"maxerrors"), (int)0);
            this.batchsize = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"batchsize"), (int)0);
            this.rowsperbatch = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"rowsperbatch"), (int)0);
            this.adddatetime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddatetime"));
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.truncate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"truncate"));
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'MSsql bulk load' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.datafiletype = rep.getJobEntryAttributeString(id_jobentry, "datafiletype");
            this.fieldterminator = rep.getJobEntryAttributeString(id_jobentry, "fieldterminator");
            this.lineterminated = rep.getJobEntryAttributeString(id_jobentry, "lineterminated");
            this.codepage = rep.getJobEntryAttributeString(id_jobentry, "codepage");
            this.specificcodepage = rep.getJobEntryAttributeString(id_jobentry, "specificcodepage");
            this.formatfilename = rep.getJobEntryAttributeString(id_jobentry, "formatfilename");
            this.firetriggers = rep.getJobEntryAttributeBoolean(id_jobentry, "firetriggers");
            this.checkconstraints = rep.getJobEntryAttributeBoolean(id_jobentry, "checkconstraints");
            this.keepnulls = rep.getJobEntryAttributeBoolean(id_jobentry, "keepnulls");
            this.keepidentity = rep.getJobEntryAttributeBoolean(id_jobentry, "keepidentity");
            this.tablock = rep.getJobEntryAttributeBoolean(id_jobentry, "tablock");
            this.startfile = (int)rep.getJobEntryAttributeInteger(id_jobentry, "startfile");
            this.endfile = (int)rep.getJobEntryAttributeInteger(id_jobentry, "endfile");
            this.orderby = rep.getJobEntryAttributeString(id_jobentry, "orderby");
            this.orderdirection = rep.getJobEntryAttributeString(id_jobentry, "orderdirection");
            this.errorfilename = rep.getJobEntryAttributeString(id_jobentry, "errorfilename");
            this.maxerrors = (int)rep.getJobEntryAttributeInteger(id_jobentry, "maxerrors");
            this.batchsize = (int)rep.getJobEntryAttributeInteger(id_jobentry, "batchsize");
            this.rowsperbatch = (int)rep.getJobEntryAttributeInteger(id_jobentry, "rowsperbatch");
            this.adddatetime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddatetime");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.truncate = rep.getJobEntryAttributeBoolean(id_jobentry, "truncate");
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'MSsql bulk load' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "datafiletype", this.datafiletype);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fieldterminator", this.fieldterminator);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "lineterminated", this.lineterminated);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "codepage", this.codepage);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specificcodepage", this.specificcodepage);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "formatfilename", this.formatfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "firetriggers", this.firetriggers);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "checkconstraints", this.checkconstraints);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keepnulls", this.keepnulls);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keepidentity", this.keepidentity);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablock", this.tablock);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "startfile", this.startfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "endfile", this.endfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "orderby", this.orderby);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "orderdirection", this.orderdirection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "errorfilename", this.errorfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maxerrors", this.maxerrors);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "batchsize", this.batchsize);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "rowsperbatch", this.rowsperbatch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddatetime", this.adddatetime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "truncate", this.truncate);
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'MSsql Bulk Load' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setMaxErrors(int maxerrors) {
        this.maxerrors = maxerrors;
    }

    public int getMaxErrors() {
        return this.maxerrors;
    }

    public int getBatchSize() {
        return this.batchsize;
    }

    public void setBatchSize(int batchsize) {
        this.batchsize = batchsize;
    }

    public int getRowsPerBatch() {
        return this.rowsperbatch;
    }

    public void setRowsPerBatch(int rowsperbatch) {
        this.rowsperbatch = rowsperbatch;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        TakeFirstNbrLines = "";
        LineTerminatedby = "";
        FieldTerminatedby = "";
        useFieldSeparator = false;
        UseCodepage = "";
        ErrorfileName = "";
        result = previousResult;
        result.setResult(false);
        vfsFilename = this.environmentSubstitute(this.filename);
        fileObject = null;
        if (Const.isEmpty((String)vfsFilename)) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Nofilename.Label", (String[])new String[0]));
            return result;
        }
        try {
            block68: {
                block69: {
                    block67: {
                        fileObject = KettleVFS.getFileObject((String)vfsFilename, (VariableSpace)this);
                        if (!(fileObject instanceof LocalFile)) {
                            throw new KettleException(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.OnlyLocalFileSupported", (String[])new String[]{vfsFilename}));
                        }
                        realFilename = KettleVFS.getFilename((FileObject)fileObject);
                        file = new File(realFilename);
                        if (!file.exists() || !file.canRead()) break block68;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.FileExists.Label", (String[])new String[]{realFilename}));
                        }
                        if (this.connection == null) {
                            result.setNrErrors(1L);
                            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Nodatabase.Label", (String[])new String[0]));
                            return result;
                        }
                        db = new Database((LoggingObjectInterface)this, this.connection);
                        if (!(db.getDatabaseMeta().getDatabaseInterface() instanceof MSSQLServerDatabaseMeta)) {
                            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.DbNotMSSQL", (String[])new String[]{this.connection.getDatabaseName()}));
                            var15_18 = result;
                            return var15_18;
                        }
                        db.shareVariablesWith((VariableSpace)this);
                        try {
                            db.connect(this.parentJob.getTransactionId(), null);
                            realSchemaname = this.environmentSubstitute(this.schemaname);
                            realTablename = this.environmentSubstitute(this.tablename);
                            if (this.schemaname != null) {
                                realTablename = realSchemaname + "." + realTablename;
                            }
                            if (db.checkTableExists(realTablename)) {
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.TableExists.Label", (String[])new String[]{realTablename}));
                                }
                                if (Const.isEmpty((String)(Fieldterminator = this.getRealFieldTerminator())) && (this.datafiletype.equals("char") || this.datafiletype.equals("widechar"))) {
                                    this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.FieldTerminatorMissing", (String[])new String[0]));
                                    var18_24 = result;
                                    return var18_24;
                                }
                                if (this.datafiletype.equals("char") || this.datafiletype.equals("widechar")) {
                                    useFieldSeparator = true;
                                    FieldTerminatedby = "FIELDTERMINATOR='" + Fieldterminator + "'";
                                }
                                if (!this.codepage.equals("Specific")) break block67;
                            }
                            ** GOTO lbl150
                        }
                        catch (KettleDatabaseException dbe) {
                            db.disconnect();
                            result.setNrErrors(1L);
                            this.logError("An error occurred executing this entry: " + dbe.getMessage());
                            return result;
                        }
                        realCodePage = this.environmentSubstitute(this.codepage);
                        if (this.specificcodepage.length() < 0) {
                            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.SpecificCodePageMissing", (String[])new String[0]));
                            e = result;
                            return e;
                        }
                        UseCodepage = "CODEPAGE = '" + realCodePage + "'";
                        break block69;
                    }
                    UseCodepage = "CODEPAGE = '" + this.codepage + "'";
                }
                realErrorFile = this.environmentSubstitute(this.errorfilename);
                if (realErrorFile == null) ** GOTO lbl83
                errorfile = new File(realErrorFile);
                if (!errorfile.exists() || this.adddatetime) ** GOTO lbl-1000
                this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.ErrorFileExists", (String[])new String[0]));
                e = result;
                return e;
lbl-1000:
                // 1 sources

                {
                    if (this.adddatetime) {
                        daf = new SimpleDateFormat();
                        now = new Date();
                        daf.applyPattern("yyyMMdd_HHmmss");
                        d = daf.format(now);
                        ErrorfileName = "ERRORFILE ='" + realErrorFile + "_" + d + "'";
                    } else {
                        ErrorfileName = "ERRORFILE ='" + realErrorFile + "'";
                    }
lbl83:
                    // 3 sources

                    if (!Const.isEmpty((String)(Rowterminator = this.getRealLineterminated()))) {
                        LineTerminatedby = "ROWTERMINATOR='" + Rowterminator + "'";
                    }
                    if (this.startfile > 0) {
                        TakeFirstNbrLines = "FIRSTROW=" + this.startfile;
                    }
                    if (this.endfile > 0) {
                        TakeFirstNbrLines = "LASTROW=" + this.endfile;
                    }
                    SQLBULKLOAD = "";
                    if (this.truncate) {
                        SQLBULKLOAD = "TRUNCATE TABLE " + realTablename + ";";
                    }
                    SQLBULKLOAD = SQLBULKLOAD + "BULK INSERT " + realTablename + " FROM " + "'" + realFilename.replace('\\', '/') + "'";
                    SQLBULKLOAD = SQLBULKLOAD + " WITH (";
                    SQLBULKLOAD = useFieldSeparator != false ? SQLBULKLOAD + FieldTerminatedby : SQLBULKLOAD + "DATAFILETYPE ='" + this.datafiletype + "'";
                    if (LineTerminatedby.length() > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + "," + LineTerminatedby;
                    }
                    if (TakeFirstNbrLines.length() > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + "," + TakeFirstNbrLines;
                    }
                    if (UseCodepage.length() > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + "," + UseCodepage;
                    }
                    if ((realFormatFile = this.environmentSubstitute(this.formatfilename)) != null) {
                        SQLBULKLOAD = SQLBULKLOAD + ", FORMATFILE='" + realFormatFile + "'";
                    }
                    if (this.firetriggers) {
                        SQLBULKLOAD = SQLBULKLOAD + ",FIRE_TRIGGERS";
                    }
                    if (this.keepnulls) {
                        SQLBULKLOAD = SQLBULKLOAD + ",KEEPNULLS";
                    }
                    if (this.keepidentity) {
                        SQLBULKLOAD = SQLBULKLOAD + ",KEEPIDENTITY";
                    }
                    if (this.checkconstraints) {
                        SQLBULKLOAD = SQLBULKLOAD + ",CHECK_CONSTRAINTS";
                    }
                    if (this.tablock) {
                        SQLBULKLOAD = SQLBULKLOAD + ",TABLOCK";
                    }
                    if (this.orderby != null) {
                        SQLBULKLOAD = SQLBULKLOAD + ",ORDER ( " + this.orderby + " " + this.orderdirection + ")";
                    }
                    if (ErrorfileName.length() > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + ", " + ErrorfileName;
                    }
                    if (this.maxerrors > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + ", MAXERRORS=" + this.maxerrors;
                    }
                    if (this.batchsize > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + ", BATCHSIZE=" + this.batchsize;
                    }
                    if (this.rowsperbatch > 0) {
                        SQLBULKLOAD = SQLBULKLOAD + ", ROWS_PER_BATCH=" + this.rowsperbatch;
                    }
                    SQLBULKLOAD = SQLBULKLOAD + ")";
                    try {
                        db.execStatement(SQLBULKLOAD);
                        db.disconnect();
                        if (this.isAddFileToResult()) {
                            resultFile = new ResultFile(0, KettleVFS.getFileObject((String)realFilename, (VariableSpace)this), this.parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        result.setResult(true);
                        return result;
                    }
                    catch (KettleDatabaseException je) {
                        result.setNrErrors(1L);
                        this.logError("An error occurred executing this job entry : " + je.getMessage(), je);
                        return result;
                    }
                    catch (KettleFileException e) {
                        this.logError("An error occurred executing this job entry : " + e.getMessage(), e);
                        result.setNrErrors(1L);
                        return result;
                    }
                    finally {
                        if (db != null) {
                            db.disconnect();
                            db = null;
                        }
                    }
lbl150:
                    // 1 sources

                    db.disconnect();
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.TableNotExists", (String[])new String[]{realTablename}));
                    return result;
                }
            }
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.Error.FileNotExists", (String[])new String[]{realFilename}));
            return result;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(JobEntryMssqlBulkLoad.PKG, (String)"JobMssqlBulkLoad.UnexpectedError.Label", (String[])new String[0]), e);
            return result;
        }
        finally {
            try {
                if (fileObject != null) {
                    fileObject.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFieldTerminator(String fieldterminator) {
        this.fieldterminator = fieldterminator;
    }

    public void setLineterminated(String lineterminated) {
        this.lineterminated = lineterminated;
    }

    public void setCodePage(String codepage) {
        this.codepage = codepage;
    }

    public String getCodePage() {
        return this.codepage;
    }

    public void setSpecificCodePage(String specificcodepage) {
        this.specificcodepage = specificcodepage;
    }

    public String getSpecificCodePage() {
        return this.specificcodepage;
    }

    public void setFormatFilename(String formatfilename) {
        this.formatfilename = formatfilename;
    }

    public String getFormatFilename() {
        return this.formatfilename;
    }

    public String getFieldTerminator() {
        return this.fieldterminator;
    }

    public String getLineterminated() {
        return this.lineterminated;
    }

    public String getDataFileType() {
        return this.datafiletype;
    }

    public void setDataFileType(String datafiletype) {
        this.datafiletype = datafiletype;
    }

    public String getRealLineterminated() {
        return this.environmentSubstitute(this.getLineterminated());
    }

    public String getRealFieldTerminator() {
        return this.environmentSubstitute(this.getFieldTerminator());
    }

    public void setStartFile(int startfile) {
        this.startfile = startfile;
    }

    public int getStartFile() {
        return this.startfile;
    }

    public void setEndFile(int endfile) {
        this.endfile = endfile;
    }

    public int getEndFile() {
        return this.endfile;
    }

    public void setOrderBy(String orderby) {
        this.orderby = orderby;
    }

    public String getOrderBy() {
        return this.orderby;
    }

    public String getOrderDirection() {
        return this.orderdirection;
    }

    public void setOrderDirection(String orderdirection) {
        this.orderdirection = orderdirection;
    }

    public void setErrorFilename(String errorfilename) {
        this.errorfilename = errorfilename;
    }

    public String getErrorFilename() {
        return this.errorfilename;
    }

    public String getRealOrderBy() {
        return this.environmentSubstitute(this.getOrderBy());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setAddDatetime(boolean adddatetime) {
        this.adddatetime = adddatetime;
    }

    public boolean isAddDatetime() {
        return this.adddatetime;
    }

    public void setFireTriggers(boolean firetriggers) {
        this.firetriggers = firetriggers;
    }

    public boolean isFireTriggers() {
        return this.firetriggers;
    }

    public void setCheckConstraints(boolean checkconstraints) {
        this.checkconstraints = checkconstraints;
    }

    public boolean isCheckConstraints() {
        return this.checkconstraints;
    }

    public void setKeepNulls(boolean keepnulls) {
        this.keepnulls = keepnulls;
    }

    public boolean isKeepNulls() {
        return this.keepnulls;
    }

    public void setKeepIdentity(boolean keepidentity) {
        this.keepidentity = keepidentity;
    }

    public boolean isKeepIdentity() {
        return this.keepidentity;
    }

    public void setTablock(boolean tablock) {
        this.tablock = tablock;
    }

    public boolean isTablock() {
        return this.tablock;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        ResourceReference reference = null;
        if (this.connection != null) {
            reference = new ResourceReference(this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference(this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

