/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.TypeFieldDefinition;

public class MetaGenerator {
    public static final TypeFieldDefinition[] FIELDS = new TypeFieldDefinition[]{new TypeFieldDefinition(4, "UsingLines"), new TypeFieldDefinition(5, "MaxNumberOfSuggestions"), new TypeFieldDefinition(2, "NameField"), new TypeFieldDefinition(2, "OrganizationField"), new TypeFieldDefinition(2, "DepartmentField"), new TypeFieldDefinition(2, "PostBoxField"), new TypeFieldDefinition(2, "SubPremiseField"), new TypeFieldDefinition(2, "PremiseField"), new TypeFieldDefinition(2, "HouseNumberField"), new TypeFieldDefinition(2, "HouseNumberAdditionField"), new TypeFieldDefinition(2, "DependentThoroughfareField"), new TypeFieldDefinition(2, "ThoroughfareField"), new TypeFieldDefinition(2, "DependentLocalityField"), new TypeFieldDefinition(2, "LocalityField"), new TypeFieldDefinition(2, "PostTownField"), new TypeFieldDefinition(2, "DeliveryServiceQualifierField"), new TypeFieldDefinition(2, "PostalCodeField"), new TypeFieldDefinition(2, "SubAdministrativeAreaField"), new TypeFieldDefinition(2, "AdministrativeAreaField"), new TypeFieldDefinition(2, "CountryNameField"), new TypeFieldDefinition(2, "CountryCodeField")};
    private TypeFieldDefinition[] fields;

    public MetaGenerator(TypeFieldDefinition[] fields) {
        this.fields = fields;
    }

    public String generateCode() {
        StringBuilder code = new StringBuilder(5000);
        for (TypeFieldDefinition field : this.fields) {
            code.append("  private " + field.getTypeDescription() + " " + field.getMemberName() + ";").append(Const.CR);
        }
        code.append(Const.CR);
        code.append("  public String getXML() throws KettleException {").append(Const.CR);
        code.append("    StringBuilder xml = new StringBuilder(100);").append(Const.CR);
        for (TypeFieldDefinition field : this.fields) {
            code.append("    xml.append(XMLHandler.addTagValue(\"" + field.getFieldName() + "\", " + field.getMemberName() + "));").append(Const.CR);
        }
        code.append("    return xml.toString();").append(Const.CR);
        code.append("  }").append(Const.CR);
        code.append(Const.CR);
        code.append("  public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {").append(Const.CR);
        block15: for (TypeFieldDefinition field : this.fields) {
            switch (field.getType()) {
                case 2: {
                    code.append("    " + field.getMemberName() + " = XMLHandler.getTagValue(stepnode, \"" + field.getFieldName() + "\");").append(Const.CR);
                    continue block15;
                }
                case 4: {
                    code.append("    " + field.getMemberName() + " = \"Y\".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, \"" + field.getFieldName() + "\"));").append(Const.CR);
                    continue block15;
                }
                case 5: {
                    code.append("    " + field.getMemberName() + " = Const.toInt(XMLHandler.getTagValue(stepnode, \"" + field.getFieldName() + "\"), -1);").append(Const.CR);
                    continue block15;
                }
            }
        }
        code.append("  }").append(Const.CR);
        code.append(Const.CR);
        code.append("  public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {").append(Const.CR);
        for (TypeFieldDefinition field : this.fields) {
            code.append("    rep.saveStepAttribute(id_transformation, id_step, \"" + field.getFieldName() + "\", " + field.getMemberName() + ");").append(Const.CR);
        }
        code.append("  }").append(Const.CR);
        code.append(Const.CR);
        code.append("  public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {").append(Const.CR);
        block17: for (TypeFieldDefinition field : this.fields) {
            switch (field.getType()) {
                case 2: {
                    code.append("    " + field.getMemberName() + " = rep.getStepAttributeString(id_step, \"" + field.getFieldName() + "\");").append(Const.CR);
                    continue block17;
                }
                case 4: {
                    code.append("    " + field.getMemberName() + " = rep.getStepAttributeBoolean(id_step, \"" + field.getFieldName() + "\");").append(Const.CR);
                    continue block17;
                }
                case 5: {
                    code.append("    " + field.getMemberName() + " = (int) rep.getStepAttributeInteger(id_step, \"" + field.getFieldName() + "\");").append(Const.CR);
                    continue block17;
                }
            }
        }
        code.append("  }").append(Const.CR);
        code.append(Const.CR);
        for (TypeFieldDefinition field : this.fields) {
            String setPrefix;
            String getPrefix;
            switch (field.getType()) {
                case 4: {
                    getPrefix = "is";
                    setPrefix = "set";
                    break;
                }
                default: {
                    getPrefix = "get";
                    setPrefix = "set";
                }
            }
            code.append("  public " + field.getTypeDescription() + " " + getPrefix + field.getFieldName() + "() {").append(Const.CR);
            code.append("    return " + field.getMemberName() + ";").append(Const.CR);
            code.append("  }").append(Const.CR);
            code.append(Const.CR);
            code.append("  public void " + setPrefix + field.getFieldName() + "(" + field.getTypeDescription() + " " + field.getMemberName() + ") {").append(Const.CR);
            code.append("    this." + field.getMemberName() + " = " + field.getMemberName() + ";").append(Const.CR);
            code.append("  }").append(Const.CR);
            code.append(Const.CR);
        }
        for (TypeFieldDefinition field : this.fields) {
            code.append("  " + field.getMemberName() + "Item = new TableItem(wInputFields.table, SWT.NONE);").append(Const.CR);
            code.append("  " + field.getMemberName() + "Item.setText(1, BaseMessages.getString(PKG, \"PIQAddressDialog." + field.getFieldName() + ".Description\"));").append(Const.CR);
            code.append("  " + field.getMemberName() + "Item.setText(2, Const.NVL(input.get" + field.getFieldName() + "(), \"\"));").append(Const.CR);
        }
        for (TypeFieldDefinition field : this.fields) {
            code.append("PIQAddressDialog." + field.getFieldName() + ".Description = " + field.getFieldName()).append(" DESCRIPTION TODO").append(Const.CR);
        }
        return code.toString();
    }

    public static void main(String[] args) {
        MetaGenerator generator = new MetaGenerator(FIELDS);
        System.out.println(generator.generateCode());
    }
}

