/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleSupport;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.i18n.BaseMessages;

public class KettleLifecycleSupport {
    private static Class<?> PKG = Const.class;
    @VisibleForTesting
    protected static PluginRegistry registry = PluginRegistry.getInstance();
    private ConcurrentMap<KettleLifecycleListener, Boolean> kettleLifecycleListeners;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public KettleLifecycleSupport() {
        Set<KettleLifecycleListener> listeners = LifecycleSupport.loadPlugins(KettleLifecyclePluginType.class, KettleLifecycleListener.class);
        this.kettleLifecycleListeners = new ConcurrentHashMap<KettleLifecycleListener, Boolean>();
        for (KettleLifecycleListener kll : listeners) {
            this.kettleLifecycleListeners.put(kll, false);
        }
        registry.addPluginListener(KettleLifecyclePluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                KettleLifecycleListener listener = null;
                try {
                    listener = (KettleLifecycleListener)registry.loadClass((PluginInterface)serviceObject);
                }
                catch (KettlePluginException e) {
                    e.printStackTrace();
                    return;
                }
                KettleLifecycleSupport.this.kettleLifecycleListeners.put(listener, false);
                if (KettleLifecycleSupport.this.initialized.get()) {
                    try {
                        KettleLifecycleSupport.this.onEnvironmentInit(listener);
                    }
                    catch (Throwable e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            }

            public void pluginRemoved(Object serviceObject) {
                KettleLifecycleSupport.this.kettleLifecycleListeners.remove(serviceObject);
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public void onEnvironmentInit() throws KettleException {
        if (this.initialized.compareAndSet(false, true)) {
            for (KettleLifecycleListener listener : this.kettleLifecycleListeners.keySet()) {
                this.onEnvironmentInit(listener);
            }
        }
    }

    private void onEnvironmentInit(KettleLifecycleListener listener) throws KettleException {
        if (this.kettleLifecycleListeners.replace(listener, false, true)) {
            try {
                listener.onEnvironmentInit();
            }
            catch (LifecycleException ex) {
                String message = BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener});
                if (ex.isSevere()) {
                    throw new KettleException(message, (Throwable)ex);
                }
                LogChannel.GENERAL.logError(message, (Throwable)ex);
            }
            catch (Throwable t) {
                Throwables.propagateIfPossible((Throwable)t, KettleException.class);
                String message = BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener});
                throw new KettleException(message, t);
            }
        }
    }

    public void onEnvironmentShutdown() {
        for (KettleLifecycleListener listener : this.kettleLifecycleListeners.keySet()) {
            try {
                listener.onEnvironmentShutdown();
            }
            catch (Throwable t) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener}), t);
            }
        }
    }
}

