/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;

public class StreamLogger
implements Runnable {
    private InputStream is;
    private String type;
    private LogChannelInterface log;
    private Boolean errorStream;
    private String lastLine;

    public StreamLogger(LogChannelInterface log, InputStream is, String type) {
        this(log, is, type, false);
    }

    public StreamLogger(LogChannelInterface log, InputStream is, String type, Boolean errorStream) {
        this.log = log;
        this.is = is;
        this.type = type;
        this.errorStream = errorStream;
    }

    @Override
    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                this.lastLine = line;
                if (this.errorStream.booleanValue()) {
                    this.log.logError(this.type + " " + line);
                    continue;
                }
                this.log.logBasic(this.type + " " + line);
            }
        }
        catch (IOException ioe) {
            this.log.logError(this.type + " " + Const.getStackTracker(ioe));
        }
    }

    public String getLastLine() {
        return this.lastLine;
    }
}

