/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlTemplateDigesterFactory;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JRXmlTemplateLoader {
    private static final Log log = LogFactory.getLog(JRXmlTemplateLoader.class);
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND = "xml.template.loader.template.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_PARSING_ERROR = "xml.template.loader.template.parsing.error";
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_READING_ERROR = "xml.template.loader.template.reading.error";
    public static final String EXCEPTION_MESSAGE_KEY_URL_CONNECTION_ERROR = "xml.template.loader.url.connection.error";
    private RepositoryContext repositoryContext;

    private JRXmlTemplateLoader(RepositoryContext repositoryContext) {
        this.repositoryContext = repositoryContext;
    }

    private static JRXmlTemplateLoader getDefaultInstance() {
        return JRXmlTemplateLoader.getInstance(DefaultJasperReportsContext.getInstance());
    }

    public static JRXmlTemplateLoader getInstance(JasperReportsContext jasperReportsContext) {
        return JRXmlTemplateLoader.getInstance(SimpleRepositoryContext.of(jasperReportsContext));
    }

    public static JRXmlTemplateLoader getInstance(RepositoryContext repositoryContext) {
        return new JRXmlTemplateLoader(repositoryContext);
    }

    public JRTemplate loadTemplate(String location) throws JRException {
        byte[] data = RepositoryUtil.getInstance(this.repositoryContext).getBytesFromLocation(location);
        return JRXmlTemplateLoader.load(new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRTemplate loadTemplate(File file) {
        BufferedInputStream fileIn;
        try {
            fileIn = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND, null, e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(fileIn);
            return jRTemplate;
        }
        finally {
            try {
                fileIn.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing XML file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRTemplate loadTemplate(URL url) {
        InputStream input;
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_URL_CONNECTION_ERROR, new Object[]{url}, e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(input);
            return jRTemplate;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.warn((Object)("Error closing connection to template URL " + url), (Throwable)e);
            }
        }
    }

    public JRTemplate loadTemplate(InputStream data) {
        JRXmlDigester digester = JRXmlTemplateDigesterFactory.instance().createDigester(this.repositoryContext.getJasperReportsContext());
        try {
            return (JRTemplate)digester.parse(data);
        }
        catch (IOException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TEMPLATE_READING_ERROR, null, e);
        }
        catch (SAXException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TEMPLATE_PARSING_ERROR, null, e);
        }
    }

    public static JRTemplate load(String location) throws JRException {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(location);
    }

    public static JRTemplate load(File file) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(file);
    }

    public static JRTemplate load(URL url) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(url);
    }

    public static JRTemplate load(InputStream data) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(data);
    }
}

