/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderInfo;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderStyle;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.StyleUtil;

public class XlsxBorderHelper
extends BaseHelper {
    private Map<XlsxBorderInfo, Integer> borderCache = new HashMap<XlsxBorderInfo, Integer>();

    public XlsxBorderHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public int getBorder(JRExporterGridCell gridCell, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction) {
        if (gridCell == null) {
            return -1;
        }
        return this.getBorder(gridCell.getBox(), sheetInfo, direction);
    }

    public int getBorder(JRPrintElement element, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction, JRStyle parentStyle) {
        if (Boolean.TRUE.equals(sheetInfo.ignoreCellBorder)) {
            return -1;
        }
        JRLineBox box = null;
        if (element instanceof JRBoxContainer && ((JRBoxContainer)((Object)element)).getLineBox() != null) {
            box = new JRBaseLineBox(null);
            if (parentStyle != null && parentStyle.getLineBox() != null) {
                StyleUtil.appendBox(box, parentStyle.getLineBox());
            }
            if (element.getStyle() != null && element.getStyle().getLineBox() != null) {
                StyleUtil.appendBox(box, element.getStyle().getLineBox());
            }
            StyleUtil.appendBox(box, ((JRBoxContainer)((Object)element)).getLineBox());
        } else {
            box = element == null || element.getStyle() == null ? (parentStyle == null ? null : parentStyle.getLineBox()) : element.getStyle().getLineBox();
        }
        return this.getBorder(box, sheetInfo, direction);
    }

    public int getBorder(JRLineBox box, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction, JRStyle parentStyle) {
        if (Boolean.TRUE.equals(sheetInfo.ignoreCellBorder)) {
            return -1;
        }
        if (box == null && parentStyle != null) {
            box = parentStyle.getLineBox();
        }
        return this.getBorder(box, sheetInfo, direction);
    }

    private int getBorder(JRLineBox box, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction) {
        if (box == null) {
            return -1;
        }
        XlsxBorderInfo borderInfo = new XlsxBorderInfo(box, direction);
        Integer borderIndex = this.borderCache.get(borderInfo);
        if (borderIndex == null) {
            borderIndex = this.borderCache.size();
            this.export(borderInfo);
            this.borderCache.put(borderInfo, borderIndex);
        }
        return borderIndex;
    }

    public void export(JRLineBox box) {
        if (box != null) {
            this.export(new XlsxBorderInfo(box));
        }
    }

    public void export(JRPen pen) {
        if (pen != null) {
            this.export(new XlsxBorderInfo(pen));
        }
    }

    private void export(XlsxBorderInfo info) {
        this.write("<border");
        if (info.getDirection() != null) {
            this.write(info.getDirection().equals(LineDirectionEnum.TOP_DOWN) ? " diagonalDown=\"1\"" : " diagonalUp=\"1\"");
        }
        this.write(">");
        this.exportBorder("left", info.leftBorderStyle, info.leftBorderColor);
        this.exportBorder("right", info.rightBorderStyle, info.rightBorderColor);
        this.exportBorder("top", info.topBorderStyle, info.topBorderColor);
        this.exportBorder("bottom", info.bottomBorderStyle, info.bottomBorderColor);
        this.exportBorder("diagonal", info.diagonalBorderStyle, info.diagonalBorderColor);
        this.write("</border>\n");
    }

    private void exportBorder(String borderName, XlsxBorderStyle style, Color color) {
        this.write("<" + borderName);
        if (style != null) {
            this.write(" style=\"" + style.value() + "\"");
        }
        this.write(">");
        if (color != null) {
            this.write("<color rgb=\"" + JRColorUtil.getColorHexa(color) + "\"/>");
        }
        this.write("</" + borderName + ">");
    }
}

