/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.inspector.InspectionController;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.inspector.UnitIDVerifier;
import de.destatis.core.inspector.UnitIDVerifierResult;
import de.destatis.core.inspector.util.DatmlRawResources;
import de.destatis.core.inspector.util.InspectionHelper;
import de.destatis.core.inspector.util.Location;
import de.destatis.core.inspector.util.SemanticsInspection;
import de.statspez.sdf.generator.util.SDFUtil;
import java.util.GregorianCalendar;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AuthorizingInspection
extends SemanticsInspection {
    private static final String WRONG_IDEV_USER_ID_ERR_NUM = "001";
    private static final String WRONG_IDEV_USER_ID_ERR_TEXT = "Die Absenderkennung muss mit der IDEV/CORE-Kennung \u00fcbereinstimmen.";
    private static final String WRONG_TEST_USER_ID_ERR_NUM = "002";
    private static final String WRONG_TEST_USER_ID_ERR_TEXT = "F\u00fcr die Testkennung sind nur die Werte 100 oder 200 zul\u00e4ssig.";
    private static final String WRONG_SURVEY_ID_ERR_NUM = "003";
    private static final String WRONG_SURVEY_ID_ERR_TEXT = "Die Erhebungskennung muss einen der Werte 0001, ..., 9999 enthalten.";
    private static final String WRONG_SURVEY_CLASS_ERR_NUM = "004";
    private static final String WRONG_SURVEY_CLASS_ERR_TEXT = "Die Klasse der Erhebungskennung muss den Wert ERHID haben.";
    private static final String NO_SENDER_ID_ERR_NUM = "005";
    private static final String NO_SENDER_ID_ERR_TEXT = "Die Absenderkennung darf nicht leer sein.";
    private static final String WRONG_SENDER_CLASS_ERR_NUM = "006";
    private static final String WRONG_SENDER_CLASS_ERR_TEXT = "Die Klasse der Absender- und Berichtspflichtigenkennung muss den Wert MELDID haben.";
    private static final String NO_RECEIVER_ID_ERR_NUM = "007";
    private static final String NO_RECEIVER_ID_ERR_TEXT = "Es ist eine Empf\u00e4ngerkennung anzugeben.";
    private static final String WRONG_RECEIVER_ID_ERR_NUM = "008";
    private static final String WRONG_RECEIVER_ID_ERR_TEXT = "Die Empf\u00e4ngerkennung muss einen der Werte 00, ..., 16, 99 enthalten.";
    private static final String NO_COLLECTOR_ERR_NUM = "009";
    private static final String NO_COLLECTOR_ERR_TEXT = "Bei Datenlieferungen an den gemeinsamen Dateneingang muss zu jeder Meldung ein Berichtsempf\u00e4nger angegeben werden.";
    private static final String NO_COLLECTOR_ID_ERR_NUM = "010";
    private static final String NO_COLLECTOR_ID_ERR_TEXT = "Wenn ein Berichtsempf\u00e4nger angegeben ist, dann muss auch die Kennung angegeben werden.";
    private static final String WRONG_COLLECTOR_ID_ERR_NUM = "011";
    private static final String WRONG_COLLECTOR_ID_ERR_TEXT = "Die Berichtsempf\u00e4ngerkennung muss einen der Werte 00, ..., 16 enthalten.";
    private static final String WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_NUM = "012";
    private static final String WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_TEXT = "Die Klasse der Empf\u00e4nger- und Berichtsempf\u00e4ngerkennung muss den Wert STAID haben.";
    private static final String NO_NAME_ERR_NUM = "013";
    private static final String NO_NAME_ERR_TEXT = "Der Name der Organisation oder Person muss angegeben werden.";
    private static final String NO_ZIP_CODE_OR_CITY_ERR_NUM = "014";
    private static final String NO_ZIP_CODE_OR_CITY_ERR_TEXT = "Die Postleitzahl und der Ort m\u00fcssen angegeben werden.";
    private static final String WRONG_REPORTING_PERIOD_ERR_NUM = "015";
    private static final String WRONG_REPORTING_PERIOD_ERR_TEXT = "Der Berichtszeitraum ist der Zeitraum, f\u00fcr den berichtet wird, und muss daher mindestens begonnen haben.";
    private static final String WRONG_BERICHTSEINHEIT_ID_ERR_NUM = "016";
    private static final String WRONG_BERICHTSEINHEIT_ID_ERR_TEXT = " Die Identifizierung der BerichtseinheitsID ist nicht m\u00f6glich (falsche oder fehlende BerichtseinheitsID). Bitte \u00fcbermitteln Sie die Meldung erneut unter Angabe der ID, die Ihnen das zust\u00e4ndige Statistische Amt mitgeteilt hat.";
    private static final String WRONG_REPORTING_PERIOD_WARN_NUM = "001";
    private static final String WRONG_REPORTING_PERIOD_WARN_TEXT = "Der Berichtszeitraum ist der Zeitraum, f\u00fcr den berichtet wird, und muss daher mindestens begonnen haben. Nur bei Testmeldungen kann der Berichtszeitraum auch in der Zukunft liegen.";
    private static final String COLLECTOR_CORRECTION_WARN_NUM = "002";
    private static final String COLLECTOR_CORRECTION_WARN_TEXT = "Der Berichtsempf\u00e4nger wurde maschinell korrigiert.";
    private static final String BERICHTSEINHEIT_ID_HELP_FEATURE_NAME = SDFUtil.UNITID_VARIABLE_NAME;
    protected InspectionController inspectionController;
    private String currentSurveyID;
    private String receiver;
    private boolean inBerichtseinheitIDHmm;
    private boolean berichtseinheitIDHmmFound;
    private String berichtseinheitIDHmmValue;
    private String currentSection = "";
    private String currentSubSection = "";
    private boolean testUser = false;
    private boolean receiver99 = false;
    private boolean idFound = false;
    private String currentIDClass = null;
    private Location currentIDLocation = null;
    private boolean nameOrSurnameFound = false;
    private boolean zipCodeFound = false;
    private boolean cityFound = false;
    private String currentYear;
    private String currentHalfYear;
    private String currentTerm;
    private String currentQuarter;
    private String currentMonth;
    private String currentWeek;
    private StringBuffer currentReportingPeriod;

    public AuthorizingInspection(InspectionController inspectionController) {
        this.inspectionLevel = 3;
        this.inspectionController = inspectionController;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.currentSurveyID = null;
        this.receiver = null;
        this.inBerichtseinheitIDHmm = false;
        this.berichtseinheitIDHmmFound = false;
        this.berichtseinheitIDHmmValue = null;
        this.currentSection = "";
        this.currentSubSection = "";
        this.receiver99 = false;
        this.currentReportingPeriod = new StringBuffer();
    }

    @Override
    public void startElement(String uri, String localName, String raw, Attributes attributes) throws SAXException {
        String helpFeatureName;
        super.startElement(uri, localName, raw, attributes);
        if (DatmlRawResources.isTestID(raw)) {
            this.testUser = true;
            String id = attributes.getValue("kennung");
            if (id != null && id.length() > 0) {
                if (!"100".equals(id) && !"200".equals(id)) {
                    this.errorProblem(3, "002", WRONG_TEST_USER_ID_ERR_TEXT);
                }
            } else if (attributes.getIndex("kennung") >= 0) {
                this.errorProblem(3, "002", WRONG_TEST_USER_ID_ERR_TEXT);
            }
        } else if (DatmlRawResources.isSender(raw) || DatmlRawResources.isReceiver(raw) || DatmlRawResources.isSurvey(raw) || DatmlRawResources.isDeclarant(raw) || DatmlRawResources.isCollector(raw)) {
            this.currentSection = raw;
            this.idFound = false;
        } else if (DatmlRawResources.isContact(raw)) {
            this.currentSection = raw;
        } else if (DatmlRawResources.isPerson(raw) || DatmlRawResources.isOrganisation(raw)) {
            this.currentSubSection = raw;
            this.nameOrSurnameFound = false;
        } else if (DatmlRawResources.isName(raw) || DatmlRawResources.isSurname(raw)) {
            this.nameOrSurnameFound = true;
        } else if (DatmlRawResources.isAddress(raw)) {
            this.currentSubSection = raw;
            this.zipCodeFound = false;
            this.cityFound = false;
        } else if (DatmlRawResources.isZipCode(raw)) {
            this.zipCodeFound = true;
        } else if (DatmlRawResources.isCity(raw)) {
            this.cityFound = true;
        } else if (DatmlRawResources.isID(raw)) {
            this.idFound = true;
            String idClass = attributes.getValue("klasse");
            if (DatmlRawResources.isSurvey(this.currentSection)) {
                if (idClass == null || !"ERHID".equals(idClass)) {
                    this.errorProblem(3, WRONG_SURVEY_CLASS_ERR_NUM, WRONG_SURVEY_CLASS_ERR_TEXT);
                }
            } else if (DatmlRawResources.isSender(this.currentSection)) {
                if (idClass == null || !"MELDID".equals(idClass)) {
                    this.errorProblem(3, WRONG_SENDER_CLASS_ERR_NUM, WRONG_SENDER_CLASS_ERR_TEXT);
                }
            } else if (DatmlRawResources.isReceiver(this.currentSection)) {
                if (idClass == null || !"STAID".equals(idClass)) {
                    this.errorProblem(3, WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_NUM, WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_TEXT);
                }
            } else if (DatmlRawResources.isCollector(this.currentSection)) {
                if (idClass == null || !"STAID".equals(idClass)) {
                    this.errorProblem(3, WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_NUM, WRONG_RECEIVER_OR_COLLECTOR_CLASS_ERR_TEXT);
                }
            } else if (DatmlRawResources.isDeclarant(this.currentSection)) {
                this.currentIDClass = idClass;
                this.currentIDLocation = new Location(null, this.getCurrentLineNumber(), this.getCurrentColumnNumber());
            }
        } else if (DatmlRawResources.isDeclaration(raw)) {
            if (this.receiver99 && !this.collectorInPath()) {
                this.errorProblem(3, NO_COLLECTOR_ERR_NUM, NO_COLLECTOR_ERR_TEXT);
            }
            if (this.inspectionController != null) {
                String statisticId = this.getCurrentSurveyId();
                String referencePeriod = this.getCurrentReportingPeriod();
                String collector = this.getCurrentCollector();
                if (statisticId != null && referencePeriod != null && referencePeriod.length() == 6 && this.inspectionController.unitIdVerificationIsActive(statisticId, referencePeriod)) {
                    this.getReporter().setUnitIdVerificationUsed();
                    if (this.berichtseinheitIDHmmValue == null) {
                        this.errorProblem(3, WRONG_BERICHTSEINHEIT_ID_ERR_NUM, WRONG_BERICHTSEINHEIT_ID_ERR_TEXT);
                    } else if (collector != null) {
                        UnitIDVerifier unitIdVerifier = this.inspectionController.getUnitIdVerifier();
                        if (unitIdVerifier == null) {
                            throw new IllegalStateException("UnitIDVerifier ist erforderlich.");
                        }
                        UnitIDVerifierResult unitIdVerifierResult = unitIdVerifier.verifyUnitId(collector, statisticId, referencePeriod, this.berichtseinheitIDHmmValue);
                        if (unitIdVerifierResult == null) {
                            throw new IllegalStateException("UnitIDVerifierResult ist null.");
                        }
                        String additionalInfo = unitIdVerifierResult.getAdditionalInfo();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("UnitIDVerifier-Status: " + unitIdVerifierResult.getResultStatus() + additionalInfo == null ? "." : ", Zusatzinfo: '" + additionalInfo + "'."));
                        }
                        if (!unitIdVerifierResult.isUnitIdAvailableAndCollectorOk()) {
                            if (unitIdVerifierResult.isBadUnitId()) {
                                this.errorProblem(3, WRONG_BERICHTSEINHEIT_ID_ERR_NUM, WRONG_BERICHTSEINHEIT_ID_ERR_TEXT);
                            } else if (unitIdVerifierResult.isUnitIdAvailableAndBadCollector()) {
                                String collectorCorrection = unitIdVerifierResult.getCollectorCorrection();
                                int msgId = this.getMessageID();
                                int declId = this.getDeclarationID();
                                if (msgId > 0 && declId > 0) {
                                    this.getReporter().setCollectorCorrection(msgId, declId, collectorCorrection);
                                }
                                this.warningProblem(3, "002", COLLECTOR_CORRECTION_WARN_TEXT);
                            } else if (!unitIdVerifierResult.isUnitIdUnchecked()) {
                                throw new IllegalStateException("Ungueltiger UnitIDVerifierResult-Status: " + unitIdVerifierResult.getResultStatus() + ".");
                            }
                        }
                    }
                }
            }
        } else if (DatmlRawResources.isReportingPeriod(raw)) {
            this.currentReportingPeriod.delete(0, this.currentReportingPeriod.length());
            this.currentYear = null;
            this.currentHalfYear = null;
            this.currentTerm = null;
            this.currentQuarter = null;
            this.currentMonth = null;
            this.currentWeek = null;
        } else if (DatmlRawResources.isHelpFeature(raw) && !this.berichtseinheitIDHmmFound && this.inspectionController != null && BERICHTSEINHEIT_ID_HELP_FEATURE_NAME.equals(helpFeatureName = attributes.getValue("name"))) {
            this.berichtseinheitIDHmmFound = true;
            this.inBerichtseinheitIDHmm = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String raw) throws SAXException {
        if (DatmlRawResources.isMessage(raw)) {
            if (this.berichtseinheitIDHmmFound && this.helpFeatureInCurrentSegment(BERICHTSEINHEIT_ID_HELP_FEATURE_NAME)) {
                this.berichtseinheitIDHmmValue = null;
                this.berichtseinheitIDHmmFound = false;
            }
        } else if (DatmlRawResources.isSegment(raw)) {
            if (this.berichtseinheitIDHmmFound && this.helpFeatureInCurrentSegment(BERICHTSEINHEIT_ID_HELP_FEATURE_NAME)) {
                this.berichtseinheitIDHmmValue = null;
                this.berichtseinheitIDHmmFound = false;
            }
        } else if (DatmlRawResources.isSender(raw)) {
            if (!this.idFound) {
                this.errorProblem(3, NO_SENDER_ID_ERR_NUM, NO_SENDER_ID_ERR_TEXT);
            }
            this.currentSection = "";
            this.idFound = false;
        } else if (DatmlRawResources.isReceiver(raw)) {
            if (!this.idFound) {
                this.errorProblem(3, NO_RECEIVER_ID_ERR_NUM, NO_RECEIVER_ID_ERR_TEXT);
            }
            this.currentSection = "";
            this.idFound = false;
        } else if (DatmlRawResources.isSurvey(raw) || DatmlRawResources.isDeclarant(raw)) {
            this.currentSection = "";
            this.idFound = false;
        } else if (DatmlRawResources.isCollector(raw)) {
            if (!this.idFound) {
                this.errorProblem(3, NO_COLLECTOR_ID_ERR_NUM, NO_COLLECTOR_ID_ERR_TEXT);
            }
            this.currentSection = "";
            this.idFound = false;
        } else if (DatmlRawResources.isContact(raw)) {
            this.currentSection = "";
        } else if (DatmlRawResources.isPerson(raw) || DatmlRawResources.isOrganisation(raw)) {
            if ((DatmlRawResources.isSender(this.currentSection) || DatmlRawResources.isDeclarant(this.currentSection) || DatmlRawResources.isContact(this.currentSection)) && !this.nameOrSurnameFound) {
                this.errorProblem(3, NO_NAME_ERR_NUM, NO_NAME_ERR_TEXT);
            }
            this.nameOrSurnameFound = false;
        } else if (DatmlRawResources.isName(raw)) {
            String name;
            if ((DatmlRawResources.isSender(this.currentSection) || DatmlRawResources.isDeclarant(this.currentSection) || DatmlRawResources.isContact(this.currentSection)) && DatmlRawResources.isOrganisation(this.currentSubSection) && ((name = this.getTextBufferTrimed()) == null || name.length() == 0)) {
                this.nameOrSurnameFound = false;
            }
        } else if (DatmlRawResources.isSurname(raw)) {
            String surname;
            if ((DatmlRawResources.isSender(this.currentSection) || DatmlRawResources.isDeclarant(this.currentSection) || DatmlRawResources.isContact(this.currentSection)) && DatmlRawResources.isPerson(this.currentSubSection) && ((surname = this.getTextBufferTrimed()) == null || surname.length() == 0)) {
                this.nameOrSurnameFound = false;
            }
        } else if (DatmlRawResources.isAddress(raw)) {
            if (!(!DatmlRawResources.isSender(this.currentSection) && !DatmlRawResources.isDeclarant(this.currentSection) && !DatmlRawResources.isContact(this.currentSection) || this.zipCodeFound && this.cityFound)) {
                this.errorProblem(3, NO_ZIP_CODE_OR_CITY_ERR_NUM, NO_ZIP_CODE_OR_CITY_ERR_TEXT);
            }
            this.zipCodeFound = false;
            this.cityFound = false;
        } else if (DatmlRawResources.isZipCode(raw)) {
            String zipCode;
            if ((DatmlRawResources.isSender(this.currentSection) || DatmlRawResources.isDeclarant(this.currentSection) || DatmlRawResources.isContact(this.currentSection)) && DatmlRawResources.isAddress(this.currentSubSection) && ((zipCode = this.getTextBufferTrimed()) == null || zipCode.length() == 0)) {
                this.zipCodeFound = false;
            }
        } else if (DatmlRawResources.isCity(raw)) {
            String city;
            if ((DatmlRawResources.isSender(this.currentSection) || DatmlRawResources.isDeclarant(this.currentSection) || DatmlRawResources.isContact(this.currentSection)) && DatmlRawResources.isAddress(this.currentSubSection) && ((city = this.getTextBufferTrimed()) == null || city.length() == 0)) {
                this.cityFound = false;
            }
        } else if (DatmlRawResources.isID(raw)) {
            String id = this.getTextBufferTrimed();
            if (DatmlRawResources.isSender(this.currentSection)) {
                if (id == null || id.length() == 0) {
                    this.idFound = false;
                }
            } else if (DatmlRawResources.isReceiver(this.currentSection)) {
                this.visitReceiver(id);
            } else if (DatmlRawResources.isSurvey(this.currentSection)) {
                this.visitSurveyID(id);
            } else if (DatmlRawResources.isDeclarant(this.currentSection)) {
                if (!(id == null || id.length() <= 0 || this.currentIDClass != null && "MELDID".equals(this.currentIDClass))) {
                    this.errorProblem(3, WRONG_SENDER_CLASS_ERR_NUM, WRONG_SENDER_CLASS_ERR_TEXT, new ProblemPosition(this.currentIDLocation.getLineNumber(), this.currentIDLocation.getColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.getVariableName()));
                }
            } else if (DatmlRawResources.isCollector(this.currentSection)) {
                this.visitCollector(id);
            }
            this.currentIDClass = null;
        } else if (DatmlRawResources.isYear(raw)) {
            this.currentYear = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isHalfYear(raw)) {
            this.currentHalfYear = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isTerm(raw)) {
            this.currentTerm = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isQuarter(raw)) {
            this.currentQuarter = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isMonth(raw)) {
            this.currentMonth = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isWeek(raw)) {
            this.currentWeek = this.getTextBufferTrimed();
        } else if (DatmlRawResources.isReportingPeriod(raw)) {
            this.checkReportingPeriod();
        } else if (DatmlRawResources.isHelpFeature(raw)) {
            this.inBerichtseinheitIDHmm = false;
        } else if (DatmlRawResources.isValue(raw) && this.inBerichtseinheitIDHmm) {
            this.berichtseinheitIDHmmValue = this.getTextBuffer();
        }
        super.endElement(uri, localName, raw);
    }

    protected void visitReceiver(String receiverId) {
        if (receiverId == null || receiverId.length() == 0) {
            this.idFound = false;
        } else if (receiverId.length() != 2 || !InspectionHelper.isNumeric(receiverId)) {
            this.errorProblem(3, WRONG_RECEIVER_ID_ERR_NUM, WRONG_RECEIVER_ID_ERR_TEXT);
        } else {
            int idInt = Integer.parseInt(receiverId);
            if (idInt > 16 && idInt < 99) {
                this.errorProblem(3, WRONG_RECEIVER_ID_ERR_NUM, WRONG_RECEIVER_ID_ERR_TEXT);
            } else {
                this.receiver = receiverId;
                if (idInt == 99) {
                    this.receiver99 = true;
                }
            }
        }
    }

    protected void visitSurveyID(String surveyId) {
        if (surveyId == null || surveyId.length() != 4 || !InspectionHelper.isNumeric(surveyId)) {
            this.currentSurveyID = null;
            this.errorProblem(3, WRONG_SURVEY_ID_ERR_NUM, WRONG_SURVEY_ID_ERR_TEXT);
        } else {
            this.currentSurveyID = surveyId;
        }
    }

    protected void visitCollector(String collector) {
        if (collector == null || collector.length() == 0) {
            this.idFound = false;
        } else if (collector.length() != 2 || !InspectionHelper.isNumeric(collector) || Integer.parseInt(collector) > 16) {
            this.errorProblem(3, WRONG_COLLECTOR_ID_ERR_NUM, WRONG_COLLECTOR_ID_ERR_TEXT);
        } else {
            SemanticsInspection.SegmentInfo segmentInfo = this.getCurrentSegmentInfo();
            if (segmentInfo != null) {
                segmentInfo.setCollectorValue(collector);
            }
        }
    }

    protected String getCurrentReportingPeriod() {
        return this.currentReportingPeriod.toString();
    }

    protected String getCurrentSurveyId() {
        return this.currentSurveyID;
    }

    protected String getCurrentCollector() {
        String collector = null;
        Stack<SemanticsInspection.SegmentInfo> segmentInfos = this.getSegmentInfoStack();
        for (int i = segmentInfos.size() - 1; i >= 0; --i) {
            SemanticsInspection.SegmentInfo segmentInfo = (SemanticsInspection.SegmentInfo)segmentInfos.get(i);
            String check = segmentInfo.getCollectorValue();
            if (check == null) continue;
            collector = check;
            break;
        }
        if (collector == null && !"99".equals(this.receiver)) {
            collector = this.receiver;
        }
        return collector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkReportingPeriod() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            boolean actualYear = false;
            if (this.currentYear == null || this.currentYear.length() <= 0) throw new Exception();
            int year = Integer.parseInt(this.currentYear);
            if (year >= 2000 && year < 2100) {
                if (year > calendar.get(1)) {
                    this.wrongReportingPeriod();
                } else if (year == calendar.get(1)) {
                    actualYear = true;
                }
                if (year < 2010) {
                    this.currentReportingPeriod.append("0");
                }
            } else {
                this.errorProblem(3, WRONG_REPORTING_PERIOD_ERR_NUM, WRONG_REPORTING_PERIOD_ERR_TEXT);
                throw new Exception();
            }
            this.currentReportingPeriod.append(year - 2000);
            if (this.currentHalfYear != null && this.currentHalfYear.length() > 0) {
                this.currentReportingPeriod.append("100");
                int halfYear = Integer.parseInt(this.currentHalfYear);
                if (halfYear != 1 && halfYear != 2) throw new Exception();
                if (actualYear && halfYear > calendar.get(2) / 6 + 1) {
                    this.wrongReportingPeriod();
                }
                this.currentReportingPeriod.append(halfYear);
                return;
            } else if (this.currentTerm != null && this.currentTerm.length() > 0) {
                this.currentReportingPeriod.append("200");
                int term = Integer.parseInt(this.currentTerm);
                if (term != 1 && term != 2) throw new Exception();
                this.currentReportingPeriod.append(term);
                return;
            } else if (this.currentQuarter != null && this.currentQuarter.length() > 0) {
                this.currentReportingPeriod.append("300");
                int quarter = Integer.parseInt(this.currentQuarter);
                if (quarter < 1 || quarter > 4) throw new Exception();
                if (actualYear && quarter > calendar.get(2) / 3 + 1) {
                    this.wrongReportingPeriod();
                }
                this.currentReportingPeriod.append(quarter);
                return;
            } else if (this.currentMonth != null && this.currentMonth.length() > 0) {
                this.currentReportingPeriod.append("40");
                int month = Integer.parseInt(this.currentMonth);
                if (month < 1 || month > 12) throw new Exception();
                if (actualYear && month > calendar.get(2) + 1) {
                    this.wrongReportingPeriod();
                }
                if (month < 10) {
                    this.currentReportingPeriod.append("0");
                }
                this.currentReportingPeriod.append(month);
                return;
            } else if (this.currentWeek != null && this.currentWeek.length() > 0) {
                this.currentReportingPeriod.append("50");
                int week = Integer.parseInt(this.currentWeek);
                if (week < 1 || week > 53) throw new Exception();
                if (actualYear && week > calendar.get(3)) {
                    this.wrongReportingPeriod();
                }
                if (week < 10) {
                    this.currentReportingPeriod.append("0");
                }
                this.currentReportingPeriod.append(week);
                return;
            } else {
                this.currentReportingPeriod.append("0000");
            }
            return;
        }
        catch (Exception e) {
            this.currentReportingPeriod.delete(0, this.currentReportingPeriod.length());
        }
    }

    private void wrongReportingPeriod() throws Exception {
        if (!this.testUser) {
            this.errorProblem(3, WRONG_REPORTING_PERIOD_ERR_NUM, WRONG_REPORTING_PERIOD_ERR_TEXT);
            throw new Exception();
        }
        this.warningProblem(3, "001", WRONG_REPORTING_PERIOD_WARN_TEXT);
    }
}

