/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.util.Contract;
import de.destatis.core.inspector.InspectionController;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.util.Inspection;
import de.destatis.core.inspector.util.InspectionFactory;
import de.destatis.core.inspector.util.InspectorConfig;
import de.destatis.core.resource.ResourceStorage;
import de.destatis.core.resource.SurveyResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.InputSource;

public class Inspector {
    public static final int SYNTAX_INSPECTION_LEVEL = 1;
    public static final int SEMANTICS_INSPECTION_LEVEL = 2;
    public static final int AUTHORIZING_INSPECTION_LEVEL = 3;
    public static final int DATA_INSPECTION_LEVEL = 4;
    public static final int LOWEST_INSPECTION_LEVEL = 1;
    public static final int HIGHEST_INSPECTION_LEVEL = 4;
    public static final String PROPERTY_INSPECTION_LEVEL = "inspector.inspectionLevel";
    public static final String PROPERTY_SURVEY_AUTOUPDATE = "inspector.survey.autoupdate";
    public static final String PROPERTY_SURVEY_DIR = "inspector.survey.dir";
    public static final String PROPERTY_SCHEMA_DIR = "inspector.schema.dir";
    private static final String INSPECTOR_VERSION;
    private InspectorConfig config = null;

    public Inspector() {
        this.config = new InspectorConfig();
    }

    public Inspector(Properties conf) {
        Contract.verify((conf != null ? 1 : 0) != 0, (String)"Keine Properties angegeben");
        this.config = new InspectorConfig(conf);
    }

    public String getVersion() {
        return INSPECTOR_VERSION;
    }

    public void setConfiguration(Properties conf) {
        Contract.verify((conf != null ? 1 : 0) != 0, (String)"Keine Properties angegeben");
        this.config.setProperties(conf);
    }

    public int getInspectionLevel() {
        return this.config.getInspectionLevel();
    }

    public void setInspectionLevel(int level) {
        Contract.verify((level >= 1 && level <= 4 ? 1 : 0) != 0, (String)"Die Pr\u00fcfstufe muss zwischen 1 und 4 sein.");
        this.config.getProperties().put(PROPERTY_INSPECTION_LEVEL, level + "");
    }

    public boolean isSurveyAutoUpdate() {
        return this.config.isSurveyAutoUpdate();
    }

    public void autoUpdateSurvey(boolean value) {
        this.config.autoUpdateSurvey(value);
    }

    public String getSurveyDir() {
        return this.config.getSurveyDir();
    }

    public void setSurveyDir(String dir) {
        Contract.verify((dir != null && new File(dir).isDirectory() ? 1 : 0) != 0, (String)"Das Erhebungsbeschreibungsverzeichnis muss ein g\u00fcltiges Verzeichnis sein.");
        this.config.setSurveyDir(dir);
    }

    public void setSurveyResourceStorage(ResourceStorage surveyResourceStorage) {
        this.config.setSurveyResourceStorage(surveyResourceStorage);
    }

    public void setSurveyResourceProvider(SurveyResourceProvider surveyResourceProvider) {
        this.config.setSurveyResourceProvider(surveyResourceProvider);
    }

    public void setClient(Client client) {
        this.config.setClient(client);
    }

    public String getSchemaDir() {
        return this.config.getSchemaDir();
    }

    public void setSchemaDir(String dir) {
        Contract.verify((dir != null && new File(dir).isDirectory() ? 1 : 0) != 0, (String)"Das Schemaverzeichnis muss ein g\u00fcltiges Verzeichnis sein.");
        this.config.getProperties().put(PROPERTY_SCHEMA_DIR, dir);
    }

    public void setInspectionController(InspectionController inspectionController) {
        this.config.setInspectionController(inspectionController);
    }

    public InspectionController getInspectionController() {
        return this.config.getInspectionController();
    }

    public InspectionReport inspect(InputSource source) throws IOException {
        return this.inspect(source, this.getInspectionLevel());
    }

    public InspectionReport inspect(InputSource source, int level) throws IOException {
        Contract.verify((source != null ? 1 : 0) != 0, (String)"Das zu pr&uuml;fende DatML/RAW-Dokument muss angegeben werden.");
        Inspection inspection = InspectionFactory.createInspection(level, this.config.getInspectionController());
        return inspection.process(this.config, source);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length < 2 || args.length > 6 || args.length % 2 == 1) {
                throw new IllegalArgumentException("Falsche Anzahl der Parameter.");
            }
            String inputfile = null;
            Integer level = null;
            String conffile = null;
            String username = null;
            String password = null;
            for (int i = 0; i < args.length - 1; i += 2) {
                if ("-inputfile".equals(args[i])) {
                    inputfile = args[i + 1];
                    continue;
                }
                if ("-level".equals(args[i])) {
                    level = new Integer(args[i + 1]);
                    continue;
                }
                if ("-conffile".equals(args[i])) {
                    conffile = args[i + 1];
                    continue;
                }
                if ("-username".equals(args[i])) {
                    username = args[i + 1];
                    continue;
                }
                if ("-password".equals(args[i])) {
                    password = args[i + 1];
                    continue;
                }
                throw new IllegalArgumentException("Falscher Parameter: " + args[i]);
            }
            if (inputfile == null) {
                throw new IllegalArgumentException("Der Name der zu pr&uuml;fenden DatML/RAW-Datei wurde nicht angegeben.");
            }
            Properties properties = new Properties();
            if (conffile != null) {
                FileInputStream in = new FileInputStream(conffile);
                properties.load(in);
                in.close();
                Inspector i = new Inspector(properties);
            }
            if (level != null) {
                properties.setProperty(PROPERTY_INSPECTION_LEVEL, String.valueOf(level));
            }
            if (username != null) {
                properties.setProperty("client.username", username);
            }
            if (password != null) {
                properties.setProperty("client.password", password);
            }
            Inspector inspector = new Inspector(properties);
            InspectionReport report = inspector.inspect(new InputSource(new FileInputStream(inputfile)));
            System.out.println(report);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println("Usage:");
            System.err.println("Inspector -inputfile <DatML/RAW-Datei> [-level 1|2|3|4] [-conffile <Konfigurationsdatei>] [-username <userid>] [-password <passwd>]");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println(t.getMessage());
        }
    }

    static {
        String version = null;
        Package pkg = Package.getPackage("de.destatis.core.inspector");
        if (pkg != null) {
            version = pkg.getSpecificationVersion();
        }
        if (version == null) {
            version = "?";
        }
        INSPECTOR_VERSION = version;
    }
}

