/*
 * Decompiled with CFR 0.152.
 */
package de.his.net;

import de.his.otherlicence.unicode.UnicodeSupportingInputStreamReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LineBasedSocket
extends Socket {
    private final Logger logger = Logger.getLogger(LineBasedSocket.class);
    private BufferedReader fromServer = null;
    private BufferedWriter toServer = null;
    protected Socket socket = null;
    private boolean glueStatusResponseLines = true;

    public LineBasedSocket(Socket aSocket) throws IOException {
        this(aSocket, true, System.getProperty("file.encoding"));
    }

    public LineBasedSocket(Socket aSocket, boolean glueStatusResponseLines) throws IOException {
        this(aSocket, glueStatusResponseLines, System.getProperty("file.encoding"));
    }

    public LineBasedSocket(Socket aSocket, boolean glueStatusResponseLines, String charsetName) throws IOException {
        this.socket = aSocket;
        this.toServer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), charsetName));
        this.fromServer = new BufferedReader(new UnicodeSupportingInputStreamReader(this.socket.getInputStream(), charsetName));
        this.glueStatusResponseLines = glueStatusResponseLines;
    }

    public void sendLine(String line) {
        try {
            this.toServer.write(line + "\r\n");
            this.toServer.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public String recvLine() throws IOException {
        return this.fromServer.readLine();
    }

    public String recvResponse() throws IOException {
        String temp = this.fromServer.readLine();
        if (temp == null) {
            return null;
        }
        StringBuilder all = new StringBuilder(temp);
        if (this.glueStatusResponseLines) {
            while (temp.length() > 4 && temp.charAt(3) == '-') {
                temp = this.fromServer.readLine();
                if (temp == null) {
                    throw new IOException("Unexpected end of input stream while reading multi line response.");
                }
                all.append(temp);
            }
        }
        return all.toString();
    }

    public String getData() throws IOException {
        StringBuffer temp = new StringBuffer("");
        String line = this.fromServer.readLine();
        if (line == null) {
            throw new IOException("Stream wurde unerwartet geschlossen.");
        }
        while (!".".equals(line)) {
            if (line.startsWith(".")) {
                line = line.substring(1);
            }
            temp.append(line + "\r\n");
            line = this.fromServer.readLine();
        }
        return temp.toString();
    }

    public void sendData(String data) {
        try {
            StringTokenizer st = new StringTokenizer(data, "\r\n", true);
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.startsWith(".")) {
                    line = "." + line;
                }
                if (line.equals("\r")) continue;
                if (line.equals("\n")) {
                    line = "\r\n";
                }
                this.toServer.write(line);
            }
            this.sendLine(".");
            this.toServer.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public int getResponseCode(String response) {
        try {
            return Integer.parseInt(response.substring(0, 3));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String execCmd(String cmd) throws IOException {
        this.sendLine(cmd);
        return this.recvResponse();
    }

    public boolean isGlueStatusResponseLines() {
        return this.glueStatusResponseLines;
    }

    public void setGlueStatusResponseLines(boolean glueStatusResponseLines) {
        this.glueStatusResponseLines = glueStatusResponseLines;
    }

    @Override
    public synchronized void close() throws IOException {
        this.socket.close();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public String toString() {
        return this.socket.toString();
    }
}

