/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.xmldb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class DbTool {
    private String dbURL;
    private String driverClass;
    private String outputFile;
    private String propertyFile;

    public DbTool(String propertyFile, String outputFile) {
        this.propertyFile = propertyFile;
        this.outputFile = outputFile;
    }

    public void createXMLOutput() {
        try {
            int read;
            StringBuffer result = new StringBuffer();
            result.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n\n<dbforms-config>\n");
            Connection con = this.createConnection();
            if (con == null) {
                System.exit(1);
            }
            DatabaseMetaData dbmd = con.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW"};
            ResultSet tablesRS = dbmd.getTables("", "", "", types);
            while (tablesRS.next()) {
                String tableName = tablesRS.getString(3);
                result.append("\t<table name=\"");
                result.append(tableName);
                result.append("\">\n");
                ResultSet rsKeys = dbmd.getPrimaryKeys("", "", tableName);
                Vector<String> keys = new Vector<String>();
                while (rsKeys.next()) {
                    String columnName = rsKeys.getString(4);
                    keys.addElement(columnName);
                }
                rsKeys.close();
                ResultSet rsFields = dbmd.getColumns("", "", tableName, null);
                while (rsFields.next()) {
                    String columnName = rsFields.getString(4);
                    String typeName = rsFields.getString(6);
                    int columnSize = rsFields.getInt(7);
                    result.append("\t\t<field name=\"");
                    result.append(columnName);
                    result.append("\" fieldType=\"");
                    result.append(typeName);
                    result.append("\" size=\"");
                    result.append(columnSize);
                    result.append("\"");
                    if (keys.contains(columnName)) {
                        result.append(" isKey=\"true\"");
                    }
                    result.append("/>\n");
                }
                rsFields.close();
                result.append("\n\t\t<!-- add \"granted-privileges\" element for security constraints -->\n\n\t</table>\n\n");
            }
            tablesRS.close();
            result.append("\t<!-- ========== Connection =================================== -->\n");
            result.append("\t<!--\n");
            result.append("\tuncomment this if you have access to JNDI of an application server (see users guide for more info)\n");
            result.append("\t<dbconnection\n");
            result.append("\t\tname = \"jdbc/dbformstest\"\n");
            result.append("\t\tisJndi = \"true\"\n");
            result.append("\t/>\n");
            result.append("\t-->\n\n");
            result.append("\t<dbconnection\n");
            result.append("\t\tname   = \"" + this.dbURL + "\"\n");
            result.append("\t\tisJndi = \"false\"\n");
            result.append("\t\tconClass  = \"" + this.driverClass + "\"\n");
            result.append("\t/>\n");
            result.append("</dbforms-config>");
            FileOutputStream os = new FileOutputStream(new File(this.outputFile));
            ByteArrayInputStream is = new ByteArrayInputStream(result.toString().getBytes());
            byte[] b = new byte[1024];
            while ((read = is.read(b)) != -1) {
                os.write(b, 0, read);
            }
            os.close();
            System.out.println("finished");
        }
        catch (Exception e) {
            System.out.println("Error:" + e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: java DbTool propertyFile outputFile\n\nexample:\njava DbTool db.properties config.xml");
            System.exit(1);
        }
        new DbTool(args[0], args[1]).createXMLOutput();
    }

    private Connection createConnection() throws SQLException, ClassNotFoundException, InstantiationException, IOException, IllegalAccessException {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(this.propertyFile)));
        this.driverClass = props.getProperty("connection-class");
        this.dbURL = props.getProperty("connection-url");
        String dbUser = props.getProperty("username");
        String dbPwd = props.getProperty("password");
        System.out.println("driverClass=" + this.driverClass);
        System.out.println("dbURL=" + this.dbURL);
        System.out.println("dbUser=" + dbUser);
        System.out.println("dbPwd=" + dbPwd);
        Class.forName(this.driverClass).newInstance();
        return DriverManager.getConnection(this.dbURL, dbUser, dbPwd);
    }
}

