/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets.reports;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.servlets.reports.JRDataSourceAbstract;
import org.dbforms.servlets.reports.ReportServletAbstract;
import org.dbforms.servlets.reports.ReportWriter;
import org.dbforms.util.Util;
import org.dbforms.util.external.FileUtil;

public abstract class LineReportServletAbstract
extends ReportServletAbstract {
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$servlets$reports$LineReportServletAbstract == null ? (class$org$dbforms$servlets$reports$LineReportServletAbstract = LineReportServletAbstract.class$("org.dbforms.servlets.reports.LineReportServletAbstract")) : class$org$dbforms$servlets$reports$LineReportServletAbstract));
    private static final String REPORTMIMETYPEPARAM = "reportMimeType";
    private String mimeType = this.getMimeType();
    private int rownum = 0;
    static /* synthetic */ Class class$org$dbforms$servlets$reports$LineReportServletAbstract;

    protected abstract String getMimeType();

    protected abstract String getFileExtension();

    protected abstract void writeData(Object[] var1) throws Exception;

    protected abstract void openStream(OutputStream var1) throws Exception;

    protected abstract void closeStream(OutputStream var1) throws Exception;

    public void init() throws ServletException {
        super.init();
        String value = this.getServletConfig().getInitParameter(REPORTMIMETYPEPARAM);
        if (!Util.isNull(value)) {
            this.mimeType = value;
        }
    }

    protected String getReportFileExtension() {
        return ".xr";
    }

    protected void writeHeader(String[] header) throws Exception {
        this.writeData(header);
    }

    private Object getFieldValue(HttpServletRequest request, JRDataSourceAbstract dataSource, String search) {
        Object o = null;
        if ((search = search.replaceAll("__", ".")).startsWith("internal.")) {
            search = search.substring(search.indexOf("internal."));
            logCat.debug((Object)("Trying to find data for internal value: " + search));
            o = this.getInternalValue(search);
        } else if (search.startsWith("request.")) {
            search = search.substring(search.indexOf("request."));
            logCat.debug((Object)("Trying to find data for page context value: " + search));
            o = this.getRequestValue(request, search);
        } else if (search.startsWith("session.")) {
            search = search.substring(search.indexOf("session."));
            logCat.debug((Object)("Trying to find data for session value: " + search));
            o = this.getSessionValue(request.getSession(), search);
        } else {
            logCat.debug((Object)("Trying to find data for field named: " + search));
            o = dataSource.getFieldValue(search);
        }
        return o;
    }

    private Object getInternalValue(String search) {
        Object obj = null;
        try {
            logCat.debug((Object)("Trying to find data for internal var : " + search));
            if (search.equalsIgnoreCase("rownum")) {
                return new Integer(this.rownum);
            }
        }
        catch (Exception e) {
            logCat.error((Object)("getInternalValue: " + e));
        }
        return obj;
    }

    private Object getRequestValue(HttpServletRequest request, String search) {
        Object obj = null;
        try {
            int pos = search.indexOf(".");
            if (pos == -1) {
                obj = request.getAttribute(search);
            } else {
                String search_bean = search.substring(0, pos);
                search = search.substring(pos + 1);
                Object bean = request.getAttribute(search_bean);
                if (bean != null) {
                    logCat.debug((Object)("calling PropertyUtils.getProperty " + search_bean + " " + search));
                    obj = PropertyUtils.getProperty((Object)bean, (String)search);
                }
            }
        }
        catch (Exception e) {
            logCat.error((Object)("getPageContextValue: " + e));
        }
        return obj;
    }

    private Object getSessionValue(HttpSession session, String search) {
        Object obj = null;
        try {
            int pos = search.indexOf(".");
            if (pos == -1) {
                obj = session.getAttribute(search);
            } else {
                String search_bean = search.substring(0, pos);
                search = search.substring(pos + 1);
                Object bean = session.getAttribute(search_bean);
                if (bean != null) {
                    logCat.debug((Object)("calling PropertyUtils.getProperty " + search_bean + " " + search));
                    obj = PropertyUtils.getProperty((Object)bean, (String)search);
                }
            }
        }
        catch (Exception e) {
            logCat.error((Object)("getSessionValue: " + e));
        }
        return obj;
    }

    private ReportWriter fillReport(HttpServletRequest request, String[] header, String[] fields, JRDataSourceAbstract dataSource) throws Exception {
        ReportWriter res = new ReportWriter();
        res.mimeType = this.mimeType;
        res.data = new ByteArrayOutputStream();
        res.fileName = this.getFileExtension();
        this.openStream(res.data);
        this.writeHeader(header);
        Object[] data = new Object[fields.length];
        while (dataSource.next()) {
            ++this.rownum;
            for (int i = 0; i < fields.length; ++i) {
                data[i] = this.getFieldValue(request, dataSource, fields[i]);
            }
            this.writeData(data);
        }
        this.closeStream(res.data);
        return res;
    }

    protected ReportWriter processReport(String reportFileFullName, JRDataSourceAbstract dataSource, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        try {
            String[] headerFields;
            File f = new File(reportFileFullName + this.getReportFileExtension());
            BufferedReader in = new BufferedReader(new FileReader(f));
            String line1 = in.readLine();
            String line2 = in.readLine();
            String fields = null;
            String headers = null;
            if (Util.isNull(line2)) {
                fields = line1;
            } else {
                headers = line1;
                fields = line2;
            }
            if (Util.isNull(fields)) {
                logCat.error((Object)"no fields found");
                return null;
            }
            String[] reportFields = fields.split(",");
            if (reportFields.length != (headerFields = headers != null ? headers.split(",") : new String[]{}).length) {
                logCat.error((Object)"reportFields.length != headerFields.length");
                headerFields = reportFields;
            }
            if (reportFields.length == 0) {
                logCat.error((Object)"no fields found");
                return null;
            }
            ReportWriter res = this.fillReport(request, headerFields, reportFields, dataSource);
            if (res != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(FileUtil.filename(reportFileFullName));
                buf.append(res.fileName);
                res.fileName = buf.toString();
            }
            return res;
        }
        catch (Exception e) {
            logCat.error((Object)"read report file", (Throwable)e);
            this.handleException(request, response, e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

