/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.MappingXmlConstants;
import de.destatis.core.map.editor.util.XmlWriter;
import de.destatis.core.map.model.MetaMapping;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class MetaMappingGenerator {
    public void generate(MetaMapping mapping, OutputStream out) throws IOException {
        this.generate(mapping, out, MappingXmlConstants.ENCODING);
    }

    public void generate(MetaMapping mapping, OutputStream out, String encoding) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
        XmlWriter xml = new XmlWriter(writer, true);
        xml.openXml(encoding);
        Date date = mapping.getCreationDate();
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        String dateStr = format.format(date);
        format = new SimpleDateFormat("HH:mm:ss");
        String timeStr = format.format(date);
        LinkedHashMap<String, String> mappingAttributes = new LinkedHashMap<String, String>();
        mappingAttributes.put(MappingXmlConstants.ATTR_VERSION, "1.0");
        mappingAttributes.put(MappingXmlConstants.ATTR_RESOURCE_ID, mapping.getId());
        mappingAttributes.put(MappingXmlConstants.ATTR_NAME, mapping.getName());
        mappingAttributes.put(MappingXmlConstants.ATTR_CUSTOM_NAME, mapping.getCustomName());
        mappingAttributes.put(MappingXmlConstants.ATTR_CREATION_DATE, dateStr);
        mappingAttributes.put(MappingXmlConstants.ATTR_CREATION_TIME, timeStr);
        xml.openTag(MappingXmlConstants.TAG_META_MAPPING, mappingAttributes);
        mappingAttributes = null;
        Iterator iter = mapping.getBindings();
        while (iter.hasNext()) {
            this.generate(mapping, (Binding)iter.next(), xml);
        }
        xml.closeTag();
        xml.flush();
    }

    private void generate(MetaMapping mapping, Binding binding, XmlWriter xml) throws IOException {
        if (binding instanceof FieldBinding) {
            FieldBinding fieldBinding = (FieldBinding)binding;
            LinkedHashMap<String, String> fieldAttributes = new LinkedHashMap<String, String>();
            fieldAttributes.put(MappingXmlConstants.ATTR_FIELD, fieldBinding.getId());
            if (fieldBinding.getCustomName() != null && fieldBinding.getCustomName().length() > 0) {
                fieldAttributes.put(MappingXmlConstants.ATTR_CUSTOM_NAME, fieldBinding.getCustomName());
            }
            if (fieldBinding.getPosition() != null) {
                fieldAttributes.put(MappingXmlConstants.ATTR_POSITION, fieldBinding.getPosition().toString());
            }
            if (fieldBinding.getDefaultValue() != null && fieldBinding.getDefaultValue().length() > 0) {
                fieldAttributes.put(MappingXmlConstants.ATTR_DEFAULT_VALUE, fieldBinding.getDefaultValue());
            }
            xml.openTag(MappingXmlConstants.TAG_FIELD_BINDING, fieldAttributes);
            fieldAttributes = null;
            xml.closeTagInCurrentLine();
        } else if (binding instanceof FieldGroupBinding) {
            FieldGroupBinding fieldGroupBinding = (FieldGroupBinding)binding;
            LinkedHashMap<String, String> fieldGroupAttributes = new LinkedHashMap<String, String>();
            fieldGroupAttributes.put(MappingXmlConstants.ATTR_FIELD_GROUP, binding.getId());
            if (fieldGroupBinding.getCustomName() != null && fieldGroupBinding.getCustomName().length() > 0) {
                fieldGroupAttributes.put(MappingXmlConstants.ATTR_CUSTOM_NAME, fieldGroupBinding.getCustomName());
            }
            if (fieldGroupBinding.getSize() != null) {
                fieldGroupAttributes.put(MappingXmlConstants.ATTR_QUANTITY, fieldGroupBinding.getSize().toString());
            }
            xml.openTag(MappingXmlConstants.TAG_FIELD_GROUP_BINDING, fieldGroupAttributes);
            fieldGroupAttributes = null;
            Iterator iter = fieldGroupBinding.getBindings();
            while (iter.hasNext()) {
                this.generate(null, (Binding)iter.next(), xml);
            }
            xml.closeTag();
        } else if (binding instanceof FieldSetBinding) {
            String tag;
            if (binding == mapping.getDocumentBinding()) {
                tag = MappingXmlConstants.TAG_DOCUMENT_BINDING;
            } else if (binding == mapping.getMessageBinding()) {
                tag = MappingXmlConstants.TAG_MESSAGE_BINDING;
            } else {
                throw new IllegalStateException("FieldSetBinding muss Document- oder MessageBinding sein.");
            }
            FieldSetBinding fieldSetBinding = (FieldSetBinding)binding;
            xml.openTag(tag);
            Iterator iter = fieldSetBinding.getBindings();
            while (iter.hasNext()) {
                this.generate(null, (Binding)iter.next(), xml);
            }
            xml.closeTag();
        }
    }
}

