/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.util;

import de.destatis.core.connect.ServerAddress;
import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.util.ClientLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class ClientConfig {
    public static final String LOG_LEVEL = "client.log.level";
    public static final String LOG_FILE = "client.log.file";
    public static final String CERTIFICATE_DIR = "client.certificate.dir";
    public static final String USERNAME = "client.username";
    public static final String PASSWORD = "client.password";
    public static final String PROTOCOL = "client.protocol";
    public static final String COMPRESSION = "client.compression";
    public static final String ADDRESS_PRESELECTION = "client.address.preselection";
    public static final String ADDRESS_USE_URI = "client.address.useURI";
    public static final String PROXY_HOST = "client.proxy.host";
    public static final String PROXY_PORT = "client.proxy.port";
    public static final String PROXY_USER = "client.proxy.user";
    public static final String PROXY_PASSWORD = "client.proxy.password";
    public static final String PROXY_DOMAIN = "client.proxy.domain";
    public static final String PROXY_AUTH_METHOD = "client.proxy.authmethod";
    private static final String DEFAULT_CLIENT_PROTOCOL = "https";
    private static final int DEFAULT_CLIENT_LOG_LEVEL = 0;
    private static final String DEFAULT_CLIENT_ADDRESS_PRESELECTION = "CORE1";
    private static final boolean DEFAULT_CLIENT_ADDRESS_USE_URI = false;
    private static final int DEFAULT_CLIENT_PROXY_PORT = 80;
    private static final String COMPRESSION_TYPE_NONE = "none";
    private static final String COMPRESSION_TYPE_ZIP = "deflate";
    private static final String COMPRESSION_TYPE_GZIP = "gzip";
    private static final String AUTH_METHOD_TYPE_AUTO = "auto";
    private static final String AUTH_METHOD_TYPE_BASIC = "basic";
    private static final String AUTH_METHOD_TYPE_DIGEST = "digest";
    private static final String AUTH_METHOD_TYPE_NTLM = "ntlm";
    private static final String DEFAULT_AUTH_METHOD = "auto";
    private static Properties systemProperties = null;
    private Properties properties = null;

    public ClientConfig() {
        this.properties = new Properties();
    }

    public ClientConfig(Properties properties) {
        this.properties = (Properties)properties.clone();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        this.setProperty(props, PROTOCOL, this.getProtocol());
        this.setProperty(props, COMPRESSION, this.getCompression());
        this.setProperty(props, ADDRESS_PRESELECTION, this.getAddressPreselectionProperty());
        this.setProperty(props, ADDRESS_USE_URI, "" + this.getAddressUseURI());
        this.setProperty(props, PROXY_HOST, this.getProxyHost());
        this.setProperty(props, PROXY_PORT, "" + this.getProxyPort());
        this.setProperty(props, PROXY_USER, this.getProxyUser());
        char[] proxyPassword = this.getProxyPassword();
        if (proxyPassword != null) {
            this.setProperty(props, PROXY_PASSWORD, new String(proxyPassword));
        }
        this.setProperty(props, PROXY_DOMAIN, this.getProxyDomain());
        this.setProperty(props, PROXY_AUTH_METHOD, this.getProxyAuthMethod());
        this.setProperty(props, LOG_FILE, ClientConfig.getLogFile());
        this.setProperty(props, LOG_LEVEL, "" + ClientConfig.getLogLevel());
        this.setProperty(props, CERTIFICATE_DIR, ClientConfig.getCertificateDir());
        return props;
    }

    public String getUserName() {
        return this.properties.getProperty(USERNAME);
    }

    public char[] getPassword() {
        char[] password = null;
        String value = this.properties.getProperty(PASSWORD);
        if (value != null && value.length() > 0) {
            password = value.toCharArray();
        }
        return password;
    }

    public TransferProtocol getProtocol() {
        TransferProtocol protocol = null;
        String value = this.properties.getProperty(PROTOCOL);
        if (value != null && value.length() > 0) {
            protocol = TransferProtocol.getInstance(value);
        }
        if (protocol == null) {
            protocol = TransferProtocol.getInstance(DEFAULT_CLIENT_PROTOCOL);
        }
        return protocol;
    }

    public static int getLogLevel() {
        int logLevel = 0;
        String value = ClientConfig.getSystemProperties().getProperty(LOG_LEVEL);
        if (value != null) {
            try {
                logLevel = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                exc.printStackTrace();
                logLevel = 0;
            }
        }
        return logLevel;
    }

    public static String getLogFile() {
        return ClientConfig.getSystemProperties().getProperty(LOG_FILE);
    }

    public String getCompression() {
        String result = COMPRESSION_TYPE_NONE;
        if (this.isCompressionGZIP()) {
            result = COMPRESSION_TYPE_GZIP;
        } else if (this.isCompressionZIP()) {
            result = COMPRESSION_TYPE_ZIP;
        }
        return result;
    }

    public boolean isCompressionNone() {
        boolean result = true;
        String value = this.properties.getProperty(COMPRESSION);
        if (value != null && (COMPRESSION_TYPE_ZIP.equalsIgnoreCase(value) || COMPRESSION_TYPE_GZIP.equalsIgnoreCase(value))) {
            result = false;
        }
        return result;
    }

    public boolean isCompressionZIP() {
        boolean result = false;
        String value = this.properties.getProperty(COMPRESSION);
        if (value != null && COMPRESSION_TYPE_ZIP.equalsIgnoreCase(value)) {
            result = true;
        }
        return result;
    }

    public boolean isCompressionGZIP() {
        boolean result = false;
        String value = this.properties.getProperty(COMPRESSION);
        if (value != null && COMPRESSION_TYPE_GZIP.equalsIgnoreCase(value)) {
            result = true;
        }
        return result;
    }

    public ServerAddress getAddressPreselection() {
        String value = this.getAddressPreselectionProperty();
        return ServerAddress.getInstance(value);
    }

    public boolean getAddressUseURI() {
        boolean useURI = false;
        String value = this.properties.getProperty(ADDRESS_USE_URI);
        if (value != null && value.length() > 0) {
            Boolean bool = Boolean.valueOf(value);
            useURI = bool;
        }
        return useURI;
    }

    public static String getCertificateDir() {
        return ClientConfig.getSystemProperties().getProperty(CERTIFICATE_DIR);
    }

    public String getProxyHost() {
        return this.properties.getProperty(PROXY_HOST);
    }

    public int getProxyPort() {
        int proxyPort = 80;
        String value = this.properties.getProperty(PROXY_PORT);
        if (value != null) {
            try {
                proxyPort = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                exc.printStackTrace();
                proxyPort = 80;
            }
        }
        return proxyPort;
    }

    public String getProxyUser() {
        return this.properties.getProperty(PROXY_USER);
    }

    public char[] getProxyPassword() {
        char[] password = null;
        String value = this.properties.getProperty(PROXY_PASSWORD);
        if (value != null && value.length() > 0) {
            password = value.toCharArray();
        }
        return password;
    }

    public String getProxyDomain() {
        return this.properties.getProperty(PROXY_DOMAIN);
    }

    public String getProxyWorkstation() {
        String proxyWorkstation = null;
        if (this.getProxyDomain() != null) {
            try {
                proxyWorkstation = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return proxyWorkstation;
    }

    public String getProxyAuthMethod() {
        String proxyAuthMethod = "auto";
        if (this.isProxyAuthMethodBasic()) {
            proxyAuthMethod = AUTH_METHOD_TYPE_BASIC;
        } else if (this.isProxyAuthMethodDigest()) {
            proxyAuthMethod = AUTH_METHOD_TYPE_DIGEST;
        } else if (this.isProxyAuthMethodNTLM()) {
            proxyAuthMethod = AUTH_METHOD_TYPE_NTLM;
        }
        return proxyAuthMethod;
    }

    public boolean isProxyAuthMethodAuto() {
        boolean proxyAuthMethodAuto = true;
        String value = this.properties.getProperty(PROXY_AUTH_METHOD);
        if (value != null && (AUTH_METHOD_TYPE_BASIC.equalsIgnoreCase(value) || AUTH_METHOD_TYPE_DIGEST.equalsIgnoreCase(value) || AUTH_METHOD_TYPE_NTLM.equalsIgnoreCase(value))) {
            proxyAuthMethodAuto = false;
        }
        return proxyAuthMethodAuto;
    }

    public boolean isProxyAuthMethodBasic() {
        boolean proxyAuthMethodBasic = false;
        String value = this.properties.getProperty(PROXY_AUTH_METHOD);
        if (value != null && AUTH_METHOD_TYPE_BASIC.equalsIgnoreCase(value)) {
            proxyAuthMethodBasic = true;
        }
        return proxyAuthMethodBasic;
    }

    public boolean isProxyAuthMethodDigest() {
        boolean proxyAuthMethodDigest = false;
        String value = this.properties.getProperty(PROXY_AUTH_METHOD);
        if (value != null && AUTH_METHOD_TYPE_DIGEST.equalsIgnoreCase(value)) {
            proxyAuthMethodDigest = true;
        }
        return proxyAuthMethodDigest;
    }

    public boolean isProxyAuthMethodNTLM() {
        boolean proxyAuthMethodNTLM = false;
        String value = this.properties.getProperty(PROXY_AUTH_METHOD);
        if (value != null && AUTH_METHOD_TYPE_NTLM.equalsIgnoreCase(value)) {
            proxyAuthMethodNTLM = true;
        }
        return proxyAuthMethodNTLM;
    }

    public void logConfiguration() {
        ClientLogger logger = ClientLogger.getLogger(this.getClass());
        logger.info("Konfiguration des aktuellen Clients:");
        this.logProperty(logger, LOG_FILE, ClientConfig.getLogFile());
        this.logProperty(logger, LOG_LEVEL, ClientConfig.getLogLevel());
        this.logProperty(logger, CERTIFICATE_DIR, ClientConfig.getCertificateDir());
        this.logProperty(logger, PROTOCOL, this.getProtocol());
        this.logProperty(logger, COMPRESSION, this.getCompression());
        this.logProperty(logger, ADDRESS_PRESELECTION, this.getAddressPreselection());
        this.logProperty(logger, ADDRESS_USE_URI, "" + this.getAddressUseURI());
        this.logProperty(logger, PROXY_HOST, this.getProxyHost());
        this.logProperty(logger, PROXY_PORT, this.getProxyPort());
        this.logProperty(logger, PROXY_USER, this.getProxyUser());
        this.logProperty(logger, PROXY_DOMAIN, this.getProxyDomain());
        this.logProperty(logger, PROXY_AUTH_METHOD, this.getProxyAuthMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getSystemProperties() {
        if (systemProperties != null) return systemProperties;
        Class<ClientConfig> clazz = ClientConfig.class;
        synchronized (ClientConfig.class) {
            if (systemProperties != null) return systemProperties;
            Properties props = new Properties();
            if (System.getProperty(LOG_FILE) != null) {
                props.setProperty(LOG_FILE, System.getProperty(LOG_FILE));
            }
            if (System.getProperty(LOG_LEVEL) != null) {
                props.setProperty(LOG_LEVEL, System.getProperty(LOG_LEVEL));
            }
            if (System.getProperty(CERTIFICATE_DIR) != null) {
                props.setProperty(CERTIFICATE_DIR, System.getProperty(CERTIFICATE_DIR));
            }
            systemProperties = props;
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemProperties;
        }
    }

    private String getAddressPreselectionProperty() {
        String value = this.properties.getProperty(ADDRESS_PRESELECTION);
        ServerAddress address = null;
        if (value != null && value.length() > 0) {
            address = ServerAddress.getInstance(value);
        }
        if (address == null) {
            value = DEFAULT_CLIENT_ADDRESS_PRESELECTION;
        }
        return value;
    }

    private void logProperty(ClientLogger logger, String name, Object value) {
        if (value != null) {
            logger.info(name + "=" + value);
        }
    }

    private void logProperty(ClientLogger logger, String name, int value) {
        logger.info(name + "=" + value);
    }

    private void setProperty(Properties props, String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        }
    }

    private void setProperty(Properties props, String name, char[] value) {
        if (value != null) {
            props.setProperty(name, new String(value));
        }
    }

    private void setProperty(Properties props, String name, Object value) {
        if (value != null) {
            props.setProperty(name, value.toString());
        }
    }
}

